/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pcgen.core.Names;
import pcgen.core.PlayerCharacter;
import pcgen.gui.NameElement;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.Utility;

public final class NameGui
extends JFrame {
    static final long serialVersionUID = 8622642599843174001L;
    private JTextField generatedName;
    private PlayerCharacter pc;
    private JButton generateButton;

    public NameGui(PlayerCharacter playerCharacter) {
        super("Random Name Generator");
        this.pc = playerCharacter;
        IconUtilitities.maybeSetIcon(this, "PCGenApp.png");
        Utility.centerFrame(this, true);
        this.setDefaultCloseOperation(2);
        DefaultListModel<NameElement> defaultListModel = new DefaultListModel<NameElement>();
        List<NameElement> list = Names.findAllNamesFiles();
        Collections.sort(list);
        for (int i = 0; i < list.size(); ++i) {
            defaultListModel.addElement(list.get(i));
        }
        this.generateButton = new JButton("Generate Name");
        this.generateButton.setMnemonic('G');
        this.generateButton.setActionCommand("Roll");
        this.generateButton.addActionListener(new ReRollListener());
        this.generatedName = new JTextField(15);
        this.generatedName.setEditable(false);
        JList jList = new JList(defaultListModel);
        jList.setSelectionMode(0);
        jList.setSelectedIndex(-1);
        jList.addListSelectionListener(new ListListener(jList));
        JScrollPane jScrollPane = new JScrollPane(jList);
        JButton jButton = new JButton("Accept");
        jButton.setMnemonic('A');
        jButton.setActionCommand("Accept");
        jButton.addActionListener(new AcceptListener());
        JLabel jLabel = new JLabel("Select a ruleset for name creation");
        JLabel jLabel2 = new JLabel("Name:");
        JPanel jPanel = new JPanel();
        Box box = new Box(0);
        box.add(jLabel2);
        box.add(this.generatedName);
        jPanel.add(box);
        Box box2 = new Box(0);
        box2.add(Box.createHorizontalGlue());
        box2.add(this.generateButton);
        box2.add(Box.createHorizontalGlue());
        Box box3 = new Box(1);
        box3.add(jPanel);
        box3.add(box2);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new EtchedBorder(1));
        jPanel2.add(box3);
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        container.add((Component)jLabel, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 11, 0, new Insets(5, 0, 5, 0), 0, 0));
        container.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 2, 1.0, 1.0, 17, 1, new Insets(0, 5, 5, 0), 0, 0));
        container.add((Component)jPanel2, new GridBagConstraints(1, 1, 2, 1, 1.3, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        container.add((Component)jButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 0, 5, 5), 0, 0));
    }

    public void setPc(PlayerCharacter playerCharacter) {
        this.pc = playerCharacter;
    }

    final class ListListener
    implements ListSelectionListener {
        private JList list;

        public ListListener(JList jList) {
            this.list = jList;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                if (this.list.getSelectedIndex() == -1) {
                    NameGui.this.requestFocus();
                    NameGui.this.generateButton.setEnabled(false);
                    NameGui.this.generatedName.setText("");
                } else {
                    NameGui.this.generateButton.setEnabled(true);
                    this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
                    NameElement nameElement = (NameElement)this.list.getSelectedValue();
                    Names.getInstance().init(nameElement, NameGui.this.pc);
                    NameGui.this.generatedName.setText(Names.getInstance().getRandomName());
                }
            }
        }
    }

    final class ReRollListener
    implements ActionListener {
        ReRollListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                NameGui.this.generatedName.setText(Names.getInstance().getRandomName());
            }
            catch (RuntimeException runtimeException) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    final class AcceptListener
    implements ActionListener {
        AcceptListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = NameGui.this.generatedName.getText();
            if (string.equals("")) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            if (NameGui.this.pc == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            NameGui.this.pc.setName(string);
            PCGen_Frame1.forceUpdate_PlayerTabs();
            PCGen_Frame1.getCurrentCharacterInfo().setTxtName(string);
            NameGui.this.dispose();
        }
    }
}

