/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import pcgen.core.GameMode;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.CoreUtility;
import pcgen.gui.CharacterInfo;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.filter.FilterDialogFactory;
import pcgen.gui.filter.Filterable;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.Utility;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;
import pcgen.util.enumeration.Tab;

public class PToolBar
extends JToolBar {
    static final long serialVersionUID = 6970993764494046979L;
    private static PToolBar currentInstance = null;
    private static JFrame helpFrame = new JFrame("Help");
    private static JEditorPane helpPane = new JEditorPane("text/html", "");
    JButton addKit;
    JButton closeItem;
    JButton gmgenItem;
    JButton newItem;
    JButton newNPCItem;
    JButton openItem;
    JButton printItem;
    JButton printPreviewItem;
    JButton saveItem;
    private FilterComponentListener fcl;
    private FilterToolTipButton openFilters;
    private JButton clearFilters;
    private JButton customFilters;
    private JButton editorFilters;
    private JButton helpItem;
    private JButton preferencesItem;

    private PToolBar(PCGen_Frame1 pCGen_Frame1) {
        this.init(pCGen_Frame1);
        this.setFloatable(true);
        this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.fcl = new FilterComponentListener();
    }

    public static void displayHelpPanel(boolean bl) {
        Serializable serializable;
        Component component = PCGen_Frame1.getBaseTabbedPane().getSelectedComponent();
        if (component == null) {
            return;
        }
        if (component instanceof CharacterInfo) {
            component = ((CharacterInfo)component).getActivePane();
        }
        String string = "";
        if (component != null) {
            string = component.getName();
        }
        Tab tab = Tab.INVALID;
        if (string != null && string.length() > 0) {
            if (string.equals(Tab.INVENTORY.toString())) {
                serializable = ((JTabbedPane)component).getSelectedComponent();
                string = ((Component)serializable).getName();
            }
            tab = GameMode.getTab(string);
        }
        try {
            String string2 = SettingsHandler.getGame().getContextPath(tab);
            if (string2.equals("")) {
                return;
            }
            string2 = CoreUtility.fixFilenamePath(SettingsHandler.getPcgenDocsDir() + File.separator + string2);
            serializable = new File(string2);
            if (!((File)serializable).exists()) {
                throw new MissingDocumentationException(((File)serializable).getAbsolutePath());
            }
            BufferedReader bufferedReader = new BufferedReader(new FileReader((File)serializable));
            int n = (int)((File)serializable).length();
            char[] cArray = new char[n];
            bufferedReader.read(cArray, 0, n);
            bufferedReader.close();
            String string3 = new String(cArray);
            int n2 = 0;
            boolean bl2 = true;
            String string4 = "";
            String string5 = ">";
            String string6 = "";
            for (int i = 0; i < 13; ++i) {
                switch (i) {
                    case 0: {
                        string6 = "<img";
                        string4 = " ";
                        break;
                    }
                    case 1: {
                        string6 = "<html ";
                        string4 = "<html>";
                        break;
                    }
                    case 2: {
                        string6 = "<body ";
                        string4 = "<body>";
                        break;
                    }
                    case 3: {
                        string6 = "<meta ";
                        string4 = " ";
                        break;
                    }
                    case 4: {
                        string6 = "<!--[";
                        string5 = "<![endif]-->";
                        break;
                    }
                    case 5: {
                        string6 = "<xml>";
                        string5 = "</xml>";
                        break;
                    }
                    case 6: {
                        string6 = "<![endif";
                        string5 = ">";
                        string4 = " ";
                        break;
                    }
                    case 7: {
                        string6 = "![endif";
                        string5 = ">";
                        string4 = " ";
                        break;
                    }
                    case 8: {
                        string6 = "<o:p";
                        string5 = ">";
                        string4 = " ";
                        break;
                    }
                    case 9: {
                        string6 = "</o:p";
                        string5 = ">";
                        string4 = " ";
                        break;
                    }
                    case 10: {
                        string6 = "<link ";
                        string5 = ">";
                        string4 = " ";
                        break;
                    }
                    case 11: {
                        string6 = "<style";
                        string5 = "</style>";
                        string4 = " ";
                        break;
                    }
                    case 12: {
                        string6 = "<li ";
                        string5 = ">";
                        string4 = "<li>";
                        break;
                    }
                    default: {
                        Logging.errorPrint("Index " + i + " not handled in Ptoolbar.displayHelpPanel");
                    }
                }
                n2 = string3.indexOf(string6);
                while (n2 >= 0) {
                    int n3 = string3.substring(n2).indexOf(string5);
                    String string7 = string4;
                    if (n3 == -1) {
                        string7 = " ";
                    }
                    string3 = string3.substring(0, n2) + string7 + string3.substring(n2 + n3 + 1);
                    n2 = string3.indexOf(string6);
                    bl2 = false;
                }
            }
            if (!bl2) {
                helpPane.setText(string3);
            } else {
                URL uRL = ((File)serializable).toURI().toURL();
                helpPane.setPage(uRL);
            }
        }
        catch (IOException iOException) {
            Logging.errorPrint("Something went wrong printing ", iOException);
        }
        catch (MissingDocumentationException missingDocumentationException) {
            Logging.errorPrint("Could not find " + missingDocumentationException.getMessage());
            helpPane.setText("<html>" + PropertyFactory.getString("in_noHelpAvailable") + "</html>");
        }
        if (helpFrame.isVisible() || bl) {
            helpFrame.setVisible(true);
        }
        helpPane.setCaretPosition(0);
    }

    public ComponentListener getComponentListener() {
        return this.fcl;
    }

    public static PToolBar getCurrentInstance() {
        return currentInstance;
    }

    public void setFilterActive() {
        this.openFilters.setActiveIcon();
    }

    public void setFilterInactive() {
        this.openFilters.setInactiveIcon();
    }

    public static PToolBar createToolBar(PCGen_Frame1 pCGen_Frame1) {
        if (currentInstance == null) {
            currentInstance = new PToolBar(pCGen_Frame1);
        }
        return currentInstance;
    }

    private void disableFilterButtons() {
        this.setFilterInactive();
        this.filterButtonsSetEnabled(false);
    }

    private void filterButtonsSetEnabled(boolean bl) {
        this.openFilters.setEnabled(bl);
        this.clearFilters.setEnabled(bl);
        this.customFilters.setEnabled(bl);
        this.editorFilters.setEnabled(bl);
    }

    private void init(PCGen_Frame1 pCGen_Frame1) {
        this.newItem = Utility.createButton(pCGen_Frame1.frameActionListener.newActionListener, "file.new", PropertyFactory.getString("in_mnuFileNewTip"), "New16.gif", false);
        this.add(this.newItem);
        this.newNPCItem = Utility.createButton(pCGen_Frame1.frameActionListener.newNPCActionListener, "file.newNPC", PropertyFactory.getString("in_mnuFileNewNPCTip"), "NewNPC16.gif", false);
        this.add(this.newNPCItem);
        this.openItem = Utility.createButton(pCGen_Frame1.frameActionListener.openActionListener, "file.open", PropertyFactory.getString("in_mnuFileOpenTip"), "Open16.gif", true);
        this.add(this.openItem);
        this.closeItem = Utility.createButton(pCGen_Frame1.frameActionListener.closeActionListener, "file.close", PropertyFactory.getString("in_mnuFileCloseTip"), "Close16.gif", false);
        this.add(this.closeItem);
        this.saveItem = Utility.createButton(pCGen_Frame1.frameActionListener.saveActionListener, "file.save", PropertyFactory.getString("in_mnuFileSaveTip"), "Save16.gif", false);
        this.add(this.saveItem);
        this.addSeparator();
        this.printPreviewItem = Utility.createButton(pCGen_Frame1.frameActionListener.printPreviewActionListener, "file.printpreview", PropertyFactory.getString("in_mnuFilePrintPreviewTip"), "PrintPreview16.gif", false);
        this.add(this.printPreviewItem);
        this.printItem = Utility.createButton(pCGen_Frame1.frameActionListener.printActionListener, "file.print", PropertyFactory.getString("in_mnuFilePrintTip"), "Print16.gif", false);
        this.add(this.printItem);
        this.addSeparator();
        this.openFilters = new FilterToolTipButton(IconUtilitities.getImageIcon("Zoom16.gif"), IconUtilitities.getImageIcon("ZoomHighlightBlue16.gif"));
        this.openFilters.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterDialogFactory.showHideFilterSelectDialog();
            }
        });
        this.add(this.openFilters);
        this.clearFilters = Utility.createButton(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterDialogFactory.clearSelectedFiltersForSelectedFilterable();
            }
        }, "filter.clear", PropertyFactory.getString("in_mnuToolsFiltersClearTip"), "RemoveZoom16.gif", false);
        this.add(this.clearFilters);
        this.customFilters = Utility.createButton(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterDialogFactory.showHideFilterCustomDialog();
            }
        }, "filter.custom", PropertyFactory.getString("in_mnuToolsFiltersCustomTip"), "CustomZoom16.gif", false);
        this.add(this.customFilters);
        this.editorFilters = Utility.createButton(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterDialogFactory.showHideFilterEditorDialog();
            }
        }, "filter.editor", PropertyFactory.getString("in_mnuToolsFiltersEditTip"), "EditZoom16.gif", false);
        this.add(this.editorFilters);
        this.addSeparator();
        this.addKit = Utility.createButton(pCGen_Frame1.frameActionListener.addKitActionListener, "assign.kit", PropertyFactory.getString("in_mnuFileAddKitTip"), "Information16.gif", false);
        this.add(this.addKit);
        this.addSeparator();
        this.preferencesItem = Utility.createButton(pCGen_Frame1.frameActionListener.preferencesActionListener, "settings.preferences", PropertyFactory.getString("in_mnuSettingsPreferencesTip"), "Preferences16.gif", true);
        this.add(this.preferencesItem);
        this.addSeparator();
        this.gmgenItem = Utility.createButton(pCGen_Frame1.frameActionListener.gmgenActionListener, "gmgen.load", PropertyFactory.getString("in_launchGMGen"), "gmgen_icon.png", true);
        this.add(this.gmgenItem);
        this.addSeparator();
        this.helpItem = Utility.createButton(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PToolBar.displayHelpPanel(true);
            }
        }, "help.context", PropertyFactory.getString("in_mnuHelpContext"), "ContextualHelp16.gif", true);
        this.add(this.helpItem);
        helpFrame.setSize(new Dimension(400, 400));
        helpFrame.getContentPane().add(new JScrollPane(helpPane));
        helpFrame.setLocation(100, 100);
        helpPane.setEditable(false);
    }

    private static class MissingDocumentationException
    extends Exception {
        MissingDocumentationException(String string) {
            super(string);
        }
    }

    private class FilterToolTipButton
    extends FilterIconButton {
        public FilterToolTipButton(Icon icon, Icon icon2) {
            super(icon, icon2);
            this.setToolTipText(PropertyFactory.getString("in_filterIcon"));
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            return FilterDialogFactory.getSelectedFiltersToolTipText();
        }
    }

    private static class FilterIconButton
    extends JButton {
        private Icon activeIcon;
        private Icon inactiveIcon;

        public FilterIconButton(Icon icon, Icon icon2) {
            super(icon);
            this.activeIcon = icon2;
            this.inactiveIcon = icon;
            this.setMargin(new Insets(0, 0, 0, 0));
        }

        public void setActiveIcon() {
            this.setIcon(this.activeIcon);
        }

        public void setInactiveIcon() {
            this.setIcon(this.inactiveIcon);
        }
    }

    private class FilterComponentListener
    extends ComponentAdapter {
        private FilterComponentListener() {
        }

        public void componentShown(ComponentEvent componentEvent) {
            JTabbedPane jTabbedPane;
            PToolBar.displayHelpPanel(false);
            Component component = componentEvent.getComponent();
            if (component.getParent() instanceof JTabbedPane && !(jTabbedPane = (JTabbedPane)component.getParent()).isVisible()) {
                return;
            }
            if (component instanceof Filterable) {
                this.handleFilterableShown((Filterable)((Object)component));
            } else if (component instanceof CharacterInfo) {
                this.handleFilterableShown(((CharacterInfo)component).getSelectedFilterable());
            } else {
                PToolBar.this.disableFilterButtons();
                PCGen_Frame1.getInst().getPcgenMenuBar().getFiltersMenu().setEnabled(false);
            }
        }

        private void handleFilterableShown(Filterable filterable) {
            if (filterable != null && filterable.getSelectionMode() != -2) {
                PToolBar.this.filterButtonsSetEnabled(true);
                if (filterable.getSelectedFilters().size() > 0) {
                    PToolBar.this.setFilterActive();
                } else {
                    PToolBar.this.setFilterInactive();
                }
                PCGen_Frame1.getInst().getPcgenMenuBar().getFiltersMenu().setEnabled(true);
            } else {
                PToolBar.this.disableFilterButtons();
                PCGen_Frame1.getInst().getPcgenMenuBar().getFiltersMenu().setEnabled(false);
            }
        }
    }
}

