/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.Timer;
import pcgen.core.SettingsHandler;
import pcgen.gui.SpringUtilities;

public class StatusBar
extends JPanel {
    private static final int STATUSBAR_HEIGHT = 17;
    private static final int MB = 0x100000;
    private final JLabel messageArea = new StatusBarArea(2, 8, true);
    private final Stack<String> oldMessages = new Stack();
    private final JLabel memoryArea = new MemoryArea();
    private final JLabel statusArea = new StatusBarArea(0, 3, false);
    private boolean showMemoryArea;

    public StatusBar() {
        this.setLayout(new SpringLayout());
        this.add(this.messageArea);
        this.add(this.statusArea);
        this.setShowMemoryArea(SettingsHandler.isShowMemoryArea());
        this.updateLayout();
    }

    public String getMessageAreaText() {
        return this.messageArea.getText();
    }

    public void setMessageAreaText(String string) {
        this.oldMessages.push(this.getMessageAreaText());
        this.setMessageAreaTextWithoutSaving(string);
    }

    public void setMessageAreaTextWithoutSaving(String string) {
        String string2 = string;
        if (string == null || string.length() == 0) {
            string2 = "                                               ";
        }
        this.messageArea.setText(string2);
        this.messageArea.setToolTipText(string2.trim());
        this.revalidate();
    }

    public void restoreMessageAreaText() {
        this.setMessageAreaTextWithoutSaving(this.oldMessages.pop());
    }

    public void setShowMemoryArea(boolean bl) {
        if (bl) {
            if (!this.showMemoryArea) {
                this.remove(this.memoryArea);
                this.remove(this.statusArea);
                this.add(this.memoryArea);
                this.add(this.statusArea);
                this.updateLayout();
            }
        } else if (this.showMemoryArea) {
            this.remove(this.memoryArea);
            this.updateLayout();
        }
        this.showMemoryArea = bl;
    }

    public void setStatus(String string) {
        this.statusArea.setText(string);
    }

    public void clearStatus() {
        this.statusArea.setText(" ");
    }

    private static Dimension getAreaDimension(int n) {
        return new Dimension(17 * n, 17);
    }

    private void updateLayout() {
        SpringUtilities.makeCompactGrid(this, 1, this.getComponentCount(), 0, 0, 0, 0);
    }

    private class MemoryArea
    extends StatusBarArea {
        private MemoryArea() {
            super(0, 5, false);
            this.setToolTipText("<html>Used v. total memory in MB.<br>Click to release memory.");
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    StatusBar.this.setMessageAreaText("Releasing memory...");
                    MemoryArea.this.paint(MemoryArea.this.getGraphics());
                    Cursor cursor = MemoryArea.this.getCursor();
                    MemoryArea.this.setCursor(Cursor.getPredefinedCursor(3));
                    System.gc();
                    MemoryArea.this.setCursor(cursor);
                    StatusBar.this.restoreMessageAreaText();
                }
            });
            new Timer(1000, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Runtime runtime = Runtime.getRuntime();
                    long l = runtime.totalMemory();
                    long l2 = l - runtime.freeMemory();
                    MemoryArea.this.setText(l2 / 0x100000L + 1L + "/" + (l / 0x100000L + 1L));
                }
            }).start();
        }
    }

    private class StatusBarArea
    extends JLabel {
        private StatusBarArea(int n, int n2, boolean bl) {
            super(" ", n);
            this.setBorder(BorderFactory.createLoweredBevelBorder());
            Dimension dimension = StatusBar.getAreaDimension(n2);
            this.setMinimumSize(dimension);
            this.setPreferredSize(dimension);
            if (!bl) {
                this.setMaximumSize(dimension);
            }
            this.setText(" ");
        }
    }
}

