/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pcgen.core.SettingsHandler;
import pcgen.gui.utils.Hyperactive;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.JLabelPane;
import pcgen.gui.utils.Utility;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

final class TipOfTheDay
extends JFrame
implements ActionListener {
    static final long serialVersionUID = 6109389084434712217L;
    private static final String NEXT = "next";
    private static final String HTML_START = "<html><body style=\"margin-left: 5px;margin-right: 5px;margin-top: 5px\">";
    private static final String HTML_END = "</body></html>";
    private JCheckBox chkShowTips;
    private JLabelPane tipText;
    private List<String> tipList = null;
    private int lastNumber = -1;

    TipOfTheDay() {
        IconUtilitities.maybeSetIcon(this, "TipOfTheDay16.gif");
        this.setTitle(PropertyFactory.getString("in_tod_title"));
        this.initUI();
        this.loadTips();
        this.pack();
        Utility.centerFrame(this, false);
        this.lastNumber = SettingsHandler.getLastTipShown();
        this.showNextTip();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (NEXT.equals(actionEvent.getActionCommand())) {
            this.showNextTip();
            return;
        }
        this.quit();
    }

    private boolean hasTips() {
        return this.tipList != null && this.tipList.size() > 0;
    }

    private void initUI() {
        JPanel jPanel = new JPanel(new BorderLayout(2, 2));
        jPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        ImageIcon imageIcon = IconUtilitities.getImageIcon("TipOfTheDay24.gif");
        JLabel jLabel = imageIcon != null ? new JLabel(imageIcon) : new JLabel("TipOfTheDay24.gif");
        jLabel.setOpaque(true);
        jPanel.add((Component)jLabel, "West");
        JLabel jLabel2 = new JLabel("    " + PropertyFactory.getString("in_tod_didyouknow"));
        Font font = jLabel2.getFont();
        jLabel2.setFont(font.deriveFont(font.getStyle() | 2, 18.0f));
        jLabel2.setOpaque(true);
        this.tipText = new JLabelPane();
        this.tipText.setBorder(null);
        this.tipText.addHyperlinkListener(new Hyperactive());
        JScrollPane jScrollPane = new JScrollPane(this.tipText);
        jScrollPane.setBorder(null);
        JPanel jPanel2 = new JPanel(new BorderLayout(0, 2));
        jPanel2.add((Component)jLabel2, "North");
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.setPreferredSize(new Dimension(585, 230));
        jPanel.add((Component)jPanel2, "Center");
        this.chkShowTips = new JCheckBox(PropertyFactory.getString("in_tod_showTips"), SettingsHandler.getShowTipOfTheDay());
        JButton jButton = new JButton(PropertyFactory.getString("in_close"));
        jButton.setMnemonic(PropertyFactory.getMnemonic("in_mn_close"));
        jButton.addActionListener(this);
        JButton jButton2 = new JButton(PropertyFactory.getString("in_tod_nextTip"));
        jButton2.setMnemonic(PropertyFactory.getMnemonic("in_mn_tod_nextTip"));
        jButton2.addActionListener(this);
        jButton2.setActionCommand(NEXT);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0);
        jPanel3.add((Component)this.chkShowTips, gridBagConstraints);
        JPanel jPanel4 = new JPanel(new FlowLayout(2));
        jPanel4.add(jButton2);
        jPanel4.add(jButton);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 13;
        jPanel3.add((Component)jPanel4, gridBagConstraints);
        jPanel.add((Component)jPanel3, "South");
        this.setContentPane(jPanel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TipOfTheDay.this.quit();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    TipOfTheDay.this.quit();
                }
            }
        });
    }

    private void loadTipFile(String string) throws FileNotFoundException, IOException {
        File file = new File(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        int n = (int)file.length();
        char[] cArray = new char[n];
        bufferedReader.read(cArray, 0, n);
        bufferedReader.close();
        StringTokenizer stringTokenizer = new StringTokenizer(new String(cArray), "\r\n", false);
        while (stringTokenizer.hasMoreTokens()) {
            this.tipList.add(stringTokenizer.nextToken());
        }
    }

    private void loadTips() {
        this.tipList = new ArrayList<String>(20);
        String string = SettingsHandler.getPcgenSystemDir() + File.separator + "gameModes" + File.separator + SettingsHandler.getGame().getName() + File.separator + "tips.lst";
        String string2 = SettingsHandler.getPcgenSystemDir() + File.separator + "gameModes" + File.separator + "default" + File.separator + "tips.lst";
        boolean bl = false;
        try {
            this.loadTipFile(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl = true;
        }
        catch (IOException iOException) {
            bl = true;
        }
        if (bl) {
            try {
                this.loadTipFile(string2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Logging.errorPrint("Warning: game mode " + SettingsHandler.getGame().getName() + " is missing file tips.lst");
            }
            catch (IOException iOException) {
                Logging.errorPrint("Warning: game mode " + SettingsHandler.getGame().getName() + " is missing file tips.lst");
            }
        }
    }

    private void quit() {
        this.setVisible(false);
        SettingsHandler.setLastTipShown(this.lastNumber);
        SettingsHandler.setShowTipOfTheDay(this.chkShowTips.isSelected());
        this.dispose();
    }

    private void showNextTip() {
        if (this.hasTips()) {
            if (++this.lastNumber >= this.tipList.size()) {
                this.lastNumber = 0;
            }
            String string = this.tipList.get(this.lastNumber);
            try {
                this.tipText.setText("<html><body style=\"margin-left: 5px;margin-right: 5px;margin-top: 5px\"><b>Tip#" + Integer.toString(this.lastNumber + 1) + "</b><br>" + string + HTML_END);
                this.repaint();
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }
}

