/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.converter;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import pcgen.base.lang.StringUtil;
import pcgen.base.util.DoubleKeyMapToList;
import pcgen.base.util.TripleKeyMapToList;
import pcgen.cdom.base.CDOMObject;
import pcgen.core.Campaign;
import pcgen.gui.converter.LSTConverter;
import pcgen.gui.converter.Loader;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.rules.context.LoadContext;
import pcgen.util.StringPClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectInjector {
    private final TripleKeyMapToList<URI, String, String, String> campaignData = new TripleKeyMapToList();
    private final DoubleKeyMapToList<URI, File, String> fileData = new DoubleKeyMapToList();
    private final Collection<Loader> loaders;
    private final File outDir;
    private final File rootDir;

    public ObjectInjector(LoadContext loadContext, File file, File file2, LSTConverter lSTConverter) {
        this.outDir = file;
        this.rootDir = file2;
        this.loaders = lSTConverter.getInjectedLoaders();
        for (Loader loader : this.loaders) {
            for (URI uRI : lSTConverter.getInjectedURIs(loader)) {
                for (CDOMObject cDOMObject : lSTConverter.getInjectedObjects(loader, uRI)) {
                    Class<?> clazz = cDOMObject.getClass();
                    String string = StringPClassUtil.getStringFor(clazz);
                    if ("EQMOD".equals(string)) {
                        string = "EQUIPMOD";
                    }
                    String string2 = string.toLowerCase() + "_516_conversion.lst";
                    loadContext.setExtractURI(uRI);
                    Collection<String> collection = loadContext.unparse(cDOMObject);
                    String string3 = cDOMObject.getDisplayName() + "\t" + StringUtil.join(collection, "\t");
                    if (collection == null) continue;
                    this.fileData.addToListFor(uRI, this.getOutputFile(uRI, string2), string3);
                    this.campaignData.addToListFor(uRI, string, string2, string3);
                }
            }
        }
    }

    private File getOutputFile(URI uRI, String string) {
        File file = new File(this.getNewOutputName(uRI).getParentFile(), string);
        if (file.exists()) {
            System.err.println("Won't overwrite: " + file);
        }
        return file;
    }

    private File getNewOutputName(URI uRI) {
        File file = new File(uRI);
        File file2 = this.findSubRoot(this.rootDir, file);
        String string = file.toString().substring(file2.toString().length() + 1);
        File file3 = this.generateCommonRoot(this.rootDir, this.outDir);
        String string2 = this.outDir.getAbsolutePath().substring(file3.getAbsolutePath().length());
        File file4 = new File(file3, File.separator + string2 + File.separator + string);
        return file4;
    }

    public void writeInjectedObjects(List<Campaign> list) throws IOException {
        ArrayList<URI> arrayList = new ArrayList<URI>();
        boolean bl = true;
        for (Campaign comparable : list) {
            for (Loader loader : this.loaders) {
                for (CampaignSourceEntry campaignSourceEntry : loader.getFiles(comparable)) {
                    bl &= this.processWrite(comparable, this.campaignData, campaignSourceEntry, bl);
                    arrayList.add(campaignSourceEntry.getURI());
                }
            }
        }
        for (URI uRI : arrayList) {
            Set<File> set = this.fileData.getSecondaryKeySet(uRI);
            if (set == null) continue;
            for (File file : set) {
                this.writeFile(file, this.fileData.getListFor(uRI, file));
            }
        }
    }

    private void writeFile(File file, List<String> list) throws IOException {
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(this.getFileHeader());
        for (String string : list) {
            fileWriter.write(string);
            fileWriter.write("\n");
        }
        fileWriter.write(this.getFileFooter());
        fileWriter.close();
    }

    private String getFileHeader() {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("# This file was automatically created ");
        stringBuilder.append("during dataset conversion by PCGen ");
        try {
            object = ResourceBundle.getBundle("pcgen/gui/prop/PCGenProp");
            stringBuilder.append(((ResourceBundle)object).getString("VersionNumber"));
        }
        catch (MissingResourceException missingResourceException) {
            missingResourceException.printStackTrace();
        }
        object = DateFormat.getDateInstance(1);
        stringBuilder.append(" on ").append(((DateFormat)object).format(new Date()));
        stringBuilder.append("\n# This file does not contain SOURCE information\n");
        return stringBuilder.toString();
    }

    private String getFileFooter() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n#\n#EOF\n#\n");
        return stringBuilder.toString();
    }

    private boolean processWrite(Campaign campaign, TripleKeyMapToList<URI, String, String, String> tripleKeyMapToList, CampaignSourceEntry campaignSourceEntry, boolean bl) throws IOException {
        URI uRI = campaignSourceEntry.getURI();
        Set<String> set = tripleKeyMapToList.getSecondaryKeySet(uRI);
        if (set != null) {
            URI uRI2 = campaign.getSourceURI();
            File file = this.getNewOutputName(uRI2);
            FileWriter fileWriter = new FileWriter(file, true);
            if (bl) {
                fileWriter.write(this.getCampaignInsertInfo());
            }
            for (String string : set) {
                for (String string2 : tripleKeyMapToList.getTertiaryKeySet(uRI, string)) {
                    CampaignSourceEntry campaignSourceEntry2 = campaignSourceEntry.getRelatedTarget(string2);
                    fileWriter.write(string);
                    fileWriter.write(":");
                    fileWriter.write(campaignSourceEntry2.getLSTformat());
                    fileWriter.write("\n");
                }
            }
            fileWriter.close();
            return false;
        }
        return true;
    }

    private String getCampaignInsertInfo() {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n#\n# The following file(s) were automatically added");
        stringBuilder.append(" during dataset conversion by PCGen ");
        try {
            object = ResourceBundle.getBundle("pcgen/gui/prop/PCGenProp");
            stringBuilder.append(((ResourceBundle)object).getString("VersionNumber"));
        }
        catch (MissingResourceException missingResourceException) {
            missingResourceException.printStackTrace();
        }
        object = DateFormat.getDateInstance(1);
        stringBuilder.append(" on ").append(((DateFormat)object).format(new Date()));
        stringBuilder.append("\n#\n");
        return stringBuilder.toString();
    }

    private File findSubRoot(File file, File file2) {
        if (file2.getParentFile() == null) {
            return null;
        }
        if (file2.getParentFile().getAbsolutePath().equals(file.getAbsolutePath())) {
            return file2;
        }
        return this.findSubRoot(file, file2.getParentFile());
    }

    private File generateCommonRoot(File file, File file2) {
        if (file.equals(file2)) {
            return file;
        }
        List<File> list = this.generateDirectoryHierarchy(file);
        List<File> list2 = this.generateDirectoryHierarchy(file2);
        File file3 = null;
        for (File file4 : list) {
            if (!list2.contains(file4)) break;
            file3 = file4;
        }
        return file3;
    }

    private List<File> generateDirectoryHierarchy(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        while (file != null) {
            arrayList.add(0, file);
            file = file.getParentFile();
        }
        return arrayList;
    }
}

