/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pcgen.core.PObject;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.editor.EditUtil;
import pcgen.gui.editor.JListModel;
import pcgen.gui.utils.BrowserLauncher;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.persistence.PersistenceLayerException;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public final class AdvancedPanel
extends JPanel {
    private static final String[] tags = new String[]{"ADD", "AUTO", "BONUS", "CHOOSE", "DEFINE", "DR", "PANTHEON", "PREALIGN", "PREARMORPROF", "PREARMORTYPE", "PREATT", "PREBASESIZEGT", "PREBASESIZEGTEQ", "PREBASESIZELT", "PREBASESIZELTEQ", "PREBASESIZEQ", "PREBASESIZENEQ", "PREBIRTHPLACE", "PRECITY", "PRECHECK", "PRECHECKBASE", "PRECLASS", "PREDR", "PREDEFAULTMONSTER", "PREDEITY", "PREDEITYALIGN", "PREDEITYDOMAIN", "PREDOMAIN", "PREEQUIP", "PREEQUIPBOTH", "PREEQUIPPRIMARY", "PREEQUIPSECONDARY", "PREEQUIPTWOWEAPON", "PREFEAT", "PREGENDER", "PREHANDSEQ", "PREHANDSGT", "PREHANDSGTEQ", "PREHANDSLT", "PREHANDSLTEQ", "PREHANDSNEQ", "PREHD", "PREHP", "PREITEM", "PRELANG", "PRELEGS", "PRELEVEL", "PRELEVELMAX", "PREMOVE", "PREPOINTBUYMETHOD", "PRERACE", "PREREGION", "PRESA", "PRESIZEEQ", "PRESIZELT", "PRESIZELTEQ", "PRESIZEGT", "PRESIZEGTEQ", "PRESIZENEQ", "PRESKILL", "PRESKILLMULT", "PRESKILLTOT", "PRESPELL", "PRESPELLCAST", "PRESPELLDESCRIPTOR", "PRESPELLSCHOOL", "PRESPELLSCHOOLSUB", "PRESPELLTYPE", "PRESR", "PRESTAT", "PRETEMPLATE", "PRETEXT", "PRETYPE", "PREUATT", "PREVAR", "PREWEAPONPROF", "QUALIFY", "SAB", "SPELLLEVEL", "SPELLS", "SR", "UDAM", "UMULT", "VISION"};
    private static final List<String> singleFireTags = Arrays.asList("CHOOSE", "KEY", "SR");
    private JButton btnAddAdvanced;
    private JButton btnHelpAdvanced;
    private JButton btnRemoveAdvanced;
    private JComboBoxEx cmbAdvancedTag;
    private JLabel lblAdvancedHeader;
    private JLabel lblAdvancedSelected;
    private JLabel lblAdvancedTag;
    private JLabel lblAdvancedTagValue;
    private JList lstAdvancedSelected;
    private JPanel pnlAdvancedAvailable;
    private JPanel pnlAdvancedButtons;
    private JPanel pnlAdvancedHeader;
    private JPanel pnlAdvancedSelected;
    private JPanel pnlAdvancedTag;
    private JPanel pnlAdvancedTagValue;
    private JPanel pnllstAdvancedSelected;
    private JPanel pnllstAdvancedTagValue;
    private JScrollPane scpAdvancedSelected;
    private JScrollPane scpAdvancedTagValue;
    private JTextArea txtAdvancedTagValue;
    private PObject thisPObject = null;

    public AdvancedPanel(PObject pObject) {
        if (pObject == null) {
            throw new NullPointerException();
        }
        this.thisPObject = pObject;
        this.initComponents();
    }

    private void btnAddAdvancedActionPerformed() {
        Object object;
        this.btnAddAdvanced.setEnabled(false);
        String string = (String)this.cmbAdvancedTag.getSelectedItem() + ":" + this.txtAdvancedTagValue.getText().trim();
        boolean bl = false;
        try {
            object = string.trim();
            int n = ((String)object).indexOf(58);
            if (n == -1) {
                Logging.errorPrint("Invalid Token - does not contain a colon: " + (String)object);
            } else if (n == 0) {
                Logging.errorPrint("Invalid Token - starts with a colon: " + (String)object);
            } else {
                String string2 = ((String)object).substring(0, n);
                String string3 = n == ((String)object).length() - 1 ? null : ((String)object).substring(n + 1);
                LoadContext loadContext = SettingsHandler.getGame().getContext();
                if (loadContext.processToken(this.thisPObject, string2, string3)) {
                    loadContext.commit();
                    bl = true;
                } else {
                    loadContext.rollback();
                    Logging.replayParsedMessages();
                }
                Logging.clearParseMessages();
            }
        }
        catch (PersistenceLayerException persistenceLayerException) {
            Logging.errorPrint(persistenceLayerException.getMessage(), persistenceLayerException);
        }
        if (!bl) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_demTagInvalid"), "PCGen", MessageType.ERROR);
            this.btnAddAdvanced.setEnabled(true);
        } else {
            object = (JListModel)this.lstAdvancedSelected.getModel();
            ((JListModel)object).addElement(string);
        }
    }

    private void btnRemoveAdvancedActionPerformed() {
        this.btnRemoveAdvanced.setEnabled(false);
        JListModel jListModel = (JListModel)this.lstAdvancedSelected.getModel();
        Object[] objectArray = this.lstAdvancedSelected.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i];
            int n = string.indexOf(58);
            if (n >= 0) {
                String string2 = string.substring(0, n);
                this.cmbAdvancedTag.setSelectedItem(string2);
                string = string.substring(n + 1);
                this.txtAdvancedTagValue.setText(string);
                this.btnAddAdvanced.setEnabled(true);
            }
            jListModel.removeElement(objectArray[i]);
        }
    }

    private void btnHelpAdvancedActionPerformed() {
        try {
            BrowserLauncher.openURL(SettingsHandler.getPcgenDocsDir().getAbsolutePath() + File.separator + "index.html");
        }
        catch (IOException iOException) {
            ShowMessageDelegate.showMessageDialog("Could not open docs in external browser. Have you set your default browser in the Preference menu? Sorry...", "PCGen", MessageType.ERROR);
            Logging.errorPrint("Could not open docs in external browser", iOException);
        }
    }

    private void initComponents() {
        try {
            this.btnAddAdvanced = new JButton(IconUtilitities.getImageIcon("Forward16.gif"));
            this.btnRemoveAdvanced = new JButton(IconUtilitities.getImageIcon("Back16.gif"));
        }
        catch (Exception exception) {
            this.btnAddAdvanced = new JButton(">");
            this.btnRemoveAdvanced = new JButton("<");
        }
        this.btnHelpAdvanced = new JButton();
        this.cmbAdvancedTag = new JComboBoxEx();
        this.lblAdvancedHeader = new JLabel();
        this.lblAdvancedSelected = new JLabel();
        this.lblAdvancedTag = new JLabel();
        this.lblAdvancedTagValue = new JLabel();
        this.lstAdvancedSelected = new JList();
        this.pnlAdvancedAvailable = new JPanel();
        this.pnlAdvancedButtons = new JPanel();
        this.pnlAdvancedHeader = new JPanel();
        this.pnlAdvancedSelected = new JPanel();
        this.pnlAdvancedTag = new JPanel();
        this.pnlAdvancedTagValue = new JPanel();
        this.pnllstAdvancedSelected = new JPanel();
        this.pnllstAdvancedTagValue = new JPanel();
        this.scpAdvancedSelected = new JScrollPane();
        this.scpAdvancedTagValue = new JScrollPane();
        this.txtAdvancedTagValue = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.setName(PropertyFactory.getString("in_demLangTab"));
        this.pnlAdvancedAvailable.setLayout(new GridBagLayout());
        this.pnlAdvancedAvailable.setPreferredSize(new Dimension(259, 147));
        this.pnlAdvancedTag.setLayout(new GridBagLayout());
        this.lblAdvancedTag.setText(PropertyFactory.getString("in_demTag"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.pnlAdvancedTag.add((Component)this.lblAdvancedTag, gridBagConstraints);
        this.cmbAdvancedTag.setEditable(true);
        this.cmbAdvancedTag.setPreferredSize(new Dimension(180, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.pnlAdvancedTag.add((Component)this.cmbAdvancedTag, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.pnlAdvancedAvailable.add((Component)this.pnlAdvancedTag, gridBagConstraints);
        this.pnlAdvancedTagValue.setLayout(new GridBagLayout());
        this.lblAdvancedTagValue.setText(PropertyFactory.getString("in_demTagVal"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.pnlAdvancedTagValue.add((Component)this.lblAdvancedTagValue, gridBagConstraints);
        this.pnllstAdvancedTagValue.setLayout(new BorderLayout());
        this.pnllstAdvancedTagValue.setPreferredSize(new Dimension(100, 16));
        this.scpAdvancedTagValue.setPreferredSize(new Dimension(259, 131));
        this.txtAdvancedTagValue.setLineWrap(true);
        this.txtAdvancedTagValue.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                super.keyReleased(keyEvent);
                AdvancedPanel.this.txtAdvancedTagValueKeyReleased();
            }
        });
        this.scpAdvancedTagValue.setViewportView(this.txtAdvancedTagValue);
        this.pnllstAdvancedTagValue.add((Component)this.scpAdvancedTagValue, "Center");
        this.btnHelpAdvanced.setText(PropertyFactory.getString("in_demHelp"));
        this.btnHelpAdvanced.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedPanel.this.btnHelpAdvancedActionPerformed();
            }
        });
        this.pnllstAdvancedTagValue.add((Component)this.btnHelpAdvanced, "South");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.8;
        this.pnlAdvancedTagValue.add((Component)this.pnllstAdvancedTagValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 8;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.8;
        this.pnlAdvancedAvailable.add((Component)this.pnlAdvancedTagValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 3.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlAdvancedAvailable, gridBagConstraints);
        this.pnlAdvancedButtons.setLayout(new GridBagLayout());
        this.btnAddAdvanced.setEnabled(false);
        this.btnAddAdvanced.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedPanel.this.btnAddAdvancedActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.pnlAdvancedButtons.add((Component)this.btnAddAdvanced, gridBagConstraints);
        this.btnRemoveAdvanced.setEnabled(false);
        this.btnRemoveAdvanced.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedPanel.this.btnRemoveAdvancedActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.pnlAdvancedButtons.add((Component)this.btnRemoveAdvanced, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlAdvancedButtons, gridBagConstraints);
        this.pnlAdvancedSelected.setLayout(new GridBagLayout());
        this.lblAdvancedSelected.setText(PropertyFactory.getString("in_selected"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.pnlAdvancedSelected.add((Component)this.lblAdvancedSelected, gridBagConstraints);
        this.pnllstAdvancedSelected.setLayout(new BorderLayout());
        this.lstAdvancedSelected.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                AdvancedPanel.this.lstAdvancedSelectedMouseClicked(mouseEvent);
            }
        });
        this.lstAdvancedSelected.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (AdvancedPanel.this.lstAdvancedSelected.getSelectedIndex() >= 0) {
                    AdvancedPanel.this.lstAdvancedSelected.ensureIndexIsVisible(AdvancedPanel.this.lstAdvancedSelected.getSelectedIndex());
                }
            }
        });
        this.scpAdvancedSelected.setViewportView(this.lstAdvancedSelected);
        this.pnllstAdvancedSelected.add((Component)this.scpAdvancedSelected, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlAdvancedSelected.add((Component)this.pnllstAdvancedSelected, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 3.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlAdvancedSelected, gridBagConstraints);
        this.lblAdvancedHeader.setText(PropertyFactory.getString("in_demMiscTags"));
        this.pnlAdvancedHeader.add(this.lblAdvancedHeader);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        this.add((Component)this.pnlAdvancedHeader, gridBagConstraints);
    }

    private void lstAdvancedSelectedMouseClicked(MouseEvent mouseEvent) {
        if (EditUtil.isDoubleClick(mouseEvent, this.lstAdvancedSelected, this.btnRemoveAdvanced)) {
            this.btnRemoveAdvancedActionPerformed();
        }
    }

    private void txtAdvancedTagValueKeyReleased() {
        boolean bl = this.txtAdvancedTagValue.getText().trim().length() != 0;
        Object object = this.cmbAdvancedTag.getSelectedItem();
        boolean bl2 = singleFireTags.contains(object);
        boolean bl3 = bl;
        if (bl2) {
            JListModel jListModel = (JListModel)this.lstAdvancedSelected.getModel();
            for (Object object2 : jListModel.getElements()) {
                String string;
                String string2 = object2.toString();
                int n = string2.indexOf(58);
                if (n < 0 || !object.equals(string = string2.substring(0, n))) continue;
                bl3 = false;
                break;
            }
        }
        this.btnAddAdvanced.setEnabled(bl3);
    }

    void setSelected(List list) {
        this.lstAdvancedSelected.setModel(new JListModel(list, true));
    }

    Object[] getSelectedList() {
        return ((JListModel)this.lstAdvancedSelected.getModel()).getElements();
    }

    void setAvailableTagList(int n) {
        this.cmbAdvancedTag.setModel(new DefaultComboBoxModel<String>(tags));
        this.cmbAdvancedTag.setSelectedIndex(0);
        switch (n) {
            case 1: {
                this.cmbAdvancedTag.removeItem("ADD");
                this.cmbAdvancedTag.removeItem("CHOOSE");
                break;
            }
            case 4: 
            case 7: {
                this.cmbAdvancedTag.removeItem("ADD");
                this.cmbAdvancedTag.removeItem("CHOOSE");
                this.cmbAdvancedTag.removeItem("PANTHEON");
                break;
            }
            case 2: {
                this.cmbAdvancedTag.removeItem("ADD");
                this.cmbAdvancedTag.removeItem("PANTHEON");
                this.cmbAdvancedTag.removeItem("SPELLLEVEL");
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                this.cmbAdvancedTag.removeItem("ADD");
                this.cmbAdvancedTag.removeItem("PANTHEON");
                break;
            }
            case 3: {
                this.cmbAdvancedTag.removeItem("PANTHEON");
                break;
            }
        }
    }
}

