/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pcgen.base.lang.StringUtil;
import pcgen.base.util.MapCollection;
import pcgen.cdom.base.CDOMListObject;
import pcgen.cdom.base.TransitionChoice;
import pcgen.cdom.content.HitDie;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.MapKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.SettingsHandler;
import pcgen.core.SpellProhibitor;
import pcgen.core.spell.Spell;
import pcgen.gui.editor.PObjectUpdater;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.rules.context.LoadContext;

public class ClassAbilityPanel
extends JPanel
implements PObjectUpdater {
    private JCheckBox memorize = new JCheckBox();
    private JCheckBox spellBook = new JCheckBox();
    private JComboBoxEx spellStat = new JComboBoxEx();
    private JComboBoxEx spellType = new JComboBoxEx();
    private JTextField attackCycle = new JTextField();
    private JTextField deity = new JTextField();
    private JTextField extraFeats = new JTextField();
    private JTextField hitDice = new JTextField();
    private JTextField itemCreate = new JTextField();
    private JTextField knownSpells = new JTextField();
    private JTextField levelsPerFeat = new JTextField();
    private JTextField maxLevel = new JTextField();
    private JTextField prohibited = new JTextField();
    private JTextField spellList = new JTextField();

    public ClassAbilityPanel() {
        this.initComponents();
        this.initComponentContents();
    }

    public void updateData(PObject pObject) {
        if (!(pObject instanceof PCClass)) {
            return;
        }
        PCClass pCClass = (PCClass)pObject;
        String string = this.attackCycle.getText().trim();
        LoadContext loadContext = Globals.getContext();
        if (string.length() > 0) {
            loadContext.unconditionallyProcess(pCClass, "ATTACKCYCLE", string);
        }
        if ((string = this.hitDice.getText().trim()).length() > 0) {
            pCClass.put(ObjectKey.LEVEL_HITDIE, new HitDie(Integer.parseInt(string)));
        }
        if ((string = this.deity.getText().trim()).length() > 0) {
            loadContext.unconditionallyProcess(pCClass, "DEITY", string);
        }
        if ((string = this.itemCreate.getText().trim()).length() > 0) {
            pCClass.put(StringKey.ITEMCREATE, string);
        }
        if ((string = this.extraFeats.getText().trim()).length() > 0) {
            pCClass.put(IntegerKey.START_FEATS, Integer.valueOf(string));
        }
        if ((string = this.levelsPerFeat.getText().trim()).length() > 0) {
            pCClass.put(IntegerKey.LEVELS_PER_FEAT, Integer.valueOf(string));
        }
        if ((string = this.knownSpells.getText().trim()).length() > 0) {
            pCClass.removeListFor(ListKey.KNOWN_SPELLS);
            loadContext.unconditionallyProcess(pCClass, "KNOWNSPELLS", string);
        }
        pCClass.put(ObjectKey.MEMORIZE_SPELLS, this.memorize.getSelectedObjects() != null);
        string = this.prohibited.getText().trim();
        if (string.length() > 0) {
            loadContext.unconditionallyProcess(pCClass, "PROHIBITED", string);
        }
        pCClass.put(ObjectKey.SPELLBOOK, this.spellBook.getSelectedObjects() != null);
        loadContext.unconditionallyProcess(pCClass, "SPELLLIST", this.spellList.getText().trim());
        string = (String)this.spellStat.getSelectedItem();
        if (string != null && string.length() > 0 && !"None".equals(string)) {
            loadContext.unconditionallyProcess(pCClass, "SPELLSTAT", string);
        }
        pCClass.remove(StringKey.SPELLTYPE);
        string = (String)this.spellType.getSelectedItem();
        if (string != null && string.length() > 0 && !string.equalsIgnoreCase("NONE")) {
            pCClass.put(StringKey.SPELLTYPE, string);
        }
        if ((string = this.maxLevel.getText().trim()).length() > 0) {
            pCClass.put(IntegerKey.LEVEL_LIMIT, Integer.parseInt(string));
        }
    }

    public void updateView(PObject pObject) {
        String[] stringArray;
        if (!(pObject instanceof PCClass)) {
            return;
        }
        PCClass pCClass = (PCClass)pObject;
        this.attackCycle.setText(StringUtil.join(new MapCollection(pObject.getMapFor(MapKey.ATTACK_CYCLE)), "|"));
        this.hitDice.setText(String.valueOf(pCClass.getSafe(ObjectKey.LEVEL_HITDIE).getDie()));
        this.deity.setText(StringUtil.join(pCClass.getSafeListFor(ListKey.DEITY), "|"));
        this.itemCreate.setText(pCClass.get(StringKey.ITEMCREATE));
        Integer n = pCClass.get(IntegerKey.START_FEATS);
        this.extraFeats.setText(n == null ? "" : n.toString());
        Integer n2 = pCClass.get(IntegerKey.LEVELS_PER_FEAT);
        if (n2 != null) {
            this.levelsPerFeat.setText(n2.toString());
        }
        if ((stringArray = Globals.getContext().unparseSubtoken(pCClass, "KNOWNSPELLS")) != null && stringArray.length > 0) {
            this.knownSpells.setText(stringArray[0]);
        }
        this.memorize.setSelected(pCClass.getSafe(ObjectKey.MEMORIZE_SPELLS));
        TreeSet<String> treeSet = new TreeSet<String>();
        for (SpellProhibitor object2 : pCClass.getSafeListFor(ListKey.PROHIBITED_SPELLS)) {
            treeSet.addAll(object2.getValueList());
        }
        this.prohibited.setText(StringUtil.join(treeSet, ","));
        Boolean bl = pCClass.get(ObjectKey.SPELLBOOK);
        this.spellBook.setSelected(bl != null && bl != false);
        TransitionChoice<CDOMListObject<Spell>> transitionChoice = pCClass.get(ObjectKey.SPELLLIST_CHOICE);
        if (transitionChoice != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(transitionChoice.getCount());
            stringBuilder.append("|");
            stringBuilder.append(transitionChoice.getChoices().getLSTformat());
            this.spellList.setText(stringBuilder.toString());
        }
        this.spellStat.setSelectedItem(pCClass.getSpellBaseStat());
        this.spellType.setSelectedItem(pCClass.getSpellType());
        this.maxLevel.setText(String.valueOf(pCClass.getSafe(IntegerKey.LEVEL_LIMIT)));
    }

    private static GridBagConstraints buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, boolean bl) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        if (bl) {
            gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        }
        return gridBagConstraints;
    }

    private void initComponentContents() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<PObject> iterator = SettingsHandler.getGame().getUnmodifiableStatList().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next().getAbb());
        }
        arrayList.remove("None");
        Collections.sort(arrayList);
        arrayList.add(0, "None");
        this.spellStat.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
        arrayList.clear();
        for (PCClass pCClass : Globals.getContext().ref.getConstructedCDOMObjects(PCClass.class)) {
            String string = pCClass.getSpellType();
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        arrayList.remove("None");
        Collections.sort(arrayList);
        arrayList.add(0, "None");
        this.spellType.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
    }

    private void initComponents() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        JLabel jLabel = new JLabel("Hit Die:");
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 0, 0, true);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 1, 0, true);
        gridBagConstraints.weightx = 0.2;
        this.add((Component)this.hitDice, gridBagConstraints);
        jLabel = new JLabel("Max Level:");
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 2, 0, true);
        gridBagConstraints.weightx = 0.1;
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 3, 0, true);
        gridBagConstraints.weightx = 0.2;
        this.add((Component)this.maxLevel, gridBagConstraints);
        jLabel = new JLabel("Bonus Feats:");
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 0, 1, true);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 1, 1, true);
        this.add((Component)this.extraFeats, gridBagConstraints);
        jLabel = new JLabel("Levels Per Feat:");
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 2, 1, true);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 3, 1, true);
        this.add((Component)this.levelsPerFeat, gridBagConstraints);
        jLabel = new JLabel("Attack Cycle:");
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 0, 2, true);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 1, 2, true);
        this.add((Component)this.attackCycle, gridBagConstraints);
        jLabel = new JLabel("Item Create Mult:");
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 2, 2, true);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 3, 2, true);
        this.add((Component)this.itemCreate, gridBagConstraints);
        jLabel = new JLabel("Spell Type:");
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 0, 3, true);
        this.add((Component)jLabel, gridBagConstraints);
        this.spellType.setEditable(true);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 1, 3, true);
        this.add((Component)this.spellType, gridBagConstraints);
        jLabel = new JLabel("Spell Stat:");
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 2, 3, true);
        this.add((Component)jLabel, gridBagConstraints);
        this.spellStat.setEditable(true);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 3, 3, true);
        this.add((Component)this.spellStat, gridBagConstraints);
        jLabel = new JLabel("Uses Spell Book:");
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 0, 5, true);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 1, 5, true);
        this.add((Component)this.spellBook, gridBagConstraints);
        jLabel = new JLabel("Memorizes Spells:");
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 2, 5, true);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 3, 5, true);
        this.add((Component)this.memorize, gridBagConstraints);
        jLabel = new JLabel("Spell List:");
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 0, 6, true);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 1, 6, true);
        this.add((Component)this.spellList, gridBagConstraints);
        jLabel = new JLabel("Prohibited:");
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 2, 6, true);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 3, 6, true);
        this.add((Component)this.prohibited, gridBagConstraints);
        jLabel = new JLabel("Known Spells:");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 0, 7, true);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 1, 7, true);
        gridBagConstraints.gridwidth = 3;
        this.add((Component)this.knownSpells, gridBagConstraints);
        jLabel = new JLabel("Deities:");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 0, 8, true);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 1, 8, true);
        gridBagConstraints.gridwidth = 3;
        this.add((Component)this.deity, gridBagConstraints);
    }
}

