/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.spell.Spell;
import pcgen.gui.filter.AbstractPObjectFilter;
import pcgen.util.PropertyFactory;

final class SpellResistanceFilter
extends AbstractPObjectFilter {
    private String sr;

    SpellResistanceFilter(String string) {
        this.sr = SpellResistanceFilter.normalizeSpellResistance(string);
        this.setCategory(PropertyFactory.getString("in_spellRes"));
        this.setName(this.sr);
    }

    public boolean accept(PlayerCharacter playerCharacter, PObject pObject) {
        if (pObject == null) {
            return false;
        }
        if (pObject instanceof Spell) {
            return ((Spell)pObject).getSpellResistance().indexOf(this.sr) > -1;
        }
        return true;
    }

    private static String normalizeSpellResistance(String string) {
        String string2 = string.trim().toUpperCase();
        if (string2.startsWith("YES")) {
            return "Yes";
        }
        if (string2.startsWith("NO")) {
            return "No";
        }
        return string;
    }
}

