/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import pcgen.cdom.content.HitDie;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.SourceFormat;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.enumeration.Type;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.SubClass;
import pcgen.core.analysis.OutputNameFormatting;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.PrerequisiteUtilities;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.CharacterInfo;
import pcgen.gui.CharacterInfoTab;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.TableColumnManager;
import pcgen.gui.TableColumnManagerModel;
import pcgen.gui.filter.FilterAdapterPanel;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.panes.FlippingSplitPane;
import pcgen.gui.pcGenGUI;
import pcgen.gui.tabs.InfoTabUtils;
import pcgen.gui.tabs.TabUtils;
import pcgen.gui.utils.AbstractTreeTableModel;
import pcgen.gui.utils.ClickHandler;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.InfoLabelTextBuilder;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.JLabelPane;
import pcgen.gui.utils.JTreeTable;
import pcgen.gui.utils.JTreeTableMouseAdapter;
import pcgen.gui.utils.JTreeTableSorter;
import pcgen.gui.utils.LabelTreeCellRenderer;
import pcgen.gui.utils.PObjectNode;
import pcgen.gui.utils.ResizeColumnListener;
import pcgen.gui.utils.TreeTableModel;
import pcgen.gui.utils.Utility;
import pcgen.gui.utils.WholeNumberField;
import pcgen.util.Delta;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;
import pcgen.util.enumeration.Tab;
import pcgen.util.enumeration.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InfoClasses
extends FilterAdapterPanel
implements CharacterInfoTab {
    static final long serialVersionUID = 9141488354194857537L;
    private static boolean needsUpdate = true;
    private static int viewMode = 0;
    private static Integer saveViewMode = null;
    private static int viewSelectMode = 0;
    private static int splitOrientation = 1;
    private static PObjectNode typeRoot;
    private static PObjectNode sourceRoot;
    private final JLabel avaLabel = new JLabel(PropertyFactory.getString("in_available"));
    private final JLabel selLabel = new JLabel(PropertyFactory.getString("in_selected"));
    private ClassModel availableModel = null;
    private ClassModel selectedModel = null;
    private FlippingSplitPane asplit;
    private FlippingSplitPane bsplit;
    private FlippingSplitPane splitPane;
    private JButton addButton;
    private JButton adjXP = new JButton(PropertyFactory.getString("in_adjXP"));
    private JButton hpButton = null;
    private JButton removeButton;
    private JButton clearQFilterButton = new JButton(PropertyFactory.getString("in_clear"));
    private JComboBoxEx viewComboBox = new JComboBoxEx();
    private JComboBoxEx viewSelectComboBox = new JComboBoxEx();
    private JTree availableTree = null;
    private JTree selectedTree = null;
    private JLabel featCount = new JLabel();
    private JLabel lAHP = new JLabel();
    private JLabel lBAB = new JLabel();
    private JLabel lDefense = new JLabel();
    private JLabel lVariableDisplay = new JLabel();
    private JLabel lVariableDisplay2 = new JLabel();
    private JLabel lVariableDisplay3 = new JLabel();
    private JLabel lblAltHP = new JLabel();
    private JLabel lblBAB = new JLabel();
    private JLabel lblDefense = new JLabel();
    private JLabel lblExperience = new JLabel();
    private JLabel lblFeats = null;
    private JLabel lblHP = new JLabel();
    private JLabel lblHPName = null;
    private JLabel lblNextLevel = new JLabel();
    private final JLabel lblQFilter = new JLabel(PropertyFactory.getString("in_filter") + ":");
    private JLabel lblSkills = new JLabel();
    private JLabel lblVariableDisplay = new JLabel();
    private JLabel lblVariableDisplay2 = new JLabel();
    private JLabel lblVariableDisplay3 = new JLabel();
    private JLabel skillCount = new JLabel();
    private JLabelPane infoLabel = new JLabelPane();
    private JPanel center = new JPanel();
    private JPanel pnlAltHP = new JPanel();
    private JPanel pnlBAB = new JPanel();
    private JPanel pnlDefense = new JPanel();
    private JPanel pnlEast = new JPanel();
    private JPanel pnlFeats = null;
    private JPanel pnlFillerEast = new JPanel();
    private JPanel pnlFillerSouth = new JPanel();
    private JPanel pnlFillerWest = new JPanel();
    private JPanel pnlHP = new JPanel();
    private JPanel pnlSkills = new JPanel();
    private JPanel pnlVariableDisplay = new JPanel();
    private JPanel pnlVariableDisplay2 = new JPanel();
    private JPanel pnlVariableDisplay3 = new JPanel();
    private JPanel pnlWest = new JPanel();
    private JPanel pnlXP = new JPanel();
    private JTextField textQFilter = new JTextField();
    private JTreeTable availableTable;
    private JTreeTable selectedTable;
    private JTreeTableSorter availableSort = null;
    private PCClass lastClass = null;
    private TreePath selPath;
    private WholeNumberField experience = new WholeNumberField();
    private WholeNumberField txtNextLevel = new WholeNumberField();
    private JLabel[] lCheck;
    private JLabel[] lblCheck;
    private JPanel[] pnlCheck;
    private boolean hasBeenSized = false;
    private PlayerCharacter pc;
    private int serial = 0;
    private boolean readyForRefresh = false;

    public InfoClasses(PlayerCharacter playerCharacter) {
        this.pc = playerCharacter;
        this.setName(Tab.CLASSES.toString());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InfoClasses.this.initComponents();
                InfoClasses.this.initActionListeners();
            }
        });
    }

    @Override
    public void setPc(PlayerCharacter playerCharacter) {
        if (this.pc != playerCharacter || playerCharacter.getSerial() > this.serial) {
            this.pc = playerCharacter;
            this.serial = playerCharacter.getSerial();
            this.forceRefresh();
        }
    }

    @Override
    public PlayerCharacter getPc() {
        return this.pc;
    }

    @Override
    public int getTabOrder() {
        return SettingsHandler.getPCGenOption(".Panel.Classes.Order", Tab.CLASSES.ordinal());
    }

    @Override
    public void setTabOrder(int n) {
        SettingsHandler.setPCGenOption(".Panel.Classes.Order", n);
    }

    @Override
    public String getTabName() {
        GameMode gameMode = SettingsHandler.getGame();
        return gameMode.getTabName(Tab.CLASSES);
    }

    @Override
    public boolean isShown() {
        GameMode gameMode = SettingsHandler.getGame();
        return gameMode.getTabShown(Tab.CLASSES);
    }

    @Override
    public List<String> getToDos() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.pc.getXP() >= this.pc.minXPForNextECL()) {
            arrayList.add(SettingsHandler.getGame().getLevelUpMessage());
        }
        return arrayList;
    }

    @Override
    public void refresh() {
        if (this.pc.getSerial() > this.serial) {
            this.serial = this.pc.getSerial();
            this.forceRefresh();
        }
    }

    @Override
    public void forceRefresh() {
        if (this.readyForRefresh) {
            needsUpdate = true;
            this.updateCharacterInfo();
        } else {
            this.serial = 0;
        }
    }

    @Override
    public JComponent getView() {
        return this;
    }

    @Override
    public boolean isMatchAnyEnabled() {
        return true;
    }

    @Override
    public boolean isNegateEnabled() {
        return true;
    }

    @Override
    public int getSelectionMode() {
        return 2;
    }

    @Override
    public void initializeFilters() {
        FilterFactory.registerAllSourceFilters(this);
        FilterFactory.registerAllClassFilters(this);
        FilterFactory.registerAllPrereqAlignmentFilters(this);
    }

    @Override
    public void refreshFiltering() {
        this.forceRefresh();
    }

    public void updateHP() {
        if (this.pc == null) {
            return;
        }
        this.lblHP.setText(String.valueOf(this.pc.hitPoints()));
    }

    private void setInfoLabelText(PCClass pCClass, PObjectNode pObjectNode) {
        boolean bl = false;
        this.lastClass = pCClass;
        if (this.lastClass instanceof SubClass) {
            this.lastClass = (PCClass)pObjectNode.getParent().getItem();
            bl = true;
        }
        if (pCClass != null) {
            InfoLabelTextBuilder infoLabelTextBuilder = new InfoLabelTextBuilder(OutputNameFormatting.piString(pCClass, false));
            infoLabelTextBuilder.appendLineBreak();
            String string = pCClass.getType();
            if (bl && string.length() == 0) {
                string = this.lastClass.getType();
            }
            infoLabelTextBuilder.appendI18nElement("in_clInfoType", string);
            HitDie hitDie = pCClass.getSafe(ObjectKey.LEVEL_HITDIE);
            if (bl && HitDie.ZERO.equals(hitDie)) {
                hitDie = this.lastClass.getSafe(ObjectKey.LEVEL_HITDIE);
            }
            if (!HitDie.ZERO.equals(hitDie)) {
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_clInfoHD", "d" + hitDie.getDie());
            }
            if (Globals.getGameModeShowSpellTab()) {
                string = pCClass.get(StringKey.SPELLTYPE);
                if (bl && string == null) {
                    string = this.lastClass.getSpellType();
                }
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_clInfoSpellType", string);
                string = pCClass.getSpellBaseStat();
                if (bl && (string == null || string.length() == 0)) {
                    string = this.lastClass.getSpellBaseStat();
                }
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_clInfoBaseStat", string);
            }
            string = PrerequisiteUtilities.preReqHTMLStringsForList(this.pc, null, pCClass.getPrerequisiteList(), false);
            if (bl && string.length() == 0) {
                string = PrerequisiteUtilities.preReqHTMLStringsForList(this.pc, null, this.lastClass.getPrerequisiteList(), false);
            }
            if (string.length() > 0) {
                infoLabelTextBuilder.appendLineBreak();
                infoLabelTextBuilder.appendI18nElement("in_requirements", string);
            }
            string = pCClass.getDefaultSourceString();
            if (bl && string.length() == 0) {
                string = this.lastClass.getDefaultSourceString();
            }
            if (string.length() > 0) {
                infoLabelTextBuilder.appendLineBreak();
                infoLabelTextBuilder.appendI18nElement("in_source", string);
            }
            this.infoLabel.setText(infoLabelTextBuilder.toString());
        }
    }

    private PCClass getSelectedClass() {
        if (this.lastClass == null) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_clNoClass"), "PCGen", MessageType.ERROR);
        }
        return this.lastClass;
    }

    private int getSelectedIndex(ListSelectionEvent listSelectionEvent) {
        DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
        if (defaultListSelectionModel == null) {
            return -1;
        }
        return defaultListSelectionModel.getMinSelectionIndex();
    }

    private void addClass(int n) {
        Serializable serializable;
        PCClass pCClass;
        if (Globals.getGameModeAlignmentText().length() != 0) {
            if (n > 0 && this.pc.getAlignment() == SettingsHandler.getGame().getIndexOfAlignment("None")) {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_clSelAlign"), "PCGen", MessageType.ERROR);
                return;
            }
            if (n > 0 && !this.pc.canLevelUp()) {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_Enforce_rejectLevelUp"), "PCGen", MessageType.ERROR);
                return;
            }
        }
        if ((pCClass = this.getSelectedClass()) == null || !pCClass.isQualified(this.pc)) {
            return;
        }
        this.pc.setDirty(true);
        PCClass pCClass2 = this.pc.getClassKeyed(pCClass.getKeyName());
        if (n > 0 && pCClass2 != null && pCClass2.getSubClassKey() != null && (serializable = pCClass2.getSubClassKeyed(pCClass2.getSubClassKey())) != null && !((PCClass)serializable).isQualified(this.pc)) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_clYouAreNotQualifiedToTakeTheClass") + pCClass2.getDisplayName() + "/" + ((PObject)serializable).getDisplayName() + ".", "PCGen", MessageType.ERROR);
            return;
        }
        if (n >= 0 && pCClass2 != null && !Globals.checkRule("LEVELCAP") && (Globals.checkRule("LEVELCAP") || pCClass2.hasMaxLevel() && pCClass2.getLevel() >= pCClass2.getSafe(IntegerKey.LEVEL_LIMIT))) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_clMaxLvl"), "PCGen", MessageType.INFORMATION);
            return;
        }
        this.pc.incrementClassLevel(n, pCClass);
        serializable = PCGen_Frame1.getCharacterPane();
        ((CharacterInfo)serializable).setPaneForUpdate(((CharacterInfo)serializable).infoAbilities());
        ((CharacterInfo)serializable).setPaneForUpdate(((CharacterInfo)serializable).infoDomain());
        ((CharacterInfo)serializable).setPaneForUpdate(((CharacterInfo)serializable).infoSkills());
        ((CharacterInfo)serializable).setPaneForUpdate(((CharacterInfo)serializable).infoSpells());
        ((CharacterInfo)serializable).setPaneForUpdate(((CharacterInfo)serializable).infoSpecialAbilities());
        ((CharacterInfo)serializable).setPaneForUpdate(((CharacterInfo)serializable).infoSummary());
        ((CharacterInfo)serializable).refresh();
        if (n > 0) {
            TabUtils.selectClothes(this.pc);
        }
        this.pc.setDirty(true);
        this.forceRefresh();
    }

    private void buildEastPanel() {
        GridBagConstraints gridBagConstraints;
        this.pnlEast.setLayout(new GridBagLayout());
        List<PObject> list = SettingsHandler.getGame().getUnmodifiableCheckList();
        int n = list.size();
        if (n != 0) {
            this.pnlCheck = new JPanel[n];
            this.lCheck = new JLabel[n];
            this.lblCheck = new JLabel[n];
            for (int i = 0; i < n; ++i) {
                this.pnlCheck[i] = new JPanel();
                this.pnlCheck[i].setLayout(new BorderLayout(5, 5));
                this.lblCheck[i] = new JLabel();
                this.lCheck[i] = new JLabel();
                this.pnlCheck[i].add((Component)this.lblCheck[i], "West");
                this.pnlCheck[i].add((Component)this.lCheck[i], "East");
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                if (i == 0) {
                    gridBagConstraints.gridy = 0;
                }
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.weightx = 1.0;
                this.pnlEast.add((Component)this.pnlCheck[i], gridBagConstraints);
            }
        }
        this.pnlVariableDisplay.setLayout(new BorderLayout(5, 5));
        String string = Globals.getGameModeVariableDisplayText();
        this.lblVariableDisplay.setText(string);
        this.pnlVariableDisplay.add((Component)this.lblVariableDisplay, "West");
        this.pnlVariableDisplay.setVisible(string.length() != 0);
        this.pnlVariableDisplay.add((Component)this.lVariableDisplay, "East");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.pnlEast.add((Component)this.pnlVariableDisplay, gridBagConstraints);
        this.pnlVariableDisplay2.setLayout(new BorderLayout(5, 5));
        string = Globals.getGameModeVariableDisplay2Text();
        this.lblVariableDisplay2.setText(string);
        this.pnlVariableDisplay2.add((Component)this.lblVariableDisplay2, "West");
        this.pnlVariableDisplay2.setVisible(string.length() != 0);
        this.pnlVariableDisplay2.add((Component)this.lVariableDisplay2, "East");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.pnlEast.add((Component)this.pnlVariableDisplay2, gridBagConstraints);
        this.pnlVariableDisplay3.setLayout(new BorderLayout(5, 5));
        string = Globals.getGameModeVariableDisplay3Text();
        this.lblVariableDisplay3.setText(string);
        this.pnlVariableDisplay3.add((Component)this.lblVariableDisplay3, "West");
        this.pnlVariableDisplay3.setVisible(string.length() != 0);
        this.pnlVariableDisplay3.add((Component)this.lVariableDisplay3, "East");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.pnlEast.add((Component)this.pnlVariableDisplay3, gridBagConstraints);
        this.pnlAltHP.setLayout(new BorderLayout(5, 5));
        string = Globals.getGameModeAltHPText();
        this.lblAltHP.setText(string);
        this.pnlAltHP.add((Component)this.lblAltHP, "West");
        this.pnlAltHP.setVisible(string.length() != 0);
        this.pnlAltHP.add((Component)this.lAHP, "East");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.pnlEast.add((Component)this.pnlAltHP, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlEast.add((Component)this.pnlFillerEast, gridBagConstraints);
        this.pnlEast.setVisible(true);
        this.pnlEast.updateUI();
    }

    private void createAvailableModel() {
        if (this.availableModel == null) {
            this.availableModel = new ClassModel(viewMode, true);
        } else {
            this.availableModel.resetModel(InfoClasses.viewMode, true);
        }
        if (this.availableSort != null) {
            this.availableSort.setRoot((PObjectNode)this.availableModel.getRoot());
            this.availableSort.sortNodeOnColumn();
        }
    }

    private void createModels() {
        this.createSelectedModel();
        this.createAvailableModel();
    }

    private void createSelectedModel() {
        if (this.selectedModel == null) {
            this.selectedModel = new ClassModel(viewSelectMode, false);
        } else {
            this.selectedModel.resetModel(InfoClasses.viewSelectMode, false);
        }
    }

    private void createTreeTables() {
        this.availableTable = new JTreeTable(this.availableModel);
        this.availableTable.setSelectionMode(0);
        this.availableTree = this.availableTable.getTree();
        this.availableTree.setRootVisible(false);
        this.availableTree.setShowsRootHandles(true);
        this.availableTree.setCellRenderer(new LabelTreeCellRenderer());
        this.selectedTable = new JTreeTable(this.selectedModel);
        this.selectedTable.setSelectionMode(0);
        this.selectedTree = this.selectedTable.getTree();
        this.selectedTree.setRootVisible(false);
        this.selectedTree.setShowsRootHandles(true);
        this.selectedTree.setCellRenderer(new LabelTreeCellRenderer());
        this.hookupPopupMenu(this.availableTable);
        this.hookupPopupMenu(this.selectedTable);
    }

    private void formComponentShown() {
        this.requestFocus();
        PCGen_Frame1.setMessageAreaTextWithoutSaving(PropertyFactory.getString("in_clNotQualify"));
        this.refresh();
        int n = this.splitPane.getDividerLocation();
        int n2 = this.bsplit.getDividerLocation();
        int n3 = this.asplit.getDividerLocation();
        if (!this.hasBeenSized) {
            int n4;
            TableColumn tableColumn;
            int n5;
            this.hasBeenSized = true;
            n = SettingsHandler.getPCGenOption("InfoClasses.splitPane", (int)(this.getSize().getWidth() * 7.0 / 10.0));
            n2 = SettingsHandler.getPCGenOption("InfoClasses.bsplit", (int)(this.getSize().getHeight() - 140.0));
            n3 = SettingsHandler.getPCGenOption("InfoClasses.asplit", (int)(this.getSize().getWidth() - 334.0));
            for (n5 = 0; n5 < this.selectedTable.getColumnCount(); ++n5) {
                tableColumn = this.selectedTable.getColumnModel().getColumn(n5);
                n4 = Globals.getCustColumnWidth("ClassSel", n5);
                if (n4 != 0) {
                    tableColumn.setPreferredWidth(n4);
                }
                tableColumn.addPropertyChangeListener(new ResizeColumnListener(this.selectedTable, "ClassSel", n5));
            }
            for (n5 = 0; n5 < this.availableTable.getColumnCount(); ++n5) {
                tableColumn = this.availableTable.getColumnModel().getColumn(n5);
                n4 = Globals.getCustColumnWidth("ClassAva", n5);
                if (n4 != 0) {
                    tableColumn.setPreferredWidth(n4);
                }
                tableColumn.addPropertyChangeListener(new ResizeColumnListener(this.availableTable, "ClassAva", n5));
            }
        }
        if (n > 0) {
            this.splitPane.setDividerLocation(n);
            SettingsHandler.setPCGenOption("InfoClasses.splitPane", n);
        }
        if (n2 > 0) {
            this.bsplit.setDividerLocation(n2);
            SettingsHandler.setPCGenOption("InfoClasses.bsplit", n2);
        }
        if (n3 > 0) {
            this.asplit.setDividerLocation(n3);
            SettingsHandler.setPCGenOption("InfoClasses.asplit", n3);
        }
    }

    private void hookupPopupMenu(JTreeTable jTreeTable) {
        jTreeTable.addMouseListener(new ClassPopupListener(jTreeTable, new ClassPopupMenu(jTreeTable)));
    }

    private void initActionListeners() {
        this.addFocusListener(new PaneFocusAdapter());
        this.addComponentListener(new PaneComponentAdapter());
        this.removeButton.addActionListener(new RemoveClassButtonActionListener());
        this.adjXP.addActionListener(new AdjustXPButtonActionListener());
        this.addButton.addActionListener(new AddClassButtonActionListener());
        this.viewComboBox.addActionListener(new ViewComboBoxActionListener());
        this.viewSelectComboBox.addActionListener(new ViewSelectComboBoxActionListener());
        if (this.hpButton != null) {
            this.hpButton.addActionListener(new HpButtonActionListener());
        }
        this.experience.setInputVerifier(new ExperienceBoxInputVerifier());
        this.availableTable.getSelectionModel().addListSelectionListener(new AvailableListSelectionListener());
        this.selectedTable.getSelectionModel().addListSelectionListener(new SelectedListSelectionListener());
        this.availableTable.addMouseListener(new JTreeTableMouseAdapter(this.availableTable, new AvailableClickHandler(), false));
        this.selectedTable.addMouseListener(new JTreeTableMouseAdapter(this.selectedTable, new SelectedClickHandler(), false));
        this.textQFilter.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                InfoClasses.this.setQFilter();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                InfoClasses.this.setQFilter();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                InfoClasses.this.setQFilter();
            }
        });
        this.clearQFilterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoClasses.this.clearQFilter();
            }
        });
        FilterFactory.restoreFilterSettings(this);
    }

    private void initComponents() {
        int n;
        Object object;
        this.readyForRefresh = true;
        typeRoot = new PObjectNode();
        sourceRoot = new PObjectNode();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (PCClass pCClass : Globals.getContext().ref.getConstructedCDOMObjects(PCClass.class)) {
            for (Type object22 : pCClass.getTrueTypeList(false)) {
                object = object22.toString();
                if (arrayList.contains(object)) continue;
                arrayList.add((String)object);
            }
            String string = SourceFormat.getFormattedString(pCClass, SourceFormat.LONG, false);
            if (string.length() == 0) {
                Logging.errorPrintLocalised("in_icPCClassHasNoSourceLongEntry", pCClass.getDisplayName());
                continue;
            }
            if (arrayList2.contains(string)) continue;
            arrayList2.add(string);
        }
        Collections.sort(arrayList);
        if (!arrayList.contains(PropertyFactory.getString("in_other"))) {
            arrayList.add(PropertyFactory.getString("in_other"));
        }
        PObjectNode[] pObjectNodeArray = new PObjectNode[arrayList.size()];
        for (int i = 0; i < pObjectNodeArray.length; ++i) {
            pObjectNodeArray[i] = new PObjectNode();
            pObjectNodeArray[i].setItem(arrayList.get(i));
            pObjectNodeArray[i].setParent(typeRoot);
        }
        typeRoot.setChildren(pObjectNodeArray);
        Collections.sort(arrayList2);
        PObjectNode[] pObjectNodeArray2 = new PObjectNode[arrayList2.size()];
        for (n = 0; n < pObjectNodeArray2.length; ++n) {
            String string = ((String)arrayList2.get(n)).toString();
            if (string == null) continue;
            pObjectNodeArray2[n] = new PObjectNode();
            pObjectNodeArray2[n].setItem(string);
            pObjectNodeArray2[n].setParent(sourceRoot);
        }
        sourceRoot.setChildren(pObjectNodeArray2);
        n = SettingsHandler.getClassTab_AvailableListMode();
        if (n >= 0 && n <= 2) {
            viewMode = n;
        }
        SettingsHandler.setClassTab_AvailableListMode(viewMode);
        this.viewComboBox.addItem(PropertyFactory.getString("in_nameLabel"));
        this.viewComboBox.addItem(PropertyFactory.getString("in_typeName"));
        this.viewComboBox.addItem(PropertyFactory.getString("in_sourceName"));
        Utility.setDescription(this.viewComboBox, PropertyFactory.getString("in_clChangCl"));
        this.viewComboBox.setSelectedIndex(viewMode);
        n = SettingsHandler.getClassTab_SelectedListMode();
        if (n >= 0 && n <= 2) {
            viewSelectMode = n;
        }
        SettingsHandler.setClassTab_SelectedListMode(viewSelectMode);
        this.viewSelectComboBox.addItem(PropertyFactory.getString("in_nameLabel"));
        this.viewSelectComboBox.addItem(PropertyFactory.getString("in_typeName"));
        this.viewSelectComboBox.addItem(PropertyFactory.getString("in_sourceName"));
        Utility.setDescription(this.viewSelectComboBox, PropertyFactory.getString("in_clChangCl"));
        this.viewSelectComboBox.setSelectedIndex(viewSelectMode);
        this.createModels();
        this.createTreeTables();
        this.center.setLayout(new BorderLayout());
        this.buildTop();
        JPanel jPanel = new JPanel(new BorderLayout());
        object = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(PropertyFactory.getString("in_clInfo"));
        titledBorder.setTitleJustification(2);
        JScrollPane jScrollPane = new JScrollPane(this.infoLabel);
        jScrollPane.setBorder(titledBorder);
        this.infoLabel.setBackground(jPanel.getBackground());
        jPanel.add((Component)jScrollPane, "Center");
        Utility.setDescription(jPanel, PropertyFactory.getString("in_infoScrollTip"));
        this.initSEPanel((JPanel)object);
        this.asplit = new FlippingSplitPane(1, jPanel, (Component)object);
        this.asplit.setOneTouchExpandable(true);
        this.asplit.setDividerSize(10);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.asplit, "Center");
        this.bsplit = new FlippingSplitPane(0, this.center, jPanel2);
        this.bsplit.setOneTouchExpandable(true);
        this.bsplit.setDividerSize(10);
        this.setLayout(new BorderLayout());
        this.add((Component)this.bsplit, "Center");
        this.availableSort = new JTreeTableSorter(this.availableTable, (PObjectNode)this.availableModel.getRoot(), this.availableModel);
    }

    private void buildTop() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.splitPane = new FlippingSplitPane(splitOrientation, jPanel, jPanel2);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerSize(10);
        this.center.add((Component)this.splitPane, "Center");
        jPanel.add((Component)InfoTabUtils.createFilterPane(this.avaLabel, this.viewComboBox, this.lblQFilter, this.textQFilter, this.clearQFilterButton), "North");
        JScrollPane jScrollPane = new JScrollPane(this.availableTable, 22, 30);
        JButton jButton = new JButton();
        jScrollPane.setCorner("UPPER_RIGHT_CORNER", jButton);
        jButton.setText("^");
        new TableColumnManager(this.availableTable, jButton, this.availableModel);
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel3 = new JPanel(new FlowLayout(1, 5, 1));
        this.addButton = new JButton(IconUtilitities.getImageIcon("Forward16.gif"));
        Utility.setDescription(this.addButton, PropertyFactory.getString("in_clAddTip"));
        this.addButton.setEnabled(false);
        jPanel3.add(this.addButton);
        jPanel.add((Component)jPanel3, "South");
        JPanel jPanel4 = new JPanel(new FlowLayout(1, 5, 1));
        jPanel4.add(this.selLabel);
        jPanel4.add(this.viewSelectComboBox);
        jPanel2.add((Component)jPanel4, "North");
        this.selectedTable.getColumnModel().getColumn(1).setPreferredWidth(15);
        JScrollPane jScrollPane2 = new JScrollPane(this.selectedTable, 22, 30);
        jPanel2.add((Component)jScrollPane2, "Center");
        JButton jButton2 = new JButton();
        jScrollPane2.setCorner("UPPER_RIGHT_CORNER", jButton2);
        jButton2.setText("^");
        new TableColumnManager(this.selectedTable, jButton2, this.selectedModel);
        int n = this.selectedTable.convertColumnIndexToView(1);
        if (n > -1) {
            this.selectedTable.setColAlign(n, 0);
        }
        JPanel jPanel5 = new JPanel(new FlowLayout(1, 5, 1));
        this.removeButton = new JButton(IconUtilitities.getImageIcon("Back16.gif"));
        Utility.setDescription(this.removeButton, PropertyFactory.getString("in_clRemoveTip"));
        this.removeButton.setEnabled(false);
        jPanel5.add(this.removeButton);
        jPanel2.add((Component)jPanel5, "South");
    }

    private boolean maybeSetExperience(int n) {
        if (n == this.pc.getXP()) {
            return true;
        }
        this.pc.setXP(n);
        if (n >= this.pc.minXPForNextECL()) {
            ShowMessageDelegate.showMessageDialog(SettingsHandler.getGame().getLevelUpMessage(), "PCGen", MessageType.INFORMATION);
        }
        return true;
    }

    private void experienceFocusLost() {
        this.maybeSetExperience(this.experience.getValue());
    }

    private void initSEPanel(JPanel jPanel) {
        jPanel.setLayout(new GridBagLayout());
        this.pnlWest.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        if (Globals.getGameModeHPFormula().length() == 0) {
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.insets = new Insets(0, 5, 0, 5);
            this.hpButton = new JButton();
            this.hpButton.setText(Globals.getGameModeHPAbbrev());
            this.hpButton.setAlignmentY(0.0f);
            this.hpButton.setHorizontalAlignment(2);
            this.pnlHP.add(this.hpButton);
            this.lblHP.setHorizontalAlignment(11);
            this.pnlHP.add(this.lblHP);
            jPanel.add((Component)this.pnlHP, gridBagConstraints);
        } else {
            this.pnlHP.setLayout(new BorderLayout(5, 5));
            this.lblHPName = new JLabel(Globals.getGameModeHitPointText());
            this.pnlHP.add((Component)this.lblHPName, "West");
            this.pnlHP.add((Component)this.lblHP, "East");
            this.pnlWest.add((Component)this.pnlHP, gridBagConstraints);
        }
        if (!Globals.getGameModeHasPointPool()) {
            this.pnlFeats = new JPanel();
            this.pnlFeats.setLayout(new BorderLayout(5, 5));
            this.lblFeats = new JLabel();
            this.lblFeats.setText(PropertyFactory.getString("in_feats"));
            this.pnlFeats.add((Component)this.lblFeats, "West");
            this.featCount.setText("0");
            this.pnlFeats.add((Component)this.featCount, "East");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weightx = 1.0;
            this.pnlWest.add((Component)this.pnlFeats, gridBagConstraints);
        }
        this.pnlSkills.setLayout(new BorderLayout(5, 5));
        if (Globals.getGameModeHasPointPool()) {
            this.lblSkills.setText(Globals.getGameModePointPoolName());
        } else {
            this.lblSkills.setText(PropertyFactory.getString("in_skills"));
        }
        this.pnlSkills.add((Component)this.lblSkills, "West");
        this.skillCount.setText("0");
        this.pnlSkills.add((Component)this.skillCount, "East");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.pnlWest.add((Component)this.pnlSkills, gridBagConstraints);
        this.pnlBAB.setLayout(new BorderLayout(5, 5));
        String string = SettingsHandler.getGame().getBabAbbrev();
        if (string == null) {
            string = "BAB";
        }
        this.lblBAB.setText(string);
        this.pnlBAB.add((Component)this.lblBAB, "West");
        this.lBAB.setText("0");
        this.pnlBAB.add((Component)this.lBAB, "East");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.pnlWest.add((Component)this.pnlBAB, gridBagConstraints);
        this.pnlDefense.setLayout(new BorderLayout(5, 5));
        string = Globals.getGameModeACText();
        this.lblDefense.setText(string);
        this.pnlDefense.add((Component)this.lblDefense, "West");
        this.pnlDefense.setVisible(string.length() != 0);
        this.lDefense.setText("0");
        this.pnlDefense.add((Component)this.lDefense, "East");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.pnlWest.add((Component)this.pnlDefense, gridBagConstraints);
        this.pnlAltHP.setLayout(new BorderLayout(5, 5));
        string = Globals.getGameModeAltHPText();
        this.lblAltHP.setText(string);
        this.pnlAltHP.add((Component)this.lblAltHP, "West");
        this.pnlAltHP.setVisible(string.length() != 0);
        this.pnlAltHP.add((Component)this.lAHP, "East");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.pnlWest.add((Component)this.pnlAltHP, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlWest.add((Component)this.pnlFillerWest, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.pnlWest, gridBagConstraints);
        this.buildEastPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.pnlEast, gridBagConstraints);
        this.pnlXP.setLayout(new GridBagLayout());
        this.lblExperience.setText(PropertyFactory.getString("in_experience"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.pnlXP.add((Component)this.lblExperience, gridBagConstraints);
        this.experience.setHorizontalAlignment(11);
        this.experience.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        gridBagConstraints.weightx = 1.0;
        this.pnlXP.add((Component)this.experience, gridBagConstraints);
        this.pnlXP.add((Component)this.adjXP, new GridBagConstraints());
        this.lblNextLevel.setText(PropertyFactory.getString("in_icNextLevel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.pnlXP.add((Component)this.lblNextLevel, gridBagConstraints);
        this.txtNextLevel.setHorizontalAlignment(11);
        this.txtNextLevel.setBorder(BorderFactory.createEtchedBorder(Color.lightGray, Color.lightGray));
        this.txtNextLevel.setBackground(Color.lightGray);
        this.txtNextLevel.setEditable(false);
        this.txtNextLevel.setValue(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        gridBagConstraints.weightx = 1.0;
        this.pnlXP.add((Component)this.txtNextLevel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.pnlXP, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.pnlFillerSouth, gridBagConstraints);
    }

    private void updateAvailableModel() {
        List<String> list = this.availableTable.getExpandedPaths();
        this.createAvailableModel();
        this.availableTable.updateUI();
        this.availableTable.expandPathList(list);
    }

    private void updateCharacterInfo() {
        if (this.pc == null || !needsUpdate) {
            return;
        }
        if (this.hpButton != null) {
            this.hpButton.setText(Globals.getGameModeHPAbbrev());
        } else if (this.lblHPName != null) {
            this.lblHPName.setText(Globals.getGameModeHitPointText());
        }
        String string = Globals.getGameModeACText();
        if (Globals.getGameModeShowClassDefense()) {
            this.lblDefense.setText(string + " (" + PropertyFactory.getString("in_class") + ")");
            this.pnlDefense.setVisible(true);
        } else {
            this.pnlDefense.setVisible(false);
        }
        string = Globals.getGameModeAltHPText();
        if (string.length() != 0) {
            this.lblAltHP.setText(string);
            this.pnlAltHP.setVisible(true);
        } else {
            this.pnlAltHP.setVisible(false);
        }
        string = Globals.getGameModeVariableDisplayText();
        if (string.length() != 0) {
            this.lblVariableDisplay.setText(string);
            this.pnlVariableDisplay.setVisible(true);
        } else {
            this.pnlVariableDisplay.setVisible(false);
        }
        string = Globals.getGameModeVariableDisplay2Text();
        if (string.length() != 0) {
            this.lblVariableDisplay2.setText(string);
            this.pnlVariableDisplay2.setVisible(true);
        } else {
            this.pnlVariableDisplay2.setVisible(false);
        }
        string = Globals.getGameModeVariableDisplay3Text();
        if (string.length() != 0) {
            this.lblVariableDisplay3.setText(string);
            this.pnlVariableDisplay3.setVisible(true);
        } else {
            this.pnlVariableDisplay3.setVisible(false);
        }
        this.pc.setAggregateAbilitiesStable(null, false);
        this.updateAvailableModel();
        this.updateSelectedModel();
        this.pc.aggregateFeatList();
        this.updateHP();
        this.featCount.setText(Double.toString(this.pc.getFeats()));
        this.skillCount.setText(Integer.toString(this.pc.getSkillPoints()));
        this.lBAB.setText(Integer.toString(this.pc.baseAttackBonus()));
        this.lDefense.setText(Integer.toString(this.pc.classAC()));
        this.updateChecks();
        this.lAHP.setText(Integer.toString(this.pc.altHP()));
        this.updateXP(this.pc);
        int n = (int)this.pc.getTotalBonusTo("VAR", Globals.getGameModeVariableDisplayName());
        this.lVariableDisplay.setText(Integer.toString(n));
        int n2 = (int)this.pc.getTotalBonusTo("VAR", Globals.getGameModeVariableDisplay2Name());
        this.lVariableDisplay2.setText(Integer.toString(n2));
        int n3 = (int)this.pc.getTotalBonusTo("VAR", Globals.getGameModeVariableDisplay3Name());
        this.lVariableDisplay3.setText(Integer.toString(n3));
        needsUpdate = false;
    }

    private void updateChecks() {
        List<PObject> list = SettingsHandler.getGame().getUnmodifiableCheckList();
        int n = list.size();
        if (this.lCheck == null || n != this.lCheck.length) {
            this.buildEastPanel();
        }
        if (n != 0) {
            for (int i = 0; i < n; ++i) {
                PObject pObject = list.get(i);
                this.lblCheck[i].setText(pObject.getDisplayName());
                this.lCheck[i].setText(Delta.toString(this.pc.getTotalCheck(i)));
            }
        }
    }

    private void updateSelectedModel() {
        List<String> list = this.selectedTable.getExpandedPaths();
        this.createSelectedModel();
        this.selectedTable.updateUI();
        this.selectedTable.expandPathList(list);
    }

    private void updateXP(PlayerCharacter playerCharacter) {
        if (playerCharacter == null) {
            return;
        }
        this.experience.setValue(playerCharacter.getXP());
        this.txtNextLevel.setValue(playerCharacter.minXPForNextECL());
    }

    private void viewComboBoxActionPerformed() {
        int n = this.viewComboBox.getSelectedIndex();
        if (n != viewMode) {
            viewMode = n;
            SettingsHandler.setClassTab_AvailableListMode(viewMode);
            this.updateAvailableModel();
        }
    }

    private void viewSelectComboBoxActionPerformed() {
        int n = this.viewSelectComboBox.getSelectedIndex();
        if (n != viewSelectMode) {
            viewSelectMode = n;
            SettingsHandler.setClassTab_SelectedListMode(viewSelectMode);
            this.updateSelectedModel();
        }
    }

    private void clearQFilter() {
        this.availableModel.clearQFilter();
        if (saveViewMode != null) {
            viewMode = saveViewMode;
            saveViewMode = null;
        }
        this.textQFilter.setText("");
        this.availableModel.resetModel(InfoClasses.viewMode, true);
        this.clearQFilterButton.setEnabled(false);
        this.viewComboBox.setEnabled(true);
        this.forceRefresh();
    }

    private void setQFilter() {
        String string = this.textQFilter.getText();
        if (string.length() == 0) {
            this.clearQFilter();
            return;
        }
        this.availableModel.setQFilter(string);
        if (saveViewMode == null) {
            saveViewMode = viewMode;
        }
        viewMode = 0;
        this.availableModel.resetModel(InfoClasses.viewMode, true);
        this.clearQFilterButton.setEnabled(true);
        this.viewComboBox.setEnabled(false);
        this.forceRefresh();
    }

    private static String getBabTitle() {
        String string = SettingsHandler.getGame().getBabAbbrev();
        if (string == null) {
            string = "BAB";
        }
        return string;
    }

    private class SelectedClickHandler
    implements ClickHandler {
        private SelectedClickHandler() {
        }

        public void singleClickEvent() {
        }

        public void doubleClickEvent() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    InfoClasses.this.addClass(-1);
                }
            });
        }

        public boolean isSelectable(Object object) {
            return !(object instanceof String);
        }
    }

    private class AvailableClickHandler
    implements ClickHandler {
        private AvailableClickHandler() {
        }

        public void singleClickEvent() {
        }

        public void doubleClickEvent() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    InfoClasses.this.addClass(1);
                }
            });
        }

        public boolean isSelectable(Object object) {
            return !(object instanceof String);
        }
    }

    private class SelectedListSelectionListener
    implements ListSelectionListener {
        private SelectedListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                Object object;
                int n = InfoClasses.this.getSelectedIndex(listSelectionEvent);
                if (n < 0) {
                    return;
                }
                Object object2 = InfoClasses.this.selectedTable.getTree().getPathForRow(n).getLastPathComponent();
                if (object2 == null) {
                    InfoClasses.this.lastClass = null;
                    InfoClasses.this.infoLabel.setText();
                    return;
                }
                PCClass pCClass = null;
                PObjectNode pObjectNode = null;
                if (object2 instanceof PObjectNode && (object = (pObjectNode = (PObjectNode)object2).getItem()) instanceof PCClass) {
                    pCClass = (PCClass)object;
                }
                InfoClasses.this.removeButton.setEnabled(pCClass != null);
                InfoClasses.this.setInfoLabelText(pCClass, pObjectNode);
            }
        }
    }

    private class AvailableListSelectionListener
    implements ListSelectionListener {
        private AvailableListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                int n = InfoClasses.this.getSelectedIndex(listSelectionEvent);
                if (n < 0) {
                    return;
                }
                Object object = InfoClasses.this.availableTable.getTree().getPathForRow(n).getLastPathComponent();
                if (object == null) {
                    InfoClasses.this.lastClass = null;
                    ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_clNoClass"), "PCGen", MessageType.ERROR);
                    return;
                }
                PCClass pCClass = null;
                PObjectNode pObjectNode = null;
                if (object instanceof PObjectNode) {
                    pObjectNode = (PObjectNode)object;
                    if ((object = ((PObjectNode)object).getItem()) instanceof PCClass) {
                        pCClass = (PCClass)object;
                    }
                }
                InfoClasses.this.addButton.setEnabled(pCClass != null);
                InfoClasses.this.setInfoLabelText(pCClass, pObjectNode);
            }
        }
    }

    private class AdjustXPButtonActionListener
    implements ActionListener {
        private AdjustXPButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = JOptionPane.showInputDialog(null, PropertyFactory.getString("in_clEnterXP"), "PCGen", 3);
            if (string != null) {
                try {
                    int n = Integer.parseInt(string) + InfoClasses.this.pc.getXP();
                    if (InfoClasses.this.maybeSetExperience(n)) {
                        InfoClasses.this.experience.setValue(n);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_clInvalidNum"), "PCGen", MessageType.ERROR);
                    return;
                }
            }
        }
    }

    private class RemoveClassButtonActionListener
    implements ActionListener {
        private RemoveClassButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            InfoClasses.this.addClass(-1);
        }
    }

    private class AddClassButtonActionListener
    implements ActionListener {
        private AddClassButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            InfoClasses.this.addClass(1);
        }
    }

    private class HpButtonActionListener
    implements ActionListener {
        private HpButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            pcGenGUI.showHpFrame(InfoClasses.this.pc);
        }
    }

    private class ExperienceBoxInputVerifier
    extends InputVerifier {
        private ExperienceBoxInputVerifier() {
        }

        public boolean shouldYieldFocus(JComponent jComponent) {
            boolean bl = this.verify(jComponent);
            InfoClasses.this.experienceFocusLost();
            return bl;
        }

        public boolean verify(JComponent jComponent) {
            return true;
        }
    }

    private class ViewSelectComboBoxActionListener
    implements ActionListener {
        private ViewSelectComboBoxActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            InfoClasses.this.viewSelectComboBoxActionPerformed();
        }
    }

    private class ViewComboBoxActionListener
    implements ActionListener {
        private ViewComboBoxActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            InfoClasses.this.viewComboBoxActionPerformed();
        }
    }

    private class PaneComponentAdapter
    extends ComponentAdapter {
        private PaneComponentAdapter() {
        }

        public void componentShown(ComponentEvent componentEvent) {
            try {
                InfoClasses.this.formComponentShown();
            }
            catch (Throwable throwable) {
                Logging.errorPrintLocalised("in_icFailureWhileShowingClassTab", throwable);
            }
        }

        public void componentResized(ComponentEvent componentEvent) {
            InfoClasses.this.bsplit.setDividerLocation((int)(InfoClasses.this.getSize().getHeight() - 140.0));
            InfoClasses.this.asplit.setDividerLocation((int)(InfoClasses.this.getSize().getWidth() - 334.0));
        }
    }

    private class PaneFocusAdapter
    extends FocusAdapter {
        private PaneFocusAdapter() {
        }

        public void focusGained(FocusEvent focusEvent) {
            InfoClasses.this.refresh();
        }
    }

    private class ClassPopupMenu
    extends JPopupMenu {
        static final long serialVersionUID = 9141488354194857537L;
        private String lastSearch = "";

        ClassPopupMenu(JTreeTable jTreeTable) {
            if (jTreeTable == InfoClasses.this.availableTable) {
                this.add(this.createAddMenuItem(PropertyFactory.getString("in_add1"), "shortcut EQUALS"));
                this.addSeparator();
                this.add(Utility.createMenuItem(PropertyFactory.getString("in_icFindItem"), new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ClassPopupMenu.this.lastSearch = InfoClasses.this.availableTable.searchTree(ClassPopupMenu.this.lastSearch);
                    }
                }, "searchItem", '\u0000', "shortcut F", PropertyFactory.getString("in_icFindItem"), null, true));
            } else {
                this.add(this.createAddMenuItem(PropertyFactory.getString("in_add1"), "shortcut EQUALS"));
                this.add(this.createRemoveMenuItem(PropertyFactory.getString("in_remove1"), "shortcut MINUS"));
                this.addSeparator();
                this.add(Utility.createMenuItem(PropertyFactory.getString("in_icFindItem"), new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ClassPopupMenu.this.lastSearch = InfoClasses.this.selectedTable.searchTree(ClassPopupMenu.this.lastSearch);
                    }
                }, "searchItem", '\u0000', "shortcut F", PropertyFactory.getString("in_icFindItem"), null, true));
            }
        }

        private JMenuItem createAddMenuItem(String string, String string2) {
            return Utility.createMenuItem(string, new AddClassActionListener(), PropertyFactory.getString("in_add1"), '\u0000', string2, PropertyFactory.getString("in_add1lvl"), "Add16.gif", true);
        }

        private JMenuItem createRemoveMenuItem(String string, String string2) {
            return Utility.createMenuItem(string, new RemoveClassActionListener(), PropertyFactory.getString("in_remove1"), '\u0000', string2, PropertyFactory.getString("in_remove1lvl"), "Remove16.gif", true);
        }

        private class RemoveClassActionListener
        extends ClassActionListener {
            private RemoveClassActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                InfoClasses.this.addClass(-1);
            }
        }

        private class ClassActionListener
        implements ActionListener {
            private ClassActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
            }
        }

        private class AddClassActionListener
        extends ClassActionListener {
            private AddClassActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                InfoClasses.this.addClass(1);
            }
        }
    }

    private class ClassPopupListener
    extends MouseAdapter {
        private ClassPopupMenu menu;
        private JTree tree;

        ClassPopupListener(JTreeTable jTreeTable, ClassPopupMenu classPopupMenu) {
            this.tree = jTreeTable.getTree();
            this.menu = classPopupMenu;
            KeyListener keyListener = new KeyListener(){

                public void keyTyped(KeyEvent keyEvent) {
                    InfoClasses.this.dispatchEvent(keyEvent);
                }

                public void keyPressed(KeyEvent keyEvent) {
                    int n = keyEvent.getKeyCode();
                    if (n != 0) {
                        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
                        for (int i = 0; i < ClassPopupListener.this.menu.getComponentCount(); ++i) {
                            KeyStroke keyStroke2;
                            Component component = ClassPopupListener.this.menu.getComponent(i);
                            if (!(component instanceof JMenuItem) || (keyStroke2 = ((JMenuItem)component).getAccelerator()) == null || !keyStroke.equals(keyStroke2)) continue;
                            InfoClasses.this.selPath = ClassPopupListener.this.tree.getSelectionPath();
                            ((JMenuItem)component).doClick(2);
                            return;
                        }
                    }
                    InfoClasses.this.dispatchEvent(keyEvent);
                }

                public void keyReleased(KeyEvent keyEvent) {
                    InfoClasses.this.dispatchEvent(keyEvent);
                }
            };
            jTreeTable.addKeyListener(keyListener);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                InfoClasses.this.selPath = this.tree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (InfoClasses.this.selPath == null) {
                    return;
                }
                this.tree.setSelectionPath(InfoClasses.this.selPath);
                this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ClassModel
    extends AbstractTreeTableModel
    implements TableColumnManagerModel {
        private int modelType;
        private List<Boolean> displayList;
        private static final int COL_NAME = 0;
        private static final int COL_REQ = 1;
        private static final int COL_LEVEL = 2;
        private static final int COL_TYPE = 3;
        private static final int COL_BAB = 4;
        private static final int COL_HD = 5;
        private static final int COL_SPELLTYPE = 6;
        private static final int COL_SPELLSTAT = 7;
        private static final int COL_SRC = 8;
        private final String[] colNameList;
        private final int[] colDefaultWidth;

        private ClassModel(int n, boolean bl) {
            super(null);
            this.modelType = 0;
            this.displayList = null;
            this.colNameList = new String[]{PropertyFactory.getString("in_nameLabel"), PropertyFactory.getString("in_preReqs"), PropertyFactory.getString("in_level"), PropertyFactory.getString("in_type"), InfoClasses.getBabTitle(), PropertyFactory.getString("in_hdLabel"), PropertyFactory.getString("in_spellType"), PropertyFactory.getString("in_baseStat"), PropertyFactory.getString("in_sourceLabel")};
            this.colDefaultWidth = new int[]{200, 100, 35, 70, 35, 40, 60, 60, 100};
            if (!bl) {
                this.modelType = 1;
            }
            this.resetModel(n, bl);
            this.displayList = new ArrayList<Boolean>();
            this.displayList.add(Boolean.TRUE);
            if (this.modelType == 0) {
                this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.colNameList[1], true));
                this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.colNameList[2], false));
            } else {
                this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.colNameList[1], false));
                this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.colNameList[2], true));
            }
            this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.colNameList[3], false));
            this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.colNameList[4], false));
            this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.colNameList[5], false));
            this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.colNameList[6], false));
            this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.colNameList[7], false));
            this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.colNameList[8], true));
        }

        @Override
        public boolean isCellEditable(Object object, int n) {
            return n == 0;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return TreeTableModel.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return Integer.class;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    return String.class;
                }
            }
            Logging.errorPrint(PropertyFactory.getString("in_clICEr4") + " " + n + " " + PropertyFactory.getString("in_clICEr2"));
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return this.colNameList.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.colNameList[n];
        }

        @Override
        public Object getRoot() {
            return super.getRoot();
        }

        @Override
        public Object getValueAt(Object object, int n) {
            PObjectNode pObjectNode = (PObjectNode)object;
            PCClass pCClass = null;
            if (pObjectNode != null && pObjectNode.getItem() instanceof PCClass) {
                pCClass = (PCClass)pObjectNode.getItem();
            }
            Integer n2 = 0;
            String string = "";
            switch (n) {
                case 0: {
                    if (pObjectNode != null) {
                        return pObjectNode.toString();
                    }
                    Logging.errorPrint(PropertyFactory.getString("in_clICEr5"));
                    return "";
                }
                case 1: {
                    if (this.modelType == 0 && pCClass != null) {
                        string = PrerequisiteUtilities.preReqHTMLStringsForList(InfoClasses.this.pc, null, pCClass.getPrerequisiteList(), true);
                    }
                    return string;
                }
                case 2: {
                    if (pCClass != null) {
                        return pCClass.getLevel();
                    }
                    return n2;
                }
                case 3: {
                    if (pCClass != null) {
                        string = pCClass.getType();
                    }
                    return string;
                }
                case 4: {
                    if (pCClass != null) {
                        // empty if block
                    }
                    return string;
                }
                case 5: {
                    if (pCClass != null) {
                        int n3 = pCClass.getSafe(ObjectKey.LEVEL_HITDIE).getDie();
                        string = "1d" + n3;
                    }
                    return string;
                }
                case 6: {
                    if (pCClass != null) {
                        string = pCClass.getSpellType();
                    }
                    return string;
                }
                case 7: {
                    if (pCClass != null) {
                        string = pCClass.getSpellBaseStat();
                    }
                    return string;
                }
                case 8: {
                    if (pObjectNode != null) {
                        string = pObjectNode.getSource();
                    }
                    return string;
                }
                case -1: {
                    if (pObjectNode != null) {
                        return pObjectNode.getItem();
                    }
                    Logging.errorPrint(PropertyFactory.getString("in_clICEr5"));
                    return null;
                }
            }
            Logging.errorPrint(PropertyFactory.getString("in_clICEr6") + " " + n + " " + PropertyFactory.getString("in_ICEr2"));
            return null;
        }

        private void setRoot(PObjectNode pObjectNode) {
            super.setRoot(pObjectNode);
        }

        private void addSubClassesTo(PObjectNode pObjectNode, PCClass pCClass) {
            List<SubClass> list = pCClass.getListFor(ListKey.SUB_CLASS);
            if (list != null) {
                for (SubClass subClass : list) {
                    PObjectNode pObjectNode2 = new PObjectNode();
                    pObjectNode2.setParent(pObjectNode);
                    pObjectNode2.setItem(subClass);
                    PrereqHandler.passesAll(subClass.getPrerequisiteList(), InfoClasses.this.pc, subClass);
                    pObjectNode.addChild(pObjectNode2);
                }
            }
        }

        private void resetModel(int n, boolean bl) {
            Object object;
            Collection<PCClass> collection = bl ? Globals.getContext().ref.getConstructedCDOMObjects(PCClass.class) : InfoClasses.this.pc.getClassList();
            switch (n) {
                case 0: {
                    this.setRoot(new PObjectNode());
                    object = this.getQFilter();
                    for (PCClass pCClass : collection) {
                        if (!this.shouldDisplayThis(pCClass) || object != null && pCClass.getDisplayName().toLowerCase().indexOf((String)object) < 0 && pCClass.getType().toLowerCase().indexOf((String)object) < 0) continue;
                        PObjectNode pObjectNode = new PObjectNode();
                        pObjectNode.setParent((PObjectNode)super.getRoot());
                        pObjectNode.setItem(pCClass);
                        PrereqHandler.passesAll(pCClass.getPrerequisiteList(), InfoClasses.this.pc, pCClass);
                        ((PObjectNode)super.getRoot()).addChild(pObjectNode);
                        if (!bl) continue;
                        this.addSubClassesTo(pObjectNode, pCClass);
                    }
                    break;
                }
                case 1: {
                    this.setRoot(typeRoot.clone());
                    for (PCClass pCClass : collection) {
                        if (!this.shouldDisplayThis(pCClass)) continue;
                        PObjectNode pObjectNode = (PObjectNode)super.getRoot();
                        boolean bl2 = false;
                        for (int i = 0; i < pObjectNode.getChildCount(); ++i) {
                            if ((bl2 || i != pObjectNode.getChildCount() - 1) && !pCClass.isType(pObjectNode.getChildren().get(i).getItem().toString())) continue;
                            PObjectNode pObjectNode2 = new PObjectNode();
                            pObjectNode2.setParent(pObjectNode.getChild(i));
                            pObjectNode2.setItem(pCClass);
                            PrereqHandler.passesAll(pCClass.getPrerequisiteList(), InfoClasses.this.pc, pCClass);
                            pObjectNode.getChild(i).addChild(pObjectNode2);
                            bl2 = true;
                            if (!bl) continue;
                            this.addSubClassesTo(pObjectNode2, pCClass);
                        }
                    }
                    break;
                }
                case 2: {
                    this.setRoot(sourceRoot.clone());
                    for (PCClass pCClass : collection) {
                        if (!this.shouldDisplayThis(pCClass)) continue;
                        PObjectNode pObjectNode = (PObjectNode)super.getRoot();
                        boolean bl3 = false;
                        for (int i = 0; i < pObjectNode.getChildCount(); ++i) {
                            String string = SourceFormat.getFormattedString(pCClass, SourceFormat.LONG, false);
                            if (string.length() == 0) {
                                Logging.errorPrintLocalised("in_icPCClassHasNoSourceLongEntry", pCClass.getDisplayName());
                                continue;
                            }
                            if ((bl3 || i != pObjectNode.getChildCount() - 1) && !string.equals(pObjectNode.getChildren().get(i).getItem().toString())) continue;
                            PObjectNode pObjectNode3 = new PObjectNode();
                            pObjectNode3.setParent(pObjectNode.getChild(i));
                            pObjectNode3.setItem(pCClass);
                            PrereqHandler.passesAll(pCClass.getPrerequisiteList(), InfoClasses.this.pc, pCClass);
                            pObjectNode.getChild(i).addChild(pObjectNode3);
                            bl3 = true;
                            if (!bl) continue;
                            this.addSubClassesTo(pObjectNode3, pCClass);
                        }
                    }
                    break;
                }
                default: {
                    Logging.errorPrint(PropertyFactory.getString("in_clICEr1") + " " + n + " " + PropertyFactory.getString("in_clICEr2"));
                }
            }
            object = (PObjectNode)super.getRoot();
            if (((PObjectNode)object).getChildCount() > 0) {
                this.fireTreeNodesChanged(super.getRoot(), new TreePath(super.getRoot()));
            }
        }

        private boolean shouldDisplayThis(PCClass pCClass) {
            if (SettingsHandler.hideMonsterClasses() && pCClass.isMonster()) {
                return false;
            }
            return this.modelType == 1 || pCClass.getSafe(ObjectKey.VISIBILITY).equals((Object)Visibility.DEFAULT) && InfoClasses.this.accept(InfoClasses.this.pc, pCClass);
        }

        @Override
        public List<String> getMColumnList() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 1; i < this.colNameList.length; ++i) {
                arrayList.add(this.colNameList[i]);
            }
            return arrayList;
        }

        @Override
        public boolean isMColumnDisplayed(int n) {
            return this.displayList.get(n);
        }

        @Override
        public void setMColumnDisplayed(int n, boolean bl) {
            this.setColumnViewOption(this.modelType + "." + this.colNameList[n], bl);
            this.displayList.set(n, bl);
        }

        @Override
        public int getMColumnOffset() {
            return 1;
        }

        @Override
        public int getMColumnDefaultWidth(int n) {
            return SettingsHandler.getPCGenOption("InfoClasses.sizecol." + this.colNameList[n], this.colDefaultWidth[n]);
        }

        @Override
        public void setMColumnDefaultWidth(int n, int n2) {
            SettingsHandler.setPCGenOption("InfoClasses.sizecol." + this.colNameList[n], n2);
        }

        private boolean getColumnViewOption(String string, boolean bl) {
            return SettingsHandler.getPCGenOption("InfoClasses.viewcol." + string, bl);
        }

        private void setColumnViewOption(String string, boolean bl) {
            SettingsHandler.setPCGenOption("InfoClasses.viewcol." + string, bl);
        }

        @Override
        public void resetMColumn(int n, TableColumn tableColumn) {
        }
    }
}

