/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.RaceType;
import pcgen.cdom.enumeration.SourceFormat;
import pcgen.cdom.enumeration.Type;
import pcgen.core.Globals;
import pcgen.core.PCTemplate;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.analysis.OutputNameFormatting;
import pcgen.core.analysis.TemplateModifier;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.PrerequisiteUtilities;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.CharacterInfo;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.TableColumnManager;
import pcgen.gui.TableColumnManagerModel;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.panes.FlippingSplitPane;
import pcgen.gui.tabs.BaseCharacterInfoTab;
import pcgen.gui.tabs.InfoTabUtils;
import pcgen.gui.utils.AbstractTreeTableModel;
import pcgen.gui.utils.ClickHandler;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.InfoLabelTextBuilder;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.JLabelPane;
import pcgen.gui.utils.JTreeTable;
import pcgen.gui.utils.JTreeTableMouseAdapter;
import pcgen.gui.utils.JTreeTableSorter;
import pcgen.gui.utils.LabelTreeCellRenderer;
import pcgen.gui.utils.PObjectNode;
import pcgen.gui.utils.ResizeColumnListener;
import pcgen.gui.utils.TreeTableModel;
import pcgen.gui.utils.Utility;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;
import pcgen.util.enumeration.Tab;
import pcgen.util.enumeration.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfoTemplates
extends BaseCharacterInfoTab {
    private static final Tab tab = Tab.TEMPLATES;
    private JLabel sortLabel = new JLabel(PropertyFactory.getString("in_irSortTempl"));
    private JComboBoxEx viewComboBox = new JComboBoxEx();
    private int viewMode = 0;
    private final JLabel lblQFilter = new JLabel("Filter:");
    private JTextField textQFilter = new JTextField();
    private JButton clearQFilterButton = new JButton("Clear");
    private static Integer saveViewMode = null;
    private JButton addButton;
    private TemplatesTableModel availableModel;
    private JTreeTableSorter availableSort = null;
    private JScrollPane availablePane;
    private JTreeTable availableTable;
    private JTree availableTree = null;
    private JLabel selSortLabel = new JLabel(PropertyFactory.getString("in_irSortTemplSel"));
    private JComboBoxEx viewSelComboBox = new JComboBoxEx();
    private int viewSelMode = 0;
    private JButton removeButton;
    private TemplatesTableModel selectedModel;
    private JTreeTableSorter selectedSort = null;
    private JScrollPane selectedPane;
    private JTreeTable selectedTable;
    private JTree selectedTree = null;
    private FlippingSplitPane split;
    private FlippingSplitPane bsplit;
    private JLabelPane infoLabel = new JLabelPane();
    private JPanel botPane = new JPanel();
    private JPanel topPane = new JPanel();
    private TreePath selPath;
    private static PObjectNode typeRoot;
    private static PObjectNode sourceRoot;
    private boolean hasBeenSized = false;
    private PCTemplate lastTemplate = null;

    public InfoTemplates(PlayerCharacter playerCharacter) {
        super(playerCharacter);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InfoTemplates.this.initComponents();
                InfoTemplates.this.initActionListeners();
            }
        });
    }

    private void initActionListeners() {
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                InfoTemplates.this.refresh();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                InfoTemplates.this.formComponentShown();
            }

            public void componentResized(ComponentEvent componentEvent) {
                int n = InfoTemplates.this.split.getDividerLocation();
                if (n > 0) {
                    SettingsHandler.setPCGenOption("InfoTemplates.asplit", n);
                }
                if ((n = InfoTemplates.this.bsplit.getDividerLocation()) > 0) {
                    SettingsHandler.setPCGenOption("InfoTemplates.bsplit", n);
                }
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoTemplates.this.removeTemplate();
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoTemplates.this.addTemplate();
            }
        });
        this.viewComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoTemplates.this.viewComboBoxActionPerformed();
            }
        });
        this.viewSelComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoTemplates.this.viewSelComboBoxActionPerformed();
            }
        });
        this.textQFilter.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                InfoTemplates.this.setQFilter();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                InfoTemplates.this.setQFilter();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                InfoTemplates.this.setQFilter();
            }
        });
        this.clearQFilterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoTemplates.this.clearQFilter();
            }
        });
        this.availableTable.getSelectionModel().addListSelectionListener(new AvailableListSelectionListener());
        this.selectedTable.getSelectionModel().addListSelectionListener(new SelectedListSelectionListener());
        this.availableTable.addMouseListener(new JTreeTableMouseAdapter(this.availableTable, new AvailableClickHandler(), false));
        this.selectedTable.addMouseListener(new JTreeTableMouseAdapter(this.selectedTable, new SelectedClickHandler(), false));
        FilterFactory.restoreFilterSettings(this);
    }

    private void initComponents() {
        int n;
        typeRoot = new PObjectNode();
        sourceRoot = new PObjectNode();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (PCTemplate pCTemplate : Globals.getContext().ref.getConstructedCDOMObjects(PCTemplate.class)) {
            for (Type object : pCTemplate.getTrueTypeList(false)) {
                String string = object.toString();
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
            String string = SourceFormat.getFormattedString(pCTemplate, SourceFormat.LONG, false);
            if (string.length() == 0) {
                Logging.errorPrint("PC template " + pCTemplate.getDisplayName() + " has no source long entry.");
                continue;
            }
            if (arrayList2.contains(string)) continue;
            arrayList2.add(string);
        }
        Collections.sort(arrayList);
        if (!arrayList.contains(PropertyFactory.getString("in_other"))) {
            arrayList.add(PropertyFactory.getString("in_other"));
        }
        PObjectNode[] pObjectNodeArray = new PObjectNode[arrayList.size()];
        for (int i = 0; i < pObjectNodeArray.length; ++i) {
            pObjectNodeArray[i] = new PObjectNode();
            pObjectNodeArray[i].setItem(arrayList.get(i));
            pObjectNodeArray[i].setParent(typeRoot);
        }
        typeRoot.setChildren(pObjectNodeArray);
        Collections.sort(arrayList2);
        PObjectNode[] pObjectNodeArray2 = new PObjectNode[arrayList2.size()];
        for (n = 0; n < pObjectNodeArray2.length; ++n) {
            String string = ((String)arrayList2.get(n)).toString();
            if (string == null) continue;
            pObjectNodeArray2[n] = new PObjectNode();
            pObjectNodeArray2[n].setItem(string);
            pObjectNodeArray2[n].setParent(sourceRoot);
        }
        sourceRoot.setChildren(pObjectNodeArray2);
        n = SettingsHandler.getTemplateTab_ListMode();
        if (n >= 0 && n <= 2) {
            this.viewMode = n;
        }
        SettingsHandler.setTemplateTab_ListMode(this.viewMode);
        this.viewComboBox.addItem(PropertyFactory.getString("in_nameLabel"));
        this.viewComboBox.addItem(PropertyFactory.getString("in_typeName"));
        this.viewComboBox.addItem(PropertyFactory.getString("in_sourceName"));
        this.viewComboBox.setSelectedIndex(this.viewMode);
        n = SettingsHandler.getTemplateSelTab_ListMode();
        if (n >= 0 && n <= 2) {
            this.viewSelMode = n;
        }
        SettingsHandler.setTemplateSelTab_ListMode(this.viewSelMode);
        this.viewSelComboBox.addItem(PropertyFactory.getString("in_nameLabel"));
        this.viewSelComboBox.addItem(PropertyFactory.getString("in_typeName"));
        this.viewSelComboBox.addItem(PropertyFactory.getString("in_sourceName"));
        this.viewSelComboBox.setSelectedIndex(this.viewSelMode);
        this.createModels();
        this.createTreeTables();
        this.buildTopPanel();
        this.buildBottomPanel();
        this.bsplit = new FlippingSplitPane(0, this.topPane, this.botPane);
        this.bsplit.setOneTouchExpandable(true);
        this.bsplit.setDividerSize(10);
        this.setLayout(new BorderLayout());
        this.add((Component)this.bsplit, "Center");
        this.availableSort = new JTreeTableSorter(this.availableTable, (PObjectNode)this.availableModel.getRoot(), this.availableModel);
    }

    private void createTreeTables() {
        this.availableTable = new JTreeTable(this.availableModel);
        this.availableTable.setSelectionMode(0);
        this.availableTree = this.availableTable.getTree();
        this.availableTree.setRootVisible(false);
        this.availableTree.setShowsRootHandles(true);
        this.availableTree.setCellRenderer(new LabelTreeCellRenderer());
        this.selectedTable = new JTreeTable(this.selectedModel);
        this.selectedTable.setSelectionMode(0);
        this.selectedTree = this.selectedTable.getTree();
        this.selectedTree.setRootVisible(false);
        this.selectedTree.setShowsRootHandles(true);
        this.selectedTree.setCellRenderer(new LabelTreeCellRenderer());
        this.hookupPopupMenu(this.availableTable);
        this.hookupPopupMenu(this.selectedTable);
    }

    private void buildTopPanel() {
        this.topPane.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new BorderLayout());
        this.split = new FlippingSplitPane(1, jPanel, jPanel2);
        this.split.setOneTouchExpandable(true);
        this.split.setDividerSize(10);
        this.topPane.add((Component)this.split, "Center");
        jPanel.add((Component)InfoTabUtils.createFilterPane(this.sortLabel, this.viewComboBox, this.lblQFilter, this.textQFilter, this.clearQFilterButton), "North");
        this.availablePane = new JScrollPane(this.availableTable, 22, 30);
        JButton jButton = new JButton();
        this.availablePane.setCorner("UPPER_RIGHT_CORNER", jButton);
        jButton.setText("^");
        new TableColumnManager(this.availableTable, jButton, this.availableModel);
        jPanel.add((Component)this.availablePane, "Center");
        JPanel jPanel3 = new JPanel();
        this.addButton = new JButton(IconUtilitities.getImageIcon("Forward16.gif"));
        Utility.setDescription(this.addButton, PropertyFactory.getString("in_irTemplAddTip"));
        this.addButton.setEnabled(true);
        jPanel3.add(this.addButton);
        jPanel.add((Component)jPanel3, "South");
        jPanel2.add((Component)InfoTabUtils.createFilterPane(this.selSortLabel, this.viewSelComboBox, null, null, null), "North");
        this.selectedPane = new JScrollPane(this.selectedTable, 22, 30);
        JButton jButton2 = new JButton();
        this.selectedPane.setCorner("UPPER_RIGHT_CORNER", jButton2);
        jButton2.setText("^");
        new TableColumnManager(this.selectedTable, jButton2, this.selectedModel);
        jPanel2.add((Component)this.selectedPane, "Center");
        JPanel jPanel4 = new JPanel();
        this.removeButton = new JButton(IconUtilitities.getImageIcon("Back16.gif"));
        Utility.setDescription(this.removeButton, PropertyFactory.getString("in_irTemplRemoveTip"));
        this.removeButton.setEnabled(true);
        jPanel4.add(this.removeButton);
        jPanel2.add((Component)jPanel4, "South");
    }

    private void buildBottomPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.botPane.setLayout(new BorderLayout());
        this.botPane.add((Component)jPanel, "Center");
        JScrollPane jScrollPane = new JScrollPane();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(PropertyFactory.getString("in_irTemplateInfo"));
        titledBorder.setTitleJustification(2);
        jScrollPane.setBorder(titledBorder);
        this.infoLabel.setBackground(this.topPane.getBackground());
        jScrollPane.setViewportView(this.infoLabel);
        jPanel.add(jScrollPane);
    }

    @Override
    public Tab getTab() {
        return tab;
    }

    @Override
    public int getTabOrder() {
        return SettingsHandler.getPCGenOption(".Panel.Race.Order", tab.ordinal());
    }

    @Override
    public void setTabOrder(int n) {
        SettingsHandler.setPCGenOption(".Panel.Race.Order", n);
    }

    @Override
    public List<String> getToDos() {
        return Collections.emptyList();
    }

    @Override
    public final boolean isMatchAnyEnabled() {
        return true;
    }

    public void pushUpdate() {
        PCGen_Frame1 pCGen_Frame1 = PCGen_Frame1.getInst();
        pCGen_Frame1.featList_Changed();
        pCGen_Frame1.hpTotal_Changed();
        PCGen_Frame1.forceUpdate_PlayerTabs();
        CharacterInfo characterInfo = PCGen_Frame1.getCharacterPane();
        characterInfo.setPaneForUpdate(characterInfo.infoSkills());
        characterInfo.setPaneForUpdate(characterInfo.infoSpells());
        characterInfo.setPaneForUpdate(characterInfo.infoDomain());
        characterInfo.setPaneForUpdate(characterInfo.infoInventory());
        characterInfo.setPaneForUpdate(characterInfo.infoSummary());
        characterInfo.refresh();
    }

    @Override
    public final boolean isNegateEnabled() {
        return true;
    }

    @Override
    public final int getSelectionMode() {
        return 2;
    }

    @Override
    public final void initializeFilters() {
        FilterFactory.registerAllSourceFilters(this);
        FilterFactory.registerAllSizeFilters(this);
        FilterFactory.registerAllRaceFilters(this);
        FilterFactory.registerAllPrereqAlignmentFilters(this);
    }

    @Override
    public final void refreshFiltering() {
        this.availableModel.resetModel(this.viewMode, true);
        this.selectedModel.resetModel(this.viewSelMode, false);
    }

    private void setInfoLabelText(PCTemplate pCTemplate, PObjectNode pObjectNode) {
        this.lastTemplate = pCTemplate;
        InfoLabelTextBuilder infoLabelTextBuilder = new InfoLabelTextBuilder();
        if (pCTemplate != null) {
            String string;
            infoLabelTextBuilder.appendTitleElement(OutputNameFormatting.piString(pCTemplate, false));
            infoLabelTextBuilder.appendLineBreak();
            RaceType raceType = pCTemplate.get(ObjectKey.RACETYPE);
            if (raceType != null) {
                infoLabelTextBuilder.appendI18nElement("in_irInfoRaceType", raceType.toString());
            }
            if (pCTemplate.getType().length() > 0) {
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_irInfoType", pCTemplate.getType());
            }
            if ((string = PrerequisiteUtilities.preReqHTMLStringsForList(this.getPc(), null, pCTemplate.getPrerequisiteList(), false)).length() > 0) {
                infoLabelTextBuilder.appendLineBreak();
                infoLabelTextBuilder.appendI18nElement("in_requirements", string);
            }
            if ((string = pCTemplate.getDefaultSourceString()).length() > 0) {
                infoLabelTextBuilder.appendLineBreak();
                infoLabelTextBuilder.appendI18nElement("in_sourceLabel", string);
            }
        }
        this.infoLabel.setText(infoLabelTextBuilder.toString());
    }

    private void formComponentShown() {
        this.requestFocus();
        PCGen_Frame1.setMessageAreaTextWithoutSaving(PropertyFactory.getString("in_irSelectTemplate"));
        this.refresh();
        int n = this.bsplit.getDividerLocation();
        int n2 = this.split.getDividerLocation();
        if (!this.hasBeenSized) {
            n = SettingsHandler.getPCGenOption("InfoTemplate.bsplit", (int)(this.getSize().getHeight() - 120.0));
            n2 = SettingsHandler.getPCGenOption("InfoTemplate.asplit", (int)(this.getSize().getWidth() * 75.0 / 100.0));
            for (int i = 0; i < this.availableTable.getColumnCount(); ++i) {
                TableColumn tableColumn = this.availableTable.getColumnModel().getColumn(i);
                int n3 = Globals.getCustColumnWidth("Template", i);
                if (n3 != 0) {
                    tableColumn.setPreferredWidth(n3);
                }
                tableColumn.addPropertyChangeListener(new ResizeColumnListener(this.availableTable, "Template", i));
            }
        }
        if (n > 0) {
            this.bsplit.setDividerLocation(n);
            SettingsHandler.setPCGenOption("InfoRace.bsplit", n);
        }
        if (n2 > 0) {
            this.split.setDividerLocation(n2);
            SettingsHandler.setPCGenOption("InfoRace.asplit", n2);
        }
    }

    private void hookupPopupMenu(JTreeTable jTreeTable) {
        jTreeTable.addMouseListener(new TemplatePopupListener(jTreeTable, new TemplatePopupMenu(jTreeTable)));
    }

    private void viewComboBoxActionPerformed() {
        int n = this.viewComboBox.getSelectedIndex();
        if (n != this.viewMode) {
            this.viewMode = n;
            SettingsHandler.setTemplateTab_ListMode(this.viewMode);
            this.updateAvailableModel();
        }
    }

    private void viewSelComboBoxActionPerformed() {
        int n = this.viewSelComboBox.getSelectedIndex();
        if (n != this.viewSelMode) {
            this.viewSelMode = n;
            SettingsHandler.setTemplateSelTab_ListMode(this.viewSelMode);
            this.updateSelectedModel();
        }
    }

    private void clearQFilter() {
        this.availableModel.clearQFilter();
        if (saveViewMode != null) {
            this.viewMode = saveViewMode;
            saveViewMode = null;
        }
        this.textQFilter.setText("");
        this.availableModel.resetModel(this.viewMode, true);
        this.clearQFilterButton.setEnabled(false);
        this.viewComboBox.setEnabled(true);
        this.forceRefresh();
    }

    private void setQFilter() {
        String string = this.textQFilter.getText();
        if (string.length() == 0) {
            this.clearQFilter();
            return;
        }
        this.availableModel.setQFilter(string);
        if (saveViewMode == null) {
            saveViewMode = this.viewMode;
        }
        this.viewMode = 0;
        this.availableModel.resetModel(this.viewMode, true);
        this.clearQFilterButton.setEnabled(true);
        this.viewComboBox.setEnabled(false);
        this.forceRefresh();
    }

    private void addTemplate() {
        PCTemplate pCTemplate = this.getSelectedTemplate();
        if (pCTemplate == null || !PrereqHandler.passesAll(pCTemplate.getPrerequisiteList(), this.getPc(), pCTemplate)) {
            return;
        }
        this.getPc().setDirty(true);
        PCTemplate pCTemplate2 = this.getPc().getTemplateKeyed(pCTemplate.getKeyName());
        if (pCTemplate2 == null) {
            this.getPc().addTemplate(pCTemplate);
            this.pushUpdate();
            this.availableModel.resetModel(this.viewMode, true);
        } else {
            JOptionPane.showMessageDialog(null, PropertyFactory.getString("in_irHaveTemplate"));
        }
        this.forceRefresh();
    }

    private void removeTemplate() {
        PCTemplate pCTemplate = this.getSelectedTemplate();
        if (pCTemplate == null) {
            return;
        }
        this.getPc().setDirty(true);
        PCTemplate pCTemplate2 = this.getPc().getTemplateKeyed(pCTemplate.getKeyName());
        if (pCTemplate2 != null) {
            this.getPc().removeTemplate(pCTemplate);
            this.pushUpdate();
            this.availableModel.resetModel(this.viewMode, true);
            this.selectedModel.resetModel(this.viewSelMode, false);
        } else {
            JOptionPane.showMessageDialog(null, PropertyFactory.getString("in_irNotRemovable"));
        }
        this.forceRefresh();
    }

    private PCTemplate getSelectedTemplate() {
        if (this.lastTemplate == null) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_irNoTemplate"), "PCGen", MessageType.ERROR);
        }
        return this.lastTemplate;
    }

    private int getSelectedIndex(ListSelectionEvent listSelectionEvent) {
        DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
        if (defaultListSelectionModel == null) {
            return -1;
        }
        return defaultListSelectionModel.getMinSelectionIndex();
    }

    private void createModels() {
        this.createSelectedModel();
        this.createAvailableModel();
    }

    private void createAvailableModel() {
        if (this.availableModel == null) {
            this.availableModel = new TemplatesTableModel(this.viewMode, true);
        } else {
            this.availableModel.resetModel(this.viewMode, true);
        }
        if (this.availableSort != null) {
            this.availableSort.setRoot((PObjectNode)this.availableModel.getRoot());
            this.availableSort.sortNodeOnColumn();
        }
    }

    private void createSelectedModel() {
        if (this.selectedModel == null) {
            this.selectedModel = new TemplatesTableModel(this.viewSelMode, false);
        } else {
            this.selectedModel.resetModel(this.viewSelMode, false);
        }
        if (this.selectedSort != null) {
            this.selectedSort.setRoot((PObjectNode)this.selectedModel.getRoot());
            this.selectedSort.sortNodeOnColumn();
        }
    }

    private void updateAvailableModel() {
        List<String> list = this.availableTable.getExpandedPaths();
        this.createAvailableModel();
        this.availableTable.updateUI();
        this.availableTable.expandPathList(list);
    }

    private void updateSelectedModel() {
        List<String> list = this.selectedTable.getExpandedPaths();
        this.createSelectedModel();
        this.selectedTable.updateUI();
        this.selectedTable.expandPathList(list);
    }

    @Override
    public final void updateCharacterInfo() {
        if (!this.needsUpdate()) {
            return;
        }
        this.updateAvailableModel();
        this.updateSelectedModel();
        this.setNeedsUpdate(false);
    }

    private class SelectedClickHandler
    implements ClickHandler {
        private SelectedClickHandler() {
        }

        public void singleClickEvent() {
        }

        public void doubleClickEvent() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    InfoTemplates.this.removeTemplate();
                }
            });
        }

        public boolean isSelectable(Object object) {
            return !(object instanceof String);
        }
    }

    private class AvailableClickHandler
    implements ClickHandler {
        private AvailableClickHandler() {
        }

        public void singleClickEvent() {
        }

        public void doubleClickEvent() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    InfoTemplates.this.addTemplate();
                }
            });
        }

        public boolean isSelectable(Object object) {
            return !(object instanceof String);
        }
    }

    private class SelectedListSelectionListener
    implements ListSelectionListener {
        private SelectedListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                Object object;
                int n = InfoTemplates.this.getSelectedIndex(listSelectionEvent);
                if (n < 0) {
                    return;
                }
                Object object2 = InfoTemplates.this.selectedTable.getTree().getPathForRow(n).getLastPathComponent();
                if (object2 == null) {
                    InfoTemplates.this.lastTemplate = null;
                    InfoTemplates.this.infoLabel.setText();
                    return;
                }
                PCTemplate pCTemplate = null;
                PObjectNode pObjectNode = null;
                if (object2 instanceof PObjectNode && (object = (pObjectNode = (PObjectNode)object2).getItem()) instanceof PCTemplate) {
                    pCTemplate = (PCTemplate)object;
                }
                InfoTemplates.this.removeButton.setEnabled(pCTemplate != null);
                InfoTemplates.this.setInfoLabelText(pCTemplate, pObjectNode);
            }
        }
    }

    private class AvailableListSelectionListener
    implements ListSelectionListener {
        private AvailableListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                int n = InfoTemplates.this.getSelectedIndex(listSelectionEvent);
                if (n < 0) {
                    return;
                }
                Object object = InfoTemplates.this.availableTable.getTree().getPathForRow(n).getLastPathComponent();
                if (object == null) {
                    InfoTemplates.this.lastTemplate = null;
                    ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_irNoTemplate"), "PCGen", MessageType.ERROR);
                    return;
                }
                PCTemplate pCTemplate = null;
                PObjectNode pObjectNode = null;
                if (object instanceof PObjectNode) {
                    pObjectNode = (PObjectNode)object;
                    if ((object = ((PObjectNode)object).getItem()) instanceof PCTemplate) {
                        pCTemplate = (PCTemplate)object;
                    }
                }
                InfoTemplates.this.addButton.setEnabled(pCTemplate != null);
                InfoTemplates.this.setInfoLabelText(pCTemplate, pObjectNode);
            }
        }
    }

    private class TemplatePopupMenu
    extends JPopupMenu {
        static final long serialVersionUID = 2565545289875422981L;

        TemplatePopupMenu(JTreeTable jTreeTable) {
            if (jTreeTable == InfoTemplates.this.availableTable) {
                this.add(this.createAddMenuItem(PropertyFactory.getString("in_irAddTemplate"), "shortcut EQUALS"));
            } else {
                this.add(this.createRemoveMenuItem(PropertyFactory.getString("in_irRemoveTemplate"), "shortcut MINUS"));
            }
        }

        private JMenuItem createAddMenuItem(String string, String string2) {
            return Utility.createMenuItem(string, new AddTemplateActionListener(), PropertyFactory.getString("in_select"), '\u0000', string2, PropertyFactory.getString("in_irAddTemplateTip"), "Add16.gif", true);
        }

        private JMenuItem createRemoveMenuItem(String string, String string2) {
            return Utility.createMenuItem(string, new RemoveTemplateActionListener(), PropertyFactory.getString("in_select"), '\u0000', string2, PropertyFactory.getString("in_irRemoveTemplateTip"), "Remove16.gif", true);
        }

        private class TemplateActionListener
        implements ActionListener {
            private TemplateActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
            }
        }

        private class RemoveTemplateActionListener
        extends TemplateActionListener {
            private RemoveTemplateActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                InfoTemplates.this.removeTemplate();
            }
        }

        private class AddTemplateActionListener
        extends TemplateActionListener {
            private AddTemplateActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                InfoTemplates.this.addTemplate();
            }
        }
    }

    private class TemplatePopupListener
    extends MouseAdapter {
        private JTree tree;
        private TemplatePopupMenu menu;

        TemplatePopupListener(JTreeTable jTreeTable, TemplatePopupMenu templatePopupMenu) {
            this.tree = jTreeTable.getTree();
            this.menu = templatePopupMenu;
            KeyListener keyListener = new KeyListener(){

                public void keyTyped(KeyEvent keyEvent) {
                    InfoTemplates.this.dispatchEvent(keyEvent);
                }

                public void keyPressed(KeyEvent keyEvent) {
                    int n = keyEvent.getKeyCode();
                    if (n != 0) {
                        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
                        for (int i = 0; i < TemplatePopupListener.this.menu.getComponentCount(); ++i) {
                            KeyStroke keyStroke2;
                            Component component = TemplatePopupListener.this.menu.getComponent(i);
                            if (!(component instanceof JMenuItem) || (keyStroke2 = ((JMenuItem)component).getAccelerator()) == null || !keyStroke.equals(keyStroke2)) continue;
                            InfoTemplates.this.selPath = TemplatePopupListener.this.tree.getSelectionPath();
                            ((JMenuItem)component).doClick(2);
                            return;
                        }
                    }
                    InfoTemplates.this.dispatchEvent(keyEvent);
                }

                public void keyReleased(KeyEvent keyEvent) {
                    InfoTemplates.this.dispatchEvent(keyEvent);
                }
            };
            jTreeTable.addKeyListener(keyListener);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                InfoTemplates.this.selPath = this.tree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (InfoTemplates.this.selPath == null) {
                    return;
                }
                this.tree.setSelectionPath(InfoTemplates.this.selPath);
                this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class TemplatesTableModel
    extends AbstractTreeTableModel
    implements TableColumnManagerModel {
        static final long serialVersionUID = 2565545289875422981L;
        private static final int COL_NAME = 0;
        private static final int COL_LEVEL = 1;
        private static final int COL_MODIFIER = 2;
        private static final int COL_REQS = 3;
        private static final int COL_SRC = 4;
        private final String[] COL_NAMES;
        private final int[] COL_DEFAULT_WIDTH;
        private int modelType;
        private List<Boolean> displayList;

        private TemplatesTableModel(int n, boolean bl) {
            super(null);
            this.COL_NAMES = new String[]{PropertyFactory.getString("in_nameLabel"), PropertyFactory.getString("in_lvlAdj"), PropertyFactory.getString("in_modifier"), PropertyFactory.getString("in_preReqs"), PropertyFactory.getString("in_source")};
            this.COL_DEFAULT_WIDTH = new int[]{200, 35, 35, 100, 100};
            this.modelType = 0;
            this.displayList = null;
            if (!bl) {
                this.modelType = 1;
            }
            this.resetModel(InfoTemplates.this.viewMode, bl);
            this.displayList = new ArrayList<Boolean>();
            this.displayList.add(Boolean.TRUE);
            if (bl) {
                this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.COL_NAMES[1], true));
                this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.COL_NAMES[2], true));
                this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.COL_NAMES[3], true));
            } else {
                this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.COL_NAMES[1], false));
                this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.COL_NAMES[2], false));
                this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.COL_NAMES[3], false));
            }
            this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.COL_NAMES[4], false));
        }

        @Override
        public Class<?> getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return TreeTableModel.class;
                }
                case 1: {
                    return Integer.class;
                }
                case 2: 
                case 3: 
                case 4: {
                    return String.class;
                }
            }
            Logging.errorPrintLocalised("in_irIREr4", n);
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public String getColumnName(int n) {
            return n >= 0 && n < this.COL_NAMES.length ? this.COL_NAMES[n] : "Out Of Bounds";
        }

        @Override
        public Object getRoot() {
            return super.getRoot();
        }

        private void setRoot(PObjectNode pObjectNode) {
            super.setRoot(pObjectNode);
        }

        @Override
        public Object getValueAt(Object object, int n) {
            PObjectNode pObjectNode = (PObjectNode)object;
            PCTemplate pCTemplate = null;
            PCTemplate pCTemplate2 = null;
            if (pObjectNode != null && pObjectNode.getItem() instanceof PCTemplate) {
                pCTemplate = (PCTemplate)pObjectNode.getItem();
                pCTemplate2 = InfoTemplates.this.getPc().getTemplateKeyed(pCTemplate.getKeyName());
            }
            if (pCTemplate2 != null) {
                pCTemplate = pCTemplate2;
            }
            if (pCTemplate != null) {
                switch (n) {
                    case 0: {
                        return pCTemplate.toString();
                    }
                    case 1: {
                        return pCTemplate.getSafe(FormulaKey.LEVEL_ADJUSTMENT).resolve(InfoTemplates.this.getPc(), "");
                    }
                    case 2: {
                        return TemplateModifier.modifierString(pCTemplate, InfoTemplates.this.getPc());
                    }
                    case 3: {
                        return PrereqHandler.toHtmlString(pCTemplate.getPrerequisiteList());
                    }
                    case 4: {
                        return pCTemplate.getDefaultSourceString();
                    }
                }
                Logging.errorPrint("In InfoTemplates.AllTemplatesTableModel.getValueAt the column " + n + " is not supported.");
            }
            return null;
        }

        private void resetModel(int n, boolean bl) {
            Collection<PCTemplate> collection = bl ? Globals.getContext().ref.getConstructedCDOMObjects(PCTemplate.class) : InfoTemplates.this.getPc().getTemplateList();
            switch (n) {
                case 0: {
                    this.createNameViewModel(collection);
                    break;
                }
                case 1: {
                    this.createTypeViewModel(collection);
                    break;
                }
                case 2: {
                    this.createSourceViewModel(collection);
                    break;
                }
                default: {
                    Logging.errorPrintLocalised("in_irIREr1", n);
                }
            }
            PObjectNode pObjectNode = (PObjectNode)super.getRoot();
            if (pObjectNode.getChildCount() > 0) {
                this.fireTreeNodesChanged(super.getRoot(), new TreePath(super.getRoot()));
            }
        }

        private void createNameViewModel(Collection<PCTemplate> collection) {
            this.setRoot(new PObjectNode());
            String string = this.getQFilter();
            for (PCTemplate pCTemplate : collection) {
                if (!this.shouldDisplayThis(pCTemplate) || string != null && pCTemplate.getDisplayName().toLowerCase().indexOf(string) < 0 && pCTemplate.getType().toLowerCase().indexOf(string) < 0) continue;
                PObjectNode pObjectNode = new PObjectNode();
                pObjectNode.setParent((PObjectNode)super.getRoot());
                pObjectNode.setItem(pCTemplate);
                PrereqHandler.passesAll(pCTemplate.getPrerequisiteList(), InfoTemplates.this.getPc(), pCTemplate);
                ((PObjectNode)super.getRoot()).addChild(pObjectNode);
            }
        }

        private void createTypeViewModel(Collection<PCTemplate> collection) {
            this.setRoot(typeRoot.clone());
            for (PCTemplate pCTemplate : collection) {
                if (!this.shouldDisplayThis(pCTemplate)) continue;
                PObjectNode pObjectNode = (PObjectNode)super.getRoot();
                boolean bl = false;
                for (int i = 0; i < pObjectNode.getChildCount(); ++i) {
                    if ((bl || i != pObjectNode.getChildCount() - 1) && !pCTemplate.isType(pObjectNode.getChildren().get(i).getItem().toString())) continue;
                    PObjectNode pObjectNode2 = new PObjectNode();
                    pObjectNode2.setParent(pObjectNode.getChild(i));
                    pObjectNode2.setItem(pCTemplate);
                    PrereqHandler.passesAll(pCTemplate.getPrerequisiteList(), InfoTemplates.this.getPc(), pCTemplate);
                    pObjectNode.getChild(i).addChild(pObjectNode2);
                    bl = true;
                }
            }
        }

        private void createSourceViewModel(Collection<PCTemplate> collection) {
            this.setRoot(sourceRoot.clone());
            for (PCTemplate pCTemplate : collection) {
                if (!this.shouldDisplayThis(pCTemplate)) continue;
                PObjectNode pObjectNode = (PObjectNode)super.getRoot();
                boolean bl = false;
                for (int i = 0; i < pObjectNode.getChildCount(); ++i) {
                    String string = SourceFormat.getFormattedString(pCTemplate, SourceFormat.LONG, false);
                    if (string.length() != 0) {
                        if ((bl || i != pObjectNode.getChildCount() - 1) && !string.equals(pObjectNode.getChildren().get(i).getItem().toString())) continue;
                        PObjectNode pObjectNode2 = new PObjectNode();
                        pObjectNode2.setParent(pObjectNode.getChild(i));
                        pObjectNode2.setItem(pCTemplate);
                        PrereqHandler.passesAll(pCTemplate.getPrerequisiteList(), InfoTemplates.this.getPc(), pCTemplate);
                        pObjectNode.getChild(i).addChild(pObjectNode2);
                        bl = true;
                        continue;
                    }
                    Logging.errorPrint("PC template " + pCTemplate.getDisplayName() + " has no source long entry.");
                }
            }
        }

        private boolean shouldDisplayThis(PCTemplate pCTemplate) {
            return (pCTemplate.getSafe(ObjectKey.VISIBILITY) == Visibility.DEFAULT || pCTemplate.getSafe(ObjectKey.VISIBILITY) == Visibility.DISPLAY_ONLY) && InfoTemplates.this.accept(InfoTemplates.this.getPc(), pCTemplate);
        }

        @Override
        public List<String> getMColumnList() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 1; i < this.COL_NAMES.length; ++i) {
                arrayList.add(this.COL_NAMES[i]);
            }
            return arrayList;
        }

        @Override
        public boolean isMColumnDisplayed(int n) {
            return this.displayList.get(n);
        }

        @Override
        public void setMColumnDisplayed(int n, boolean bl) {
            this.setColumnViewOption(this.modelType + "." + this.COL_NAMES[n], bl);
            this.displayList.set(n, bl);
        }

        @Override
        public int getMColumnOffset() {
            return 1;
        }

        @Override
        public int getMColumnDefaultWidth(int n) {
            return SettingsHandler.getPCGenOption("InfoTemplates.sizecol." + this.COL_NAMES[n], this.COL_DEFAULT_WIDTH[n]);
        }

        @Override
        public void setMColumnDefaultWidth(int n, int n2) {
            SettingsHandler.setPCGenOption("InfoTemplates.sizecol." + this.COL_NAMES[n], n2);
        }

        private boolean getColumnViewOption(String string, boolean bl) {
            return SettingsHandler.getPCGenOption("InfoTemplates.viewcol." + string, bl);
        }

        private void setColumnViewOption(String string, boolean bl) {
            SettingsHandler.setPCGenOption("InfoTemplates.viewcol." + string, bl);
        }

        @Override
        public void resetMColumn(int n, TableColumn tableColumn) {
        }
    }
}

