/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs.ability;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.InputVerifier;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import pcgen.core.AbilityCategory;
import pcgen.core.PlayerCharacter;
import pcgen.gui.tabs.ability.IAbilityCategorySelectionListener;
import pcgen.gui.utils.Utility;
import pcgen.util.BigDecimalHelper;
import pcgen.util.PropertyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbilityPoolPanel
extends JPanel {
    private PlayerCharacter thePC;
    private AbilityCategory theCategory;
    private JComboBox theCategoryField = new JComboBox();
    private JTextField theNumAbilitiesField = new JTextField();
    private List<IAbilityCategorySelectionListener> theCatListeners = new ArrayList<IAbilityCategorySelectionListener>();
    private ActionListener categoryListener;

    public AbilityPoolPanel(PlayerCharacter playerCharacter, Collection<AbilityCategory> collection) {
        this.thePC = playerCharacter;
        this.setLayout(new FlowLayout());
        for (AbilityCategory abilityCategory : collection) {
            this.theCategoryField.addItem(new AbilityCatDisplay(abilityCategory));
        }
        this.add(this.theCategoryField);
        this.theCategory = ((AbilityCatDisplay)this.theCategoryField.getSelectedItem()).abilityCat;
        JLabel jLabel = new JLabel();
        jLabel.setText(PropertyFactory.getFormattedString("InfoAbility.Remaining.Label", ""));
        this.add(jLabel);
        this.theNumAbilitiesField.setInputVerifier(new InputVerifier(){

            public boolean verify(JComponent jComponent) {
                String string = ((JTextField)jComponent).getText();
                if (string.length() > 0) {
                    try {
                        if (!AbilityPoolPanel.this.theCategory.allowFractionalPool()) {
                            Integer.parseInt(string);
                            return true;
                        }
                        Double.parseDouble(string);
                        return true;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
                return true;
            }

            public boolean shouldYieldFocus(JComponent jComponent) {
                boolean bl = super.shouldYieldFocus(jComponent);
                if (!bl) {
                    AbilityPoolPanel.this.getToolkit().beep();
                } else if (AbilityPoolPanel.this.theNumAbilitiesField.getText().length() > 0) {
                    BigDecimal bigDecimal = AbilityPoolPanel.this.thePC.getAvailableAbilityPool(AbilityPoolPanel.this.theCategory);
                    BigDecimal bigDecimal2 = new BigDecimal(AbilityPoolPanel.this.theNumAbilitiesField.getText());
                    AbilityPoolPanel.this.thePC.adjustAbilities(AbilityPoolPanel.this.theCategory, bigDecimal2.subtract(bigDecimal));
                } else {
                    AbilityPoolPanel.this.showRemainingAbilityPoints();
                }
                return bl;
            }
        });
        this.categoryListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbilityPoolPanel.this.categoryFieldActionPerformed();
            }
        };
        this.theCategoryField.addActionListener(this.categoryListener);
        this.showRemainingAbilityPoints();
        this.theNumAbilitiesField.setColumns(3);
        this.theNumAbilitiesField.setEditable(this.theCategory.allowPoolMod());
        Utility.setDescription(this.theNumAbilitiesField, PropertyFactory.getFormattedString("InfoAbility.Pool.Description", this.theCategory.getDisplayName()));
        this.add(this.theNumAbilitiesField);
    }

    private void categoryFieldActionPerformed() {
        final AbilityCategory abilityCategory = ((AbilityCatDisplay)this.theCategoryField.getSelectedItem()).abilityCat;
        for (final IAbilityCategorySelectionListener iAbilityCategorySelectionListener : this.getCategoryListeners()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    iAbilityCategorySelectionListener.abilityCategorySelected(abilityCategory);
                }
            });
        }
    }

    public void setPC(PlayerCharacter playerCharacter) {
        this.thePC = playerCharacter;
    }

    public void setCategory(AbilityCategory abilityCategory) {
        this.theCategory = abilityCategory;
        this.theNumAbilitiesField.setEditable(this.theCategory.allowPoolMod());
        Utility.setDescription(this.theNumAbilitiesField, PropertyFactory.getFormattedString("InfoAbility.Pool.Description", this.theCategory.getDisplayName()));
        this.theCategoryField.removeActionListener(this.categoryListener);
        for (int i = 0; i < this.theCategoryField.getItemCount(); ++i) {
            AbilityCatDisplay abilityCatDisplay = (AbilityCatDisplay)this.theCategoryField.getItemAt(i);
            if (abilityCatDisplay.abilityCat != abilityCategory) continue;
            this.theCategoryField.setSelectedIndex(i);
            break;
        }
        this.theCategoryField.addActionListener(this.categoryListener);
    }

    public void showRemainingAbilityPoints() {
        this.theNumAbilitiesField.setText(BigDecimalHelper.trimBigDecimal(this.thePC.getAvailableAbilityPool(this.theCategory)).toString());
    }

    public void addAbilityCategorySelectionListener(IAbilityCategorySelectionListener iAbilityCategorySelectionListener) {
        if (!this.theCatListeners.contains(iAbilityCategorySelectionListener)) {
            this.theCatListeners.add(iAbilityCategorySelectionListener);
        }
    }

    public List<IAbilityCategorySelectionListener> getCategoryListeners() {
        return Collections.unmodifiableList(this.theCatListeners);
    }

    private class AbilityCatDisplay {
        public final AbilityCategory abilityCat;

        public AbilityCatDisplay(AbilityCategory abilityCategory) {
            this.abilityCat = abilityCategory;
        }

        public String toString() {
            return this.abilityCat.getPluralName();
        }
    }
}

