/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs.components;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import pcgen.gui.tabs.IFilterableView;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.Utility;
import pcgen.util.PropertyFactory;

public class FilterPanel
extends JPanel {
    private IFilterableView theView;
    private int theViewIndex = 0;
    private JComboBoxEx theViewComboBox;
    private JTextField theFilterText;
    private JButton theClearButton;

    public FilterPanel(IFilterableView iFilterableView, String string) {
        this.theView = iFilterableView;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        JLabel jLabel = new JLabel(string);
        Utility.buildConstraints(gridBagConstraints, n++, 0, 1, 1, 0.0, 0.0);
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        this.add((Component)jLabel, gridBagConstraints);
        this.theViewComboBox = new JComboBoxEx();
        this.theViewComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = FilterPanel.this.theViewComboBox.getSelectedIndex();
                if (FilterPanel.this.theViewIndex != n) {
                    FilterPanel.this.theViewIndex = n;
                    FilterPanel.this.theView.viewChanged(FilterPanel.this.theViewIndex);
                }
            }
        });
        for (String string2 : iFilterableView.getViewChoices()) {
            this.theViewComboBox.addItem(string2);
        }
        Utility.setDescription(this.theViewComboBox, PropertyFactory.getString("InfoTabs.ViewCombo.Description"));
        this.theViewComboBox.setSelectedIndex(iFilterableView.getInitialChoice());
        Utility.buildConstraints(gridBagConstraints, n++, 0, 1, 1, 0.0, 0.0);
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.theViewComboBox, gridBagConstraints);
        JLabel jLabel2 = new JLabel(PropertyFactory.getString("InfoTabs.FilterLabel"));
        Utility.buildConstraints(gridBagConstraints, n++, 0, 1, 1, 0.0, 0.0);
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        this.add((Component)jLabel2, gridBagConstraints);
        this.theFilterText = new JTextField();
        this.theFilterText.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                FilterPanel.this.setQFilter();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                FilterPanel.this.setQFilter();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                FilterPanel.this.setQFilter();
            }
        });
        Utility.buildConstraints(gridBagConstraints, n++, 0, 1, 1, 95.0, 0.0);
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.theFilterText, gridBagConstraints);
        this.theClearButton = new JButton(PropertyFactory.getString("in_clear"));
        this.theClearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterPanel.this.clearQFilter();
            }
        });
        Utility.buildConstraints(gridBagConstraints, n++, 0, 1, 1, 0.0, 0.0);
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        this.theClearButton.setEnabled(false);
        this.add((Component)this.theClearButton, gridBagConstraints);
    }

    private void setQFilter() {
        String string = this.theFilterText.getText();
        if (string.length() == 0) {
            this.clearQFilter();
            return;
        }
        this.theView.setQFilter(string);
        this.theClearButton.setEnabled(true);
        this.theViewComboBox.setEnabled(false);
    }

    private void clearQFilter() {
        this.theClearButton.setEnabled(false);
        this.theViewComboBox.setEnabled(true);
        this.theFilterText.setText(null);
        this.theView.clearQFilter();
    }
}

