/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs.spells;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.CharacterDomain;
import pcgen.core.Domain;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.analysis.DescriptionFormatting;
import pcgen.core.analysis.OutputNameFormatting;
import pcgen.core.analysis.SpellLevel;
import pcgen.core.analysis.SpellPoint;
import pcgen.core.character.CharacterSpell;
import pcgen.core.character.SpellInfo;
import pcgen.core.spell.Spell;
import pcgen.gui.TableColumnManagerModel;
import pcgen.gui.tabs.spells.InfoSpellsSubTab;
import pcgen.gui.utils.AbstractTreeTableModel;
import pcgen.gui.utils.PObjectNode;
import pcgen.gui.utils.TreeTableModel;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpellModel
extends AbstractTreeTableModel
implements TableColumnManagerModel {
    private static final int COL_NAME = 0;
    private static final int COL_SCHOOL = 1;
    private static final int COL_SUBSCHOOL = 2;
    private static final int COL_DESCRIPTOR = 3;
    private static final int COL_COMPONENT = 4;
    private static final int COL_CASTTIME = 5;
    private static final int COL_RANGE = 6;
    private static final int COL_DESCRIPTION = 7;
    private static final int COL_TARGET = 8;
    private static final int COL_DURATION = 9;
    private static final int COL_SAVE = 10;
    private static final int COL_SR = 11;
    private static final int COL_SRC = 12;
    private static final int COL_PPCOST = 13;
    private static final int COL_SPCOST = 14;
    private final int[] colDefaultWidth = new int[]{200, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100};
    private PObjectNode theRoot;
    private String[] colNameList = new String[]{""};
    private int[] colTranslateList = new int[]{0};
    private List<Boolean> displayList;
    private boolean includeRace = false;
    private PlayerCharacter pc;
    private boolean available = false;

    public SpellModel(int n, int n2, boolean bl, List<String> list, String string, int n3, PlayerCharacter playerCharacter, InfoSpellsSubTab infoSpellsSubTab, String string2) {
        super(null);
        this.available = bl;
        this.setCharacter(playerCharacter);
        this.colTranslateList = Globals.hasSpellPPCost() ? new int[]{0, 1, 2, 3, 13, 4, 5, 6, 7, 8, 9, 10, 11, 12} : (Spell.hasSpellPointCost() ? new int[]{0, 1, 2, 3, 14, 4, 5, 6, 7, 8, 9, 10, 11, 12} : new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12});
        this.colNameList = this.makeHeaderList(this.colTranslateList);
        this.displayList = this.makeDisplayList(bl);
        this.resetModel(n, n2, bl, list, string, n3, infoSpellsSubTab, string2);
    }

    private String[] makeHeaderList(int[] nArray) {
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            String string;
            switch (nArray[i]) {
                case 0: {
                    string = PropertyFactory.getString("SpellModel.Name");
                    break;
                }
                case 1: {
                    string = PropertyFactory.getString("SpellModel.Scool");
                    break;
                }
                case 2: {
                    string = PropertyFactory.getString("SpellModel.SubSchool");
                    break;
                }
                case 3: {
                    string = PropertyFactory.getString("SpellModel.Descriptor");
                    break;
                }
                case 4: {
                    string = PropertyFactory.getString("SpellModel.Components");
                    break;
                }
                case 5: {
                    string = PropertyFactory.getString("SpellModel.CastingTime");
                    break;
                }
                case 6: {
                    string = PropertyFactory.getString("SpellModel.Range");
                    break;
                }
                case 7: {
                    string = PropertyFactory.getString("SpellModel.Description");
                    break;
                }
                case 8: {
                    string = PropertyFactory.getString("SpellModel.TargetArea");
                    break;
                }
                case 9: {
                    string = PropertyFactory.getString("SpellModel.Duration");
                    break;
                }
                case 10: {
                    string = PropertyFactory.getString("SpellModel.SaveInfo");
                    break;
                }
                case 11: {
                    string = PropertyFactory.getString("SpellModel.SR");
                    break;
                }
                case 12: {
                    string = PropertyFactory.getString("SpellModel.SourceFile");
                    break;
                }
                case 13: {
                    string = PropertyFactory.getString("SpellModel.PPCost");
                    break;
                }
                case 14: {
                    string = PropertyFactory.getString("SpellModel.SpellPointCost");
                    break;
                }
                default: {
                    string = Integer.toString(nArray[i]);
                }
            }
            stringArray[i] = string;
        }
        return stringArray;
    }

    private List<Boolean> makeDisplayList(boolean bl) {
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
        arrayList.add(Boolean.TRUE);
        if (bl) {
            int n = 1;
            arrayList.add(this.getColumnViewOption(this.colNameList[n++], false));
            arrayList.add(this.getColumnViewOption(this.colNameList[n++], false));
            arrayList.add(this.getColumnViewOption(this.colNameList[n++], false));
            if (Globals.hasSpellPPCost()) {
                arrayList.add(this.getColumnViewOption(this.colNameList[n++], true));
            } else if (Spell.hasSpellPointCost()) {
                arrayList.add(this.getColumnViewOption(this.colNameList[n++], true));
            }
            arrayList.add(this.getColumnViewOption(this.colNameList[n++], false));
            arrayList.add(this.getColumnViewOption(this.colNameList[n++], false));
            arrayList.add(this.getColumnViewOption(this.colNameList[n++], false));
            arrayList.add(this.getColumnViewOption(this.colNameList[n++], false));
            arrayList.add(this.getColumnViewOption(this.colNameList[n++], false));
            arrayList.add(this.getColumnViewOption(this.colNameList[n++], false));
            arrayList.add(this.getColumnViewOption(this.colNameList[n++], false));
            arrayList.add(this.getColumnViewOption(this.colNameList[n++], false));
            arrayList.add(this.getColumnViewOption(this.colNameList[n++], false));
        } else {
            int n = 1;
            arrayList.add(this.getColumnViewOption(this.colNameList[n++], true));
            arrayList.add(this.getColumnViewOption(this.colNameList[n++], true));
            arrayList.add(this.getColumnViewOption(this.colNameList[n++], true));
            if (Globals.hasSpellPPCost()) {
                arrayList.add(this.getColumnViewOption(this.colNameList[n++], true));
            } else if (Spell.hasSpellPointCost()) {
                arrayList.add(this.getColumnViewOption(this.colNameList[n++], true));
            }
            arrayList.add(this.getColumnViewOption(this.colNameList[n++], false));
            arrayList.add(this.getColumnViewOption(this.colNameList[n++], false));
            arrayList.add(this.getColumnViewOption(this.colNameList[n++], false));
            arrayList.add(this.getColumnViewOption(this.colNameList[n++], false));
            arrayList.add(this.getColumnViewOption(this.colNameList[n++], false));
            arrayList.add(this.getColumnViewOption(this.colNameList[n++], false));
            arrayList.add(this.getColumnViewOption(this.colNameList[n++], false));
            arrayList.add(this.getColumnViewOption(this.colNameList[n++], false));
            arrayList.add(this.getColumnViewOption(this.colNameList[n++], true));
        }
        return arrayList;
    }

    private int translateColumn(int n) {
        return this.colTranslateList[n];
    }

    @Override
    public boolean isCellEditable(Object object, int n) {
        return (n = this.translateColumn(n)) == 0;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return (n = this.translateColumn(n)) == 0 ? TreeTableModel.class : String.class;
    }

    @Override
    public int getColumnCount() {
        return this.colNameList.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.colNameList[n];
    }

    @Override
    public Object getRoot() {
        return super.getRoot();
    }

    @Override
    public Object getValueAt(Object object, int n) {
        PObjectNode pObjectNode = (PObjectNode)object;
        Spell spell = null;
        CharacterSpell characterSpell = null;
        if (pObjectNode == null) {
            Logging.errorPrint(PropertyFactory.getString("SpellModel.NoActiveNode"));
            return null;
        }
        if (pObjectNode.getItem() instanceof SpellInfo) {
            characterSpell = ((SpellInfo)pObjectNode.getItem()).getOwner();
            spell = characterSpell.getSpell();
            ((SpellInfo)pObjectNode.getItem()).getActualLevel();
        }
        n = this.translateColumn(n);
        switch (n) {
            case 0: {
                if (SettingsHandler.guiUsesOutputNameSpells()) {
                    return spell != null ? spell.getOutputName() : pObjectNode.toString();
                }
                return pObjectNode.toString();
            }
            case 1: {
                return spell != null ? spell.getSchool() : null;
            }
            case 2: {
                return spell != null ? spell.getSubschool() : null;
            }
            case 3: {
                return spell != null ? spell.descriptor() : null;
            }
            case 4: {
                return spell != null ? spell.getComponentList() : null;
            }
            case 5: {
                return spell != null ? spell.getCastingTime() : null;
            }
            case 6: {
                return spell != null ? StringUtil.joinToStringBuffer(spell.getListFor(ListKey.RANGE), ", ") : null;
            }
            case 7: {
                if (spell != null && characterSpell != null) {
                    return this.pc.parseSpellString(characterSpell, this.pc.getDescription(spell), characterSpell.getOwner());
                }
                return spell != null ? DescriptionFormatting.piDescString(this.pc, spell) : null;
            }
            case 8: {
                if (spell != null && characterSpell != null) {
                    return this.pc.parseSpellString(characterSpell, spell.getSafe(StringKey.TARGET_AREA), characterSpell.getOwner());
                }
                return spell != null ? spell.getSafe(StringKey.TARGET_AREA) : null;
            }
            case 9: {
                if (spell != null && characterSpell != null) {
                    return this.pc.parseSpellString(characterSpell, spell.getDuration(), characterSpell.getOwner());
                }
                return spell != null ? spell.getDuration() : null;
            }
            case 10: {
                return spell != null ? spell.getSaveInfo() : null;
            }
            case 11: {
                return spell != null ? spell.getSpellResistance() : null;
            }
            case 12: {
                return spell != null ? spell.getDefaultSourceString() : null;
            }
            case 14: {
                return characterSpell != null ? Integer.valueOf(SpellPoint.getSpellPointCostActual(this.pc, spell)) : null;
            }
            case 13: {
                return characterSpell != null ? Integer.valueOf(spell.getSafe(IntegerKey.PP_COST)) : null;
            }
        }
        return pObjectNode.getItem();
    }

    private void setRoot(PObjectNode pObjectNode) {
        super.setRoot(pObjectNode);
    }

    private void addDomainSpellsForClass(PCClass pCClass, PObjectNode pObjectNode, int n) {
        if (!this.pc.hasCharacterDomainList()) {
            return;
        }
        PObjectNode pObjectNode2 = new PObjectNode();
        pObjectNode2.setItem("Domains");
        boolean bl = false;
        for (CharacterDomain characterDomain : this.pc.getCharacterDomainList()) {
            Domain domain = characterDomain.getDomain();
            if (domain == null || !characterDomain.isFromPCClass(pCClass.getKeyName())) continue;
            List<Spell> list = Globals.getSpellsIn(n, Collections.singletonList(domain.get(ObjectKey.DOMAIN_SPELLLIST)), this.pc);
            pObjectNode2.setParent(pObjectNode);
            if (!bl) {
                pObjectNode.addChild(pObjectNode2);
            }
            bl = true;
            this.setNodeSpells(list, pObjectNode2, n, domain, Globals.getDefaultSpellBook(), this.pc);
        }
    }

    private void setNodeSpells(List<?> list, PObjectNode pObjectNode, int n, PObject pObject, String string, PlayerCharacter playerCharacter) {
        for (Object obj : list) {
            PObjectNode pObjectNode2;
            Object object;
            Comparable<CharacterSpell> comparable;
            if (obj instanceof CharacterSpell) {
                comparable = (CharacterSpell)obj;
                object = ((CharacterSpell)comparable).getSpellInfoFor(string, n, -1);
                if (object == null) continue;
                pObjectNode2 = new PObjectNode();
                pObjectNode2.setItem(object);
            } else {
                comparable = (Spell)obj;
                if (!SpellLevel.levelForKeyContains(comparable, pObject.getSpellLists(playerCharacter), n, playerCharacter)) continue;
                object = new CharacterSpell(pObject, (Spell)comparable);
                SpellInfo spellInfo = ((CharacterSpell)object).addInfo(n, 1, string);
                pObjectNode2 = new PObjectNode();
                pObjectNode2.setItem(spellInfo);
            }
            pObjectNode2.setParent(pObjectNode);
            pObjectNode.addChild(pObjectNode2);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void resetModel(int var1_1, int var2_2, boolean var3_3, List<String> var4_4, String var5_5, int var6_6, InfoSpellsSubTab var7_7, String var8_8) {
        var9_9 = new ArrayList<PObject>();
        var10_10 = new ArrayList<Object>();
        this.includeRace = false;
        var11_11 = null;
        var12_12 = null;
        var13_13 = null;
        this.theRoot = new PObjectNode();
        this.setRoot(this.theRoot);
        if (this.pc == null) {
            return;
        }
        v0 = var14_14 = var6_6 == 0;
        if (var14_14) {
            var13_13 = new PObjectNode[var4_4.size()];
            var15_15 = 0;
            for (String var17_17 : var4_4) {
                var13_13[var15_15] = new PObjectNode();
                if (this.pc != null) {
                    var13_13[var15_15].setItem(this.pc.getSpellBookByName(var17_17));
                } else {
                    var13_13[var15_15].setItem(var17_17);
                }
                var13_13[var15_15].setParent(this.theRoot);
                var18_18 = this.pc.getCharacterSpells(this.pc.getRace(), null, var17_17, -1);
                var19_19 = var18_18.iterator();
                while (var19_19.hasNext()) {
                    var20_20 = (CharacterSpell)var19_19.next();
                    if (var20_20 instanceof Spell) {
                        var21_21 /* !! */  = var20_20;
                        if (!var7_7.shouldDisplayThis((Spell)var21_21 /* !! */ )) continue;
                        var10_10.add(var21_21 /* !! */ );
                        continue;
                    }
                    if (!(var20_20 instanceof CharacterSpell) || !var7_7.shouldDisplayThis((var21_21 /* !! */  = (CharacterSpell)var20_20).getSpell())) continue;
                    var10_10.add(var21_21 /* !! */ );
                }
                ++var15_15;
            }
            this.theRoot.setChildren(var13_13);
        }
        this.includeRace = var10_10.isEmpty() == false;
        this.getSpellcastingClasses(var6_6, var9_9, var10_10, var7_7);
        if (this.includeRace) {
            var9_9.add(this.pc.getRace());
        }
        var15_15 = 1;
        var16_16 = new HashMap<K, V>();
        for (Object var19_19 : var10_10) {
            var20_20 = null;
            var21_21 /* !! */  = null;
            if (var19_19 instanceof CharacterSpell) {
                var21_21 /* !! */  = (CharacterSpell)var19_19;
                var20_20 = var21_21 /* !! */ .getSpell();
                if (!var14_14 && var21_21 /* !! */ .getOwner() instanceof Domain) continue;
            }
            if (var19_19 instanceof Spell) {
                var20_20 = (Spell)var19_19;
            }
            for (var22_22 = 0; !(var22_22 > var4_4.size() || var14_14 && var22_22 == var4_4.size() || !var14_14 && var22_22 > 0); ++var22_22) {
                var23_23 = var5_5;
                if (var14_14) {
                    var23_23 = var4_4.get(var22_22).toString();
                }
                if (var15_15 != 0) {
                    var11_11 = this.getNodesByMode(var1_1, var9_9);
                } else if (var14_14) {
                    var13_13[var22_22].getChildren().toArray(var11_11);
                } else {
                    this.theRoot.getChildren().toArray(var11_11);
                }
                block23: for (var24_24 = 0; var24_24 < var11_11.length; ++var24_24) {
                    if (var19_19 instanceof Spell) {
                        var21_21 /* !! */  = null;
                    }
                    var25_25 = false;
                    var26_26 = false;
                    var27_27 = null;
                    var28_28 = null;
                    var29_29 = -1;
                    var30_30 = var11_11[var24_24];
                    switch (var1_1) {
                        case 0: {
                            var28_28 = (PObject)var9_9.get(var24_24);
                            var25_25 = SpellLevel.levelForKeyContains(var20_20, var28_28.getSpellLists(this.pc), var29_29, this.pc);
                            if (var21_21 /* !! */  != null) {
                                var25_25 = var28_28 instanceof Race ? var21_21 /* !! */ .getOwner().getKeyName().equals(var28_28.getKeyName()) : (var21_21 /* !! */ .getOwner() instanceof Domain ? this.pc.containsAssoc(var28_28, AssociationListKey.CHARACTER_SPELLS, var21_21 /* !! */ ) : var21_21 /* !! */ .getOwner().getKeyName().equals(var28_28.getKeyName()));
                            }
                            ** GOTO lbl110
                        }
                        case 1: {
                            var29_29 = var24_24;
                            var25_25 = true;
                            var27_27 = null;
                            if (var25_25 && var21_21 /* !! */  != null) {
                                var27_27 = var21_21 /* !! */ .getSpellInfoFor(var23_23, var29_29, -1);
                            }
                            if (var27_27 == null) {
                                var25_25 = SpellLevel.isLevel(var20_20, var29_29, this.pc);
                            } else if (!var14_14 && var27_27.getFeatList() != null) {
                                continue block23;
                            }
                            ** GOTO lbl110
                        }
                        case 2: {
                            var25_25 = var20_20.containsInList(ListKey.SPELL_DESCRIPTOR, var30_30.toString());
                            ** GOTO lbl110
                        }
                        case 3: {
                            var25_25 = var20_20.getRange().equals(var30_30.toString());
                            ** GOTO lbl110
                        }
                        case 4: {
                            var25_25 = var20_20.getDuration().equals(var30_30.toString());
                            ** GOTO lbl110
                        }
                        case 5: {
                            var25_25 = var20_20.isType(var30_30.toString());
                            ** GOTO lbl110
                        }
                        case 6: {
                            var25_25 = var20_20.containsInList(ListKey.SPELL_SCHOOL, var30_30.toString());
                        }
lbl110:
                        // 9 sources

                        default: {
                            if (var2_2 == 7) {
                                if (var15_15 == 0 && !var25_25) continue block23;
                                var12_12 = new PObjectNode[]{new PObjectNode()};
                                var12_12[0].setItem("");
                            } else if (var15_15 != 0) {
                                var12_12 = this.getNodesByMode(var2_2, var9_9);
                            } else {
                                if (!var25_25) continue block23;
                                var30_30.getChildren().toArray(var12_12);
                            }
                            block24: for (var31_31 = 0; var31_31 < var12_12.length; ++var31_31) {
                                var17_17 = var23_23 + "." + var30_30.toString() + "." + var12_12[var31_31].toString();
                                switch (var2_2) {
                                    case 0: {
                                        var28_28 = (PObject)var9_9.get(var31_31);
                                        var26_26 = var25_25 != false && SpellLevel.getFirstLevelForKey(var20_20, var28_28.getSpellLists(this.pc), this.pc) >= 0;
                                        ** GOTO lbl159
                                    }
                                    case 1: {
                                        var29_29 = var31_31;
                                        var26_26 = false;
                                        var27_27 = null;
                                        if (var25_25) {
                                            if (var21_21 /* !! */  != null) {
                                                var27_27 = var21_21 /* !! */ .getSpellInfoFor(var23_23, var29_29, -1);
                                                v1 = var26_26 = var27_27 != null;
                                            }
                                            if (var27_27 == null) {
                                                var26_26 = var28_28 != null ? SpellLevel.levelForKeyContains(var20_20, var28_28.getSpellLists(this.pc), var29_29, this.pc) : SpellLevel.isLevel(var20_20, var29_29, this.pc);
                                            }
                                        }
                                        if (!var14_14 && var27_27 != null && var27_27.getFeatList() != null) {
                                            continue block24;
                                        }
                                        ** GOTO lbl159
                                    }
                                    case 2: {
                                        var26_26 = var25_25 != false && var20_20.containsInList(ListKey.SPELL_DESCRIPTOR, var12_12[var31_31].toString()) != false;
                                        ** GOTO lbl159
                                    }
                                    case 3: {
                                        var26_26 = var25_25 != false && var20_20.getRange().equals(var12_12[var31_31].toString()) != false;
                                        ** GOTO lbl159
                                    }
                                    case 4: {
                                        var26_26 = var25_25 != false && var20_20.getDuration().equals(var12_12[var31_31].toString()) != false;
                                        ** GOTO lbl159
                                    }
                                    case 5: {
                                        var26_26 = var25_25 != false && var20_20.isType(var12_12[var31_31].toString()) != false;
                                        ** GOTO lbl159
                                    }
                                    case 7: {
                                        var26_26 = var25_25;
                                        ** GOTO lbl159
                                    }
                                    case 6: {
                                        var26_26 = var25_25 != false && var20_20.containsInList(ListKey.SPELL_SCHOOL, var12_12[var31_31].toString()) != false;
                                    }
lbl159:
                                    // 9 sources

                                    default: {
                                        if (var15_15 != 0 && var2_2 != 7) {
                                            var12_12[var31_31].setParent(var30_30);
                                            if (!var14_14 && var28_28 != null && var29_29 > -1 && var28_28 instanceof PCClass) {
                                                this.addDomainSpellsForClass((PCClass)var28_28, var12_12[var31_31], var29_29);
                                            }
                                        }
                                        if (var27_27 != null && !var27_27.getBook().equals(var23_23) || var14_14 && var27_27 != null && (var32_32 = (List)var16_16.get(var17_17)) != null && var32_32.contains(var27_27)) continue block24;
                                        if (var28_28 != null && var29_29 > -1 && var26_26 && var28_28 instanceof PCClass) {
                                            var32_33 = var29_29;
                                            if (var27_27 != null) {
                                                var32_33 = -1;
                                            }
                                            var33_34 = var28_28;
                                            if (var21_21 /* !! */  != null) {
                                                var33_34 = var21_21 /* !! */ .getOwner();
                                            }
                                            var26_26 = SpellLevel.levelForKeyContains(var20_20, var33_34.getSpellLists(this.pc), var32_33, this.pc);
                                        }
                                        if (var26_26 && var27_27 == null && !var14_14) {
                                            var32_32 = var28_28;
                                            if (var28_28 == null && var9_9.size() == 1) {
                                                var32_32 = (PObject)var9_9.get(0);
                                            }
                                            var21_21 /* !! */  = new CharacterSpell((PObject)var32_32, (Spell)var20_20);
                                            var27_27 = var21_21 /* !! */ .addInfo(var29_29, 1, var23_23);
                                        }
                                        if (!var26_26 || var27_27 == null) continue block24;
                                        var32_32 = var12_12[var31_31];
                                        if (var2_2 == 7) {
                                            var32_32 = var30_30;
                                        }
                                        this.addSpellToNode(var27_27, (PObjectNode)var32_32, (HashMap<String, List<SpellInfo>>)var16_16, var17_17);
                                    }
                                }
                            }
                            if (var2_2 != 7) {
                                var30_30.setChildren(var12_12);
                            }
                            if (!var14_14) {
                                var30_30.setParent(this.theRoot);
                                continue block23;
                            }
                            var30_30.setParent(var13_13[var22_22]);
                        }
                    }
                }
                if (var14_14) {
                    var13_13[var22_22].setChildren(var11_11);
                    continue;
                }
                this.theRoot.setChildren(var11_11);
            }
            var15_15 = 0;
        }
        var18_18 = (PObjectNode)super.getRoot();
        if (var18_18.getChildCount() > 0) {
            var18_18.pruneEmpty();
            this.fireTreeNodesChanged(super.getRoot(), new TreePath(super.getRoot()));
        } else {
            var19_19 = new PObjectNode();
            var19_19.setDisplayName(var8_8);
            var20_20 = new PObject();
            var20_20.setName(var8_8);
            var19_19.setItem(var20_20);
            var19_19.setParent((PObjectNode)var18_18);
            var18_18.addChild((PObjectNode)var19_19);
        }
    }

    private void addSpellToNode(SpellInfo spellInfo, PObjectNode pObjectNode, HashMap<String, List<SpellInfo>> hashMap, String string) {
        PObjectNode pObjectNode2 = new PObjectNode();
        pObjectNode2.setItem(spellInfo);
        pObjectNode2.setParent(pObjectNode);
        pObjectNode.addChild(pObjectNode2);
        List<SpellInfo> list = hashMap.get(string);
        if (list == null) {
            list = new ArrayList<SpellInfo>();
            hashMap.put(string, list);
        }
        list.add(spellInfo);
    }

    private void getSpellcastingClasses(int n, List<PObject> list, List<Object> list2, InfoSpellsSubTab infoSpellsSubTab) {
        Collection<PCClass> collection = n == 2 ? Globals.getContext().ref.getConstructedCDOMObjects(PCClass.class) : this.pc.getClassList();
        for (PCClass pCClass : collection) {
            if (pCClass.get(StringKey.SPELLTYPE) == null || pCClass.zeroCastSpells() && !pCClass.hasKnownList()) continue;
            list.add(pCClass);
            if (n != 0) {
                for (Spell spell : Globals.getSpellsIn(-1, pCClass.getSpellLists(this.pc), this.pc)) {
                    if (list2.contains(spell) || !infoSpellsSubTab.shouldDisplayThis(spell)) continue;
                    list2.add(spell);
                }
                continue;
            }
            Collection<CharacterSpell> collection2 = this.pc.getSafeAssocList(pCClass, AssociationListKey.CHARACTER_SPELLS);
            SpellLevel.addBonusKnowSpellsToList(this.pc, pCClass, collection2);
            list2.addAll((Collection<Object>)collection2);
            Iterator iterator = collection2.iterator();
            while (iterator.hasNext()) {
                CharacterSpell characterSpell = (CharacterSpell)iterator.next();
                Spell spell = characterSpell instanceof CharacterSpell ? characterSpell.getSpell() : (Spell)((Object)characterSpell);
                if (!infoSpellsSubTab.shouldDisplayThis(spell)) continue;
                list2.add(spell);
            }
        }
    }

    private PObjectNode[] getNodesByMode(int n, List<PObject> list) {
        PObjectNode[] pObjectNodeArray = null;
        switch (n) {
            case 0: {
                pObjectNodeArray = this.getClassNameNodes(list);
                break;
            }
            case 1: {
                pObjectNodeArray = this.getLevelNodes();
                break;
            }
            case 2: {
                pObjectNodeArray = this.getDescriptorNodes();
                break;
            }
            case 3: {
                pObjectNodeArray = this.getRangeNodes();
                break;
            }
            case 4: {
                pObjectNodeArray = this.getDurationNodes();
                break;
            }
            case 5: {
                pObjectNodeArray = this.getTypeNodes();
                break;
            }
            case 6: {
                pObjectNodeArray = this.getSchoolNodes();
            }
        }
        return pObjectNodeArray;
    }

    private PObjectNode[] getClassNameNodes(List<PObject> list) {
        PObjectNode[] pObjectNodeArray = new PObjectNode[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            PObject pObject = list.get(i);
            String string = OutputNameFormatting.piString(pObject, true);
            pObjectNodeArray[i] = new PObjectNode();
            pObjectNodeArray[i].setItem(string);
        }
        return pObjectNodeArray;
    }

    private PObjectNode[] getLevelNodes() {
        PObjectNode[] pObjectNodeArray = new PObjectNode[26];
        for (int i = 0; i <= 25; ++i) {
            pObjectNodeArray[i] = new PObjectNode();
            String string = "" + i;
            if (i < 10) {
                string = " " + string;
            }
            pObjectNodeArray[i].setItem(PropertyFactory.getString("SpellModel.24") + string);
        }
        return pObjectNodeArray;
    }

    private PObjectNode[] getDescriptorNodes() {
        PObjectNode[] pObjectNodeArray = new PObjectNode[Globals.getDescriptorSet().size()];
        int n = 0;
        for (String string : Globals.getDescriptorSet()) {
            pObjectNodeArray[n] = new PObjectNode();
            pObjectNodeArray[n++].setItem(string);
        }
        return pObjectNodeArray;
    }

    private PObjectNode[] getRangeNodes() {
        PObjectNode[] pObjectNodeArray = new PObjectNode[Globals.getRangesSet().size()];
        int n = 0;
        for (String string : Globals.getRangesSet()) {
            pObjectNodeArray[n] = new PObjectNode();
            pObjectNodeArray[n++].setItem(string);
        }
        return pObjectNodeArray;
    }

    private PObjectNode[] getDurationNodes() {
        PObjectNode[] pObjectNodeArray = new PObjectNode[Globals.getDurationSet().size()];
        int n = 0;
        for (String string : Globals.getDurationSet()) {
            pObjectNodeArray[n] = new PObjectNode();
            pObjectNodeArray[n++].setItem(string);
        }
        return pObjectNodeArray;
    }

    private PObjectNode[] getTypeNodes() {
        PObjectNode[] pObjectNodeArray = new PObjectNode[Globals.getTypeForSpells().size()];
        int n = 0;
        for (String string : Globals.getTypeForSpells()) {
            pObjectNodeArray[n] = new PObjectNode();
            pObjectNodeArray[n++].setItem(string);
        }
        return pObjectNodeArray;
    }

    private PObjectNode[] getSchoolNodes() {
        PObjectNode[] pObjectNodeArray = new PObjectNode[SettingsHandler.getGame().getUnmodifiableSchoolsList().size()];
        int n = 0;
        for (String string : SettingsHandler.getGame().getUnmodifiableSchoolsList()) {
            pObjectNodeArray[n] = new PObjectNode();
            pObjectNodeArray[n++].setItem(string);
        }
        return pObjectNodeArray;
    }

    public void setCharacter(PlayerCharacter playerCharacter) {
        this.pc = playerCharacter;
    }

    @Override
    public List<String> getMColumnList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 1; i < this.colNameList.length; ++i) {
            arrayList.add(this.colNameList[i]);
        }
        return arrayList;
    }

    @Override
    public boolean isMColumnDisplayed(int n) {
        return this.displayList.get(n);
    }

    @Override
    public int getMColumnOffset() {
        return 1;
    }

    @Override
    public void setMColumnDisplayed(int n, boolean bl) {
        this.setColumnViewOption(this.colNameList[n], bl);
        this.displayList.set(n, bl);
    }

    @Override
    public int getMColumnDefaultWidth(int n) {
        return SettingsHandler.getPCGenOption(this.getOptionName() + "sizecol." + this.colNameList[n], this.colDefaultWidth[n]);
    }

    @Override
    public void setMColumnDefaultWidth(int n, int n2) {
        SettingsHandler.setPCGenOption(this.getOptionName() + "sizecol." + this.colNameList[n], n2);
    }

    private boolean getColumnViewOption(String string, boolean bl) {
        return SettingsHandler.getPCGenOption(this.getOptionName() + "viewcol." + string, bl);
    }

    private void setColumnViewOption(String string, boolean bl) {
        SettingsHandler.setPCGenOption(this.getOptionName() + "viewcol." + string, bl);
    }

    private String getOptionName() {
        StringBuffer stringBuffer = new StringBuffer("InfoSpells.");
        if (this.available) {
            stringBuffer.append("left.");
        } else {
            stringBuffer.append("right.");
        }
        return stringBuffer.toString();
    }

    @Override
    public void resetMColumn(int n, TableColumn tableColumn) {
    }
}

