/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.StringTokenizer;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.utils.CoreUtility;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.util.Logging;

public class BonusToken
extends Token {
    public static final String TOKENNAME = "BONUS";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String string, PlayerCharacter playerCharacter, ExportHandler exportHandler) {
        return BonusToken.getBonusToken(string, playerCharacter);
    }

    public static String getBonusToken(String string, PlayerCharacter playerCharacter) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
        stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        double d = 0.0;
        int n = 0;
        double d2 = 0.0;
        int n2 = 1;
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (CoreUtility.doublesEqual(d, 0.0) && "LISTING".equals(string4)) {
                return playerCharacter.listBonusesFor(string2 + "." + string3);
            }
            if (PreParserFactory.isPreReqString(string4)) {
                Logging.debugPrint("Why is this not parsed in loading: " + string4 + " rather than in BonusToken.getBonusToken()");
                Prerequisite prerequisite = null;
                try {
                    PreParserFactory preParserFactory = PreParserFactory.getInstance();
                    prerequisite = preParserFactory.parse(string4);
                }
                catch (PersistenceLayerException persistenceLayerException) {
                    Logging.errorPrint(persistenceLayerException.getMessage(), persistenceLayerException);
                }
                if (PrereqHandler.passes(prerequisite, playerCharacter, null)) continue;
                d -= d2 * (double)n2;
                d2 = 0.0;
                continue;
            }
            if (string4.startsWith("MIN=")) {
                double d3 = Float.parseFloat(string4.substring(4));
                if (!(d2 < d3)) continue;
                d -= d2 - d3;
                continue;
            }
            if (string4.startsWith("MAX=")) {
                double d4 = Float.parseFloat(string4.substring(4));
                d4 = Math.min(d4, d2);
                d -= d2 - d4;
                d2 = 0.0;
                continue;
            }
            n2 = 1;
            if (string4.length() > 0 && string4.charAt(0) == '!') {
                n2 = -1;
                string4 = string4.substring(1);
            }
            if (string4.equals("EQTYPE") && stringTokenizer.hasMoreTokens()) {
                string4 = string4 + "." + stringTokenizer.nextToken();
            }
            if ("TOTAL".equals(string4)) {
                d2 = playerCharacter.getTotalBonusTo(string2, string3);
            } else if (string4.startsWith("DEC=")) {
                n = Integer.parseInt(string4.substring(4));
            } else if (string4.startsWith("TYPE=") || string4.startsWith("EQTYPE.")) {
                d2 = 0.0;
                String string5 = string4.startsWith("TYPE=") ? string4.substring(5) : string4.substring(7);
                for (Equipment equipment : playerCharacter.getEquipmentOfType(string5, "", 1)) {
                    d2 += equipment.bonusTo(playerCharacter, string2, string3, true);
                }
            } else {
                d2 = playerCharacter.getBonusDueToType(string2, string3, string4);
            }
            d += d2 * (double)n2;
        }
        return String.valueOf((int)(d * Math.pow(10.0, n)) / (int)Math.pow(10.0, n));
    }
}

