/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.MapKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Equipment;
import pcgen.core.EquipmentUtilities;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.analysis.OutputNameFormatting;
import pcgen.io.ExportHandler;
import pcgen.io.FileAccess;
import pcgen.io.exporttoken.Token;
import pcgen.util.BigDecimalHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EqToken
extends Token {
    public static final String TOKENNAME = "EQ";
    private static String cachedString = null;
    private static List<Equipment> cachedList = null;
    private static int cachedSerial = 0;
    private static PlayerCharacter cachedPC = null;

    @Override
    public String getTokenName() {
        return TOKENNAME;
    }

    @Override
    public String getToken(String string, PlayerCharacter playerCharacter, ExportHandler exportHandler) {
        String string2;
        String string3;
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "~");
        if (stringTokenizer.countTokens() >= 3) {
            string4 = stringTokenizer.nextToken();
            string5 = stringTokenizer.nextToken();
            string6 = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                string7 = stringTokenizer.nextToken();
                string8 = stringTokenizer.nextToken();
            }
            string = string.substring(0, string4.lastIndexOf(46));
        }
        stringTokenizer = new StringTokenizer(string4, ".");
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            if ("IF".equals(string3)) {
                bl = true;
                continue;
            }
            if (bl) {
                string4 = string4 + "." + string3;
                continue;
            }
            string4 = string3;
        }
        string3 = string.split("[0-9]+")[0];
        List<Equipment> list = null;
        StringTokenizer stringTokenizer2 = null;
        int n = -1;
        if (string3.equals(cachedString) && playerCharacter == cachedPC && playerCharacter.getSerial() == cachedSerial) {
            list = cachedList;
            string = string.substring(string3.length());
            stringTokenizer2 = new StringTokenizer(string, ".", false);
            string2 = stringTokenizer2.nextToken();
            while (stringTokenizer2.hasMoreTokens()) {
                try {
                    n = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (n < 0) {
                    string2 = stringTokenizer2.nextToken();
                    continue;
                }
                break;
            }
        } else {
            stringTokenizer2 = new StringTokenizer(string, ".", false);
            stringTokenizer2.nextToken();
            string2 = stringTokenizer2.nextToken();
            int n2 = 0;
            if (string2.indexOf("MERGE") >= 0) {
                n2 = EqToken.returnMergeType(string2);
                string2 = stringTokenizer2.nextToken();
            }
            list = new ArrayList<Equipment>();
            for (Equipment equipment : playerCharacter.getEquipmentListInOutputOrder(n2)) {
                list.add(equipment);
            }
            while (stringTokenizer2.hasMoreTokens()) {
                if ("NOT".equalsIgnoreCase(string2)) {
                    list = EqToken.listNotType(playerCharacter, list, stringTokenizer2.nextToken());
                } else if ("ADD".equalsIgnoreCase(string2)) {
                    list = EqToken.listAddType(playerCharacter, list, stringTokenizer2.nextToken());
                } else if ("IS".equalsIgnoreCase(string2)) {
                    list = EqToken.listIsType(playerCharacter, list, stringTokenizer2.nextToken());
                } else {
                    try {
                        n = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (n >= 0) break;
                string2 = stringTokenizer2.nextToken();
            }
            cachedList = list;
            cachedString = string3;
            cachedPC = playerCharacter;
            cachedSerial = playerCharacter.getSerial();
        }
        string2 = stringTokenizer2.nextToken();
        String string9 = "";
        if (n >= 0 && n < list.size()) {
            Equipment equipment = list.get(n);
            string9 = FileAccess.filterString(EqToken.getEqToken(playerCharacter, equipment, string2, stringTokenizer2));
            if (!"".equals(string4)) {
                stringTokenizer2 = new StringTokenizer(string4, ".");
                boolean bl2 = false;
                boolean bl3 = false;
                while (stringTokenizer2.hasMoreTokens()) {
                    String string10 = stringTokenizer2.nextToken();
                    if ("AND".equals(string10)) {
                        bl3 = true;
                        continue;
                    }
                    if ("OR".equals(string10)) {
                        bl3 = false;
                        continue;
                    }
                    if (bl3) {
                        bl2 = bl2 && equipment.isType(string10);
                        continue;
                    }
                    bl2 = bl2 || equipment.isType(string10);
                }
                string9 = bl2 ? string5 + string9 + string6 : string7 + string9 + string8;
            }
        }
        return string9;
    }

    @Override
    public boolean isEncoded() {
        return false;
    }

    public static String getAcCheckToken(PlayerCharacter playerCharacter, Equipment equipment) {
        return EqToken.getAcCheckTokenInt(playerCharacter, equipment) + "";
    }

    public static int getAcCheckTokenInt(PlayerCharacter playerCharacter, Equipment equipment) {
        return equipment.acCheck(playerCharacter);
    }

    public static String getAcModToken(PlayerCharacter playerCharacter, Equipment equipment) {
        return EqToken.getAcModTokenInt(playerCharacter, equipment) + "";
    }

    public static int getAcModTokenInt(PlayerCharacter playerCharacter, Equipment equipment) {
        return equipment.getACMod(playerCharacter);
    }

    public static String getAltCritMultToken(Equipment equipment) {
        return equipment.getAltCritMult();
    }

    public static String getAltCritRangeToken(PlayerCharacter playerCharacter, Equipment equipment) {
        int n = playerCharacter.getCritRange(equipment, false);
        return n == 0 ? "" : Integer.toString(n);
    }

    public static String getAltDamageToken(PlayerCharacter playerCharacter, Equipment equipment) {
        return equipment.getAltDamage(playerCharacter);
    }

    public static String getAttacksToken(PlayerCharacter playerCharacter, Equipment equipment) {
        return EqToken.getAttacksTokenDouble(playerCharacter, equipment) + "";
    }

    public static double getAttacksTokenDouble(PlayerCharacter playerCharacter, Equipment equipment) {
        return equipment.bonusTo(playerCharacter, "COMBAT", "ATTACKS", true);
    }

    public static String getCarriedToken(Equipment equipment) {
        return EqToken.getCarriedTokenFloat(equipment) + "";
    }

    public static float getCarriedTokenFloat(Equipment equipment) {
        return equipment.numberCarried().floatValue();
    }

    public static String getChargesToken(Equipment equipment) {
        String string = "";
        int n = EqToken.getChargesTokenInt(equipment);
        if (n >= 0) {
            string = n + "";
        }
        return string;
    }

    public static int getChargesTokenInt(Equipment equipment) {
        return equipment.getRemainingCharges();
    }

    public static String getChargesUsedToken(Equipment equipment) {
        String string = "";
        int n = EqToken.getChargesUsedTokenInt(equipment);
        if (n >= 0) {
            string = n + "";
        }
        return string;
    }

    public static int getChargesUsedTokenInt(Equipment equipment) {
        return equipment.getUsedCharges();
    }

    public static double getContentWeightTokenDouble(PlayerCharacter playerCharacter, Equipment equipment) {
        if (equipment.getChildCount() == 0) {
            return 0.0;
        }
        return equipment.getContainedWeight(playerCharacter, true).doubleValue();
    }

    public static String getContentsToken(PlayerCharacter playerCharacter, Equipment equipment, StringTokenizer stringTokenizer) {
        if (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            String string2 = "NAME";
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
            }
            try {
                int n = Integer.parseInt(string);
                return EqToken.getEqToken(playerCharacter, equipment.getContainedByIndex(n), string2, stringTokenizer);
            }
            catch (NumberFormatException numberFormatException) {
                return equipment.getContainerByType(string, string2);
            }
        }
        return EqToken.getContentsToken(equipment);
    }

    public static String getContentsToken(Equipment equipment) {
        return equipment.getContainerContentsString();
    }

    public static String getContentsNumToken(Equipment equipment) {
        return EqToken.getContentsNumTokenInt(equipment) + "";
    }

    public static int getContentsNumTokenInt(Equipment equipment) {
        return equipment.getContents().size();
    }

    public static String getCostToken(PlayerCharacter playerCharacter, Equipment equipment) {
        return BigDecimalHelper.trimZeros(equipment.getCost(playerCharacter));
    }

    public static String getCritMultToken(Equipment equipment) {
        return equipment.getCritMult();
    }

    public static String getCritRangeToken(PlayerCharacter playerCharacter, Equipment equipment) {
        int n = playerCharacter.getCritRange(equipment, true);
        return n == 0 ? "" : Integer.toString(n);
    }

    public static String getDamageToken(PlayerCharacter playerCharacter, Equipment equipment) {
        return equipment.getDamage(playerCharacter);
    }

    public static String getDescriptionToken(PlayerCharacter playerCharacter, Equipment equipment) {
        return playerCharacter.getDescription(equipment);
    }

    public static String getEdrToken(PlayerCharacter playerCharacter, Equipment equipment) {
        return EqToken.getEdrTokenInt(playerCharacter, equipment) + "";
    }

    public static int getEdrTokenInt(PlayerCharacter playerCharacter, Equipment equipment) {
        return equipment.eDR(playerCharacter);
    }

    public static String getEquippedToken(Equipment equipment) {
        return EqToken.getEquippedTokenBoolean(equipment) ? "Y" : "N";
    }

    public static boolean getEquippedTokenBoolean(Equipment equipment) {
        return equipment.isEquipped();
    }

    public static String getFumbleRangeToken(Equipment equipment) {
        return equipment.getFumbleRange();
    }

    public static String getIsTypeToken(Equipment equipment, String string) {
        return EqToken.getIsTypeTokenBoolean(equipment, string) ? "TRUE" : "FALSE";
    }

    public static boolean getIsTypeTokenBoolean(Equipment equipment, String string) {
        return equipment.isType(string);
    }

    public static String getLocationToken(Equipment equipment) {
        PObject pObject = (PObject)((Object)equipment.getParent());
        if (pObject != null) {
            return pObject.getOutputName();
        }
        return equipment.getParentName();
    }

    public static String getLongNameToken(Equipment equipment) {
        return equipment.longName();
    }

    public static String getMaxChargesToken(Equipment equipment) {
        String string = "";
        int n = EqToken.getMaxChargesTokenInt(equipment);
        if (n >= 0) {
            string = n + "";
        }
        return string;
    }

    public static int getMaxChargesTokenInt(Equipment equipment) {
        return equipment.getMaxCharges();
    }

    public static String getMaxDexToken(PlayerCharacter playerCharacter, Equipment equipment) {
        return EqToken.getMaxDexTokenInt(playerCharacter, equipment) + "";
    }

    public static int getMaxDexTokenInt(PlayerCharacter playerCharacter, Equipment equipment) {
        return equipment.getMaxDex(playerCharacter);
    }

    public static String getMoveToken(Equipment equipment) {
        return equipment.moveString();
    }

    public static String getNameToken(Equipment equipment, PlayerCharacter playerCharacter) {
        return OutputNameFormatting.parseOutputName(equipment.getOutputName(), playerCharacter);
    }

    public static String getNoteToken(Equipment equipment) {
        return equipment.getNote();
    }

    public static String getQtyToken(Equipment equipment) {
        return BigDecimalHelper.trimZeros(Double.toString(EqToken.getQtyDoubleToken(equipment)));
    }

    public static double getQtyDoubleToken(Equipment equipment) {
        return equipment.qty();
    }

    public static double getCheckboxesDoubleToken(Equipment equipment) {
        if (SettingsHandler.getShowSingleBoxPerBundle()) {
            return EqToken.getQtyDoubleToken(equipment);
        }
        return EqToken.getQtyDoubleToken(equipment) * (double)equipment.getSafe(IntegerKey.BASE_QUANTITY);
    }

    public static String getCheckboxesToken(Equipment equipment) {
        return BigDecimalHelper.trimZeros(Double.toString(EqToken.getCheckboxesDoubleToken(equipment)));
    }

    public static String getRangeToken(Equipment equipment, PlayerCharacter playerCharacter) {
        return Globals.getGameModeUnitSet().displayDistanceInUnitSet(equipment.getRange(playerCharacter).intValue()) + Globals.getGameModeUnitSet().getDistanceUnit();
    }

    public static String getSizeToken(Equipment equipment) {
        return equipment.getSize();
    }

    public static String getSizeLongToken(Equipment equipment) {
        return equipment.getSafe(ObjectKey.SIZE).getDisplayName();
    }

    public static String getSourceToken(Equipment equipment) {
        return equipment.getDefaultSourceString();
    }

    public static String getSpellFailureToken(PlayerCharacter playerCharacter, Equipment equipment) {
        return EqToken.getSpellFailureTokenInt(playerCharacter, equipment) + "";
    }

    public static int getSpellFailureTokenInt(PlayerCharacter playerCharacter, Equipment equipment) {
        return equipment.spellFailure(playerCharacter);
    }

    public static String getSpropToken(PlayerCharacter playerCharacter, Equipment equipment) {
        return equipment.getSpecialProperties(playerCharacter);
    }

    public static double getTotalWeightTokenDouble(PlayerCharacter playerCharacter, Equipment equipment) {
        return EqToken.getContentWeightTokenDouble(playerCharacter, equipment) + EqToken.getWtTokenDouble(playerCharacter, equipment);
    }

    public static double getTotalWtTokenDouble(PlayerCharacter playerCharacter, Equipment equipment) {
        return equipment.qty() * equipment.getWeightAsDouble(playerCharacter);
    }

    public static String getTypeToken(Equipment equipment) {
        return equipment.getType().toUpperCase();
    }

    public static String getTypeToken(Equipment equipment, int n) {
        return equipment.typeIndex(n).toUpperCase();
    }

    public static double getWtTokenDouble(PlayerCharacter playerCharacter, Equipment equipment) {
        return equipment.getWeightAsDouble(playerCharacter);
    }

    public static List<Equipment> listNotType(PlayerCharacter playerCharacter, List<Equipment> list, String string) {
        return EquipmentUtilities.removeEqType(list, string);
    }

    public static List<Equipment> listAddType(PlayerCharacter playerCharacter, List<Equipment> list, String string) {
        return playerCharacter.addEqType(list, string);
    }

    public static List<Equipment> listIsType(PlayerCharacter playerCharacter, List<Equipment> list, String string) {
        return EquipmentUtilities.removeNotEqType(list, string);
    }

    protected static String getEqToken(PlayerCharacter playerCharacter, Equipment equipment, String string, StringTokenizer stringTokenizer) {
        String string2 = "";
        if ("LONGNAME".equals(string)) {
            string2 = EqToken.getLongNameToken(equipment);
        } else if ("NAME".equals(string) || "OUTPUTNAME".equals(string)) {
            string2 = EqToken.getNameToken(equipment, playerCharacter);
        } else if ("NOTE".equals(string)) {
            string2 = EqToken.getNoteToken(equipment);
        } else if ("WT".equals(string) || "ITEMWEIGHT".equals(string)) {
            string2 = Globals.getGameModeUnitSet().displayWeightInUnitSet(EqToken.getWtTokenDouble(playerCharacter, equipment));
        } else if ("TOTALWT".equals(string)) {
            string2 = Globals.getGameModeUnitSet().displayWeightInUnitSet(EqToken.getTotalWtTokenDouble(playerCharacter, equipment));
        } else if ("TOTALWEIGHT".equals(string)) {
            string2 = Globals.getGameModeUnitSet().displayWeightInUnitSet(EqToken.getTotalWeightTokenDouble(playerCharacter, equipment));
        } else if ("ISTYPE".equals(string)) {
            string2 = EqToken.getIsTypeToken(equipment, stringTokenizer.nextToken());
        } else if ("CHECKBOXES".equals(string)) {
            string2 = EqToken.getCheckboxesToken(equipment);
        } else if ("CONTENTWEIGHT".equals(string)) {
            string2 = Globals.getGameModeUnitSet().displayWeightInUnitSet(EqToken.getContentWeightTokenDouble(playerCharacter, equipment));
        } else if ("COST".equals(string)) {
            string2 = EqToken.getCostToken(playerCharacter, equipment);
        } else if ("DESC".equals(string)) {
            string2 = EqToken.getDescriptionToken(playerCharacter, equipment);
        } else if ("FUMBLERANGE".equals(string)) {
            string2 = EqToken.getFumbleRangeToken(equipment);
        } else if ("QTY".equals(string)) {
            string2 = EqToken.getQtyToken(equipment);
        } else if ("EQUIPPED".equals(string)) {
            string2 = EqToken.getEquippedToken(equipment);
        } else if ("CARRIED".equals(string)) {
            string2 = EqToken.getCarriedToken(equipment);
        } else if ("CONTENTSNUM".equals(string)) {
            string2 = EqToken.getContentsNumToken(equipment);
        } else if ("LOCATION".equals(string)) {
            string2 = EqToken.getLocationToken(equipment);
        } else if ("ACMOD".equals(string)) {
            string2 = EqToken.getAcModToken(playerCharacter, equipment);
        } else if ("MAXDEX".equals(string)) {
            string2 = EqToken.getMaxDexToken(playerCharacter, equipment);
        } else if ("ACCHECK".equals(string)) {
            string2 = EqToken.getAcCheckToken(playerCharacter, equipment);
        } else if ("EDR".equals(string)) {
            string2 = EqToken.getEdrToken(playerCharacter, equipment);
        } else if ("MOVE".equals(string)) {
            string2 = EqToken.getMoveToken(equipment);
        } else {
            if ("TYPE".equals(string)) {
                if (stringTokenizer.hasMoreTokens()) {
                    try {
                        int n = Integer.parseInt(stringTokenizer.nextToken());
                        return EqToken.getTypeToken(equipment, n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return EqToken.getTypeToken(equipment);
            }
            if ("QUALITY".equals(string)) {
                Map<String, String> map = equipment.getMapFor(MapKey.QUALITY);
                if (map != null) {
                    if (stringTokenizer.hasMoreTokens()) {
                        block90: {
                            String string3 = stringTokenizer.nextToken();
                            try {
                                int n = Integer.parseInt(string3);
                                for (String string4 : map.values()) {
                                    if (--n != 0) continue;
                                    return string4;
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                String string5 = map.get(string3);
                                if (string5 == null) break block90;
                                return string5;
                            }
                        }
                        return "";
                    }
                    TreeSet<String> treeSet = new TreeSet<String>();
                    for (Map.Entry<String, String> entry : map.entrySet()) {
                        treeSet.add(entry.getKey() + ": " + entry.getValue());
                    }
                    return StringUtil.join(treeSet, ", ");
                }
                return "";
            }
            if ("SPELLFAILURE".equals(string)) {
                string2 = EqToken.getSpellFailureToken(playerCharacter, equipment);
            } else if ("SIZE".equals(string)) {
                string2 = EqToken.getSizeToken(equipment);
            } else if ("SIZELONG".equals(string)) {
                string2 = EqToken.getSizeLongToken(equipment);
            } else if ("DAMAGE".equals(string)) {
                string2 = EqToken.getDamageToken(playerCharacter, equipment);
            } else if ("CRITRANGE".equals(string)) {
                string2 = EqToken.getCritRangeToken(playerCharacter, equipment);
            } else if ("CRITMULT".equals(string)) {
                string2 = EqToken.getCritMultToken(equipment);
            } else if ("ALTDAMAGE".equals(string)) {
                string2 = EqToken.getAltDamageToken(playerCharacter, equipment);
            } else if ("ALTCRITMULT".equals(string) || "ALTCRIT".equals(string)) {
                string2 = EqToken.getAltCritMultToken(equipment);
            } else if ("ALTCRITRANGE".equals(string)) {
                string2 = EqToken.getAltCritRangeToken(playerCharacter, equipment);
            } else if ("RANGE".equals(string)) {
                string2 = EqToken.getRangeToken(equipment, playerCharacter);
            } else if ("ATTACKS".equals(string)) {
                string2 = EqToken.getAttacksToken(playerCharacter, equipment);
            } else if ("PROF".equals(string)) {
                string2 = equipment.consolidatedProfName();
            } else if ("SPROP".equals(string)) {
                string2 = EqToken.getSpropToken(playerCharacter, equipment);
            } else if ("CHARGES".equals(string)) {
                string2 = EqToken.getChargesToken(equipment);
            } else if ("CHARGESUSED".equals(string)) {
                string2 = EqToken.getChargesUsedToken(equipment);
            } else if ("MAXCHARGES".equals(string)) {
                string2 = EqToken.getMaxChargesToken(equipment);
            } else if ("CONTENTS".equals(string)) {
                string2 = EqToken.getContentsToken(playerCharacter, equipment, stringTokenizer);
            } else if ("SOURCE".equals(string)) {
                string2 = EqToken.getSourceToken(equipment);
            }
        }
        return string2;
    }

    protected static int returnMergeType(String string) {
        int n = 0;
        if ("MERGENONE".equals(string)) {
            n = 1;
        } else if ("MERGELOC".equals(string)) {
            n = 2;
        } else if ("MERGEALL".equals(string)) {
            n = 0;
        }
        return n;
    }
}

