/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.filters;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.CoreUtility;
import pcgen.io.filters.OutputFilter;
import pcgen.util.Logging;

public class PatternFilter
implements OutputFilter {
    private String outputFilterName = "";
    private List<String> match = null;
    private List<String> replace = null;

    public PatternFilter(String string) throws IOException {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        if ((string = string.toLowerCase()).equals(this.outputFilterName)) {
            return;
        }
        string = SettingsHandler.getPcgenSystemDir() + File.separator + "outputFilters" + File.separator + "re" + string + ".lst";
        Logging.debugPrint("Creating filter from " + string);
        File file = new File(string);
        if (file.canRead() && file.isFile()) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            this.outputFilterName = string;
            this.match = new ArrayList<String>();
            this.replace = new ArrayList<String>();
            while (true) {
                String string2 = bufferedReader.readLine();
                Logging.debugPrint("Line read:" + string2);
                if (string2 == null) break;
                if (string2.length() == 0 || string2.charAt(0) == '#') continue;
                String string3 = 0 < string2.indexOf("\t#") ? string2.substring(0, string2.indexOf("\t#")) : string2;
                Logging.debugPrint("Stripped line:" + string3);
                List<String> list = CoreUtility.split(string3, '\t');
                try {
                    if (list.size() == 2) {
                        this.match.add(list.get(0));
                        Logging.debugPrint("Match: [" + list.get(0) + "] and replace with [" + list.get(1) + "]");
                        this.replace.add(list.get(1).replaceAll("\\\\n", "\n").replaceAll("\\\\t", "\t"));
                        continue;
                    }
                    if (list.size() == 1) {
                        this.match.add(list.get(0));
                        this.replace.add("");
                        Logging.debugPrint("Match: [" + list.get(0) + "] and replace with []");
                        continue;
                    }
                    Logging.errorPrint("Incorrect line format in PatternFilter: Line ignored");
                }
                catch (NullPointerException nullPointerException) {
                    Logging.errorPrint("Exception in setCurrentOutputFilter", nullPointerException);
                }
                catch (NumberFormatException numberFormatException) {
                    Logging.errorPrint("Exception in setCurrentOutputFilter", numberFormatException);
                }
            }
            bufferedReader.close();
        }
    }

    public String filterString(String string) {
        String string2 = string;
        Logging.debugPrint("Filtering: " + string);
        if (this.match != null && this.match.size() != 0 && string != null) {
            Logging.debugPrint("Found " + this.match.size() + " filters");
            for (int i = 0; i < this.match.size(); ++i) {
                String string3 = string2;
                if ((string2 = string2.replaceAll(this.match.get(i), this.replace.get(i))).equals(string3)) continue;
                Logging.debugPrint("Match: [" + this.match.get(i) + "] and replace with [" + this.replace.get(i) + "]");
                Logging.debugPrint("[" + string3 + "]=>[" + string2 + "]");
            }
        }
        Logging.debugPrint("Filtered: " + string2);
        return string2;
    }
}

