/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import java.util.ArrayList;
import java.util.StringTokenizer;
import pcgen.core.BioSet;
import pcgen.core.GameMode;
import pcgen.core.SystemCollections;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.rules.context.LoadContext;

final class BioSetLoader
extends LstLineFileLoader {
    private static String regionName = "None";
    BioSet bioSet = new BioSet();
    int currentAgeSetIndex = 0;

    public static void clear() {
        regionName = "None";
    }

    public void loadLstFile(LoadContext loadContext, URI uRI) throws PersistenceLayerException {
        this.currentAgeSetIndex = 0;
        GameMode gameMode = SystemCollections.getGameModeNamed(this.gameMode);
        this.bioSet = gameMode.getBioSet();
        super.loadLstFile(loadContext, uRI);
        gameMode.setBioSet(this.bioSet);
    }

    public void parseLine(LoadContext loadContext, String string, URI uRI) {
        if (string.startsWith("AGESET:")) {
            this.currentAgeSetIndex = this.bioSet.addToAgeMap(regionName, string.substring(7), this.currentAgeSetIndex);
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
            String string2 = "";
            ArrayList<String> arrayList = null;
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3.startsWith("RACENAME:")) {
                    string2 = string3.substring(9);
                    continue;
                }
                if (string3.startsWith("REGION:")) {
                    regionName = string3.substring(7);
                    continue;
                }
                if (PreParserFactory.isPreReqString(string3)) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<String>();
                    }
                    arrayList.add(string3);
                    continue;
                }
                String string4 = "";
                if (arrayList != null) {
                    StringBuffer stringBuffer = new StringBuffer(100);
                    int n = arrayList.size();
                    for (int i = 0; i < n; ++i) {
                        stringBuffer.append('[').append((String)arrayList.get(i)).append(']');
                    }
                    string4 = stringBuffer.toString();
                }
                this.bioSet.addToUserMap(regionName, string2, string3 + string4, this.currentAgeSetIndex);
            }
        }
    }
}

