/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import java.util.Map;
import pcgen.core.InstallableCampaign;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.InstallLstToken;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.TokenStore;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;

public class InstallLoader
extends LstLineFileLoader {
    private InstallableCampaign campaign = null;

    public void loadLstString(LoadContext loadContext, URI uRI, String string) throws PersistenceLayerException {
        this.campaign = new InstallableCampaign();
        this.campaign.setSourceURI(uRI);
        super.loadLstString(loadContext, uRI, string);
    }

    public void parseLine(LoadContext loadContext, String string, URI uRI) throws PersistenceLayerException {
        int n = string.indexOf(58);
        if (n < 0) {
            Logging.errorPrint("Unparsed line: " + string + " in " + uRI.toString());
            return;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        Map<String, LstToken> map = TokenStore.inst().getTokenMap(InstallLstToken.class);
        InstallLstToken installLstToken = (InstallLstToken)map.get(string2);
        if (installLstToken != null) {
            LstUtils.deprecationCheck(installLstToken, this.campaign, string3);
            if (!installLstToken.parse(this.campaign, string3, uRI)) {
                Logging.errorPrint("Error parsing install " + this.campaign.getDisplayName() + ':' + string);
            }
        } else {
            Logging.errorPrint("Unparsed line: " + string + " in " + uRI.toString());
        }
    }

    public InstallableCampaign getCampaign() {
        return this.campaign;
    }
}

