/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.util.StringTokenizer;
import pcgen.core.Kit;
import pcgen.core.kit.KitAbilities;
import pcgen.core.kit.KitAlignment;
import pcgen.core.kit.KitBio;
import pcgen.core.kit.KitClass;
import pcgen.core.kit.KitDeity;
import pcgen.core.kit.KitFunds;
import pcgen.core.kit.KitGear;
import pcgen.core.kit.KitKit;
import pcgen.core.kit.KitLangBonus;
import pcgen.core.kit.KitLevelAbility;
import pcgen.core.kit.KitProf;
import pcgen.core.kit.KitRace;
import pcgen.core.kit.KitSelect;
import pcgen.core.kit.KitSkill;
import pcgen.core.kit.KitSpells;
import pcgen.core.kit.KitStat;
import pcgen.core.kit.KitTable;
import pcgen.core.kit.KitTemplate;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.LstObjectFileLoader;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.CDOMKitLoader;
import pcgen.rules.persistence.CDOMSubLineLoader;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KitLoader
extends LstObjectFileLoader<Kit> {
    private final CDOMKitLoader kitLoader = new CDOMKitLoader();

    public KitLoader() {
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitAlignment>("*KITTOKEN", "ALIGN", KitAlignment.class));
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitRace>("*KITTOKEN", "RACE", KitRace.class));
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitSkill>("*KITTOKEN", "SKILL", KitSkill.class));
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitGear>("*KITTOKEN", "GEAR", KitGear.class));
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitSpells>("*KITTOKEN", "SPELLS", KitSpells.class));
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitStat>("*KITTOKEN", "STAT", KitStat.class));
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitProf>("*KITTOKEN", "PROF", KitProf.class));
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitAbilities>("*KITTOKEN", "FEAT", KitAbilities.class));
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitAbilities>("*KITTOKEN", "ABILITY", KitAbilities.class));
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitBio>("*KITTOKEN", "NAME", KitBio.class));
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitLevelAbility>("*KITTOKEN", "LEVELABILITY", KitLevelAbility.class));
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitClass>("*KITTOKEN", "CLASS", KitClass.class));
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitTemplate>("*KITTOKEN", "TEMPLATE", KitTemplate.class));
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitDeity>("*KITTOKEN", "DEITY", KitDeity.class));
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitKit>("*KITTOKEN", "KIT", KitKit.class));
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitTable>("*KITTOKEN", "TABLE", KitTable.class));
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitSelect>("*KITTOKEN", "SELECT", KitSelect.class));
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitBio>("*KITTOKEN", "GENDER", KitBio.class));
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitFunds>("*KITTOKEN", "FUNDS", KitFunds.class));
        this.kitLoader.addLineLoader(new CDOMSubLineLoader<KitLangBonus>("*KITTOKEN", "LANGBONUS", KitLangBonus.class));
    }

    @Override
    protected Kit getObjectKeyed(LoadContext loadContext, String string) {
        return loadContext.ref.silentlyGetConstructedCDOMObject(Kit.class, string);
    }

    @Override
    public Kit parseLine(LoadContext loadContext, Kit kit, String string, CampaignSourceEntry campaignSourceEntry) throws PersistenceLayerException {
        if (string.startsWith("STARTPACK:")) {
            if (kit != null) {
                this.completeObject(loadContext, campaignSourceEntry, kit);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(58);
            kit = loadContext.ref.constructCDOMObject(Kit.class, string2.substring(n + 1));
            kit.setSourceCampaign(campaignSourceEntry.getCampaign());
            kit.setSourceURI(campaignSourceEntry.getURI());
            loadContext.addStatefulInformation(kit);
            while (stringTokenizer.hasMoreTokens()) {
                String string3;
                String string4 = stringTokenizer.nextToken().trim();
                int n2 = string4.indexOf(58);
                if (n2 == -1) {
                    Logging.errorPrint("Invalid Token - does not contain a colon: " + string4);
                    continue;
                }
                if (n2 == 0) {
                    Logging.errorPrint("Invalid Token - starts with a colon: " + string4);
                    continue;
                }
                String string5 = string4.substring(0, n2);
                String string6 = string3 = n2 == string4.length() - 1 ? null : string4.substring(n2 + 1);
                if (loadContext.processToken(kit, string5, string3)) {
                    loadContext.commit();
                    continue;
                }
                loadContext.rollback();
                Logging.replayParsedMessages();
            }
        } else if (string.startsWith("REGION:")) {
            String string7 = string.substring(7);
            loadContext.clearStatefulInformation();
            if (string7 != null && string7.length() > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string7, "\t");
                String string8 = stringTokenizer.nextToken();
                if (!string8.equalsIgnoreCase("NONE")) {
                    if (loadContext.addStatefulToken("PREREGION:" + string8)) {
                        loadContext.commit();
                    } else {
                        loadContext.rollback();
                        Logging.errorPrint("Invalid Stateful Token from Region NONE: PREREGION:" + string8);
                        Logging.replayParsedMessages();
                    }
                    Logging.clearParseMessages();
                }
                while (stringTokenizer.hasMoreTokens()) {
                    String string9 = stringTokenizer.nextToken();
                    if (loadContext.addStatefulToken(string9)) continue;
                    Logging.errorPrint("Invalid Stateful Token: " + string9);
                }
            }
        } else {
            loadContext.rollback();
            if (this.kitLoader.parseSubLine(loadContext, kit, string, campaignSourceEntry.getURI())) {
                Logging.clearParseMessages();
                loadContext.commit();
            } else {
                loadContext.rollback();
                Logging.replayParsedMessages();
                Logging.clearParseMessages();
            }
        }
        return kit;
    }
}

