/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.Campaign;
import pcgen.core.PObject;
import pcgen.core.SettingsHandler;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.LstFileLoader;
import pcgen.persistence.lst.SourceLoader;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LstObjectFileLoader<T extends PObject>
extends Observable {
    public static final String FIELD_SEPARATOR = "\t";
    public static final String LINE_SEPARATOR = "\r\n";
    public static final String INCLUDE_TAG = "INCLUDE";
    public static final String EXCLUDE_TAG = "EXCLUDE";
    public static final String COPY_SUFFIX = ".COPY";
    public static final String MOD_SUFFIX = ".MOD";
    public static final String FORGET_SUFFIX = ".FORGET";
    private List<ModEntry> copyLineList = new ArrayList<ModEntry>();
    private List<String> forgetLineList = new ArrayList<String>();
    private List<List<ModEntry>> modEntryList = new ArrayList<List<ModEntry>>();
    private boolean processComplete = true;
    protected List<String> excludedObjects = new ArrayList<String>();

    public void loadLstFiles(LoadContext loadContext, List<CampaignSourceEntry> list) throws PersistenceLayerException {
        this.processComplete = true;
        HashSet<CampaignSourceEntry> hashSet = new HashSet<CampaignSourceEntry>();
        for (CampaignSourceEntry campaignSourceEntry : list) {
            if (campaignSourceEntry == null || hashSet.contains(campaignSourceEntry)) continue;
            this.loadLstFile(loadContext, campaignSourceEntry);
            hashSet.add(campaignSourceEntry);
        }
        this.processCopies(loadContext);
        this.processComplete = false;
        this.processMods(loadContext);
        this.processForgets(loadContext);
    }

    public abstract T parseLine(LoadContext var1, T var2, String var3, CampaignSourceEntry var4) throws PersistenceLayerException;

    public void completeObject(LoadContext loadContext, CampaignSourceEntry campaignSourceEntry, T t) throws PersistenceLayerException {
        if (!this.processComplete || t == null) {
            return;
        }
        if (this.includeObject(campaignSourceEntry, (PObject)t)) {
            this.finishObject((PObject)t);
            this.storeObject(loadContext, t);
        } else {
            this.excludedObjects.add(((CDOMObject)t).getKeyName());
            loadContext.ref.forget(t);
        }
    }

    protected void storeObject(LoadContext loadContext, T t) {
        T t2 = this.getMatchingObject(loadContext, (PObject)t);
        if (!loadContext.consolidate() || t2 == null || !((PObject)t).equals(t2)) {
            this.addGlobalObject((PObject)t);
        } else if (t2 != t) {
            if (SettingsHandler.isAllowOverride()) {
                Date date = ((CDOMObject)t).get(ObjectKey.SOURCE_DATE);
                Date date2 = ((CDOMObject)t2).get(ObjectKey.SOURCE_DATE);
                if (date != null && (date2 == null || date.compareTo(date2) > 0)) {
                    this.performForget(loadContext, t2);
                    this.addGlobalObject((PObject)t);
                } else {
                    loadContext.ref.forget(t);
                }
            } else {
                Logging.errorPrintLocalised("Warnings.LstFileLoader.DuplicateObject", ((CDOMObject)t).getKeyName(), ((PObject)t2).getSourceURI(), ((PObject)t).getSourceURI());
            }
        }
    }

    protected void addGlobalObject(PObject pObject) {
    }

    protected void finishObject(PObject pObject) {
    }

    protected boolean includeObject(CampaignSourceEntry campaignSourceEntry, PObject pObject) {
        if (pObject == null || pObject.getDisplayName() == null || pObject.getDisplayName().trim().length() == 0 || pObject.getKeyName() == null || pObject.getKeyName().trim().length() == 0) {
            return false;
        }
        List<String> list = campaignSourceEntry.getIncludeItems();
        if (!list.isEmpty()) {
            return list.contains(pObject.getKeyName());
        }
        List<String> list2 = campaignSourceEntry.getExcludeItems();
        if (!list2.isEmpty()) {
            return !list2.contains(pObject.getKeyName());
        }
        return true;
    }

    protected abstract T getObjectKeyed(LoadContext var1, String var2);

    protected T getMatchingObject(LoadContext loadContext, PObject pObject) {
        return this.getObjectKeyed(loadContext, pObject.getKeyName());
    }

    protected void loadLstFile(LoadContext loadContext, CampaignSourceEntry campaignSourceEntry) {
        StringBuilder stringBuilder;
        this.setChanged();
        URI uRI = campaignSourceEntry.getURI();
        this.notifyObservers(uRI);
        try {
            stringBuilder = LstFileLoader.readFromURI(uRI);
        }
        catch (PersistenceLayerException persistenceLayerException) {
            String string = PropertyFactory.getFormattedString("Errors.LstFileLoader.LoadError", uRI, persistenceLayerException.getMessage());
            Logging.errorPrint(string);
            this.setChanged();
            return;
        }
        String string = stringBuilder.toString();
        if (loadContext != null) {
            loadContext.setSourceURI(uRI);
        }
        Object object = null;
        ArrayList<ModEntry> arrayList = null;
        String[] stringArray = string.replaceAll(LINE_SEPARATOR, "\r").split("(\r|\n)");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            String string3 = stringArray[i];
            if (string3.length() == 0 || string3.charAt(0) == '#') continue;
            int n = string3.indexOf(FIELD_SEPARATOR);
            String string4 = n == -1 ? string3 : string3.substring(0, n);
            if (arrayList != null) {
                if (string4.startsWith("CLASS:")) {
                    this.modEntryList.add(arrayList);
                    arrayList = null;
                } else {
                    arrayList.add(new ModEntry(campaignSourceEntry, string3, i + 1));
                    continue;
                }
            }
            if (string3.startsWith("SOURCE")) {
                SourceLoader.parseLine(loadContext, string3, uRI);
                continue;
            }
            if (string3.trim().length() == 0) continue;
            if (string4.indexOf(COPY_SUFFIX) > 0) {
                this.copyLineList.add(new ModEntry(campaignSourceEntry, string3, i + 1));
                continue;
            }
            if (string4.indexOf(MOD_SUFFIX) > 0) {
                if (string4.startsWith("CLASS:")) {
                    arrayList = new ArrayList<ModEntry>();
                    arrayList.add(new ModEntry(campaignSourceEntry, string3, i + 1));
                    continue;
                }
                ArrayList<ModEntry> arrayList2 = new ArrayList<ModEntry>();
                arrayList2.add(new ModEntry(campaignSourceEntry, string3, i + 1));
                this.modEntryList.add(arrayList2);
                continue;
            }
            if (string4.indexOf(FORGET_SUFFIX) > 0) {
                this.forgetLineList.add(string3);
                continue;
            }
            try {
                object = this.parseLine(loadContext, object, string3, campaignSourceEntry);
                continue;
            }
            catch (PersistenceLayerException persistenceLayerException) {
                string2 = PropertyFactory.getFormattedString("Errors.LstFileLoader.ParseError", uRI, i + 1, persistenceLayerException.getMessage());
                Logging.errorPrint(string2);
                this.setChanged();
                Logging.debugPrint("Parse error:", persistenceLayerException);
                continue;
            }
            catch (Throwable throwable) {
                string2 = PropertyFactory.getFormattedString("Errors.LstFileLoader.ParseError", uRI, i + 1, throwable.getMessage());
                Logging.errorPrint(string2);
                this.setChanged();
                Logging.errorPrint(PropertyFactory.getString("Errors.LstFileLoader.Ignoring"), throwable);
            }
        }
        if (arrayList != null) {
            this.modEntryList.add(arrayList);
        }
        if (object != null) {
            try {
                this.completeObject(loadContext, campaignSourceEntry, object);
            }
            catch (PersistenceLayerException persistenceLayerException) {
                Logging.errorPrint("Error in completing " + object.getClass().getSimpleName() + " " + ((CDOMObject)object).getKeyName());
                this.setChanged();
                Logging.debugPrint("Parse error:", persistenceLayerException);
            }
        }
    }

    protected void performForget(LoadContext loadContext, T t) {
        loadContext.ref.forget(t);
    }

    private T performCopy(LoadContext loadContext, String string, String string2) throws PersistenceLayerException {
        T t = this.getObjectKeyed(loadContext, string);
        try {
            if (t == null) {
                String string3 = PropertyFactory.getFormattedString("Errors.LstFileLoader.CopyObjectNotFound", string);
                Logging.errorPrint(string3);
                this.setChanged();
                return null;
            }
            PObject pObject = ((PObject)t).clone();
            pObject.setName(string2);
            pObject.put(StringKey.KEY_NAME, string2);
            return (T)pObject;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            String string4 = PropertyFactory.getFormattedString("Errors.LstFileLoader.CopyNotSupported", t.getClass().getName(), string, string2);
            Logging.errorPrint(string4);
            this.setChanged();
            return null;
        }
    }

    private void performCopy(LoadContext loadContext, ModEntry modEntry) throws PersistenceLayerException {
        String string = modEntry.getLstLine();
        int n = string.indexOf(FIELD_SEPARATOR);
        String string2 = n != -1 ? string.substring(0, n) : string;
        int n2 = string2.indexOf(COPY_SUFFIX);
        String string3 = string2.substring(0, n2);
        String string4 = string2.substring(n2 + 6);
        T t = this.performCopy(loadContext, string3, string4);
        loadContext.ref.importObject(t);
        if (t != null) {
            if (n != -1) {
                String string5 = modEntry.getLstLine().substring(n2 + 6);
                this.parseLine(loadContext, t, string5, modEntry.getSource());
            }
            this.completeObject(loadContext, modEntry.getSource(), t);
        }
    }

    private void performMod(LoadContext loadContext, List<ModEntry> list) {
        T t;
        ModEntry modEntry = list.get(0);
        int n = modEntry.getLstLine().indexOf(MOD_SUFFIX);
        String string = modEntry.getLstLine().substring(0, n);
        int n2 = string.indexOf(58);
        if (n2 > 0) {
            string = string.substring(n2 + 1);
        }
        if ((t = this.getObjectKeyed(loadContext, string)) == null) {
            if (this.excludedObjects.contains(string)) {
                return;
            }
            String string2 = PropertyFactory.getFormattedString("Errors.LstFileLoader.ModObjectNotFound", modEntry.getSource().getURI(), modEntry.getLineNumber(), string);
            Logging.log(Logging.LST_ERROR, string2);
            this.setChanged();
            return;
        }
        try {
            for (ModEntry modEntry2 : list) {
                loadContext.setSourceURI(modEntry2.source.getURI());
                try {
                    Campaign campaign = ((CDOMObject)t).get(ObjectKey.SOURCE_CAMPAIGN);
                    this.parseLine(loadContext, t, modEntry2.getLstLine(), modEntry2.getSource());
                    if (campaign == null) continue;
                    ((PObject)t).setSourceCampaign(campaign);
                }
                catch (PersistenceLayerException persistenceLayerException) {
                    String string3 = PropertyFactory.getFormattedString("Errors.LstFileLoader.ModParseError", modEntry2.getSource().getURI(), modEntry2.getLineNumber(), persistenceLayerException.getMessage());
                    Logging.errorPrint(string3);
                    this.setChanged();
                }
            }
            this.completeObject(loadContext, modEntry.getSource(), t);
        }
        catch (PersistenceLayerException persistenceLayerException) {
            String string4 = PropertyFactory.getFormattedString("Errors.LstFileLoader.ModParseError", modEntry.getSource().getURI(), modEntry.getLineNumber(), persistenceLayerException.getMessage());
            Logging.errorPrint(string4);
            this.setChanged();
        }
    }

    private void processCopies(LoadContext loadContext) throws PersistenceLayerException {
        for (ModEntry modEntry : this.copyLineList) {
            loadContext.setSourceURI(modEntry.source.getURI());
            this.performCopy(loadContext, modEntry);
        }
        this.copyLineList.clear();
    }

    private void processForgets(LoadContext loadContext) {
        for (String string : this.forgetLineList) {
            T t;
            if (this.excludedObjects.contains(string = string.substring(0, string.indexOf(FORGET_SUFFIX))) || (t = this.getObjectKeyed(loadContext, string)) == null) continue;
            this.performForget(loadContext, t);
        }
        this.forgetLineList.clear();
    }

    private void processMods(LoadContext loadContext) {
        for (List<ModEntry> list : this.modEntryList) {
            this.performMod(loadContext, list);
        }
        this.modEntryList.clear();
    }

    public static class ModEntry {
        private CampaignSourceEntry source = null;
        private String lstLine = null;
        private int lineNumber = 0;
        private Map<String, String> sourceMap = null;

        public ModEntry(CampaignSourceEntry campaignSourceEntry, String string, int n) {
            if (campaignSourceEntry == null) {
                throw new IllegalArgumentException("source must not be null");
            }
            if (string == null) {
                throw new IllegalArgumentException("lstLine must not be null");
            }
            this.source = campaignSourceEntry;
            this.lstLine = string;
            this.lineNumber = n;
        }

        public String getLstLine() {
            return this.lstLine;
        }

        public CampaignSourceEntry getSource() {
            return this.source;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }
    }
}

