/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeSet;
import pcgen.base.lang.StringUtil;
import pcgen.base.lang.UnreachableError;
import pcgen.cdom.base.Constants;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.MapKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.SourceFormat;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.reference.UnconstructedValidator;
import pcgen.core.AbilityCategory;
import pcgen.core.ArmorProf;
import pcgen.core.Campaign;
import pcgen.core.CustomData;
import pcgen.core.Deity;
import pcgen.core.Description;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.EquipmentList;
import pcgen.core.EquipmentModifier;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.PCAlignment;
import pcgen.core.PCStat;
import pcgen.core.PCTemplate;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.ShieldProf;
import pcgen.core.SizeAdjustment;
import pcgen.core.Skill;
import pcgen.core.SystemCollections;
import pcgen.core.WeaponProf;
import pcgen.core.analysis.EqModAttachment;
import pcgen.gui.pcGenGUI;
import pcgen.io.PCGFile;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.SystemLoader;
import pcgen.persistence.lst.AbilityCategoryLoader;
import pcgen.persistence.lst.AbilityLoader;
import pcgen.persistence.lst.BioSetLoader;
import pcgen.persistence.lst.CampaignLoader;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.CompanionModLoader;
import pcgen.persistence.lst.EquipSlotLoader;
import pcgen.persistence.lst.FeatLoader;
import pcgen.persistence.lst.GameModeLoader;
import pcgen.persistence.lst.GenericLoader;
import pcgen.persistence.lst.KitLoader;
import pcgen.persistence.lst.LanguageLoader;
import pcgen.persistence.lst.LevelLoader;
import pcgen.persistence.lst.LoadInfoLoader;
import pcgen.persistence.lst.LocationLoader;
import pcgen.persistence.lst.LstFileLoader;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.persistence.lst.PCClassLoader;
import pcgen.persistence.lst.PaperInfoLoader;
import pcgen.persistence.lst.PointBuyLoader;
import pcgen.persistence.lst.RuleCheckLoader;
import pcgen.persistence.lst.SizeAdjustmentLoader;
import pcgen.persistence.lst.SpellLoader;
import pcgen.persistence.lst.SponsorLoader;
import pcgen.persistence.lst.StatsAndChecksLoader;
import pcgen.persistence.lst.TraitLoader;
import pcgen.persistence.lst.UnitSetLoader;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LstSystemLoader
extends Observable
implements SystemLoader,
Observer {
    private static final FilenameFilter gameModeFileFilter = new FilenameFilter(){

        public boolean accept(File file, String string) {
            try {
                File file2 = new File(file, string);
                if (file2.isDirectory()) {
                    File file3 = new File(file2, "statsandchecks.lst");
                    if (file3.exists()) {
                        file3 = new File(file2, "miscinfo.lst");
                        return file3.exists();
                    }
                    return false;
                }
            }
            catch (SecurityException securityException) {
                Logging.errorPrint("GameModes.listGameFiles", securityException);
            }
            return false;
        }
    };
    private AbilityCategoryLoader abilityCategoryLoader = new AbilityCategoryLoader();
    private BioSetLoader bioLoader = new BioSetLoader();
    private CampaignLoader campaignLoader = new CampaignLoader();
    private final CampaignSourceEntry globalCampaign;
    private GenericLoader<Deity> deityLoader = new GenericLoader<Deity>(Deity.class);
    private GenericLoader<Domain> domainLoader = new GenericLoader<Domain>(Domain.class);
    private AbilityLoader abilityLoader = new AbilityLoader();
    private FeatLoader featLoader = new FeatLoader();
    private final FilenameFilter pccFileFilter = new FilenameFilter(){

        public boolean accept(File file, String string) {
            try {
                Comparable<URI> comparable;
                if (".pcc".regionMatches(true, 0, string, string.length() - 4, 4) && Globals.getCampaignByURI((URI)(comparable = new File(file, string).toURI()), false) == null) {
                    LstSystemLoader.this.campaignLoader.loadLstFile(null, (URI)comparable);
                }
                if (!".svn".equals(string) && !".lst".regionMatches(true, 0, string, string.length() - 4, 4) && ((File)(comparable = new File(file, string))).isDirectory()) {
                    LstSystemLoader.this.loadPCCFilesInDirectory((File)comparable);
                }
            }
            catch (PersistenceLayerException persistenceLayerException) {
                LstSystemLoader.this.logError("PersistanceLayer", persistenceLayerException);
            }
            return false;
        }
    };
    private LanguageLoader languageLoader = new LanguageLoader();
    private LoadInfoLoader loadInfoLoader = new LoadInfoLoader();
    private UnitSetLoader unitSetLoader = new UnitSetLoader();
    private EquipSlotLoader eqSlotLoader = new EquipSlotLoader();
    private final List<CampaignSourceEntry> bioSetFileList = new ArrayList<CampaignSourceEntry>();
    private final Map<String, List<URI>> chosenCampaignSourcefiles = new HashMap<String, List<URI>>();
    private final List<CampaignSourceEntry> classFileList = new ArrayList<CampaignSourceEntry>();
    private final List<CampaignSourceEntry> companionmodFileList = new ArrayList<CampaignSourceEntry>();
    private final List<CampaignSourceEntry> deityFileList = new ArrayList<CampaignSourceEntry>();
    private final List<CampaignSourceEntry> domainFileList = new ArrayList<CampaignSourceEntry>();
    private final List<CampaignSourceEntry> equipmentFileList = new ArrayList<CampaignSourceEntry>();
    private final List<CampaignSourceEntry> equipmodFileList = new ArrayList<CampaignSourceEntry>();
    private final List<CampaignSourceEntry> abilityCategoryFileList = new ArrayList<CampaignSourceEntry>();
    private final List<CampaignSourceEntry> abilityFileList = new ArrayList<CampaignSourceEntry>();
    private final List<CampaignSourceEntry> featFileList = new ArrayList<CampaignSourceEntry>();
    private final List<CampaignSourceEntry> kitFileList = new ArrayList<CampaignSourceEntry>();
    private final List<CampaignSourceEntry> languageFileList = new ArrayList<CampaignSourceEntry>();
    private List<CampaignSourceEntry> licenseFiles = new ArrayList<CampaignSourceEntry>();
    private final List<CampaignSourceEntry> lstExcludeFiles = new ArrayList<CampaignSourceEntry>();
    private final List<CampaignSourceEntry> raceFileList = new ArrayList<CampaignSourceEntry>();
    private final List<CampaignSourceEntry> skillFileList = new ArrayList<CampaignSourceEntry>();
    private final List<CampaignSourceEntry> spellFileList = new ArrayList<CampaignSourceEntry>();
    private final List<CampaignSourceEntry> templateFileList = new ArrayList<CampaignSourceEntry>();
    private final List<CampaignSourceEntry> weaponProfFileList = new ArrayList<CampaignSourceEntry>();
    private final List<CampaignSourceEntry> armorProfFileList = new ArrayList<CampaignSourceEntry>();
    private final List<CampaignSourceEntry> shieldProfFileList = new ArrayList<CampaignSourceEntry>();
    private LocationLoader locationLoader = new LocationLoader();
    private final Set<URI> loadedFiles = new HashSet<URI>();
    private PCClassLoader classLoader = new PCClassLoader();
    private GenericLoader<PCTemplate> templateLoader = new GenericLoader<PCTemplate>(PCTemplate.class);
    private GenericLoader<Equipment> equipmentLoader = new GenericLoader<Equipment>(Equipment.class);
    private GenericLoader<EquipmentModifier> eqModLoader = new GenericLoader<EquipmentModifier>(EquipmentModifier.class);
    private CompanionModLoader companionModLoader = new CompanionModLoader();
    private KitLoader kitLoader = new KitLoader();
    private PaperInfoLoader paperLoader = new PaperInfoLoader();
    private PointBuyLoader pointBuyLoader = new PointBuyLoader();
    private SponsorLoader sponsorLoader = new SponsorLoader();
    private GenericLoader<Race> raceLoader = new GenericLoader<Race>(Race.class);
    private final Set<String> sourcesSet = new TreeSet<String>();
    private SizeAdjustmentLoader sizeLoader = new SizeAdjustmentLoader();
    private GenericLoader<Skill> skillLoader = new GenericLoader<Skill>(Skill.class);
    private SpellLoader spellLoader = new SpellLoader();
    private StatsAndChecksLoader statCheckLoader = new StatsAndChecksLoader();
    private StringBuffer licensesToDisplayString = new StringBuffer();
    private StringBuffer matureCampaigns = new StringBuffer();
    private TraitLoader traitLoader = new TraitLoader();
    private GenericLoader<WeaponProf> wProfLoader = new GenericLoader<WeaponProf>(WeaponProf.class);
    private GenericLoader<ArmorProf> aProfLoader = new GenericLoader<ArmorProf>(ArmorProf.class);
    private GenericLoader<ShieldProf> sProfLoader = new GenericLoader<ShieldProf>(ShieldProf.class);
    private boolean customItemsLoaded = false;
    private boolean showD20 = false;
    private boolean showLicensed = true;
    private boolean showMature = false;
    private boolean showOGL = false;

    public LstSystemLoader() {
        this.abilityCategoryLoader.addObserver(this);
        this.bioLoader.addObserver(this);
        this.campaignLoader.addObserver(this);
        this.companionModLoader.addObserver(this);
        this.deityLoader.addObserver(this);
        this.domainLoader.addObserver(this);
        this.equipmentLoader.addObserver(this);
        this.eqModLoader.addObserver(this);
        this.eqSlotLoader.addObserver(this);
        this.abilityLoader.addObserver(this);
        this.featLoader.addObserver(this);
        this.kitLoader.addObserver(this);
        this.languageLoader.addObserver(this);
        this.locationLoader.addObserver(this);
        this.classLoader.addObserver(this);
        this.paperLoader.addObserver(this);
        this.pointBuyLoader.addObserver(this);
        this.sponsorLoader.addObserver(this);
        this.raceLoader.addObserver(this);
        this.sizeLoader.addObserver(this);
        this.skillLoader.addObserver(this);
        this.spellLoader.addObserver(this);
        this.statCheckLoader.addObserver(this);
        this.templateLoader.addObserver(this);
        this.traitLoader.addObserver(this);
        this.wProfLoader.addObserver(this);
        this.aProfLoader.addObserver(this);
        this.sProfLoader.addObserver(this);
        try {
            this.globalCampaign = new CampaignSourceEntry(new Campaign(), new URI("file:/System%20Configuration%20Document"));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new UnreachableError(uRISyntaxException);
        }
    }

    @Override
    public void setChosenCampaignSourcefiles(List<URI> list, GameMode gameMode) {
        List<URI> list2 = this.chosenCampaignSourcefiles.get(gameMode.getName());
        if (list2 == null) {
            list2 = new ArrayList<URI>();
            this.chosenCampaignSourcefiles.put(gameMode.getName(), list2);
        }
        list2.clear();
        list2.addAll(list);
        SettingsHandler.getOptions().setProperty("pcgen.files.chosenCampaignSourcefiles." + gameMode.getName(), StringUtil.join(list2, ", "));
    }

    @Override
    public List<URI> getChosenCampaignSourcefiles(GameMode gameMode) {
        List<URI> list = this.chosenCampaignSourcefiles.get(gameMode.getName());
        if (list == null) {
            list = new ArrayList<URI>();
            this.chosenCampaignSourcefiles.put(gameMode.getName(), list);
        }
        return list;
    }

    public void setCustomItemsLoaded(boolean bl) {
        this.customItemsLoaded = bl;
    }

    @Override
    public boolean isCustomItemsLoaded() {
        return this.customItemsLoaded;
    }

    @Override
    public Set<String> getSources() {
        return this.sourcesSet;
    }

    @Override
    public void emptyLists() {
        this.loadedFiles.clear();
        this.licensesToDisplayString = new StringBuffer();
        this.matureCampaigns = new StringBuffer();
        this.releaseFileData();
        this.customItemsLoaded = false;
    }

    @Override
    public void initialize() throws PersistenceLayerException {
        this.loadGameModes();
        this.loadSponsorsLstFile();
        this.loadPCCFilesInDirectory(SettingsHandler.getPccFilesLocation().getAbsolutePath());
        this.loadPCCFilesInDirectory(SettingsHandler.getPcgenVendorDataDir().getAbsolutePath());
        this.initRecursivePccFiles();
        Globals.sortPObjectListByName(Globals.getCampaignList());
    }

    private void loadSponsorsLstFile() {
        File file = new File(SettingsHandler.getPcgenSystemDir(), "sponsors");
        File file2 = new File(file, "sponsors.lst");
        try {
            this.sponsorLoader.loadLstFile(null, file2.toURI(), null);
        }
        catch (PersistenceLayerException persistenceLayerException) {
            Logging.errorPrint("Warning: sponsors file is missing");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadCampaigns(List<Campaign> list) throws PersistenceLayerException {
        this.sourcesSet.clear();
        this.licenseFiles.clear();
        if (list.size() == 0) {
            throw new PersistenceLayerException("You must select at least one campaign to load.");
        }
        try {
            LoadContext loadContext = Globals.getContext();
            this.loadCampaigns(list, loadContext);
            this.loadCustomItems();
            this.verifyWeaponsMeleeOrRanged();
            if (!SettingsHandler.wantToLoadMasterworkAndMagic()) {
                EquipmentList.autoGenerateEquipment();
            }
            for (Campaign campaign : list) {
                this.sourcesSet.add(SourceFormat.getFormattedString(campaign, SourceFormat.MEDIUM, true));
            }
            loadContext.setLoaded(list);
            this.showLicensesIfNeeded();
            this.showSponsorsIfNeeded();
        }
        catch (Throwable throwable) {
            Logging.errorPrint("Exception loading files.", throwable);
        }
        finally {
            this.releaseFileData();
            this.setChanged();
            this.notifyObservers("DONE");
        }
    }

    public void loadCampaigns(List<Campaign> list, LoadContext loadContext) throws PersistenceLayerException {
        GameMode gameMode = SettingsHandler.getGame();
        if (gameMode == null) {
            return;
        }
        File file = new File(SettingsHandler.getPcgenSystemDir(), "gameModes");
        File file2 = new File(file, gameMode.getFolderName());
        File file3 = new File(file2, "statsandchecks.lst");
        this.statCheckLoader.loadLstFile(loadContext, file3.toURI());
        this.sortCampaignsByRank(list);
        Collection<Campaign> collection = this.readPccFiles(loadContext, list, null, gameMode);
        this.addCustomFilesToStartOfList();
        this.setChanged();
        this.notifyObservers(this.countTotalFilesToLoad());
        this.abilityCategoryLoader.loadLstFiles(loadContext, this.abilityCategoryFileList);
        this.validateAbilityCategories(gameMode);
        for (PCAlignment pObject : gameMode.getUnmodifiableAlignmentList()) {
            loadContext.ref.registerAbbreviation(pObject, pObject.getKeyName());
        }
        for (PCStat pCStat : gameMode.getUnmodifiableStatList()) {
            loadContext.ref.registerAbbreviation(pCStat, pCStat.getAbb());
        }
        for (SizeAdjustment sizeAdjustment : gameMode.getUnmodifiableSizeAdjustmentList()) {
            loadContext.ref.registerAbbreviation(sizeAdjustment, sizeAdjustment.getAbbreviation());
        }
        for (Campaign campaign : collection) {
            campaign.applyTo(loadContext.ref);
        }
        this.wProfLoader.loadLstFiles(loadContext, this.weaponProfFileList);
        this.aProfLoader.loadLstFiles(loadContext, this.armorProfFileList);
        this.sProfLoader.loadLstFiles(loadContext, this.shieldProfFileList);
        this.skillLoader.loadLstFiles(loadContext, this.skillFileList);
        this.languageLoader.loadLstFiles(loadContext, this.languageFileList);
        this.featLoader.loadLstFiles(loadContext, this.featFileList);
        this.abilityLoader.loadLstFiles(loadContext, this.abilityFileList);
        this.raceLoader.loadLstFiles(loadContext, this.raceFileList);
        this.domainLoader.loadLstFiles(loadContext, this.domainFileList);
        this.spellLoader.loadLstFiles(loadContext, this.spellFileList);
        this.deityLoader.loadLstFiles(loadContext, this.deityFileList);
        this.classLoader.loadLstFiles(loadContext, this.classFileList);
        this.templateLoader.loadLstFiles(loadContext, this.templateFileList);
        this.eqModLoader.loadLstFiles(loadContext, this.equipmodFileList);
        this.equipmentLoader.loadLstFiles(loadContext, this.equipmentFileList);
        this.companionModLoader.loadLstFiles(loadContext, this.companionmodFileList);
        this.kitLoader.loadLstFiles(loadContext, this.kitFileList);
        this.bioLoader.setGameMode(gameMode.getName());
        this.bioLoader.loadLstFiles(loadContext, this.bioSetFileList);
        this.checkRequiredDeities(file2, loadContext);
        this.addDefaultEquipmentMods(loadContext);
        this.classLoader.loadSubLines(loadContext);
        System.gc();
        loadContext.resolveDeferredTokens();
        loadContext.ref.buildDeferredObjects();
        loadContext.ref.buildDerivedObjects();
        loadContext.ref.validate(new UnconstructedValidator(list));
        loadContext.resolveReferences();
        for (Equipment equipment : loadContext.ref.getConstructedCDOMObjects(Equipment.class)) {
            EqModAttachment.finishEquipment(equipment);
        }
        loadContext.buildTypeLists();
    }

    private void addDefaultEquipmentMods(LoadContext loadContext) throws PersistenceLayerException {
        URI uRI;
        try {
            uRI = new URI("file:/" + this.eqModLoader.getClass().getName() + ".java");
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new UnreachableError(uRISyntaxException);
        }
        loadContext.setSourceURI(uRI);
        CampaignSourceEntry campaignSourceEntry = new CampaignSourceEntry(new Campaign(), uRI);
        String string = "Add Type\tKEY:ADDTYPE\tTYPE:ALL\tCOST:0\tNAMEOPT:NONAME\tSOURCELONG:PCGen Internal\tCHOOSE:EQBUILDER.EQTYPE|COUNT=ALL|TITLE=desired TYPE(s)";
        this.eqModLoader.parseLine(loadContext, null, string, campaignSourceEntry);
        string = "PCGENi_WEAPON\tTYPE:Weapon\tVISIBLE:NO\tCHOOSE:NOCHOICE\tNAMEOPT:NONAME";
        this.eqModLoader.parseLine(loadContext, null, string, campaignSourceEntry);
        string = "PCGENi_ARMOR\tTYPE:Armor\tVISIBLE:NO\tCHOOSE:NOCHOICE\tNAMEOPT:NONAME";
        this.eqModLoader.parseLine(loadContext, null, string, campaignSourceEntry);
    }

    private void validateAbilityCategories(GameMode gameMode) {
        for (AbilityCategory abilityCategory : gameMode.getAllAbilityCategories()) {
            if (!abilityCategory.getAbilityTypes().isEmpty() || !abilityCategory.getAbilityKeys().isEmpty() || abilityCategory.isAllAbilityTypes() || abilityCategory.getAbilityCategory().equalsIgnoreCase(abilityCategory.getKeyName())) continue;
            Logging.log(Logging.LST_ERROR, "Ability Category " + abilityCategory.getKeyName() + " had no TYPE or ABILITYLIST, but has a different CATEGORY");
        }
    }

    private int countTotalFilesToLoad() {
        int n = this.bioSetFileList.size();
        n += this.abilityCategoryFileList.size();
        n += this.classFileList.size();
        n += this.companionmodFileList.size();
        n += this.deityFileList.size();
        n += this.domainFileList.size();
        n += this.equipmentFileList.size();
        n += this.equipmodFileList.size();
        n += this.abilityFileList.size();
        n += this.featFileList.size();
        n += this.kitFileList.size();
        n += this.languageFileList.size();
        n += this.raceFileList.size();
        n += this.skillFileList.size();
        n += this.spellFileList.size();
        n += this.templateFileList.size();
        n += this.weaponProfFileList.size();
        n += this.armorProfFileList.size();
        return n += this.shieldProfFileList.size();
    }

    @Override
    public void loadModItems(boolean bl) {
    }

    @Override
    public void refreshCampaigns() {
        Globals.clearCampaignsForRefresh();
        this.loadPCCFilesInDirectory(SettingsHandler.getPccFilesLocation().getAbsolutePath());
        this.loadPCCFilesInDirectory(SettingsHandler.getPcgenVendorDataDir().getAbsolutePath());
        try {
            this.campaignLoader.initRecursivePccFiles();
        }
        catch (PersistenceLayerException persistenceLayerException) {
            Logging.errorPrint("Failed to refresh campaigns", persistenceLayerException);
        }
        Globals.sortPObjectListByName(Globals.getCampaignList());
    }

    private static void setCampaignOptions(Campaign campaign) {
        Set<String> set = campaign.getKeysFor(MapKey.PROPERTY);
        if (set != null) {
            for (String string : set) {
                String string2 = campaign.get(MapKey.PROPERTY, string);
                SettingsHandler.setPCGenOption(string, string2);
            }
        }
    }

    private static String[] getGameFilesList() {
        String string = SettingsHandler.getPcgenSystemDir() + File.separator + "gameModes" + File.separator;
        return new File(string).list(gameModeFileFilter);
    }

    private void addCustomFilesToStartOfList() {
        File file;
        File file2;
        File file3;
        File file4;
        File file5;
        File file6;
        File file7;
        File file8;
        File file9;
        File file10;
        CampaignSourceEntry campaignSourceEntry = null;
        Campaign campaign = new Campaign();
        campaign.setName("Custom");
        campaign.addToListFor(ListKey.DESCRIPTION, new Description("Custom data"));
        File file11 = new File(CustomData.customBioSetFilePath(true));
        if (file11.exists()) {
            campaignSourceEntry = new CampaignSourceEntry(campaign, file11.toURI());
            this.bioSetFileList.remove(campaignSourceEntry);
            this.bioSetFileList.add(0, campaignSourceEntry);
        }
        if ((file10 = new File(CustomData.customClassFilePath(true))).exists()) {
            campaignSourceEntry = new CampaignSourceEntry(campaign, file10.toURI());
            this.classFileList.remove(campaignSourceEntry);
            this.classFileList.add(0, campaignSourceEntry);
        }
        if ((file9 = new File(CustomData.customDeityFilePath(true))).exists()) {
            campaignSourceEntry = new CampaignSourceEntry(campaign, file9.toURI());
            this.deityFileList.remove(campaignSourceEntry);
            this.deityFileList.add(0, campaignSourceEntry);
        }
        if ((file8 = new File(CustomData.customDomainFilePath(true))).exists()) {
            campaignSourceEntry = new CampaignSourceEntry(campaign, file8.toURI());
            this.domainFileList.remove(campaignSourceEntry);
            this.domainFileList.add(0, campaignSourceEntry);
        }
        if ((file7 = new File(CustomData.customAbilityFilePath(true))).exists()) {
            campaignSourceEntry = new CampaignSourceEntry(campaign, file7.toURI());
            this.abilityFileList.remove(campaignSourceEntry);
            this.abilityFileList.add(0, campaignSourceEntry);
        }
        if ((file6 = new File(CustomData.customFeatFilePath(true))).exists()) {
            campaignSourceEntry = new CampaignSourceEntry(campaign, file6.toURI());
            this.featFileList.remove(campaignSourceEntry);
            this.featFileList.add(0, campaignSourceEntry);
        }
        if ((file5 = new File(CustomData.customLanguageFilePath(true))).exists()) {
            campaignSourceEntry = new CampaignSourceEntry(campaign, file5.toURI());
            this.languageFileList.remove(campaignSourceEntry);
            this.languageFileList.add(0, campaignSourceEntry);
        }
        if ((file4 = new File(CustomData.customRaceFilePath(true))).exists()) {
            campaignSourceEntry = new CampaignSourceEntry(campaign, file4.toURI());
            this.raceFileList.remove(campaignSourceEntry);
            this.raceFileList.add(0, campaignSourceEntry);
        }
        if ((file3 = new File(CustomData.customSkillFilePath(true))).exists()) {
            campaignSourceEntry = new CampaignSourceEntry(campaign, file3.toURI());
            this.skillFileList.remove(campaignSourceEntry);
            this.skillFileList.add(0, campaignSourceEntry);
        }
        if ((file2 = new File(CustomData.customSpellFilePath(true))).exists()) {
            campaignSourceEntry = new CampaignSourceEntry(campaign, file2.toURI());
            this.spellFileList.remove(campaignSourceEntry);
            this.spellFileList.add(0, campaignSourceEntry);
        }
        if ((file = new File(CustomData.customTemplateFilePath(true))).exists()) {
            campaignSourceEntry = new CampaignSourceEntry(campaign, file.toURI());
            this.templateFileList.remove(campaignSourceEntry);
            this.templateFileList.add(0, campaignSourceEntry);
        }
    }

    private void checkRequiredDeities(File file, LoadContext loadContext) throws PersistenceLayerException {
        loadContext.setSourceURI(new File(file, "miscinfo.lst").toURI());
        List<String> list = Globals.getGlobalDeityList();
        if (list != null && list.size() != 0) {
            for (String string : list) {
                this.deityLoader.parseLine(loadContext, null, string, this.globalCampaign);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCustomItems() {
        this.customItemsLoaded = true;
        if (!SettingsHandler.getSaveCustomEquipment()) {
            return;
        }
        BufferedReader bufferedReader = CustomData.getCustomEquipmentReader();
        EquipmentList.setAutoGeneration(true);
        try {
            while (bufferedReader != null) {
                int n;
                String string = bufferedReader.readLine();
                if (string == null) {
                    break;
                }
                if (!string.startsWith("BASEITEM:") || (n = string.indexOf(9, 9)) < 10) continue;
                String string2 = string.substring(9, n);
                string = string.substring(n + 1);
                Equipment equipment = Globals.getContext().ref.silentlyGetConstructedCDOMObject(Equipment.class, string2);
                if (equipment == null) continue;
                equipment = equipment.clone();
                equipment.load(string);
                if (!equipment.isType("Custom")) {
                    equipment.addType(Type.CUSTOM);
                }
                Globals.getContext().ref.importObject(equipment);
            }
        }
        catch (IOException iOException) {
            this.logError("Error when loading custom items", iOException);
        }
        finally {
            EquipmentList.setAutoGeneration(false);
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                this.logError("Error when closing infile after loading custom items", iOException);
            }
        }
    }

    private static void loadGameModeInfoFile(GameMode gameMode, URI uRI, String string) {
        String string2;
        try {
            string2 = LstFileLoader.readFromURI(uRI).toString();
        }
        catch (PersistenceLayerException persistenceLayerException) {
            Logging.errorPrint(PropertyFactory.getFormattedString("Errors.LstSystemLoader.loadGameModeInfoFile", uRI, persistenceLayerException.getMessage()));
            return;
        }
        String[] stringArray = string2.split("(\r|\n)");
        String string3 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            if (string4.length() > 0 && string4.charAt(0) == '#' || string4.length() == 0) continue;
            if (string.equals("load")) {
                gameMode.addLoadString(string4);
                continue;
            }
            if (string.equals("level")) {
                string3 = LevelLoader.parseLine(gameMode, string4, i + 1, uRI, string3);
                continue;
            }
            if (!string.equals("rules")) continue;
            RuleCheckLoader.parseLine(gameMode, string4, uRI);
        }
    }

    private static GameMode loadGameModeMiscInfo(String string, URI uRI) {
        Object object;
        String string2;
        GameMode gameMode = null;
        try {
            string2 = LstFileLoader.readFromURI(uRI).toString();
        }
        catch (PersistenceLayerException persistenceLayerException) {
            Logging.errorPrint(PropertyFactory.getFormattedString("Errors.LstSystemLoader.loadGameModeInfoFile", uRI, persistenceLayerException.getMessage()));
            return gameMode;
        }
        String[] stringArray = string2.split("(\r|\n)");
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            if (((String)object).length() > 0 && ((String)object).charAt(0) == '#' || ((String)object).length() == 0) continue;
            if (gameMode == null) {
                gameMode = new GameMode(string);
                SystemCollections.addToGameModeList(gameMode);
            }
            GameModeLoader.parseMiscGameInfoLine(gameMode, (String)object, uRI, i + 1);
        }
        int[] nArray = gameMode.getDieSizes();
        if (nArray == null || nArray.length == 0) {
            object = new int[]{1, 2, 3, 4, 6, 8, 10, 12, 20, 100, 1000};
            gameMode.setDieSizes((int[])object);
            Logging.log(Logging.LST_ERROR, "GameMode (" + gameMode.getName() + ") : MiscInfo.lst did not contain any valid DIESIZES. " + "Using the system default DIESIZES.");
        }
        return gameMode;
    }

    public void loadPCCFilesInDirectory(String string) {
        new File(string).list(this.pccFileFilter);
    }

    public void loadPCCFilesInDirectory(File file) {
        file.list(this.pccFileFilter);
    }

    private void loadGameModeLstFile(LoadContext loadContext, LstLineFileLoader lstLineFileLoader, String string, String string2, String string3) {
        this.loadGameModeLstFile(loadContext, lstLineFileLoader, string, string2, string3, true);
    }

    private boolean loadGameModeLstFile(LoadContext loadContext, LstLineFileLoader lstLineFileLoader, String string, String string2, String string3, boolean bl) {
        block6: {
            File file;
            File file2;
            File file3 = new File(SettingsHandler.getPcgenSystemDir(), "gameModes");
            try {
                file2 = new File(file3, string2);
                file = new File(file2, string3);
                if (file.exists()) {
                    lstLineFileLoader.loadLstFile(loadContext, file.toURI(), string);
                    return true;
                }
            }
            catch (PersistenceLayerException persistenceLayerException) {
                // empty catch block
            }
            try {
                file2 = new File(file3, "default");
                file = new File(file2, string3);
                if (file.exists()) {
                    lstLineFileLoader.loadLstFile(loadContext, file.toURI(), string);
                    return true;
                }
            }
            catch (PersistenceLayerException persistenceLayerException) {
                if (!bl) break block6;
                Logging.errorPrint("Warning: game mode " + string + " is missing file " + string3);
            }
        }
        return false;
    }

    public void loadGameModes() {
        String[] stringArray = LstSystemLoader.getGameFilesList();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        SystemCollections.clearGameModeList();
        File file = new File(SettingsHandler.getPcgenSystemDir(), "gameModes");
        for (String string : stringArray) {
            SystemCollections.setEmptyUnitSetList(string);
            File file2 = new File(file, string);
            File file3 = new File(file2, "miscinfo.lst");
            GameMode gameMode = LstSystemLoader.loadGameModeMiscInfo(string, file3.toURI());
            String string2 = gameMode.getName();
            SettingsHandler.setGame(string2);
            if (gameMode == null) continue;
            LoadContext loadContext = gameMode.getContext();
            LstSystemLoader.loadGameModeInfoFile(gameMode, new File(file2, "level.lst").toURI(), "level");
            LstSystemLoader.loadGameModeInfoFile(gameMode, new File(file2, "rules.lst").toURI(), "rules");
            this.loadGameModeLstFile(loadContext, this.eqSlotLoader, string2, string, "equipmentslots.lst");
            this.loadGameModeLstFile(loadContext, this.paperLoader, string2, string, "paperInfo.lst");
            this.loadGameModeLstFile(loadContext, this.traitLoader, string2, string, "bio" + File.separator + "traits.lst");
            this.loadGameModeLstFile(loadContext, this.locationLoader, string2, string, "bio" + File.separator + "locations.lst");
            this.loadGameModeLstFile(loadContext, this.bioLoader, string2, string, "bio" + File.separator + "biosettings.lst");
            this.loadGameModeLstFile(loadContext, this.loadInfoLoader, string2, string, "load.lst");
            this.loadGameModeLstFile(loadContext, this.unitSetLoader, string2, string, "unitset.lst", false);
            this.loadPointBuyFile(loadContext, string, string2);
            this.loadGameModeLstFile(loadContext, this.sizeLoader, string2, string, "sizeAdjustment.lst");
            this.loadGameModeLstFile(loadContext, this.statCheckLoader, string2, string, "statsandchecks.lst");
        }
        SystemCollections.sortGameModeList();
    }

    private void loadPointBuyFile(LoadContext loadContext, String string, String string2) {
        File file = new File(CustomData.customPurchaseModeFilePath(true, string2));
        boolean bl = true;
        if (file.exists()) {
            try {
                this.pointBuyLoader.loadLstFile(loadContext, file.toURI(), string2);
                bl = false;
            }
            catch (PersistenceLayerException persistenceLayerException) {
                // empty catch block
            }
        }
        if (bl && !this.loadGameModeLstFile(loadContext, this.pointBuyLoader, string2, string, "pointbuymethods.lst", false)) {
            this.loadGameModeLstFile(loadContext, this.pointBuyLoader, string2, string, "pointbuymethods_system.lst", false);
        }
    }

    private Collection<Campaign> readPccFiles(LoadContext loadContext, List<Campaign> list, PlayerCharacter playerCharacter, GameMode gameMode) {
        if (SettingsHandler.isOptionAllowedInSources()) {
            SettingsHandler.setOptionsProperties(playerCharacter);
        }
        HashSet<Campaign> hashSet = new HashSet<Campaign>();
        for (Campaign campaign : list) {
            campaign.setIsLoaded(true);
            URI uRI = campaign.getSourceURI();
            List<URI> list2 = this.getChosenCampaignSourcefiles(gameMode);
            if (!list2.contains(uRI)) {
                list2.add(uRI);
                SettingsHandler.getOptions().setProperty("pcgen.files.chosenCampaignSourcefiles." + gameMode.getName(), StringUtil.join(list2, ", "));
            }
            this.showOGL |= campaign.getSafe(ObjectKey.IS_OGL).booleanValue();
            this.showD20 |= campaign.getSafe(ObjectKey.IS_D20).booleanValue();
            this.showLicensed |= campaign.getSafe(ObjectKey.IS_LICENSED).booleanValue();
            if (campaign.getSafe(ObjectKey.IS_LICENSED).booleanValue()) {
                List<CampaignSourceEntry> list3;
                List<String> list32 = campaign.getSafeListFor(ListKey.LICENSE);
                if (list32 != null && list32.size() > 0) {
                    this.licensesToDisplayString.append(list32);
                }
                if ((list3 = campaign.getSafeListFor(ListKey.LICENSE_FILE)) != null) {
                    this.licenseFiles.addAll(list3);
                }
            }
            this.showMature |= campaign.getSafe(ObjectKey.IS_MATURE).booleanValue();
            if (campaign.getSafe(ObjectKey.IS_MATURE).booleanValue()) {
                this.matureCampaigns.append(SourceFormat.LONG.getField(campaign) + " (" + campaign.getSafe(StringKey.PUB_NAME_LONG) + ")<br>");
            }
            this.lstExcludeFiles.addAll(campaign.getSafeListFor(ListKey.FILE_LST_EXCLUDE));
            this.raceFileList.addAll(campaign.getSafeListFor(ListKey.FILE_RACE));
            this.classFileList.addAll(campaign.getSafeListFor(ListKey.FILE_CLASS));
            this.companionmodFileList.addAll(campaign.getSafeListFor(ListKey.FILE_COMPANION_MOD));
            this.skillFileList.addAll(campaign.getSafeListFor(ListKey.FILE_SKILL));
            this.abilityCategoryFileList.addAll(campaign.getSafeListFor(ListKey.FILE_ABILITY_CATEGORY));
            this.abilityFileList.addAll(campaign.getSafeListFor(ListKey.FILE_ABILITY));
            this.featFileList.addAll(campaign.getSafeListFor(ListKey.FILE_FEAT));
            this.deityFileList.addAll(campaign.getSafeListFor(ListKey.FILE_DEITY));
            this.domainFileList.addAll(campaign.getSafeListFor(ListKey.FILE_DOMAIN));
            this.weaponProfFileList.addAll(campaign.getSafeListFor(ListKey.FILE_WEAPON_PROF));
            this.armorProfFileList.addAll(campaign.getSafeListFor(ListKey.FILE_ARMOR_PROF));
            this.shieldProfFileList.addAll(campaign.getSafeListFor(ListKey.FILE_SHIELD_PROF));
            this.equipmentFileList.addAll(campaign.getSafeListFor(ListKey.FILE_EQUIP));
            this.spellFileList.addAll(campaign.getSafeListFor(ListKey.FILE_SPELL));
            this.languageFileList.addAll(campaign.getSafeListFor(ListKey.FILE_LANGUAGE));
            this.templateFileList.addAll(campaign.getSafeListFor(ListKey.FILE_TEMPLATE));
            this.equipmodFileList.addAll(campaign.getSafeListFor(ListKey.FILE_EQUIP_MOD));
            this.kitFileList.addAll(campaign.getSafeListFor(ListKey.FILE_KIT));
            this.bioSetFileList.addAll(campaign.getSafeListFor(ListKey.FILE_BIO_SET));
            hashSet.add(campaign);
            if (SettingsHandler.isOptionAllowedInSources()) {
                LstSystemLoader.setCampaignOptions(campaign);
            }
            for (CampaignSourceEntry campaignSourceEntry : campaign.getSafeListFor(ListKey.FILE_PCC)) {
                Campaign campaign2;
                URI uRI2 = campaignSourceEntry.getURI();
                if (!PCGFile.isPCGenCampaignFile(uRI2) || !hashSet.add(campaign2 = Globals.getCampaignByURI(uRI2, false))) continue;
                campaign2.applyTo(loadContext.ref);
            }
        }
        this.stripLstExcludes();
        if (SettingsHandler.isOptionAllowedInSources()) {
            SettingsHandler.getOptionsFromProperties(playerCharacter);
        }
        return hashSet;
    }

    private void stripLstExcludes() {
        this.stripLstExcludes(this.raceFileList);
        this.stripLstExcludes(this.classFileList);
        this.stripLstExcludes(this.companionmodFileList);
        this.stripLstExcludes(this.skillFileList);
        this.stripLstExcludes(this.abilityCategoryFileList);
        this.stripLstExcludes(this.abilityFileList);
        this.stripLstExcludes(this.featFileList);
        this.stripLstExcludes(this.deityFileList);
        this.stripLstExcludes(this.domainFileList);
        this.stripLstExcludes(this.weaponProfFileList);
        this.stripLstExcludes(this.armorProfFileList);
        this.stripLstExcludes(this.shieldProfFileList);
        this.stripLstExcludes(this.equipmentFileList);
        this.stripLstExcludes(this.spellFileList);
        this.stripLstExcludes(this.languageFileList);
        this.stripLstExcludes(this.templateFileList);
        this.stripLstExcludes(this.equipmodFileList);
        this.stripLstExcludes(this.kitFileList);
        this.stripLstExcludes(this.bioSetFileList);
    }

    private void stripLstExcludes(List<CampaignSourceEntry> list) {
        for (CampaignSourceEntry campaignSourceEntry : this.lstExcludeFiles) {
            URI uRI = campaignSourceEntry.getURI();
            Iterator<CampaignSourceEntry> iterator = list.iterator();
            while (iterator.hasNext()) {
                CampaignSourceEntry campaignSourceEntry2 = iterator.next();
                if (!campaignSourceEntry2.getURI().equals(uRI)) continue;
                iterator.remove();
            }
        }
    }

    private void releaseFileData() {
        this.lstExcludeFiles.clear();
        this.raceFileList.clear();
        this.classFileList.clear();
        this.companionmodFileList.clear();
        this.skillFileList.clear();
        this.abilityCategoryFileList.clear();
        this.abilityFileList.clear();
        this.featFileList.clear();
        this.deityFileList.clear();
        this.domainFileList.clear();
        this.templateFileList.clear();
        this.weaponProfFileList.clear();
        this.armorProfFileList.clear();
        this.shieldProfFileList.clear();
        this.equipmentFileList.clear();
        this.spellFileList.clear();
        this.languageFileList.clear();
        this.equipmodFileList.clear();
        this.kitFileList.clear();
        this.bioSetFileList.clear();
    }

    private void showLicensesIfNeeded() {
        if (Globals.getUseGUI()) {
            String string;
            if (this.showOGL && SettingsHandler.showLicense()) {
                pcGenGUI.showLicense();
            }
            if (this.showLicensed && SettingsHandler.showLicense()) {
                string = this.licensesToDisplayString.toString();
                if (string.trim().length() > 0) {
                    pcGenGUI.showLicense("Special Licenses", string);
                }
                pcGenGUI.showLicense("Special Licenses", this.licenseFiles);
            }
            if (this.showD20 && SettingsHandler.showD20Info()) {
                pcGenGUI.showMandatoryD20Info();
            }
            if (this.showMature && SettingsHandler.showMature() && (string = this.matureCampaigns.toString()).trim().length() > 0) {
                pcGenGUI.showMature(string);
            }
        }
        Globals.getSection15().setLength(0);
        this.showOGL = false;
        this.showD20 = false;
        this.showLicensed = false;
    }

    private void showSponsorsIfNeeded() {
        if (Globals.getUseGUI() && SettingsHandler.showSponsors()) {
            pcGenGUI.showSponsors();
        }
    }

    private void sortCampaignsByRank(List<Campaign> list) {
        Collections.sort(list, new Comparator<Campaign>(){

            @Override
            public int compare(Campaign campaign, Campaign campaign2) {
                return campaign.getSafe(IntegerKey.CAMPAIGN_RANK) - campaign2.getSafe(IntegerKey.CAMPAIGN_RANK);
            }
        });
    }

    private void verifyWeaponsMeleeOrRanged() throws PersistenceLayerException {
        for (Equipment equipment : Globals.getContext().ref.getConstructedCDOMObjects(Equipment.class)) {
            if (!equipment.isWeapon() || equipment.isMelee() || equipment.isRanged()) continue;
            throw new PersistenceLayerException("Weapon: " + equipment.getName() + " is neither Melee nor Ranged." + Constants.s_LINE_SEP + "PCGen" + " cannot calculate \"to hit\" unless one of these is selected." + Constants.s_LINE_SEP + "Source: " + equipment.getSourceURI());
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        this.setChanged();
        this.notifyObservers(object);
    }

    public void logError(String string, Throwable throwable) {
        Logging.errorPrint(string, throwable);
        this.setChanged();
    }

    public void initRecursivePccFiles() throws PersistenceLayerException {
        this.campaignLoader.initRecursivePccFiles();
    }
}

