/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.SubClass;
import pcgen.core.SubstitutionClass;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.LstObjectFileLoader;
import pcgen.persistence.lst.utils.DeferredLine;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PCClassLoader
extends LstObjectFileLoader<PCClass> {
    @Override
    public PCClass parseLine(LoadContext loadContext, PCClass pCClass, String string, CampaignSourceEntry campaignSourceEntry) throws PersistenceLayerException {
        if (string.startsWith("SUBCLASS:") || string.startsWith("SUBCLASSLEVEL:")) {
            if (pCClass == null) {
                Logging.errorPrint("Ignoring line: " + string + " as SUBCLASS* type line appeared before CLASS: line");
                return null;
            }
            SubClass subClass = null;
            if (string.startsWith("SUBCLASS:")) {
                int n = string.indexOf("\t");
                if (n == -1) {
                    Logging.errorPrint("Expected SUBCLASS to have additional Tags in " + campaignSourceEntry.getURI() + " (e.g. COST is a required Tag in a SUBCLASS)");
                }
                String string2 = string.substring(9, n);
                String string3 = string.substring(n);
                subClass = pCClass.getSubClassKeyed(string2);
                if (subClass == null) {
                    subClass = new SubClass();
                    subClass.setName(string2);
                    subClass.setSourceCampaign(campaignSourceEntry.getCampaign());
                    subClass.setSourceURI(campaignSourceEntry.getURI());
                    pCClass.addSubClass(subClass);
                }
                this.parseLineIntoClass(loadContext, subClass, campaignSourceEntry, string3);
            } else {
                List<SubClass> list = pCClass.getListFor(ListKey.SUB_CLASS);
                if (list != null) {
                    subClass = list.get(list.size() - 1);
                    subClass.addToListFor(ListKey.SUB_CLASS_LEVEL, new DeferredLine(campaignSourceEntry, string.substring(14)));
                }
            }
            return pCClass;
        }
        if (string.startsWith("SUBSTITUTIONCLASS:") || string.startsWith("SUBSTITUTIONLEVEL:")) {
            if (pCClass == null) {
                Logging.errorPrint("Ignoring line: " + string + " as SUBSTITUTIONCLASS* type line appeared before CLASS: line");
                return null;
            }
            SubstitutionClass substitutionClass = null;
            if (string.startsWith("SUBSTITUTIONCLASS:")) {
                String string4;
                String string5;
                int n = string.indexOf("\t");
                if (n > 0) {
                    string5 = string.substring(18, n);
                    string4 = string.substring(n);
                } else {
                    string5 = string.substring(18);
                    string4 = null;
                }
                substitutionClass = pCClass.getSubstitutionClassKeyed(string5);
                if (substitutionClass == null) {
                    substitutionClass = new SubstitutionClass();
                    substitutionClass.setName(string5);
                    substitutionClass.setSourceCampaign(campaignSourceEntry.getCampaign());
                    substitutionClass.setSourceURI(campaignSourceEntry.getURI());
                    pCClass.addSubstitutionClass(substitutionClass);
                }
                this.parseLineIntoClass(loadContext, substitutionClass, campaignSourceEntry, string4);
            } else {
                List<SubstitutionClass> list = pCClass.getListFor(ListKey.SUBSTITUTION_CLASS);
                if (list != null && !list.isEmpty() && string.length() > 18) {
                    substitutionClass = list.get(list.size() - 1);
                    substitutionClass.addToListFor(ListKey.SUB_CLASS_LEVEL, new DeferredLine(campaignSourceEntry, string.substring(18)));
                }
            }
            return pCClass;
        }
        return this.parseClassLine(loadContext, string, campaignSourceEntry, pCClass);
    }

    private PCClass parseClassLine(LoadContext loadContext, String string, CampaignSourceEntry campaignSourceEntry, PCClass pCClass) throws PersistenceLayerException {
        String string2;
        String string3;
        int n = string.indexOf("\t");
        if (n == -1) {
            string3 = string;
            string2 = null;
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        }
        if (string3.startsWith("CLASS:")) {
            String string4 = string3.substring(6);
            if (pCClass == null || !string4.equals(pCClass.getKeyName()) && string4.indexOf(".MOD") < 0) {
                if (pCClass != null) {
                    this.completeObject(loadContext, campaignSourceEntry, pCClass);
                }
                pCClass = new PCClass();
                pCClass.setName(string4);
                pCClass.setSourceURI(campaignSourceEntry.getURI());
                pCClass.setSourceCampaign(campaignSourceEntry.getCampaign());
                loadContext.addStatefulInformation(pCClass);
                loadContext.ref.importObject(pCClass);
            } else if (string4.endsWith(".MOD")) {
                pCClass = loadContext.ref.silentlyGetConstructedCDOMObject(PCClass.class, string4.substring(0, string4.length() - 4));
            }
            this.parseLineIntoClass(loadContext, pCClass, campaignSourceEntry, string2);
        } else {
            this.parseFullClassLevelLine(loadContext, campaignSourceEntry, pCClass, string3, string2);
        }
        return pCClass;
    }

    private void parseFullClassLevelLine(LoadContext loadContext, CampaignSourceEntry campaignSourceEntry, PCClass pCClass, String string, String string2) throws PersistenceLayerException {
        try {
            String string3;
            String string4 = null;
            int n = string.indexOf(":REPEATLEVEL:");
            if (n == -1) {
                string3 = string;
            } else {
                string3 = string.substring(0, n);
                string4 = string.substring(n + 13);
            }
            int n2 = Integer.parseInt(string3);
            if (n2 == 0) {
                this.parseLineIntoClass(loadContext, pCClass, campaignSourceEntry, string2);
            } else if (n2 > 0) {
                this.parseClassLevelLine(loadContext, pCClass, n2, campaignSourceEntry, string2);
                if (string4 != null) {
                    this.parseRepeatClassLevel(loadContext, string2, campaignSourceEntry, pCClass, n2, string4);
                }
            } else {
                Logging.errorPrint("Invalid Level Identifier: " + string3 + " for " + pCClass.getDisplayName() + ". Value must be greater than zero");
            }
        }
        catch (NumberFormatException numberFormatException) {
            Logging.errorPrint("Expected a level value, but got '" + string + "' instead (as a level line in " + pCClass.getKeyName() + ") in source " + campaignSourceEntry.getURI());
            Logging.errorPrint("  Rest of line was: " + string2);
        }
    }

    public void parseClassLevelLine(LoadContext loadContext, PCClass pCClass, int n, CampaignSourceEntry campaignSourceEntry, String string) throws PersistenceLayerException {
        if (string == null) {
            return;
        }
        PCClassLevel pCClassLevel = pCClass.getClassLevel(n);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3 = stringTokenizer.nextToken().trim();
            int n2 = string3.indexOf(58);
            if (n2 == -1) {
                Logging.errorPrint("Invalid Token - does not contain a colon: '" + string3 + "' in Class " + pCClass.getDisplayName() + " of " + campaignSourceEntry);
                continue;
            }
            if (n2 == 0) {
                Logging.errorPrint("Invalid Token - starts with a colon: '" + string3 + "' in Class " + pCClass.getDisplayName() + " of " + campaignSourceEntry);
                continue;
            }
            String string4 = string3.substring(0, n2);
            String string5 = string2 = n2 == string3.length() - 1 ? null : string3.substring(n2 + 1);
            if (loadContext.processToken(pCClassLevel, string4, string2)) {
                loadContext.commit();
            } else {
                loadContext.rollback();
                Logging.replayParsedMessages();
            }
            Logging.clearParseMessages();
        }
    }

    public void parseLineIntoClass(LoadContext loadContext, PCClass pCClass, CampaignSourceEntry campaignSourceEntry, String string) throws PersistenceLayerException {
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3 = stringTokenizer.nextToken().trim();
            if (string3.startsWith("CHECK")) {
                Logging.deprecationPrint("Class " + pCClass.getDisplayName() + " has token " + string3 + " which is ignored");
                continue;
            }
            int n = string3.indexOf(58);
            if (n == -1) {
                Logging.errorPrint("Invalid Token - does not contain a colon: '" + string3 + "' in Class " + pCClass.getDisplayName() + " of " + campaignSourceEntry);
                continue;
            }
            if (n == 0) {
                Logging.errorPrint("Invalid Token - starts with a colon: '" + string3 + "' in Class " + pCClass.getDisplayName() + " of " + campaignSourceEntry);
                continue;
            }
            String string4 = string3.substring(0, n);
            String string5 = string2 = n == string3.length() - 1 ? null : string3.substring(n + 1);
            if (loadContext.processToken(pCClass, string4, string2)) {
                loadContext.commit();
            } else {
                loadContext.rollback();
                Logging.replayParsedMessages();
            }
            Logging.clearParseMessages();
        }
    }

    private void parseRepeatClassLevel(LoadContext loadContext, String string, CampaignSourceEntry campaignSourceEntry, PCClass pCClass, int n, String string2) throws PersistenceLayerException {
        String string3;
        int n2;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
        int n3 = stringTokenizer.countTokens();
        int n4 = 1000;
        int n5 = 0;
        int n6 = 100;
        if (pCClass.hasMaxLevel()) {
            n6 = pCClass.getSafe(IntegerKey.LEVEL_LIMIT);
        }
        if (n3 > 0) {
            try {
                n4 = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                Logging.errorPrint("Non-Numeric Level Increment info '" + string2 + "' in " + campaignSourceEntry.getURI(), numberFormatException);
            }
        }
        boolean bl = false;
        if (n3 > 1) {
            n2 = 0;
            string3 = stringTokenizer.nextToken();
            if (string3.startsWith("SKIP=")) {
                string3 = string3.substring(5);
            } else if (string3.startsWith("MAX=")) {
                if (n3 > 2) {
                    Logging.errorPrint("MAX= cannot be followed by another item in REPEATLEVEL.  SKIP= must appear before MAX=");
                }
                String string4 = string3.substring(4);
                try {
                    n6 = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    Logging.errorPrint("Non-Numeric Max Level info MAX='" + n6 + "' in " + campaignSourceEntry.getURI(), numberFormatException);
                }
                n2 = 1;
            } else {
                bl = true;
            }
            if (n2 == 0) {
                try {
                    n5 = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    Logging.errorPrint("Non-Numeric Consecutive Level info '" + string2 + "' in " + campaignSourceEntry.getURI(), numberFormatException);
                }
            }
        }
        if (n3 > 2) {
            String string5 = stringTokenizer.nextToken();
            string3 = !bl && string5.startsWith("MAX=") ? string5.substring(4) : string5;
            try {
                n6 = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                Logging.errorPrint("Non-Numeric Max Level info '" + string2 + "' in " + campaignSourceEntry.getURI(), numberFormatException);
            }
        }
        n2 = n5 - 1;
        for (int i = n + n4; i <= n6; i += n4) {
            if (n5 == 0 || n2 != 0) {
                this.parseClassLevelLine(loadContext, pCClass, i, campaignSourceEntry, string);
            }
            if (n5 == 0) continue;
            if (n2 == 0) {
                n2 = n5;
                continue;
            }
            --n2;
        }
    }

    @Override
    protected PCClass getObjectKeyed(LoadContext loadContext, String string) {
        return loadContext.ref.silentlyGetConstructedCDOMObject(PCClass.class, string.startsWith("CLASS:") ? string.substring(6) : string);
    }

    @Override
    protected void finishObject(PObject pObject) {
        List<Prerequisite> list = pObject.getPrerequisiteList();
        if (list != null) {
            for (Prerequisite prerequisite : list) {
                if (!"VAR".equalsIgnoreCase(prerequisite.getKind())) continue;
                prerequisite.setSubKey("CLASS:" + pObject.getKeyName());
            }
        }
    }

    public void loadSubLines(LoadContext loadContext) {
        Collection<PCClass> collection = loadContext.ref.getConstructedCDOMObjects(PCClass.class);
        for (PCClass pCClass : collection) {
            Object object;
            Object object2;
            List<SubClass> list = pCClass.getListFor(ListKey.SUB_CLASS);
            if (list != null) {
                object2 = list.iterator();
                while (object2.hasNext()) {
                    object = (SubClass)object2.next();
                    ((PCClass)object).copyLevelsFrom(pCClass);
                    this.processSubLevelLines(loadContext, pCClass, (PCClass)object);
                }
            }
            if ((object2 = pCClass.getListFor(ListKey.SUBSTITUTION_CLASS)) == null) continue;
            object = object2.iterator();
            while (object.hasNext()) {
                SubstitutionClass substitutionClass = (SubstitutionClass)object.next();
                this.processSubLevelLines(loadContext, pCClass, substitutionClass);
            }
        }
    }

    private void processSubLevelLines(LoadContext loadContext, PCClass pCClass, PCClass pCClass2) {
        for (DeferredLine deferredLine : pCClass2.getSafeListFor(ListKey.SUB_CLASS_LEVEL)) {
            loadContext.setSourceURI(deferredLine.source.getURI());
            String string = deferredLine.lstLine;
            try {
                String string2;
                String string3;
                int n = string.indexOf("\t");
                if (n == -1) {
                    string3 = string;
                    string2 = null;
                } else {
                    string3 = string.substring(0, n);
                    string2 = string.substring(n + 1);
                }
                this.parseFullClassLevelLine(loadContext, deferredLine.source, pCClass2, string3, string2);
            }
            catch (PersistenceLayerException persistenceLayerException) {
                Logging.log(Logging.LST_ERROR, "Error parsing " + pCClass2.getClass().getSimpleName() + " line: " + pCClass.getKeyName() + " " + pCClass2.getKeyName() + " " + string, persistenceLayerException);
            }
        }
    }
}

