/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import java.util.Map;
import java.util.StringTokenizer;
import pcgen.core.PCStat;
import pcgen.core.SettingsHandler;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.PCStatLstToken;
import pcgen.persistence.lst.TokenStore;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;

public final class PCStatLoader
extends LstLineFileLoader {
    public void parseLine(LoadContext loadContext, String string, URI uRI) throws PersistenceLayerException {
        PCStat pCStat = new PCStat();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        Map<String, LstToken> map = TokenStore.inst().getTokenMap(PCStatLstToken.class);
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3 = stringTokenizer.nextToken().trim();
            int n = string3.indexOf(58);
            if (n == -1) {
                Logging.errorPrint("Invalid Token - does not contain a colon: '" + string3 + "' in PCStat " + pCStat.getDisplayName() + " of " + uRI);
                continue;
            }
            if (n == 0) {
                Logging.errorPrint("Invalid Token - starts with a colon: '" + string3 + "' in PCStat " + pCStat.getDisplayName() + " of " + uRI);
                continue;
            }
            String string4 = string3.substring(0, n);
            String string5 = string2 = n == string3.length() - 1 ? null : string3.substring(n + 1);
            if (loadContext.processToken(pCStat, string4, string2)) {
                loadContext.commit();
            } else {
                loadContext.rollback();
                if (map.containsKey(string4)) {
                    PCStatLstToken pCStatLstToken = (PCStatLstToken)map.get(string4);
                    LstUtils.deprecationCheck(pCStatLstToken, pCStat, string2);
                    if (!pCStatLstToken.parse(pCStat, string2)) {
                        Logging.errorPrint("Error parsing PCStat " + pCStat.getDisplayName() + ':' + uRI.toString() + ':' + string3 + "\"");
                    }
                } else {
                    Logging.replayParsedMessages();
                }
            }
            Logging.clearParseMessages();
        }
        SettingsHandler.getGame().addToStatList(pCStat);
    }
}

