/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import java.util.Map;
import java.util.StringTokenizer;
import pcgen.core.GameMode;
import pcgen.core.SystemCollections;
import pcgen.core.UnitSet;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.TokenStore;
import pcgen.persistence.lst.UnitSetLstToken;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;

public final class UnitSetLoader
extends LstLineFileLoader {
    public void parseLine(LoadContext loadContext, String string, URI uRI) {
        Logging.errorPrint("Warning: unitset.lst deprecated. use UNITSET in miscinfo.lst instead (GameMode: " + this.getGameMode() + ")");
        UnitSet unitSet = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            try {
                switch (n) {
                    case 0: {
                        unitSet = SystemCollections.getUnitSet(string2, this.getGameMode());
                        unitSet.setName(string2);
                        break;
                    }
                    case 1: {
                        unitSet.setHeightUnit(string2);
                        break;
                    }
                    case 2: {
                        unitSet.setHeightFactor(Double.parseDouble(string2));
                        break;
                    }
                    case 3: {
                        unitSet.setHeightDisplayPattern(string2);
                        break;
                    }
                    case 4: {
                        unitSet.setDistanceUnit(string2);
                        break;
                    }
                    case 5: {
                        unitSet.setDistanceFactor(Double.parseDouble(string2));
                        break;
                    }
                    case 6: {
                        unitSet.setDistanceDisplayPattern(string2);
                        break;
                    }
                    case 7: {
                        unitSet.setWeightUnit(string2);
                        break;
                    }
                    case 8: {
                        unitSet.setWeightFactor(Double.parseDouble(string2));
                        break;
                    }
                    case 9: {
                        unitSet.setWeightDisplayPattern(string2);
                        break;
                    }
                    default: {
                        Logging.errorPrint("Unexpected token '" + string2 + "' in " + uRI.toString());
                        break;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                Logging.errorPrint("Illegal unit set info '" + string + "' in " + uRI.toString());
            }
            ++n;
        }
    }

    public void parseLine(GameMode gameMode, String string, URI uRI) throws PersistenceLayerException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        UnitSet unitSet = null;
        Map<String, LstToken> map = TokenStore.inst().getTokenMap(UnitSetLstToken.class);
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3 = stringTokenizer.nextToken().trim();
            int n = string3.indexOf(58);
            String string4 = "";
            try {
                string4 = string3.substring(0, n);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
            UnitSetLstToken unitSetLstToken = (UnitSetLstToken)map.get(string4);
            if (string4.equals("UNITSET")) {
                string2 = string3.substring(n + 1).trim();
                unitSet = SystemCollections.getUnitSet(string2, gameMode.getName());
                unitSet.setName(string2);
                continue;
            }
            if (unitSetLstToken != null) {
                string2 = string3.substring(n + 1).trim();
                LstUtils.deprecationCheck(unitSetLstToken, "Unit Set", uRI, string2);
                if (unitSetLstToken.parse(unitSet, string2)) continue;
                Logging.errorPrint("Error parsing unit set:miscinfo.lst from the " + gameMode.getName() + " Game Mode" + ':' + string3 + "\"");
                continue;
            }
            Logging.errorPrint("Invalid sub tag " + unitSetLstToken + " on UNITSET line");
            throw new PersistenceLayerException("Invalid sub tag " + unitSetLstToken + " on UNITSET line");
        }
    }
}

