/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst.output.prereq;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.TreeSet;
import pcgen.base.lang.StringUtil;
import pcgen.core.PObject;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriterFactory;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriterInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrerequisiteWriter {
    public void write(Writer writer, Prerequisite prerequisite) throws PersistenceLayerException {
        PrerequisiteWriterFactory prerequisiteWriterFactory = PrerequisiteWriterFactory.getInstance();
        PrerequisiteWriterInterface prerequisiteWriterInterface = prerequisiteWriterFactory.getWriter(prerequisite.getKind());
        if (prerequisiteWriterInterface == null) {
            throw new PersistenceLayerException("Can not find a Writer for prerequisites fo kind: " + prerequisite.getKind());
        }
        prerequisiteWriterInterface.write(writer, prerequisite);
    }

    public static String prereqsToString(PObject pObject) {
        if (pObject.hasPrerequisites()) {
            PrerequisiteWriter prerequisiteWriter = new PrerequisiteWriter();
            StringWriter stringWriter = new StringWriter();
            for (Prerequisite prerequisite : pObject.getPrerequisiteList()) {
                try {
                    stringWriter.write(9);
                    prerequisiteWriter.write(stringWriter, prerequisite);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return stringWriter.toString();
        }
        return "";
    }

    public String getPrerequisiteString(Collection<Prerequisite> collection) throws PersistenceLayerException {
        String string = null;
        if (collection != null && !collection.isEmpty()) {
            TreeSet<String> treeSet = new TreeSet<String>();
            for (Prerequisite prerequisite : collection) {
                StringWriter stringWriter = new StringWriter();
                this.write(stringWriter, prerequisite);
                treeSet.add(stringWriter.toString());
            }
            string = StringUtil.join(treeSet, "|");
        }
        return string;
    }
}

