/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.persistence;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import pcgen.cdom.base.CDOMObject;
import pcgen.core.PCClass;
import pcgen.persistence.lst.prereq.PrerequisiteParserInterface;
import pcgen.rules.persistence.token.CDOMCompatibilityToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.rules.persistence.token.CDOMSubToken;
import pcgen.rules.persistence.token.CDOMToken;
import pcgen.rules.persistence.token.ClassWrappedToken;
import pcgen.rules.persistence.token.DeferredToken;
import pcgen.rules.persistence.token.PreCompatibilityToken;
import pcgen.rules.persistence.util.TokenFamily;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenLibrary {
    private static final Class<PCClass> PCCLASS_CLASS = PCClass.class;
    private static final Class<CDOMObject> CDOMOBJECT_CLASS = CDOMObject.class;
    private static final List<DeferredToken<? extends CDOMObject>> deferredTokens = new ArrayList<DeferredToken<? extends CDOMObject>>();
    private static final Set<TokenFamily> TOKEN_FAMILIES = new TreeSet<TokenFamily>();

    public static List<DeferredToken<? extends CDOMObject>> getDeferredTokens() {
        return new ArrayList<DeferredToken<? extends CDOMObject>>(deferredTokens);
    }

    public static void addToTokenMap(Object object) {
        Object object2;
        if (object instanceof DeferredToken) {
            deferredTokens.add((DeferredToken)object);
        }
        if (object instanceof CDOMPrimaryToken) {
            object2 = (CDOMPrimaryToken)object;
            if (TokenFamily.CURRENT.putToken(object2) != null) {
                Logging.errorPrint("Duplicate " + object2.getTokenClass().getSimpleName() + " Token found for token " + object2.getTokenName());
            }
            if (PCCLASS_CLASS.equals(object2.getTokenClass())) {
                TokenLibrary.addToTokenMap(new ClassWrappedToken((CDOMToken<PCClass>)object2));
            }
        }
        if (object instanceof CDOMSecondaryToken && TokenFamily.CURRENT.putSubToken(object2 = (CDOMSecondaryToken)object) != null) {
            Logging.errorPrint("Duplicate " + object2.getTokenClass().getSimpleName() + " Token found for token " + object2.getParentToken() + ":" + object2.getTokenName());
        }
        if (object instanceof PrerequisiteParserInterface) {
            object2 = (PrerequisiteParserInterface)object;
            TokenFamily.CURRENT.putPrerequisiteToken((PrerequisiteParserInterface)object2);
            for (String string : object2.kindsHandled()) {
                PreCompatibilityToken preCompatibilityToken = new PreCompatibilityToken(string, (PrerequisiteParserInterface)object2, false);
                if (TokenFamily.CURRENT.putToken(preCompatibilityToken) != null) {
                    Logging.errorPrint("Duplicate " + preCompatibilityToken.getTokenClass().getSimpleName() + " Token found for token " + preCompatibilityToken.getTokenName());
                }
                if (TokenFamily.CURRENT.putSubToken(preCompatibilityToken) != null) {
                    Logging.errorPrint("Duplicate " + preCompatibilityToken.getTokenClass().getSimpleName() + " Token found for token " + preCompatibilityToken.getParentToken() + ":" + preCompatibilityToken.getTokenName());
                }
                TokenFamily.CURRENT.putSubToken(preCompatibilityToken);
                PreCompatibilityToken preCompatibilityToken2 = new PreCompatibilityToken(string, (PrerequisiteParserInterface)object2, true);
                if (TokenFamily.CURRENT.putToken(preCompatibilityToken2) != null) {
                    Logging.errorPrint("Duplicate " + preCompatibilityToken2.getTokenClass().getSimpleName() + " Token found for token " + preCompatibilityToken2.getTokenName());
                }
                if (TokenFamily.CURRENT.putSubToken(preCompatibilityToken2) == null) continue;
                Logging.errorPrint("Duplicate " + preCompatibilityToken2.getTokenClass().getSimpleName() + " Token found for token " + preCompatibilityToken2.getParentToken() + ":" + preCompatibilityToken2.getTokenName());
            }
        }
        if (object instanceof CDOMCompatibilityToken) {
            object2 = (CDOMCompatibilityToken)object;
            TokenFamily tokenFamily = TokenFamily.getConstant(object2.compatibilityLevel(), object2.compatibilitySubLevel(), object2.compatibilityPriority());
            if (tokenFamily.putToken(object2) != null) {
                Logging.errorPrint("Duplicate " + object2.getTokenClass().getSimpleName() + " Compatibility Token found for token " + object2.getTokenName() + " at compatibility level " + object2.compatibilityLevel() + "." + object2.compatibilitySubLevel() + "." + object2.compatibilityPriority());
            }
            TOKEN_FAMILIES.add(tokenFamily);
            if (tokenFamily.compareTo(TokenFamily.REV514) <= 0 && PCCLASS_CLASS.equals(object2.getTokenClass())) {
                TokenLibrary.addToTokenMap(new ClassWrappedToken((CDOMToken<PCClass>)object2));
            }
        }
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    static {
        TOKEN_FAMILIES.add(TokenFamily.CURRENT);
        TOKEN_FAMILIES.add(TokenFamily.REV514);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PreTokenIterator
    extends AbstractTokenIterator<CDOMObject, PrerequisiteParserInterface> {
        public PreTokenIterator(String string) {
            super(CDOMOBJECT_CLASS, string);
        }

        @Override
        protected PrerequisiteParserInterface grabToken(TokenFamily tokenFamily, Class<?> clazz, String string) {
            return tokenFamily.getPrerequisiteToken(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SubTokenIterator<C, T extends CDOMSubToken<? super C>>
    extends AbstractTokenIterator<C, T> {
        private final String subTokenKey;

        public SubTokenIterator(Class<C> clazz, String string, String string2) {
            super(clazz, string);
            this.subTokenKey = string2;
        }

        @Override
        protected T grabToken(TokenFamily tokenFamily, Class<?> clazz, String string) {
            return (T)tokenFamily.getSubToken(clazz, string, this.subTokenKey);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TokenIterator<C extends CDOMObject, T extends CDOMToken<? super C>>
    extends AbstractTokenIterator<C, T> {
        public TokenIterator(Class<C> clazz, String string) {
            super(clazz, string);
        }

        @Override
        protected T grabToken(TokenFamily tokenFamily, Class<?> clazz, String string) {
            return (T)tokenFamily.getToken(clazz, string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class AbstractTokenIterator<C, T>
    implements Iterator<T> {
        private final Class<C> rootClass;
        private final String tokenKey;
        private T nextToken = null;
        private boolean needNewToken = true;
        private Class<?> stopClass;
        private final Iterator<TokenFamily> subIterator;

        public AbstractTokenIterator(Class<C> clazz, String string) {
            this.rootClass = clazz;
            this.subIterator = TOKEN_FAMILIES.iterator();
            this.tokenKey = string;
        }

        @Override
        public boolean hasNext() {
            this.setNextToken();
            return !this.needNewToken;
        }

        protected void setNextToken() {
            while (this.needNewToken && this.subIterator.hasNext()) {
                Class<C> clazz;
                TokenFamily tokenFamily = this.subIterator.next();
                this.nextToken = this.grabToken(tokenFamily, clazz, this.tokenKey);
                for (clazz = this.rootClass; this.nextToken == null && clazz != null && !clazz.equals(this.stopClass); clazz = clazz.getSuperclass()) {
                    this.nextToken = this.grabToken(tokenFamily, clazz, this.tokenKey);
                }
                if (this.stopClass == null) {
                    this.stopClass = clazz;
                }
                this.needNewToken = this.nextToken == null;
            }
        }

        protected abstract T grabToken(TokenFamily var1, Class<?> var2, String var3);

        @Override
        public T next() {
            this.setNextToken();
            if (this.needNewToken) {
                throw new NoSuchElementException();
            }
            this.needNewToken = true;
            return this.nextToken;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Iterator does not support remove");
        }
    }
}

