/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.Collection;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.Movement;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveLst
extends AbstractToken
implements CDOMPrimaryToken<CDOMObject> {
    public String getTokenName() {
        return "MOVE";
    }

    private boolean validateMove(String string, String string2) {
        try {
            if (Integer.parseInt(string2) < 0) {
                Logging.addParseMessage((Level)Logging.LST_ERROR, (String)("Invalid movement (cannot be negative): " + string2 + " in MOVE: " + string));
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            Logging.addParseMessage((Level)Logging.LST_ERROR, (String)("Invalid movement (must be an integer >= 0): " + string2 + " in MOVE: " + string));
            return false;
        }
        return true;
    }

    public boolean parse(LoadContext loadContext, CDOMObject cDOMObject, String string) {
        Movement movement;
        if (this.isEmpty(string) || this.hasIllegalSeparator(',', string)) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.countTokens() == 1) {
            movement = new Movement(1);
            String string2 = stringTokenizer.nextToken();
            if (!this.validateMove(string, string2)) {
                return false;
            }
            movement.assignMovement(0, "Walk", string2);
        } else {
            movement = new Movement(stringTokenizer.countTokens() / 2);
            int n = 0;
            while (stringTokenizer.countTokens() > 1) {
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                if (!this.validateMove(string, string4)) {
                    return false;
                }
                movement.assignMovement(n++, string3, string4);
            }
            if (stringTokenizer.countTokens() != 0) {
                Logging.addParseMessage((Level)Logging.LST_ERROR, (String)("Badly formed MOVE token (extra value at end of list): " + string));
                return false;
            }
        }
        movement.setMoveRatesFlag(0);
        loadContext.obj.addToList(cDOMObject, ListKey.MOVEMENT, (Object)movement);
        return true;
    }

    public String[] unparse(LoadContext loadContext, CDOMObject cDOMObject) {
        Changes changes = loadContext.getObjectContext().getListChanges(cDOMObject, ListKey.MOVEMENT);
        Collection collection = changes.getAdded();
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Movement movement : collection) {
            if (movement.getMoveRatesFlag() != 0) continue;
            StringBuilder stringBuilder = new StringBuilder();
            movement.addTokenContents(stringBuilder);
            treeSet.add(stringBuilder.toString());
        }
        if (treeSet.isEmpty()) {
            return null;
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }
}

