/*
 * Decompiled with CFR 0.152.
 */
package plugin.jepcommands;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.nfunk.jep.ParseException;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Ability;
import pcgen.core.AbilityUtilities;
import pcgen.core.CharacterDomain;
import pcgen.core.Equipment;
import pcgen.core.Language;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.core.VariableProcessor;
import pcgen.core.character.Follower;
import pcgen.util.Logging;
import pcgen.util.PCGenCommand;
import pcgen.util.ParameterTree;
import pcgen.util.enumeration.Visibility;

public class CountCommand
extends PCGenCommand {
    public CountCommand() {
        this.numberOfParameters = -1;
    }

    public String getFunctionName() {
        return "COUNT";
    }

    private PlayerCharacter getPC() {
        PlayerCharacter playerCharacter = null;
        if (this.parent instanceof VariableProcessor) {
            playerCharacter = ((VariableProcessor)this.parent).getPc();
        } else if (this.parent instanceof PlayerCharacter) {
            playerCharacter = (PlayerCharacter)this.parent;
        }
        return playerCharacter;
    }

    private Object[] paramStackToArray(Stack stack, int n) {
        Object[] objectArray = new Object[n];
        if (0 < n) {
            for (int i = n - 1; 0 <= i; --i) {
                objectArray[i] = stack.pop();
            }
        }
        return objectArray;
    }

    public void run(Stack stack) throws ParseException {
        Object e;
        Object[] objectArray;
        PlayerCharacter playerCharacter = this.getPC();
        if (playerCharacter == null) {
            throw new ParseException("Invalid parent (no PC): " + this.parent.getClass().getName());
        }
        this.checkStack(stack);
        if (1 <= this.curNumberOfParameters) {
            objectArray = this.paramStackToArray(stack, this.curNumberOfParameters - 1);
            e = stack.pop();
            if (!(e instanceof String)) {
                throw new ParseException("Invalid parameter type");
            }
        } else {
            throw new ParseException("missing parameter, nothing to count");
        }
        JepCountEnum jepCountEnum = JepCountEnum.valueOf((String)e);
        Double d = (Double)jepCountEnum.count(playerCharacter, objectArray);
        stack.push(d);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JepCountEnum {
        ABILITIES{
            public Map<Ability.Nature, Set<Ability>> abdata;

            @Override
            protected void getData(PlayerCharacter playerCharacter) {
                this.abdata = playerCharacter.getAbilitiesSet();
            }

            @Override
            public Object count(PlayerCharacter playerCharacter, Object[] objectArray) throws ParseException {
                Object[] objectArray2 = this.validateParams(objectArray);
                ParameterTree parameterTree = JepCountEnum.convertParams(objectArray2);
                this.getData(playerCharacter);
                Set<PObject> set = this.doFilterP(parameterTree);
                return this.countData(set, playerCharacter);
            }

            protected Object countData(Iterable<PObject> iterable, PlayerCharacter playerCharacter) {
                double d = 0.0;
                for (PObject pObject : iterable) {
                    double d2 = playerCharacter.getSelectCorrectedAssociationCount((CDOMObject)pObject);
                    d += 1.01 >= d2 ? 1.0 : d2;
                }
                return d;
            }

            @Override
            protected Set<PObject> filterSetP(String string) {
                Object object4;
                Object object2;
                JepAbilityCountEnum jepAbilityCountEnum;
                String[] stringArray = string.split("=");
                try {
                    jepAbilityCountEnum = JepAbilityCountEnum.valueOf(stringArray[0]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Logging.errorPrint((String)("Bad paramter to count(\"Ability\"), " + string));
                    return new HashSet<PObject>();
                }
                HashSet hashSet = null;
                switch (jepAbilityCountEnum) {
                    case CATEGORY: 
                    case CAT: {
                        Ability ability;
                        object2 = stringArray[1];
                        hashSet = new HashSet(this.abdata.get(Ability.Nature.ANY));
                        Iterator iterator = hashSet.iterator();
                        while (iterator.hasNext()) {
                            ability = (Ability)iterator.next();
                            if (ability.getCategory().equalsIgnoreCase((String)object2)) continue;
                            iterator.remove();
                        }
                        break;
                    }
                    case NAME: 
                    case NAM: {
                        Object object3;
                        hashSet = new HashSet(this.abdata.get(Ability.Nature.ANY));
                        Iterator iterator = hashSet.iterator();
                        while (iterator.hasNext()) {
                            object3 = (Ability)iterator.next();
                            object4 = (Boolean)object3.getSafe(ObjectKey.MULTIPLE_ALLOWED) != false ? AbilityUtilities.getUndecoratedName((String)object3.getDisplayName(), new ArrayList()) : object3.getDisplayName();
                            if (((String)object4).equalsIgnoreCase(stringArray[1])) continue;
                            iterator.remove();
                        }
                        break;
                    }
                    case NATURE: 
                    case NAT: {
                        Object object3;
                        try {
                            object3 = Ability.Nature.valueOf((String)stringArray[1]);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            Logging.errorPrint((String)("Bad paramter to count(\"Ability\"), no such NATURE " + string));
                            object3 = Ability.Nature.ANY;
                        }
                        hashSet = new HashSet(this.abdata.get(object3));
                        break;
                    }
                    case TYPE: 
                    case TYP: {
                        hashSet = new HashSet(this.abdata.get(Ability.Nature.ANY));
                        Iterator iterator = hashSet.iterator();
                        JepCountEnum.filterPObjectByType(iterator, stringArray[1]);
                        break;
                    }
                    case VISIBILITY: 
                    case VIS: {
                        Ability ability;
                        Iterator iterator;
                        hashSet = new HashSet(this.abdata.get(Ability.Nature.ANY));
                        try {
                            object4 = Visibility.valueOf((String)stringArray[1]);
                            iterator = hashSet.iterator();
                            while (iterator.hasNext()) {
                                ability = (Ability)iterator.next();
                                if (((Visibility)ability.getSafe(ObjectKey.VISIBILITY)).equals(object4)) continue;
                                iterator.remove();
                            }
                            break;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            Logging.errorPrint((String)("Bad paramter to count(\"Ability\"), no such Visibility " + stringArray[1]));
                        }
                    }
                }
                object2 = new HashSet();
                for (Object object4 : hashSet) {
                    object2.add(object4);
                }
                return object2;
            }

            @Override
            protected Set<String> filterSetS(String string) throws ParseException {
                throw new ParseException("PCClass is a PObject, should be calling filterSetP");
            }
        }
        ,
        CLASSES{
            public Set<PCClass> objdata;

            @Override
            protected void getData(PlayerCharacter playerCharacter) {
                this.objdata = new HashSet<PCClass>();
                this.objdata.addAll(playerCharacter.getClassList());
            }

            @Override
            public Object count(PlayerCharacter playerCharacter, Object[] objectArray) throws ParseException {
                Object[] objectArray2 = this.validateParams(objectArray);
                ParameterTree parameterTree = JepCountEnum.convertParams(objectArray2);
                this.getData(playerCharacter);
                Set<PObject> set = this.doFilterP(parameterTree);
                return (double)set.size();
            }

            @Override
            protected Set<String> filterSetS(String string) throws ParseException {
                throw new ParseException("PCClass is a PObject, should be calling filterSetP");
            }

            @Override
            protected Set<PObject> filterSetP(String string) throws ParseException {
                String[] stringArray = string.split("=");
                if (!"TYPE".equalsIgnoreCase(stringArray[0])) {
                    throw new ParseException("Bad parameter to count(\"CLASSES\" ... )" + string);
                }
                HashSet<PCClass> hashSet = new HashSet<PCClass>(this.objdata);
                Iterator iterator = hashSet.iterator();
                JepCountEnum.filterPObjectByType(iterator, stringArray[1]);
                HashSet<PObject> hashSet2 = new HashSet<PObject>();
                for (PCClass pCClass : hashSet) {
                    hashSet2.add((PObject)pCClass);
                }
                return hashSet2;
            }
        }
        ,
        DOMAINS{
            public Map<CharacterDomain, String> objdata;

            @Override
            protected void getData(PlayerCharacter playerCharacter) {
                HashSet hashSet = new HashSet();
                hashSet.addAll(playerCharacter.getCharacterDomainList());
                for (CharacterDomain characterDomain : hashSet) {
                    this.objdata.put(characterDomain, characterDomain.getObjectName());
                }
            }

            @Override
            public Object count(PlayerCharacter playerCharacter, Object[] objectArray) throws ParseException {
                Object[] objectArray2 = this.validateParams(objectArray);
                ParameterTree parameterTree = JepCountEnum.convertParams(objectArray2);
                this.getData(playerCharacter);
                Set<String> set = this.doFilterS(parameterTree);
                return (double)set.size();
            }

            @Override
            protected Set<String> filterSetS(String string) throws ParseException {
                CharacterDomain characterDomain;
                String[] stringArray = string.split("=");
                if (!"TYPE".equalsIgnoreCase(stringArray[0])) {
                    throw new ParseException("Bad parameter to count(\"" + (Object)((Object)this) + "\" ... )" + string);
                }
                HashSet<CharacterDomain> hashSet = new HashSet<CharacterDomain>(this.objdata.keySet());
                Iterator iterator = hashSet.iterator();
                if (!"ALL".equalsIgnoreCase(stringArray[1])) {
                    while (iterator.hasNext()) {
                        characterDomain = (CharacterDomain)iterator.next();
                        if (characterDomain.getDomainType().equalsIgnoreCase(stringArray[1])) continue;
                        iterator.remove();
                    }
                }
                characterDomain = new HashSet();
                for (CharacterDomain characterDomain2 : hashSet) {
                    characterDomain.add(this.objdata.get(characterDomain2));
                }
                return characterDomain;
            }

            @Override
            protected Set<PObject> filterSetP(String string) throws ParseException {
                throw new ParseException("CharacterDomain is not a PObject, should be calling filterSetS");
            }
        }
        ,
        EQUIPMENT{
            public Set<Equipment> objdata;

            @Override
            protected void getData(PlayerCharacter playerCharacter) {
                this.objdata = new HashSet<Equipment>();
                this.objdata.addAll(playerCharacter.getEquipmentListInOutputOrder());
            }

            @Override
            public Object count(PlayerCharacter playerCharacter, Object[] objectArray) throws ParseException {
                Object[] objectArray2 = this.validateParams(objectArray);
                ParameterTree parameterTree = JepCountEnum.convertParams(objectArray2);
                this.getData(playerCharacter);
                Set<PObject> set = this.doFilterP(parameterTree);
                return (double)set.size();
            }

            @Override
            protected Set<String> filterSetS(String string) throws ParseException {
                throw new ParseException("Equipment is a PObject, should be calling filterSetP");
            }

            @Override
            protected Set<PObject> filterSetP(String string) throws ParseException {
                Equipment equipment;
                JepEquipmentCountEnum jepEquipmentCountEnum;
                String[] stringArray = string.split("=");
                try {
                    jepEquipmentCountEnum = JepEquipmentCountEnum.valueOf(stringArray[0]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Logging.errorPrint((String)("Bad paramter to count(\"Equipment\"), " + string));
                    return new HashSet<PObject>();
                }
                HashSet<Equipment> hashSet = new HashSet<Equipment>(this.objdata);
                Iterator iterator = hashSet.iterator();
                switch (jepEquipmentCountEnum) {
                    case TYPE: {
                        JepCountEnum.filterPObjectByType(iterator, stringArray[1]);
                        break;
                    }
                    case WIELDCATEGORY: {
                        while (iterator.hasNext()) {
                            equipment = (Equipment)iterator.next();
                            if (equipment.getWieldName().equalsIgnoreCase(stringArray[1])) continue;
                            iterator.remove();
                        }
                        break;
                    }
                    case LOCATION: {
                        if ("CARRIED".equalsIgnoreCase(stringArray[1]) || "Equipped".equalsIgnoreCase(stringArray[1])) {
                            // empty if block
                        }
                    }
                    case LOC: {
                        break;
                    }
                    case TYP: {
                        break;
                    }
                }
                equipment = new HashSet();
                for (Equipment equipment2 : hashSet) {
                    equipment.add(equipment2);
                }
                return equipment;
            }
        }
        ,
        FOLLOWERS{
            public Map<Follower, String> objdata;

            @Override
            protected void getData(PlayerCharacter playerCharacter) {
                List list = playerCharacter.getFollowerList();
                for (Follower follower : list) {
                    this.objdata.put(follower, "");
                }
            }

            @Override
            public Object count(PlayerCharacter playerCharacter, Object[] objectArray) throws ParseException {
                Object[] objectArray2 = this.validateParams(objectArray);
                ParameterTree parameterTree = JepCountEnum.convertParams(objectArray2);
                this.getData(playerCharacter);
                Set<String> set = this.doFilterS(parameterTree);
                return this.countDataS(set);
            }

            @Override
            protected Set<PObject> filterSetP(String string) throws ParseException {
                throw new ParseException("Follower is not a PObject, should be calling filterSetS");
            }

            @Override
            protected Set<String> filterSetS(String string) {
                return (Set)this.objdata.values();
            }
        }
        ,
        LANGUAGES{
            public Set<Language> objdata;

            @Override
            protected void getData(PlayerCharacter playerCharacter) {
                this.objdata = new HashSet<Language>();
                this.objdata.addAll(playerCharacter.getLanguagesList());
            }

            @Override
            public Object count(PlayerCharacter playerCharacter, Object[] objectArray) throws ParseException {
                Object[] objectArray2 = this.validateParams(objectArray);
                ParameterTree parameterTree = JepCountEnum.convertParams(objectArray2);
                this.getData(playerCharacter);
                Set<PObject> set = this.doFilterP(parameterTree);
                return (double)set.size();
            }

            @Override
            protected Set<PObject> filterSetP(String string) throws ParseException {
                String[] stringArray = string.split("=");
                if (!"TYPE".equalsIgnoreCase(stringArray[0])) {
                    throw new ParseException(MessageFormat.format("Bad parameter to count(\"CLASSES\" ... ){0}", string));
                }
                HashSet<Language> hashSet = new HashSet<Language>(this.objdata);
                Iterator iterator = hashSet.iterator();
                JepCountEnum.filterPObjectByType(iterator, stringArray[1]);
                HashSet<PObject> hashSet2 = new HashSet<PObject>();
                for (Language language : hashSet) {
                    hashSet2.add((PObject)language);
                }
                return hashSet2;
            }

            @Override
            protected Set<String> filterSetS(String string) throws ParseException {
                throw new ParseException("Language is a PObject, should be calling filterSetP");
            }
        }
        ,
        RACESUBTYPES{
            public Set<String> objdata = new HashSet<String>();

            @Override
            protected void getData(PlayerCharacter playerCharacter) {
                this.objdata.addAll(playerCharacter.getRacialSubTypes());
            }

            @Override
            public Object count(PlayerCharacter playerCharacter, Object[] objectArray) throws ParseException {
                Object[] objectArray2 = this.validateParams(objectArray);
                ParameterTree parameterTree = JepCountEnum.convertParams(objectArray2);
                this.getData(playerCharacter);
                Set<String> set = this.doFilterS(parameterTree);
                return (double)set.size();
            }

            @Override
            protected Set<PObject> filterSetP(String string) throws ParseException {
                throw new ParseException("RaceSubType is not a PObject, should be calling filterSetS");
            }

            @Override
            protected Set<String> filterSetS(String string) throws ParseException {
                String[] stringArray = string.split("=");
                if (!"TYPE".equalsIgnoreCase(stringArray[0])) {
                    throw new ParseException(MessageFormat.format("Bad parameter to count(\"CLASSES\" ... ){0}", string));
                }
                HashSet<String> hashSet = new HashSet<String>(this.objdata);
                if (!"ALL".equalsIgnoreCase(stringArray[1])) {
                    Iterator iterator = hashSet.iterator();
                    ArrayList arrayList = new ArrayList();
                    Collections.addAll(arrayList, stringArray[1].split("\\."));
                    block0: while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        for (String string3 : arrayList) {
                            if (string2.equals(string3)) continue;
                            iterator.remove();
                            continue block0;
                        }
                    }
                }
                return hashSet;
            }
        }
        ,
        SKILLS{
            public Set<Skill> objdata;

            @Override
            protected void getData(PlayerCharacter playerCharacter) {
                this.objdata = new HashSet<Skill>();
                this.objdata.addAll(playerCharacter.getAllSkillList(true));
            }

            @Override
            public Object count(PlayerCharacter playerCharacter, Object[] objectArray) throws ParseException {
                Object[] objectArray2 = this.validateParams(objectArray);
                ParameterTree parameterTree = JepCountEnum.convertParams(objectArray2);
                this.getData(playerCharacter);
                Set<PObject> set = this.doFilterP(parameterTree);
                return (double)set.size();
            }

            @Override
            protected Set<String> filterSetS(String string) throws ParseException {
                throw new ParseException("Skill is a PObject, should be calling filterSetP");
            }

            @Override
            protected Set<PObject> filterSetP(String string) throws ParseException {
                String[] stringArray = string.split("=");
                if (!"TYPE".equalsIgnoreCase(stringArray[0])) {
                    throw new ParseException("Bad parameter to count(\"CLASSES\" ... )" + string);
                }
                HashSet<Skill> hashSet = new HashSet<Skill>(this.objdata);
                Iterator iterator = hashSet.iterator();
                JepCountEnum.filterPObjectByType(iterator, stringArray[1]);
                HashSet<PObject> hashSet2 = new HashSet<PObject>();
                for (Skill skill : hashSet) {
                    hashSet2.add((PObject)skill);
                }
                return hashSet2;
            }
        }
        ,
        SPELLBOOKS{

            @Override
            public Object count(PlayerCharacter playerCharacter, Object[] objectArray) throws ParseException {
                return (double)playerCharacter.getSpellBooks().size();
            }

            @Override
            protected void getData(PlayerCharacter playerCharacter) {
            }

            @Override
            protected Set<PObject> filterSetP(String string) {
                return new HashSet<PObject>();
            }

            @Override
            protected Set<String> filterSetS(String string) {
                return new HashSet<String>();
            }
        }
        ,
        SPELLS{

            @Override
            protected void getData(PlayerCharacter playerCharacter) {
            }

            @Override
            public Object count(PlayerCharacter playerCharacter, Object[] objectArray) throws ParseException {
                return Double.valueOf("0.0");
            }

            @Override
            protected Set<String> filterSetS(String string) throws ParseException {
                throw new ParseException("Not implemented yet");
            }

            @Override
            protected Set<PObject> filterSetP(String string) throws ParseException {
                throw new ParseException("Not implemented yet");
            }
        }
        ,
        SPELLSINBOOK{

            @Override
            protected void getData(PlayerCharacter playerCharacter) {
            }

            @Override
            public Object count(PlayerCharacter playerCharacter, Object[] objectArray) throws ParseException {
                return Double.valueOf("0.0");
            }

            @Override
            protected Set<String> filterSetS(String string) throws ParseException {
                throw new ParseException("Not implemented yet");
            }

            @Override
            protected Set<PObject> filterSetP(String string) throws ParseException {
                throw new ParseException("Not implemented yet");
            }
        }
        ,
        SPELLSKNOWN{

            @Override
            protected void getData(PlayerCharacter playerCharacter) {
            }

            @Override
            public Object count(PlayerCharacter playerCharacter, Object[] objectArray) throws ParseException {
                return Double.valueOf("0.0");
            }

            @Override
            protected Set<String> filterSetS(String string) throws ParseException {
                throw new ParseException("Not implemented yet");
            }

            @Override
            protected Set<PObject> filterSetP(String string) throws ParseException {
                throw new ParseException("Not implemented yet");
            }
        }
        ,
        TEMPLATES{
            public Set<PCTemplate> objdata = new HashSet<PCTemplate>();

            @Override
            protected void getData(PlayerCharacter playerCharacter) {
                this.objdata.addAll(playerCharacter.getTemplateList());
            }

            @Override
            public Object count(PlayerCharacter playerCharacter, Object[] objectArray) throws ParseException {
                return Double.valueOf("0.0");
            }

            @Override
            protected Set<String> filterSetS(String string) throws ParseException {
                throw new ParseException("PCTemplate is a PObject, should be calling filterSetP");
            }

            @Override
            protected Set<PObject> filterSetP(String string) throws ParseException {
                String[] stringArray = string.split("=");
                if (!"TYPE".equalsIgnoreCase(stringArray[0])) {
                    throw new ParseException("Bad parameter to count(\"CLASSES\" ... )" + string);
                }
                HashSet<PCTemplate> hashSet = new HashSet<PCTemplate>(this.objdata);
                Iterator iterator = hashSet.iterator();
                JepCountEnum.filterPObjectByType(iterator, stringArray[1]);
                HashSet<PObject> hashSet2 = new HashSet<PObject>();
                for (PCTemplate pCTemplate : hashSet) {
                    hashSet2.add((PObject)pCTemplate);
                }
                return hashSet2;
            }
        };

        public static String CountType;

        private static ParameterTree convertParams(Object[] objectArray) {
            ParameterTree parameterTree = null;
            for (Object object : objectArray) {
                try {
                    if (parameterTree == null) {
                        parameterTree = ParameterTree.makeTree((String)((String)object));
                        continue;
                    }
                    ParameterTree parameterTree2 = ParameterTree.makeTree((String)ParameterTree.andString);
                    parameterTree2.setLeftTree(parameterTree);
                    parameterTree = parameterTree2;
                    ParameterTree parameterTree3 = ParameterTree.makeTree((String)((String)object));
                    parameterTree.setRightTree(parameterTree3);
                }
                catch (ParseException parseException) {
                    Logging.errorPrint((String)MessageFormat.format("Malformed parameter to count {0}", object), (Throwable)parseException);
                }
            }
            return parameterTree;
        }

        private static void filterPObjectByType(Iterator<? extends PObject> iterator, String string) {
            if (!"ALL".equalsIgnoreCase(string)) {
                ArrayList arrayList = new ArrayList();
                Collections.addAll(arrayList, string.split("\\."));
                block0: while (iterator.hasNext()) {
                    PObject pObject = iterator.next();
                    for (String string2 : arrayList) {
                        if (pObject.isType(string2)) continue;
                        iterator.remove();
                        continue block0;
                    }
                }
            }
        }

        protected Object[] validateParams(Object[] objectArray) throws ParseException {
            Object[] objectArray2 = new Object[1];
            if (1 > objectArray.length) {
                objectArray2[0] = "TYPE=ALL";
            } else {
                objectArray2 = objectArray;
            }
            return objectArray2;
        }

        public abstract Object count(PlayerCharacter var1, Object[] var2) throws ParseException;

        public Object countP(PlayerCharacter playerCharacter, Object[] objectArray) throws ParseException {
            Object[] objectArray2 = this.validateParams(objectArray);
            ParameterTree parameterTree = JepCountEnum.convertParams(objectArray2);
            this.getData(playerCharacter);
            Set<PObject> set = this.doFilterP(parameterTree);
            return this.countDataP(set);
        }

        protected Object countDataP(Collection<PObject> collection) {
            return (double)collection.size();
        }

        protected Set<PObject> doFilterP(ParameterTree parameterTree) throws ParseException {
            String string = parameterTree.getContents();
            if (string.equalsIgnoreCase(ParameterTree.orString) || string.equalsIgnoreCase(ParameterTree.andString)) {
                Set<PObject> set = this.doFilterP(parameterTree.getLeftTree());
                Set<PObject> set2 = this.doFilterP(parameterTree.getRightTree());
                if (string.equalsIgnoreCase(ParameterTree.orString)) {
                    set.addAll(set2);
                } else {
                    set.retainAll(set2);
                }
                return set;
            }
            return this.filterSetP(string);
        }

        public Object countS(PlayerCharacter playerCharacter, Object[] objectArray) throws ParseException {
            Object[] objectArray2 = this.validateParams(objectArray);
            ParameterTree parameterTree = JepCountEnum.convertParams(objectArray2);
            this.getData(playerCharacter);
            Set<String> set = this.doFilterS(parameterTree);
            return this.countDataS(set);
        }

        protected Object countDataS(Collection<String> collection) {
            return (double)collection.size();
        }

        protected Set<String> doFilterS(ParameterTree parameterTree) throws ParseException {
            String string = parameterTree.getContents();
            if (string.equalsIgnoreCase(ParameterTree.orString) || string.equalsIgnoreCase(ParameterTree.andString)) {
                Set<String> set = this.doFilterS(parameterTree.getLeftTree());
                Set<String> set2 = this.doFilterS(parameterTree.getRightTree());
                if (string.equalsIgnoreCase(ParameterTree.orString)) {
                    set.addAll(set2);
                } else {
                    set.retainAll(set2);
                }
                return set;
            }
            return this.filterSetS(string);
        }

        protected abstract void getData(PlayerCharacter var1);

        protected abstract Set<PObject> filterSetP(String var1) throws ParseException;

        protected abstract Set<String> filterSetS(String var1) throws ParseException;

        static {
            CountType = "";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JepEquipmentCountEnum {
        TYPE,
        WIELDCATEGORY,
        LOCATION,
        TYP,
        WDC,
        LOC;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JepAbilityCountEnum {
        CATEGORY,
        NAME,
        NATURE,
        TYPE,
        VISIBILITY,
        CAT,
        NAM,
        NAT,
        TYP,
        VIS;

    }
}

