/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import pcgen.base.util.HashMapToList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.Category;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.helper.Qualifier;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.CategorizedCDOMReference;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.Race;
import pcgen.core.Skill;
import pcgen.core.WeaponProf;
import pcgen.core.spell.Spell;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;
import pcgen.util.StringPClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QualifyToken
extends AbstractToken
implements CDOMPrimaryToken<CDOMObject> {
    public String getTokenName() {
        return "QUALIFY";
    }

    public List<Class<? extends CDOMObject>> getLegalTypes() {
        return Arrays.asList(PCClassLevel.class, Ability.class, Deity.class, Domain.class, Equipment.class, PCClass.class, Race.class, Skill.class, Spell.class, PCTemplate.class, WeaponProf.class);
    }

    public boolean parse(LoadContext loadContext, CDOMObject cDOMObject, String string) {
        if (!this.getLegalTypes().contains(cDOMObject.getClass())) {
            Logging.log((Level)Logging.LST_ERROR, (String)("Cannot use QUALIFY on a " + cDOMObject.getClass()));
            return false;
        }
        if (this.isEmpty(string) || this.hasIllegalSeparator('|', string)) {
            return false;
        }
        if (string.indexOf("|") == -1) {
            Logging.log((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " requires at least two arguments, QualifyType and Key: " + string));
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        String string2 = stringTokenizer.nextToken();
        ReferenceManufacturer referenceManufacturer = loadContext.getManufacturer(string2);
        if (referenceManufacturer == null) {
            Logging.log((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " unable to generate manufacturer for type: " + string));
            return false;
        }
        while (stringTokenizer.hasMoreTokens()) {
            CDOMSingleRef cDOMSingleRef = referenceManufacturer.getReference(stringTokenizer.nextToken());
            loadContext.obj.addToList(cDOMObject, ListKey.QUALIFY, (Object)new Qualifier(referenceManufacturer.getReferenceClass(), cDOMSingleRef));
        }
        return true;
    }

    public String[] unparse(LoadContext loadContext, CDOMObject cDOMObject) {
        Object object;
        Object object22;
        Changes changes = loadContext.getObjectContext().getListChanges(cDOMObject, ListKey.QUALIFY);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        Collection collection = changes.getAdded();
        HashMapToList hashMapToList = new HashMapToList();
        for (Object object22 : collection) {
            Class clazz = object22.getQualifiedClass();
            String string = StringPClassUtil.getStringFor((Class)clazz);
            object = object22.getQualifiedReference();
            String string2 = string;
            if (object instanceof CategorizedCDOMReference) {
                Category category = ((CategorizedCDOMReference)object).getCDOMCategory();
                string2 = AbilityCategory.FEAT.equals((Object)category) ? "FEAT" : string2 + '=' + category.toString();
            }
            hashMapToList.addToListFor((Object)string2, object);
        }
        TreeSet treeSet = new TreeSet(ReferenceUtilities.REFERENCE_SORTER);
        object22 = new TreeSet();
        for (String string : hashMapToList.getKeySet()) {
            treeSet.clear();
            treeSet.addAll(hashMapToList.getListFor((Object)string));
            object = new StringBuilder();
            ((StringBuilder)object).append(string).append("|").append(ReferenceUtilities.joinLstFormat((Collection)treeSet, (String)"|"));
            object22.add(((StringBuilder)object).toString());
        }
        return object22.toArray(new String[object22.size()]);
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }
}

