/*
 * Decompiled with CFR 0.152.
 */
package plugin.notes.gui;

import gmgen.GMGenSystem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import pcgen.util.Logging;
import plugin.notes.NotesPlugin;

public class JIcon
extends JPanel {
    public static final boolean MAC_OS_X = System.getProperty("os.name").equals("Mac OS X");
    File launch;
    NotesPlugin plugin;
    private JButton button;
    private JLabel label;
    private JMenuItem deleteMI;
    private JMenuItem launchMI;
    private JPopupMenu contextMenu;

    public JIcon(File file, NotesPlugin notesPlugin) {
        this.plugin = notesPlugin;
        this.initComponents();
        if (file.getName().length() > 18) {
            this.label.setText(" " + file.getName().substring(0, 15) + "... ");
        } else {
            this.label.setText(" " + file.getName() + " ");
        }
        this.button.setIcon(this.getIconForType(file.getName()));
        this.button.setToolTipText(file.getName());
        this.launch = file;
    }

    public ImageIcon getIconForType(String string) {
        String string2 = string.replaceFirst(".*\\.", "");
        if (string2.equalsIgnoreCase("html") || string2.equalsIgnoreCase("htm")) {
            return new ImageIcon(this.getClass().getResource("/pcgen/gui/resource/gnome-text-html.png"));
        }
        if (string2.equalsIgnoreCase("doc")) {
            return new ImageIcon(this.getClass().getResource("/pcgen/gui/resource/win-word.png"));
        }
        if (string2.equalsIgnoreCase("pdf")) {
            return new ImageIcon(this.getClass().getResource("/pcgen/gui/resource/win-acrobat.png"));
        }
        if (string2.equalsIgnoreCase("rtf")) {
            return new ImageIcon(this.getClass().getResource("/pcgen/gui/resource/gnome-application-rtf.png"));
        }
        if (string2.equalsIgnoreCase("xls")) {
            return new ImageIcon(this.getClass().getResource("/pcgen/gui/resource/win-excel.png"));
        }
        if (string2.equalsIgnoreCase("ppt")) {
            return new ImageIcon(this.getClass().getResource("/pcgen/gui/resource/gnome-application-vnd.ms-powerpoint.png"));
        }
        if (string2.equalsIgnoreCase("txt")) {
            return new ImageIcon(this.getClass().getResource("/pcgen/gui/resource/gnome-text-plain.png"));
        }
        if (string2.equalsIgnoreCase("fcw")) {
            return new ImageIcon(this.getClass().getResource("/pcgen/gui/resource/win-cc2.png"));
        }
        if (string2.equalsIgnoreCase("zip")) {
            return new ImageIcon(this.getClass().getResource("/pcgen/gui/resource/win-zip.png"));
        }
        if (string2.equalsIgnoreCase("jpg") || string2.equalsIgnoreCase("gif") || string2.equalsIgnoreCase("png")) {
            return new ImageIcon(this.getClass().getResource("/pcgen/gui/resource/gnome-image-generic.png"));
        }
        return new ImageIcon(this.getClass().getResource("/pcgen/gui/resource/gnome-generic.png"));
    }

    protected void deleteFile() {
        int n = JOptionPane.showConfirmDialog((Component)GMGenSystem.inst, "Delete file " + this.launch.getPath(), "Delete File?", 0, 3);
        if (n == 0) {
            try {
                this.launch.delete();
                Container container = this.getParent();
                container.remove(this);
                if (container instanceof JComponent) {
                    JComponent jComponent = (JComponent)container;
                    jComponent.updateUI();
                }
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    protected void launchFile() {
        if (this.plugin.isRecognizedFileType(this.launch)) {
            this.plugin.loadRecognizedFileType(this.launch);
        } else if (MAC_OS_X) {
            String string = "/usr/bin/open";
            String string2 = this.launch.getAbsolutePath();
            String[] stringArray = new String[]{string, string2};
            System.err.println("Runtime.getRuntime().exec: [" + stringArray[0] + "] [" + stringArray[1] + "]");
            try {
                Runtime.getRuntime().exec(stringArray);
            }
            catch (IOException iOException) {
                Logging.errorPrint((String)iOException.getMessage(), (Throwable)iOException);
            }
        } else {
            try {
                String string = " rundll32 url.dll,FileProtocolHandler file://" + this.launch.getAbsoluteFile();
                Runtime.getRuntime().exec(string);
            }
            catch (Exception exception) {
                Logging.errorPrint((String)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private void buttonActionPerformed(ActionEvent actionEvent) {
    }

    private void buttonFocusGained(FocusEvent focusEvent) {
        this.setBackground(SystemColor.textHighlight);
        this.button.setBackground(SystemColor.textHighlight);
    }

    private void buttonFocusLost(FocusEvent focusEvent) {
        this.setBackground((Color)UIManager.getDefaults().get("Panel.background"));
        this.button.setBackground((Color)UIManager.getDefaults().get("Button.background"));
    }

    private void buttonKeyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 127) {
            this.deleteFile();
        } else if (n == 10) {
            this.launchFile();
        }
    }

    private void buttonMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() >= 2) {
            this.launchFile();
        }
    }

    private void buttonMouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.contextMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void deleteMIActionPerformed(ActionEvent actionEvent) {
        this.deleteFile();
    }

    private void initComponents() {
        this.contextMenu = new JPopupMenu();
        this.launchMI = new JMenuItem();
        this.deleteMI = new JMenuItem();
        this.button = new JButton();
        this.label = new JLabel();
        this.launchMI.setText("Launch File (enter)");
        this.launchMI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JIcon.this.launchMIActionPerformed(actionEvent);
            }
        });
        this.contextMenu.add(this.launchMI);
        this.deleteMI.setText("Delete File (del)");
        this.deleteMI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JIcon.this.deleteMIActionPerformed(actionEvent);
            }
        });
        this.contextMenu.add(this.deleteMI);
        this.setLayout(new BorderLayout());
        this.setBackground((Color)UIManager.getDefaults().get("Panel.background"));
        this.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.button.setBackground((Color)UIManager.getDefaults().get("Button.background"));
        this.button.setBorder(null);
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JIcon.this.buttonActionPerformed(actionEvent);
            }
        });
        this.button.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                JIcon.this.buttonFocusGained(focusEvent);
            }

            public void focusLost(FocusEvent focusEvent) {
                JIcon.this.buttonFocusLost(focusEvent);
            }
        });
        this.button.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                JIcon.this.buttonKeyReleased(keyEvent);
            }
        });
        this.button.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                JIcon.this.buttonMouseClicked(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                JIcon.this.buttonMouseReleased(mouseEvent);
            }
        });
        this.add((Component)this.button, "North");
        this.label.setBackground(new Color(204, 204, 204));
        this.add((Component)this.label, "Center");
    }

    private void launchMIActionPerformed(ActionEvent actionEvent) {
        this.launchFile();
    }
}

