/*
 * Decompiled with CFR 0.152.
 */
package plugin.notes.gui;

import gmgen.GMGenSystem;
import gmgen.GMGenSystemView;
import gmgen.gui.ExtendedHTMLDocument;
import gmgen.gui.ExtendedHTMLEditorKit;
import gmgen.gui.ImageFileChooser;
import gmgen.io.SimpleFileFilter;
import gmgen.util.LogReceiver;
import gmgen.util.LogUtilities;
import gmgen.util.MiscUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ProgressMonitor;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import pcgen.core.SettingsHandler;
import pcgen.gui.panes.FlippingSplitPane;
import pcgen.util.Logging;
import plugin.notes.NotesPlugin;
import plugin.notes.gui.JIcon;
import plugin.notes.gui.NotesTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotesView
extends JPanel {
    protected DropTarget editAreaDT;
    protected DropTarget filesBarDT;
    protected DropTarget treeDT;
    protected ExtendedHTMLEditorKit.InsertListAction actionListOrdered = new ExtendedHTMLEditorKit.InsertListAction("InsertOLItem", HTML.Tag.OL);
    protected ExtendedHTMLEditorKit.InsertListAction actionListUnordered = new ExtendedHTMLEditorKit.InsertListAction("InsertULItem", HTML.Tag.UL);
    protected NotesPlugin plugin;
    protected NotesTreeNode root;
    protected RedoAction redoAction = new RedoAction();
    protected String dataDir;
    protected UndoAction undoAction = new UndoAction();
    protected UndoManager undo = new UndoManager();
    protected final String[] extsIMG = new String[]{"gif", "jpg", "jpeg", "png"};
    private JButton boldButton;
    private JButton bulletButton;
    private JButton centerJustifyButton;
    private JButton colorButton;
    private JButton copyButton;
    private JButton cutButton;
    private JButton deleteButton;
    private JButton enumButton;
    private JButton exportButton;
    private JButton fileLeft;
    private JButton fileRight;
    private JButton imageButton;
    private JButton italicButton;
    private JButton leftJustifyButton;
    private JButton newButton;
    private JButton pasteButton;
    private JButton revertButton;
    private JButton rightJustifyButton;
    private JButton saveButton;
    private JButton underlineButton;
    private JComboBox sizeCB;
    private JPanel filePane;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private FlippingSplitPane jSplitPane1;
    private JTextPane editor;
    private JToolBar alignmentBar;
    private JToolBar clipboardBar;
    private JToolBar fileBar;
    private JToolBar filesBar;
    private JToolBar formatBar;
    private JTree notesTree;

    public NotesView(String string, NotesPlugin notesPlugin) {
        this.plugin = notesPlugin;
        this.dataDir = string;
        this.initComponents();
        this.initEditingComponents();
        this.initDnDComponents();
        this.initTree();
        this.initFileBar(new ArrayList<File>());
        this.initLogging();
    }

    public Action getActionByName(JTextComponent jTextComponent, String string) {
        for (Action action : jTextComponent.getActions()) {
            if (!action.getValue("Name").equals(string)) continue;
            return action;
        }
        return null;
    }

    public void handleOpen() {
        String string = SettingsHandler.getGMGenOption((String)"Notes.LastFile", (String)System.getProperty("user.dir"));
        File file = new File(string);
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(file);
        for (FileFilter fileFilter : this.plugin.getFileTypes()) {
            jFileChooser.addChoosableFileFilter(fileFilter);
            jFileChooser.setFileFilter(fileFilter);
        }
        jFileChooser.setMultiSelectionEnabled(true);
        Cursor cursor = MiscUtilities.setBusyCursor((Component)GMGenSystem.inst);
        int n = jFileChooser.showOpenDialog((Component)GMGenSystem.inst);
        if (n == 0) {
            for (File file2 : jFileChooser.getSelectedFiles()) {
                SettingsHandler.setGMGenOption((String)"Notes.LastFile", (String)file2.toString());
                if (!file2.toString().endsWith(".gmn")) continue;
                this.openGMN(file2);
            }
        }
        MiscUtilities.setCursor((Component)GMGenSystem.inst, (Cursor)cursor);
        this.refreshTree();
    }

    public void initEditMenu(JMenu jMenu) {
        JMenuItem jMenuItem = new JMenuItem("Paste");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NotesView.this.pasteButtonActionPerformed(actionEvent);
            }
        });
        jMenu.insert(jMenuItem, 0);
        JMenuItem jMenuItem2 = new JMenuItem("Copy");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NotesView.this.copyButtonActionPerformed(actionEvent);
            }
        });
        jMenu.insert(jMenuItem2, 0);
        JMenuItem jMenuItem3 = new JMenuItem("Cut");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NotesView.this.cutButtonActionPerformed(actionEvent);
            }
        });
        jMenu.insert(jMenuItem3, 0);
        jMenu.insertSeparator(0);
        jMenu.insert(this.redoAction, 0);
        jMenu.insert(this.undoAction, 0);
    }

    public void openGMN(File file) {
        try {
            Object object = this.notesTree.getLastSelectedPathComponent();
            if (object instanceof NotesTreeNode) {
                ZipEntry zipEntry;
                int n;
                NotesTreeNode notesTreeNode = (NotesTreeNode)object;
                if (notesTreeNode != this.root && (n = JOptionPane.showConfirmDialog(this, "Importing note " + file.getName() + " into a node other then root, Continue?", "Importing to a node other then root", 0, 3)) == 1) {
                    return;
                }
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
                ProgressMonitor progressMonitor = new ProgressMonitor((Component)GMGenSystem.inst, "Reading Notes Export", "Reading", 1, 1000);
                int n2 = 1;
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    this.unzip(zipInputStream, zipEntry.getName(), notesTreeNode.getDir());
                    if (++n2 > 99) {
                        n2 = 99;
                    }
                    progressMonitor.setProgress(n2);
                }
                zipInputStream.close();
                progressMonitor.close();
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "Error Reading File" + file.getName());
            Logging.errorPrint((String)("Error Reading File" + file.getName()));
            Logging.errorPrint((String)iOException.getMessage(), (Throwable)iOException);
        }
    }

    public void refreshTree() {
        this.root.refresh();
        this.notesTree.updateUI();
    }

    public void windowClosed() {
        if (this.root.isTreeDirty()) {
            GMGenSystemView.getTabPane().setSelectedComponent(this);
        }
        this.root.checkSave();
    }

    protected void exportFile(NotesTreeNode notesTreeNode) {
        JFileChooser jFileChooser = new JFileChooser();
        String string = SettingsHandler.getGMGenOption((String)"Notes.LastFile", (String)"");
        new File(string);
        String[] stringArray = new String[]{"gmn"};
        SimpleFileFilter simpleFileFilter = new SimpleFileFilter(stringArray, "GMGen Notes Export");
        jFileChooser.addChoosableFileFilter((FileFilter)simpleFileFilter);
        jFileChooser.setFileFilter((FileFilter)simpleFileFilter);
        int n = jFileChooser.showSaveDialog(this);
        try {
            if (n == 0) {
                int n2;
                File file;
                String string2 = jFileChooser.getSelectedFile().getName();
                String string3 = jFileChooser.getSelectedFile().getParent();
                String string4 = "";
                if (string2.indexOf(".gmn") < 0) {
                    string4 = ".gmn";
                }
                if ((file = new File(string3 + File.separator + string2 + string4)).exists() && (n2 = JOptionPane.showConfirmDialog(this, "File Exists, Overwrite?", "File Exists", 0, 3)) == 1) {
                    return;
                }
                SettingsHandler.setGMGenOption((String)"Notes.LastFile", (String)file.toString());
                this.writeNotesFile(file, notesTreeNode);
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Error Writing File");
            Logging.errorPrint((String)("Error Writing to file: " + exception.getMessage()), (Throwable)exception);
        }
    }

    protected int fileCount(File file) {
        int n = 0;
        for (File file2 : file.listFiles()) {
            if (file2.isDirectory()) {
                n += this.fileCount(file2);
                continue;
            }
            ++n;
        }
        return n;
    }

    protected void highlightButton(JButton jButton) {
        jButton.setBorder(new BevelBorder(1));
    }

    protected void performTextPaneAction(String string, ActionEvent actionEvent) {
        Action action = this.getActionByName(this.editor, string);
        action.actionPerformed(actionEvent);
        this.editor.grabFocus();
        int n = this.editor.getCaretPosition();
        this.updateButtons(this.editor, n);
    }

    protected void stdButton(JButton jButton) {
        jButton.setBorder(new EtchedBorder(1));
    }

    protected void unzip(ZipInputStream zipInputStream, String string, File file) throws IOException {
        File file2 = new File(file.getPath() + File.separator + string);
        File file3 = file2.getParentFile();
        file3.mkdirs();
        file2.createNewFile();
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        byte[] byArray = new byte[512];
        int n = 0;
        while ((n = zipInputStream.read(byArray)) != -1) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileOutputStream.close();
    }

    protected void updateButtons(JTextPane jTextPane, int n) {
        StyledDocument styledDocument = jTextPane.getStyledDocument();
        AttributeSet attributeSet = styledDocument.getCharacterElement(n - 1).getAttributes();
        AttributeSet attributeSet2 = styledDocument.getCharacterElement(n).getAttributes();
        if (StyleConstants.isBold(attributeSet) && StyleConstants.isBold(attributeSet2)) {
            this.highlightButton(this.boldButton);
        } else {
            this.stdButton(this.boldButton);
        }
        if (StyleConstants.isItalic(attributeSet) && StyleConstants.isItalic(attributeSet2)) {
            this.highlightButton(this.italicButton);
        } else {
            this.stdButton(this.italicButton);
        }
        if (StyleConstants.isUnderline(attributeSet) && StyleConstants.isUnderline(attributeSet2)) {
            this.highlightButton(this.underlineButton);
        } else {
            this.stdButton(this.underlineButton);
        }
        int n2 = StyleConstants.getAlignment(attributeSet);
        this.stdButton(this.leftJustifyButton);
        this.stdButton(this.rightJustifyButton);
        this.stdButton(this.centerJustifyButton);
        if (n2 == 0) {
            this.highlightButton(this.leftJustifyButton);
        } else if (n2 == 2) {
            this.highlightButton(this.rightJustifyButton);
        } else if (n2 == 1) {
            this.highlightButton(this.centerJustifyButton);
        }
        int n3 = StyleConstants.getFontSize(attributeSet);
        for (int i = 0; i < this.sizeCB.getItemCount(); ++i) {
            String string = (String)this.sizeCB.getItemAt(i);
            if (!string.equals(Integer.toString(n3))) continue;
            this.sizeCB.setSelectedItem(string);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int writeNotesDir(ZipOutputStream zipOutputStream, File file, File file2, ProgressMonitor progressMonitor, int n) throws IOException {
        byte[] byArray = new byte[4096];
        int n2 = n;
        for (File file3 : file2.listFiles()) {
            if (progressMonitor.isCanceled()) {
                return 0;
            }
            if (file3.isDirectory()) {
                n2 = this.writeNotesDir(zipOutputStream, file, file3, progressMonitor, n2);
                continue;
            }
            FileInputStream fileInputStream = new FileInputStream(file3);
            try {
                int n3;
                String string = file.getParentFile().getAbsolutePath();
                ZipEntry zipEntry = new ZipEntry(file3.getAbsolutePath().substring(string.length() + 1));
                zipOutputStream.putNextEntry(zipEntry);
                while ((n3 = fileInputStream.read(byArray)) != -1) {
                    zipOutputStream.write(byArray, 0, n3);
                }
            }
            finally {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
            ++n2;
        }
        progressMonitor.setProgress(n2);
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeNotesFile(File file, NotesTreeNode notesTreeNode) throws IOException {
        File file2 = notesTreeNode.getDir();
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
        int n = this.fileCount(file2);
        ProgressMonitor progressMonitor = new ProgressMonitor((Component)GMGenSystem.inst, "Writing out Notes Export", "Writing", 0, n);
        try {
            this.writeNotesDir(zipOutputStream, file2, file2, progressMonitor, 0);
        }
        finally {
            try {
                zipOutputStream.close();
            }
            catch (IOException iOException) {}
        }
        progressMonitor.close();
    }

    private File getCurrentDir() {
        Object object = this.notesTree.getLastSelectedPathComponent();
        if (object instanceof NotesTreeNode) {
            NotesTreeNode notesTreeNode = (NotesTreeNode)object;
            return notesTreeNode.getDir();
        }
        return null;
    }

    private File getImageFromChooser(String string, String[] stringArray, String string2) {
        ImageFileChooser imageFileChooser = new ImageFileChooser(string);
        imageFileChooser.setDialogType(2);
        imageFileChooser.setFileFilter((FileFilter)new SimpleFileFilter(stringArray, string2));
        imageFileChooser.setDialogTitle("Select an Image to Insert");
        int n = 1;
        n = imageFileChooser.showDialog((Component)this, "Insert");
        if (n == 0) {
            return imageFileChooser.getSelectedFile();
        }
        return null;
    }

    private void notesTreeNodesChanged() {
        Object object = this.notesTree.getLastSelectedPathComponent();
        if (object instanceof NotesTreeNode) {
            NotesTreeNode notesTreeNode = (NotesTreeNode)object;
            try {
                notesTreeNode.rename((String)notesTreeNode.getUserObject());
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        }
    }

    private void boldButtonActionPerformed(ActionEvent actionEvent) {
        this.performTextPaneAction("font-bold", actionEvent);
    }

    private void centerJustifyButtonActionPerformed(ActionEvent actionEvent) {
        StyledEditorKit.AlignmentAction alignmentAction = new StyledEditorKit.AlignmentAction("Align Centre", 1);
        alignmentAction.actionPerformed(actionEvent);
        this.editor.grabFocus();
        int n = this.editor.getCaretPosition();
        this.updateButtons(this.editor, n);
    }

    private void colorButtonActionPerformed() {
        AttributeSet attributeSet = this.editor.getCharacterAttributes();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(attributeSet);
        Color color = JColorChooser.showDialog((Component)GMGenSystem.inst, "Choose Text Color", this.editor.getStyledDocument().getForeground(attributeSet));
        if (color != null) {
            StyleConstants.setForeground(simpleAttributeSet, color);
            this.editor.setCharacterAttributes(simpleAttributeSet, true);
        }
        this.editor.repaint();
    }

    private void copyButtonActionPerformed(ActionEvent actionEvent) {
        this.performTextPaneAction("copy-to-clipboard", actionEvent);
    }

    private void cutButtonActionPerformed(ActionEvent actionEvent) {
        this.performTextPaneAction("cut-to-clipboard", actionEvent);
    }

    private void deleteButtonActionPerformed() {
        Object object = this.notesTree.getLastSelectedPathComponent();
        if (object instanceof NotesTreeNode) {
            NotesTreeNode notesTreeNode = (NotesTreeNode)object;
            notesTreeNode.delete();
        }
        this.notesTree.updateUI();
    }

    private void editorCaretUpdate(CaretEvent caretEvent) {
        int n = caretEvent.getDot();
        this.updateButtons(this.editor, n);
        Object object = this.notesTree.getLastSelectedPathComponent();
        if (object instanceof NotesTreeNode) {
            NotesTreeNode notesTreeNode = (NotesTreeNode)object;
            if (notesTreeNode.isDirty()) {
                this.revertButton.setEnabled(true);
            } else {
                this.revertButton.setEnabled(false);
            }
        }
    }

    private void editorKeyTyped(KeyEvent keyEvent) {
        this.editor.getCaretPosition();
        this.editor.getStyledDocument();
        if (keyEvent.getKeyChar() == '\b') {
            this.handleBackspace();
        } else if (keyEvent.getKeyChar() == '\n') {
            this.handleEnter();
        }
    }

    private void editorUndoableEditHappened(UndoableEditEvent undoableEditEvent) {
        this.undo.addEdit(undoableEditEvent.getEdit());
        this.undoAction.updateUndoState();
        this.redoAction.updateRedoState();
    }

    private void exportButtonActionPerformed() {
        Object object = this.notesTree.getLastSelectedPathComponent();
        if (object instanceof NotesTreeNode) {
            NotesTreeNode notesTreeNode = (NotesTreeNode)object;
            this.exportFile(notesTreeNode);
        }
    }

    private void fileLeftActionPerformed() {
        if (this.filesBar.getComponentCount() > 1) {
            Component component = this.filesBar.getComponent(this.filesBar.getComponentCount() - 1);
            this.filesBar.remove(component);
            this.filesBar.add(component, 0);
        }
        this.filesBar.updateUI();
    }

    private void fileRightActionPerformed() {
        if (this.filesBar.getComponentCount() > 1) {
            Component component = this.filesBar.getComponent(0);
            this.filesBar.remove(component);
            this.filesBar.add(component);
        }
        this.filesBar.updateUI();
    }

    private void handleBackspace() {
        int n = this.editor.getCaretPosition();
        ExtendedHTMLDocument extendedHTMLDocument = (ExtendedHTMLDocument)this.editor.getStyledDocument();
        try {
            if (n > 0) {
                if (this.editor.getSelectedText() != null) {
                    ExtendedHTMLEditorKit.delete((JTextPane)this.editor);
                    return;
                }
                int n2 = extendedHTMLDocument.getParagraphElement(n).getStartOffset();
                if (n2 == this.editor.getSelectionStart()) {
                    boolean bl = true;
                    if (ExtendedHTMLEditorKit.checkParentsTag((Element)extendedHTMLDocument.getParagraphElement(this.editor.getCaretPosition()), (HTML.Tag)HTML.Tag.LI)) {
                        int n3;
                        Element element = ExtendedHTMLEditorKit.getListItemParent((Element)extendedHTMLDocument.getCharacterElement(this.editor.getCaretPosition()));
                        bl = false;
                        int n4 = element.getStartOffset();
                        if (n4 + 1 < (n3 = element.getEndOffset())) {
                            char[] cArray = this.editor.getText(n4, n3 - n4).toCharArray();
                            for (int i = 0; i < cArray.length; ++i) {
                                if (Character.isWhitespace(cArray[i])) continue;
                                bl = true;
                            }
                        }
                        if (!bl) {
                            element.getParentElement();
                            ExtendedHTMLEditorKit.removeTag((JTextPane)this.editor, (Element)element, (boolean)true);
                            this.editor.setCaretPosition(n2 - 1);
                            return;
                        }
                        this.editor.setCaretPosition(this.editor.getCaretPosition() - 1);
                        this.editor.moveCaretPosition(this.editor.getCaretPosition() - 2);
                        this.editor.replaceSelection("");
                        return;
                    }
                }
                this.editor.replaceSelection("");
                return;
            }
        }
        catch (BadLocationException badLocationException) {
            Logging.errorPrint((String)badLocationException.getMessage(), (Throwable)badLocationException);
        }
    }

    private void handleEnter() {
        int n = this.editor.getCaretPosition();
        int n2 = -1;
        ExtendedHTMLDocument extendedHTMLDocument = (ExtendedHTMLDocument)this.editor.getStyledDocument();
        try {
            if (ExtendedHTMLEditorKit.checkParentsTag((Element)extendedHTMLDocument.getParagraphElement(this.editor.getCaretPosition()), (HTML.Tag)HTML.Tag.UL) || ExtendedHTMLEditorKit.checkParentsTag((Element)extendedHTMLDocument.getParagraphElement(this.editor.getCaretPosition()), (HTML.Tag)HTML.Tag.OL)) {
                int n3;
                Element element = ExtendedHTMLEditorKit.getListItemParent((Element)extendedHTMLDocument.getCharacterElement(this.editor.getCaretPosition()));
                int n4 = element.getStartOffset();
                int n5 = element.getEndOffset();
                char[] cArray = this.editor.getText(n4, n5 - n4).toCharArray();
                boolean bl = false;
                for (n3 = 0; n3 < cArray.length; ++n3) {
                    if (Character.isWhitespace(cArray[n3])) continue;
                    bl = true;
                }
                if (bl) {
                    n3 = -1;
                    int n6 = cArray.length;
                    do {
                        if (!Character.isLetterOrDigit(cArray[--n6])) continue;
                        n3 = n6;
                    } while (n3 == -1 && n6 >= 0);
                    n6 = n3;
                    do {
                        if (Character.isSpaceChar(cArray[++n6])) continue;
                        n2 = n6 - n3 - 1;
                    } while (n2 == -1 && n6 < cArray.length);
                    if (n2 == -1) {
                        n2 = 0;
                    }
                }
                if (element.getStartOffset() == element.getEndOffset() || !bl) {
                    this.manageListElement(extendedHTMLDocument);
                } else if (this.editor.getCaretPosition() + 1 == element.getEndOffset()) {
                    ExtendedHTMLEditorKit.insertListElement((JTextPane)this.editor, (String)"");
                    this.editor.setCaretPosition(n - n2);
                } else {
                    n3 = this.editor.getCaretPosition();
                    String string = this.editor.getText(n3, n5 - n3);
                    this.editor.select(n3, n5 - 1);
                    this.editor.replaceSelection("");
                    ExtendedHTMLEditorKit.insertListElement((JTextPane)this.editor, (String)string);
                    Element element2 = ExtendedHTMLEditorKit.getListItemParent((Element)extendedHTMLDocument.getCharacterElement(this.editor.getCaretPosition()));
                    this.editor.setCaretPosition(element2.getEndOffset());
                }
            }
        }
        catch (BadLocationException badLocationException) {
            Logging.errorPrint((String)badLocationException.getMessage(), (Throwable)badLocationException);
        }
    }

    private void imageButtonActionPerformed() {
        try {
            this.insertLocalImage(null);
        }
        catch (Exception exception) {
            Logging.errorPrint((String)exception.getMessage(), (Throwable)exception);
        }
    }

    private void initComponents() {
        this.jSplitPane1 = new FlippingSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.notesTree = new JTree();
        this.jPanel1 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.editor = new JTextPane();
        this.jPanel2 = new JPanel();
        this.fileBar = new JToolBar();
        this.newButton = new JButton();
        this.saveButton = new JButton();
        this.exportButton = new JButton();
        this.revertButton = new JButton();
        this.deleteButton = new JButton();
        this.clipboardBar = new JToolBar();
        this.cutButton = new JButton();
        this.copyButton = new JButton();
        this.pasteButton = new JButton();
        this.formatBar = new JToolBar();
        this.sizeCB = new JComboBox();
        this.boldButton = new JButton();
        this.italicButton = new JButton();
        this.underlineButton = new JButton();
        this.colorButton = new JButton();
        this.bulletButton = new JButton();
        this.enumButton = new JButton();
        this.imageButton = new JButton();
        this.alignmentBar = new JToolBar();
        this.leftJustifyButton = new JButton();
        this.centerJustifyButton = new JButton();
        this.rightJustifyButton = new JButton();
        this.filePane = new JPanel();
        this.fileLeft = new JButton();
        this.fileRight = new JButton();
        this.filesBar = new JToolBar();
        this.setLayout(new BorderLayout());
        this.jSplitPane1.setDividerLocation(175);
        this.jSplitPane1.setDividerSize(5);
        this.jScrollPane1.setViewportView(this.notesTree);
        this.jSplitPane1.setLeftComponent((Component)this.jScrollPane1);
        this.jPanel1.setLayout(new BorderLayout());
        this.editor.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                NotesView.this.editorCaretUpdate(caretEvent);
            }
        });
        this.jScrollPane2.setViewportView(this.editor);
        this.jPanel1.add((Component)this.jScrollPane2, "Center");
        this.jPanel2.setLayout(new FlowLayout(0, 0, 0));
        this.newButton.setIcon(new ImageIcon(this.getClass().getResource("/pcgen/gui/resource/stock_new-16.png")));
        this.newButton.setToolTipText("New Node");
        this.newButton.setBorder(new EtchedBorder());
        this.newButton.setEnabled(false);
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NotesView.this.newButtonActionPerformed();
            }
        });
        this.fileBar.add(this.newButton);
        this.saveButton.setIcon(new ImageIcon(this.getClass().getResource("/pcgen/gui/resource/stock_save-16.png")));
        this.saveButton.setToolTipText("Save Node");
        this.saveButton.setBorder(new EtchedBorder());
        this.saveButton.setEnabled(false);
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NotesView.this.saveButtonActionPerformed();
            }
        });
        this.fileBar.add(this.saveButton);
        this.exportButton.setIcon(new ImageIcon(this.getClass().getResource("/pcgen/gui/resource/stock_export-16.png")));
        this.exportButton.setToolTipText("Export");
        this.exportButton.setBorder(new EtchedBorder());
        this.exportButton.setEnabled(false);
        this.exportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NotesView.this.exportButtonActionPerformed();
            }
        });
        this.fileBar.add(this.exportButton);
        this.revertButton.setIcon(new ImageIcon(this.getClass().getResource("/pcgen/gui/resource/stock_revert-16.png")));
        this.revertButton.setToolTipText("Revert to Saved");
        this.revertButton.setBorder(new EtchedBorder());
        this.revertButton.setEnabled(false);
        this.revertButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NotesView.this.revertButtonActionPerformed();
            }
        });
        this.fileBar.add(this.revertButton);
        this.deleteButton.setIcon(new ImageIcon(this.getClass().getResource("/pcgen/gui/resource/stock_broken_image-16.png")));
        this.deleteButton.setToolTipText("Delete Node");
        this.deleteButton.setBorder(new EtchedBorder());
        this.deleteButton.setEnabled(false);
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NotesView.this.deleteButtonActionPerformed();
            }
        });
        this.fileBar.add(this.deleteButton);
        this.jPanel2.add(this.fileBar);
        this.cutButton.setIcon(new ImageIcon(this.getClass().getResource("/pcgen/gui/resource/stock_cut-16.png")));
        this.cutButton.setToolTipText("Cut");
        this.cutButton.setBorder(new EtchedBorder());
        this.cutButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NotesView.this.cutButtonActionPerformed(actionEvent);
            }
        });
        this.clipboardBar.add(this.cutButton);
        this.copyButton.setIcon(new ImageIcon(this.getClass().getResource("/pcgen/gui/resource/stock_copy-16.png")));
        this.copyButton.setToolTipText("Copy");
        this.copyButton.setBorder(new EtchedBorder());
        this.copyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NotesView.this.copyButtonActionPerformed(actionEvent);
            }
        });
        this.clipboardBar.add(this.copyButton);
        this.pasteButton.setIcon(new ImageIcon(this.getClass().getResource("/pcgen/gui/resource/stock_paste-16.png")));
        this.pasteButton.setToolTipText("Paste");
        this.pasteButton.setBorder(new EtchedBorder());
        this.pasteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NotesView.this.pasteButtonActionPerformed(actionEvent);
            }
        });
        this.clipboardBar.add(this.pasteButton);
        this.jPanel2.add(this.clipboardBar);
        this.sizeCB.setToolTipText("Size");
        this.sizeCB.setBorder(new EtchedBorder());
        this.sizeCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NotesView.this.sizeCBActionPerformed(actionEvent);
            }
        });
        this.formatBar.add(this.sizeCB);
        this.boldButton.setIcon(new ImageIcon(this.getClass().getResource("/pcgen/gui/resource/stock_text_bold-16.png")));
        this.boldButton.setToolTipText("Bold");
        this.boldButton.setBorder(new EtchedBorder());
        this.boldButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NotesView.this.boldButtonActionPerformed(actionEvent);
            }
        });
        this.formatBar.add(this.boldButton);
        this.italicButton.setIcon(new ImageIcon(this.getClass().getResource("/pcgen/gui/resource/stock_text_italic-16.png")));
        this.italicButton.setToolTipText("Italic");
        this.italicButton.setBorder(new EtchedBorder());
        this.italicButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NotesView.this.italicButtonActionPerformed(actionEvent);
            }
        });
        this.formatBar.add(this.italicButton);
        this.underlineButton.setIcon(new ImageIcon(this.getClass().getResource("/pcgen/gui/resource/stock_text_underline-16.png")));
        this.underlineButton.setToolTipText("Underline");
        this.underlineButton.setBorder(new EtchedBorder());
        this.underlineButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NotesView.this.underlineButtonActionPerformed(actionEvent);
            }
        });
        this.formatBar.add(this.underlineButton);
        this.colorButton.setForeground(new Color(0, 0, 0));
        this.colorButton.setIcon(new ImageIcon(this.getClass().getResource("/pcgen/gui/resource/menu-mode-RGB-alt.png")));
        this.colorButton.setToolTipText("Color");
        this.colorButton.setBorder(new EtchedBorder());
        this.colorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NotesView.this.colorButtonActionPerformed();
            }
        });
        this.formatBar.add(this.colorButton);
        this.bulletButton.setIcon(new ImageIcon(this.getClass().getResource("/pcgen/gui/resource/stock_list_bulet-16.png")));
        this.bulletButton.setToolTipText("Bulleted List");
        this.bulletButton.setAction((Action)this.actionListUnordered);
        this.bulletButton.setBorder(new EtchedBorder());
        this.formatBar.add(this.bulletButton);
        this.enumButton.setIcon(new ImageIcon(this.getClass().getResource("/pcgen/gui/resource/stock_list_enum-16.png")));
        this.enumButton.setToolTipText("Numbered List");
        this.enumButton.setAction((Action)this.actionListOrdered);
        this.enumButton.setBorder(new EtchedBorder());
        this.formatBar.add(this.enumButton);
        this.imageButton.setIcon(new ImageIcon(this.getClass().getResource("/pcgen/gui/resource/stock_insert_graphic-16.png")));
        this.imageButton.setBorder(new EtchedBorder());
        this.imageButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NotesView.this.imageButtonActionPerformed();
            }
        });
        this.formatBar.add(this.imageButton);
        this.jPanel2.add(this.formatBar);
        this.leftJustifyButton.setIcon(new ImageIcon(this.getClass().getResource("/pcgen/gui/resource/stock_text_align_left-16.png")));
        this.leftJustifyButton.setToolTipText("Left Justify");
        this.leftJustifyButton.setBorder(new EtchedBorder());
        this.leftJustifyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NotesView.this.leftJustifyButtonActionPerformed(actionEvent);
            }
        });
        this.alignmentBar.add(this.leftJustifyButton);
        this.centerJustifyButton.setIcon(new ImageIcon(this.getClass().getResource("/pcgen/gui/resource/stock_text_align_center-16.png")));
        this.centerJustifyButton.setToolTipText("Center");
        this.centerJustifyButton.setBorder(new EtchedBorder());
        this.centerJustifyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NotesView.this.centerJustifyButtonActionPerformed(actionEvent);
            }
        });
        this.alignmentBar.add(this.centerJustifyButton);
        this.rightJustifyButton.setIcon(new ImageIcon(this.getClass().getResource("/pcgen/gui/resource/stock_text_align_right-16.png")));
        this.rightJustifyButton.setToolTipText("Right Justify");
        this.rightJustifyButton.setBorder(new EtchedBorder());
        this.rightJustifyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NotesView.this.rightJustifyButtonActionPerformed(actionEvent);
            }
        });
        this.alignmentBar.add(this.rightJustifyButton);
        this.jPanel2.add(this.alignmentBar);
        this.jPanel1.add((Component)this.jPanel2, "North");
        this.filePane.setLayout(new BoxLayout(this.filePane, 0));
        this.fileLeft.setText("<");
        this.fileLeft.setBorder(new EtchedBorder());
        this.fileLeft.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NotesView.this.fileLeftActionPerformed();
            }
        });
        this.filePane.add(this.fileLeft);
        this.fileRight.setText(">");
        this.fileRight.setBorder(new EtchedBorder());
        this.fileRight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NotesView.this.fileRightActionPerformed();
            }
        });
        this.filePane.add(this.fileRight);
        this.filePane.add(this.filesBar);
        this.jPanel1.add((Component)this.filePane, "South");
        this.jSplitPane1.setRightComponent((Component)this.jPanel1);
        this.add((Component)this.jSplitPane1, "Center");
    }

    private void initDnDComponents() {
        this.filesBarDT = new DropTarget(this.filesBar, new DropBarListener());
        this.treeDT = new DropTarget(this.notesTree, new DropTreeListener());
    }

    private void initEditingComponents() {
        this.bulletButton.setIcon(new ImageIcon(this.getClass().getResource("/pcgen/gui/resource/stock_list_bulet-16.png")));
        this.bulletButton.setToolTipText("Bulleted List");
        this.enumButton.setIcon(new ImageIcon(this.getClass().getResource("/pcgen/gui/resource/stock_list_enum-16.png")));
        this.enumButton.setToolTipText("Numbered List");
        this.enumButton.setText("");
        this.bulletButton.setText("");
        Vector<String> vector = new Vector<String>();
        vector.add("8");
        vector.add("10");
        vector.add("12");
        vector.add("14");
        vector.add("16");
        vector.add("18");
        vector.add("24");
        vector.add("36");
        vector.add("48");
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(vector);
        this.sizeCB.setModel(defaultComboBoxModel);
        this.sizeCB.setBorder(new EtchedBorder(1));
        this.stdButton(this.boldButton);
        this.stdButton(this.italicButton);
        this.stdButton(this.underlineButton);
        this.stdButton(this.colorButton);
        this.stdButton(this.leftJustifyButton);
        this.stdButton(this.centerJustifyButton);
        this.stdButton(this.rightJustifyButton);
        this.stdButton(this.newButton);
        this.stdButton(this.saveButton);
        this.stdButton(this.deleteButton);
        this.stdButton(this.cutButton);
        this.stdButton(this.copyButton);
        this.stdButton(this.pasteButton);
    }

    private void initFileBar(List<File> list) {
        this.filePane.removeAll();
        this.filesBar.removeAll();
        if (list.size() > 0) {
            this.filePane.add(this.fileLeft);
            this.filePane.add(this.fileRight);
            this.filePane.add(this.filesBar);
            for (File file : list) {
                this.filesBar.add(new JIcon(file, this.plugin));
            }
        }
        this.filePane.updateUI();
    }

    private void initLogging() {
        LogUtilities.inst().addReceiver((LogReceiver)new NotesLogReciever());
    }

    private void initTree() {
        File file = new File(this.dataDir);
        file.listFiles();
        this.root = new NotesTreeNode(file.getName(), file, this.notesTree);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(this.root);
        this.notesTree.setModel(defaultTreeModel);
        this.notesTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                NotesView.this.notesTreeActionPerformed();
            }
        });
        this.notesTree.getSelectionModel().setSelectionMode(1);
        this.notesTree.setEditable(true);
        defaultTreeModel.addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                NotesView.this.notesTreeNodesChanged();
            }

            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            }

            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            }

            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            }
        });
    }

    private void insertLocalImage(File file) throws IOException, BadLocationException, RuntimeException {
        File file2;
        File file3;
        File file4 = file;
        if (file == null && (file3 = this.getImageFromChooser((file2 = this.getCurrentDir()).getPath(), this.extsIMG, "Image File")) != null && file3.exists() && !(file4 = new File(file2.getAbsolutePath() + File.separator + file3.getName())).exists()) {
            MiscUtilities.copy((File)file3, (File)file4);
        }
        if (file4 != null) {
            int n = this.editor.getCaretPosition();
            file3 = (ExtendedHTMLEditorKit)this.editor.getEditorKit();
            ExtendedHTMLDocument extendedHTMLDocument = (ExtendedHTMLDocument)this.editor.getStyledDocument();
            file3.insertHTML((HTMLDocument)extendedHTMLDocument, n, "<IMG SRC=\"" + file4 + "\">", 0, 0, HTML.Tag.IMG);
            this.editor.setCaretPosition(n + 1);
        }
    }

    private void italicButtonActionPerformed(ActionEvent actionEvent) {
        this.performTextPaneAction("font-italic", actionEvent);
    }

    private void leftJustifyButtonActionPerformed(ActionEvent actionEvent) {
        StyledEditorKit.AlignmentAction alignmentAction = new StyledEditorKit.AlignmentAction("Left Justify", 0);
        alignmentAction.actionPerformed(actionEvent);
        this.editor.grabFocus();
        int n = this.editor.getCaretPosition();
        this.updateButtons(this.editor, n);
    }

    private void manageListElement(ExtendedHTMLDocument extendedHTMLDocument) {
        Element element = ExtendedHTMLEditorKit.getListItemParent((Element)extendedHTMLDocument.getCharacterElement(this.editor.getCaretPosition()));
        element.getParentElement();
        ExtendedHTMLEditorKit.removeTag((JTextPane)this.editor, (Element)element, (boolean)true);
    }

    private void newButtonActionPerformed() {
        Object object = this.notesTree.getLastSelectedPathComponent();
        if (object instanceof NotesTreeNode) {
            NotesTreeNode notesTreeNode = (NotesTreeNode)object;
            notesTreeNode.createChild();
        }
        this.refreshTree();
    }

    private void notesTreeActionPerformed() {
        this.refreshTreeNodes();
    }

    private void pasteButtonActionPerformed(ActionEvent actionEvent) {
        this.performTextPaneAction("paste-from-clipboard", actionEvent);
    }

    private void refreshTreeNodes() {
        Object object = this.notesTree.getLastSelectedPathComponent();
        if (object instanceof NotesTreeNode) {
            NotesTreeNode notesTreeNode = (NotesTreeNode)object;
            this.editor = notesTreeNode.getTextPane();
            this.root.checkCache();
            JViewport jViewport = new JViewport();
            jViewport.setView(this.editor);
            this.jScrollPane2.setViewport(jViewport);
            this.editAreaDT = new DropTarget(this.editor, new DropEditorListener());
            this.editor.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent caretEvent) {
                    NotesView.this.editorCaretUpdate(caretEvent);
                }
            });
            this.editor.addKeyListener(new KeyListener(){

                public void keyTyped(KeyEvent keyEvent) {
                    NotesView.this.editorKeyTyped(keyEvent);
                }

                public void keyPressed(KeyEvent keyEvent) {
                }

                public void keyReleased(KeyEvent keyEvent) {
                }
            });
            this.editor.getStyledDocument().addUndoableEditListener(new UndoableEditListener(){

                public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                    NotesView.this.editorUndoableEditHappened(undoableEditEvent);
                }
            });
            if (notesTreeNode.isLeaf()) {
                this.deleteButton.setEnabled(true);
            } else {
                this.deleteButton.setEnabled(false);
            }
            if (notesTreeNode == this.root) {
                this.exportButton.setEnabled(false);
            } else {
                this.exportButton.setEnabled(true);
            }
            if (notesTreeNode.isDirty()) {
                this.revertButton.setEnabled(true);
            } else {
                this.revertButton.setEnabled(false);
            }
            this.initFileBar(notesTreeNode.getFiles());
            this.saveButton.setEnabled(true);
            this.newButton.setEnabled(true);
        } else if (object == null) {
            this.deleteButton.setEnabled(false);
            this.saveButton.setEnabled(false);
            this.revertButton.setEnabled(false);
            this.newButton.setEnabled(false);
        }
    }

    private void revertButtonActionPerformed() {
        Object object = this.notesTree.getLastSelectedPathComponent();
        if (object instanceof NotesTreeNode) {
            NotesTreeNode notesTreeNode = (NotesTreeNode)object;
            notesTreeNode.revert();
            this.refreshTreeNodes();
            this.notesTree.updateUI();
        }
    }

    private void rightJustifyButtonActionPerformed(ActionEvent actionEvent) {
        StyledEditorKit.AlignmentAction alignmentAction = new StyledEditorKit.AlignmentAction("Right Justify", 2);
        alignmentAction.actionPerformed(actionEvent);
        this.editor.grabFocus();
        int n = this.editor.getCaretPosition();
        this.updateButtons(this.editor, n);
    }

    private void saveButtonActionPerformed() {
        Object object = this.notesTree.getLastSelectedPathComponent();
        if (object instanceof NotesTreeNode) {
            NotesTreeNode notesTreeNode = (NotesTreeNode)object;
            notesTreeNode.save();
        }
        this.revertButton.setEnabled(false);
        this.notesTree.updateUI();
    }

    private void sizeCBActionPerformed(ActionEvent actionEvent) {
        if (this.sizeCB.hasFocus()) {
            String string = (String)this.sizeCB.getSelectedItem();
            this.performTextPaneAction("font-size-" + string, actionEvent);
        }
    }

    private void underlineButtonActionPerformed(ActionEvent actionEvent) {
        this.performTextPaneAction("font-underline", actionEvent);
    }

    protected class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                NotesView.this.undo.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                Logging.errorPrint((String)("Unable to undo: " + cannotUndoException.getMessage()), (Throwable)cannotUndoException);
            }
            this.updateUndoState();
            NotesView.this.redoAction.updateRedoState();
        }

        protected void updateUndoState() {
            if (NotesView.this.undo.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", NotesView.this.undo.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Undo");
            }
        }
    }

    protected class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                NotesView.this.undo.redo();
            }
            catch (CannotRedoException cannotRedoException) {
                Logging.errorPrint((String)("Unable to redo: " + cannotRedoException));
            }
            this.updateRedoState();
            NotesView.this.undoAction.updateUndoState();
        }

        protected void updateRedoState() {
            if (NotesView.this.undo.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", NotesView.this.undo.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Redo");
            }
        }
    }

    public class NotesLogReciever
    implements LogReceiver {
        NotesTreeNode log;

        public void logMessage(String string, String string2) {
            if (this.log == null) {
                this.log = this.getChildNode("Logs", NotesView.this.root);
            }
            NotesTreeNode notesTreeNode = this.getChildNode(string, this.log);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM-dd-yyyy hh.mm.ss a z");
            notesTreeNode.appendText("<br>\n<b>" + simpleDateFormat.format(Calendar.getInstance().getTime()) + "</b> " + string2);
        }

        public void logMessage(String string) {
            this.logMessage("Misc", string);
        }

        private NotesTreeNode getChildNode(String string, NotesTreeNode notesTreeNode) {
            Enumeration enumeration = notesTreeNode.children();
            while (enumeration.hasMoreElements()) {
                NotesTreeNode notesTreeNode2 = (NotesTreeNode)enumeration.nextElement();
                if (!notesTreeNode2.getUserObject().equals(NotesTreeNode.checkName(string))) continue;
                return notesTreeNode2;
            }
            return notesTreeNode.createChild(string);
        }
    }

    public class DropTreeListener
    extends DropListener {
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            Point point = dropTargetDropEvent.getLocation();
            TreePath treePath = NotesView.this.notesTree.getPathForLocation(point.x, point.y);
            if (treePath == null) {
                dropTargetDropEvent.rejectDrop();
                return;
            }
            Object object = treePath.getLastPathComponent();
            if (object instanceof NotesTreeNode) {
                NotesTreeNode notesTreeNode = (NotesTreeNode)object;
                if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    dropTargetDropEvent.dropComplete(notesTreeNode.handleDropJavaFileList(dropTargetDropEvent));
                    NotesView.this.refreshTreeNodes();
                } else {
                    dropTargetDropEvent.rejectDrop();
                }
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }
    }

    public class DropEditorListener
    extends DropListener {
        public boolean isImageFile(File file) {
            for (int i = 0; i < NotesView.this.extsIMG.length; ++i) {
                if (!file.getName().endsWith(NotesView.this.extsIMG[i])) continue;
                return true;
            }
            return false;
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            Object object = NotesView.this.notesTree.getLastSelectedPathComponent();
            if (object instanceof NotesTreeNode) {
                if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    dropTargetDropEvent.dropComplete(this.handleDropJavaFileListAsImage(dropTargetDropEvent));
                    NotesView.this.refreshTreeNodes();
                } else {
                    dropTargetDropEvent.rejectDrop();
                }
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }

        public boolean handleDropJavaFileListAsImage(DropTargetDropEvent dropTargetDropEvent) {
            dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
            Transferable transferable = dropTargetDropEvent.getTransferable();
            try {
                List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                File file = NotesView.this.getCurrentDir();
                for (int i = 0; i < list.size(); ++i) {
                    File file2 = (File)list.get(i);
                    if (!file2.exists()) continue;
                    File file3 = new File(file.getAbsolutePath() + File.separator + file2.getName());
                    if (!this.isImageFile(file3) || !file3.exists()) {
                        MiscUtilities.copy((File)file2, (File)file3);
                    }
                    NotesView.this.editor.setCaretPosition(NotesView.this.editor.viewToModel(dropTargetDropEvent.getLocation()));
                    this.handleImageDropInsertion(file3);
                }
            }
            catch (Exception exception) {
                Logging.errorPrint((String)exception.getMessage(), (Throwable)exception);
                return false;
            }
            return true;
        }

        public void handleImageDropInsertion(File file) {
            for (String string : NotesView.this.extsIMG) {
                if (!file.getName().endsWith(string)) continue;
                try {
                    NotesView.this.insertLocalImage(file);
                }
                catch (Exception exception) {
                    Logging.errorPrint((String)exception.getMessage(), (Throwable)exception);
                }
                break;
            }
        }
    }

    public class DropBarListener
    extends DropListener {
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            Object object = NotesView.this.notesTree.getLastSelectedPathComponent();
            if (object instanceof NotesTreeNode) {
                NotesTreeNode notesTreeNode = (NotesTreeNode)object;
                if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    dropTargetDropEvent.dropComplete(notesTreeNode.handleDropJavaFileList(dropTargetDropEvent));
                    NotesView.this.refreshTreeNodes();
                } else {
                    dropTargetDropEvent.rejectDrop();
                }
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }
    }

    public abstract class DropListener
    implements DropTargetListener {
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            if (dropTargetDragEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (dropTargetDragEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }

        public abstract void drop(DropTargetDropEvent var1);

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }
    }
}

