/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.inst.EquipmentHead;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Equipment;
import pcgen.core.SettingsHandler;
import pcgen.core.SizeAdjustment;
import pcgen.core.WeaponProf;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.DeferredToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NaturalattacksLst
extends AbstractToken
implements CDOMPrimaryToken<CDOMObject>,
DeferredToken<CDOMObject> {
    private static final Class<WeaponProf> WEAPONPROF_CLASS = WeaponProf.class;

    public String getTokenName() {
        return "NATURALATTACKS";
    }

    public boolean parse(LoadContext loadContext, CDOMObject cDOMObject, String string) {
        if (this.isEmpty(string) || this.hasIllegalSeparator('|', string)) {
            return false;
        }
        int n = 1;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (this.hasIllegalSeparator(',', string2)) {
                return false;
            }
            Equipment equipment = this.createNaturalWeapon(loadContext, cDOMObject, string2);
            if (equipment == null) {
                Logging.log((Level)Logging.LST_ERROR, (String)("Natural Weapon Creation Failed for : " + string2));
                return false;
            }
            if (n == 1) {
                equipment.setModifiedName("Natural/Primary");
            } else {
                equipment.setModifiedName("Natural/Secondary");
            }
            equipment.setOutputIndex(0);
            equipment.setOutputSubindex(n);
            equipment.setQty(new Float(1.0f));
            equipment.setNumberCarried(new Float(1.0f));
            loadContext.obj.addToList(cDOMObject, ListKey.NATURAL_WEAPON, (Object)equipment);
            ++n;
        }
        return true;
    }

    private Equipment createNaturalWeapon(LoadContext loadContext, CDOMObject cDOMObject, String string) {
        Object object;
        int n;
        boolean bl;
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n2 = stringTokenizer.countTokens();
        if (n2 != 4 && n2 != 5) {
            Logging.errorPrint((String)("Invalid Build of Natural Weapon in " + this.getTokenName() + ": " + string));
            return null;
        }
        String string3 = stringTokenizer.nextToken();
        if (string3.equalsIgnoreCase("NONE")) {
            Logging.errorPrint((String)("Attempt to Build 'None' as a Natural Weapon in " + this.getTokenName() + ": " + string));
            return null;
        }
        Equipment equipment = new Equipment();
        equipment.setName(string3);
        equipment.put(ObjectKey.PARENT, (Object)cDOMObject);
        EquipmentHead equipmentHead = equipment.getEquipmentHead(1);
        String string4 = stringTokenizer.nextToken();
        if (this.hasIllegalSeparator('.', string4)) {
            return null;
        }
        StringTokenizer stringTokenizer2 = new StringTokenizer(string4, ".");
        while (stringTokenizer2.hasMoreTokens()) {
            string2 = Type.getConstant((String)stringTokenizer2.nextToken());
            equipment.addToListFor(ListKey.TYPE, (Object)string2);
        }
        string2 = stringTokenizer.nextToken();
        boolean bl2 = bl = string2.length() > 0 && string2.charAt(0) == '*';
        if (bl) {
            string2 = string2.substring(1);
        }
        equipment.put(ObjectKey.ATTACKS_PROGRESS, (Object)(!bl ? 1 : 0));
        try {
            n = Integer.parseInt(string2) - 1;
            object = Bonus.newBonus((String)("WEAPON|ATTACKS|" + n));
            if (object == null) {
                Logging.errorPrint((String)(this.getTokenName() + " was given invalid number of attacks: " + n));
                return null;
            }
            object.setCreatorObject((Object)equipment);
            equipment.addToListFor(ListKey.BONUS, object);
        }
        catch (NumberFormatException numberFormatException) {
            Logging.errorPrint((String)("Non-numeric value for number of attacks in " + this.getTokenName() + ": '" + string2 + "'"));
            return null;
        }
        equipmentHead.put(StringKey.DAMAGE, stringTokenizer.nextToken());
        n = 0;
        if (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            try {
                n = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                Logging.errorPrint((String)("Non-numeric value for hands required: '" + (String)object + "'"));
                return null;
            }
        }
        equipment.put(IntegerKey.SLOTS, Integer.valueOf(n));
        equipment.put(ObjectKey.WEIGHT, (Object)BigDecimal.ZERO);
        object = (WeaponProf)loadContext.ref.silentlyGetConstructedCDOMObject(WEAPONPROF_CLASS, string3);
        if (object == null) {
            object = (WeaponProf)loadContext.ref.constructNowIfNecessary(WEAPONPROF_CLASS, string3);
            object.addToListFor(ListKey.TYPE, (Object)Type.NATURAL);
        }
        CDOMSingleRef cDOMSingleRef = loadContext.ref.getCDOMReference(WEAPONPROF_CLASS, string3);
        equipment.put(ObjectKey.WEAPON_PROF, (Object)cDOMSingleRef);
        equipment.addToListFor(ListKey.IMPLIED_WEAPONPROF, (Object)cDOMSingleRef);
        equipmentHead.put(IntegerKey.CRIT_RANGE, Integer.valueOf(1));
        equipmentHead.put(IntegerKey.CRIT_MULT, Integer.valueOf(2));
        return equipment;
    }

    public String[] unparse(LoadContext loadContext, CDOMObject cDOMObject) {
        Changes changes = loadContext.getObjectContext().getListChanges(cDOMObject, ListKey.NATURAL_WEAPON);
        Collection collection = changes.getAdded();
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Equipment equipment : collection) {
            BonusObj bonusObj;
            List list;
            Equipment equipment2;
            String string;
            if (!bl) {
                stringBuilder.append("|");
            }
            if ((string = (equipment2 = (Equipment)Equipment.class.cast(equipment)).getDisplayName()) == null) {
                loadContext.addWriteMessage(this.getTokenName() + " expected Equipment to have a name");
                return null;
            }
            stringBuilder.append(string).append(",");
            List list2 = equipment2.getListFor(ListKey.TYPE);
            if (list2 == null || list2.isEmpty()) {
                loadContext.addWriteMessage(this.getTokenName() + " expected Equipment to have a type");
                return null;
            }
            stringBuilder.append(StringUtil.join((Collection)list2, (String)"."));
            stringBuilder.append(",");
            Boolean bl2 = (Boolean)equipment2.get(ObjectKey.ATTACKS_PROGRESS);
            if (bl2 == null) {
                loadContext.addWriteMessage(this.getTokenName() + " expected Equipment to know ATTACKS_PROGRESS state");
                return null;
            }
            if (!bl2.booleanValue()) {
                stringBuilder.append('*');
            }
            if ((list = equipment2.getListFor(ListKey.BONUS)) == null || list.isEmpty()) {
                stringBuilder.append("1");
            } else {
                if (list.size() != 1) {
                    loadContext.addWriteMessage(this.getTokenName() + " expected only one BONUS on Equipment: " + list);
                    return null;
                }
                bonusObj = (BonusObj)list.iterator().next();
                stringBuilder.append(Integer.parseInt(bonusObj.getValue()) + 1);
            }
            stringBuilder.append(",");
            bonusObj = equipment2.getEquipmentHeadReference(1);
            if (bonusObj == null) {
                loadContext.addWriteMessage(this.getTokenName() + " expected an EquipmentHead on Equipment");
                return null;
            }
            String string2 = bonusObj.get(StringKey.DAMAGE);
            if (string2 == null) {
                loadContext.addWriteMessage(this.getTokenName() + " expected a Damage on EquipmentHead");
                return null;
            }
            stringBuilder.append(string2);
            Integer n = equipment2.get(IntegerKey.SLOTS);
            if (n != null && n != 0) {
                stringBuilder.append(',').append(n);
            }
            bl = false;
        }
        return new String[]{stringBuilder.toString()};
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    public boolean process(LoadContext loadContext, CDOMObject cDOMObject) {
        List list = cDOMObject.getListFor(ListKey.NATURAL_WEAPON);
        if (list != null) {
            try {
                int n = cDOMObject.getSafe(FormulaKey.SIZE).resolve(null, "").intValue();
                SizeAdjustment sizeAdjustment = SettingsHandler.getGame().getSizeAdjustmentAtIndex(n);
                for (Equipment equipment : list) {
                    equipment.put(ObjectKey.BASESIZE, (Object)sizeAdjustment);
                    equipment.put(ObjectKey.SIZE, (Object)sizeAdjustment);
                }
            }
            catch (NullPointerException nullPointerException) {
                Logging.errorPrint((String)("SIZE in " + cDOMObject.getClass().getSimpleName() + " " + cDOMObject.getKeyName() + " must not be a variable " + "if it contains a NATURALATTACKS token"));
            }
        }
        return true;
    }

    public Class<CDOMObject> getDeferredTokenClass() {
        return this.getTokenClass();
    }
}

