/*
 * Decompiled with CFR 0.152.
 */
package plugin.charactersheet.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.cdom.enumeration.SourceFormat;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.character.CharacterSpell;
import pcgen.core.character.SpellInfo;
import pcgen.core.spell.Spell;
import plugin.charactersheet.gui.CharacterPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassSpellLevelPane
extends JPanel {
    private PlayerCharacter pc;
    private PCClass pcclass;
    private int level;
    private boolean racial = false;
    private List<Component> removeList = new ArrayList<Component>();
    private List<Component> lightList = new ArrayList<Component>();
    private List<Component> darkList = new ArrayList<Component>();
    private int serial = 0;
    private static final String DIALOG = "Dialog";
    private static final String NONE = "NONE";
    private static final String EFFECT = "Effect: ";
    private static final String TARGET = "Target: ";
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel13;
    private JPanel jPanel14;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JLabel known;
    private JLabel perDay;
    private JLabel title;

    public ClassSpellLevelPane() {
        this.initComponents();
        this.setColor();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.title = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.known = new JLabel();
        this.jLabel3 = new JLabel();
        this.perDay = new JLabel();
        this.jPanel4 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabel12 = new JLabel();
        this.jPanel5 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jPanel6 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jPanel7 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jPanel8 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jPanel9 = new JPanel();
        this.jLabel7 = new JLabel();
        this.jPanel10 = new JPanel();
        this.jLabel8 = new JLabel();
        this.jPanel11 = new JPanel();
        this.jLabel9 = new JLabel();
        this.jPanel12 = new JPanel();
        this.jLabel10 = new JLabel();
        this.jPanel13 = new JPanel();
        this.jLabel11 = new JLabel();
        this.jPanel14 = new JPanel();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.jLabel16 = new JLabel();
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(CharacterPanel.white);
        this.jPanel1.setLayout(new FlowLayout(1, 1, 0));
        this.title.setFont(new Font(DIALOG, 1, 16));
        this.jPanel1.add(this.title);
        this.add(this.jPanel1);
        this.jPanel2.setLayout(new FlowLayout(0, 1, 0));
        this.jLabel1.setFont(new Font(DIALOG, 1, 13));
        this.jLabel1.setText("  Known: ");
        this.jPanel2.add(this.jLabel1);
        this.known.setText(" ");
        this.jPanel2.add(this.known);
        this.jLabel3.setFont(new Font(DIALOG, 1, 13));
        this.jLabel3.setText("     Per Day: ");
        this.jPanel2.add(this.jLabel3);
        this.perDay.setFont(new Font(DIALOG, 1, 13));
        this.perDay.setText(" ");
        this.jPanel2.add(this.perDay);
        this.add(this.jPanel2);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel3.setLayout(new FlowLayout(0, 1, 0));
        this.jLabel12.setFont(new Font(DIALOG, 0, 10));
        this.jLabel12.setText(" ");
        this.jPanel3.add(this.jLabel12);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel5.setLayout(new FlowLayout(0, 1, 0));
        this.jLabel2.setFont(new Font(DIALOG, 1, 11));
        this.jLabel2.setText("Name");
        this.jPanel5.add(this.jLabel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)this.jPanel5, gridBagConstraints);
        this.jPanel6.setLayout(new FlowLayout(0, 1, 0));
        this.jLabel4.setFont(new Font(DIALOG, 1, 11));
        this.jLabel4.setText("DC   ");
        this.jPanel6.add(this.jLabel4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)this.jPanel6, gridBagConstraints);
        this.jPanel7.setLayout(new FlowLayout(0, 1, 0));
        this.jLabel5.setFont(new Font(DIALOG, 1, 11));
        this.jLabel5.setText("Saving Throw");
        this.jPanel7.add(this.jLabel5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)this.jPanel7, gridBagConstraints);
        this.jPanel8.setLayout(new FlowLayout(0, 1, 0));
        this.jLabel6.setFont(new Font(DIALOG, 1, 11));
        this.jLabel6.setText("Time");
        this.jPanel8.add(this.jLabel6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)this.jPanel8, gridBagConstraints);
        this.jPanel9.setLayout(new FlowLayout(0, 1, 0));
        this.jLabel7.setFont(new Font(DIALOG, 1, 11));
        this.jLabel7.setText("Duration");
        this.jPanel9.add(this.jLabel7);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)this.jPanel9, gridBagConstraints);
        this.jPanel10.setLayout(new FlowLayout(0, 1, 0));
        this.jLabel8.setFont(new Font(DIALOG, 1, 11));
        this.jLabel8.setText("Range");
        this.jPanel10.add(this.jLabel8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)this.jPanel10, gridBagConstraints);
        this.jPanel11.setLayout(new FlowLayout(0, 1, 0));
        this.jLabel9.setFont(new Font(DIALOG, 1, 11));
        this.jLabel9.setText("Comp.");
        this.jPanel11.add(this.jLabel9);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)this.jPanel11, gridBagConstraints);
        this.jPanel12.setLayout(new FlowLayout(0, 1, 0));
        this.jLabel10.setFont(new Font(DIALOG, 1, 11));
        this.jLabel10.setText("Spell Resistance ");
        this.jPanel12.add(this.jLabel10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)this.jPanel12, gridBagConstraints);
        this.jPanel13.setLayout(new FlowLayout(0, 1, 0));
        this.jLabel11.setFont(new Font(DIALOG, 1, 11));
        this.jLabel11.setText("School");
        this.jPanel13.add(this.jLabel11);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)this.jPanel13, gridBagConstraints);
        this.jPanel14.setLayout(new FlowLayout(0, 1, 0));
        this.jLabel13.setFont(new Font(DIALOG, 1, 11));
        this.jLabel13.setText("Source");
        this.jPanel14.add(this.jLabel13);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)this.jPanel14, gridBagConstraints);
        this.jLabel14.setFont(new Font(DIALOG, 1, 11));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 125, 0, 0);
        this.jPanel4.add((Component)this.jLabel14, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 45, 0, 0);
        this.jPanel4.add((Component)this.jLabel15, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 100, 0, 0);
        this.jPanel4.add((Component)this.jLabel16, gridBagConstraints);
        this.add(this.jPanel4);
    }

    public void setColor() {
        this.setBackground(CharacterPanel.white);
        this.jPanel1.setBackground(CharacterPanel.header);
        this.jPanel2.setBackground(CharacterPanel.header);
        this.jPanel4.setBackground(CharacterPanel.white);
        this.jPanel3.setBackground(CharacterPanel.header);
        this.jPanel5.setBackground(CharacterPanel.header);
        this.jPanel6.setBackground(CharacterPanel.header);
        this.jPanel7.setBackground(CharacterPanel.header);
        this.jPanel8.setBackground(CharacterPanel.header);
        this.jPanel9.setBackground(CharacterPanel.header);
        this.jPanel10.setBackground(CharacterPanel.header);
        this.jPanel11.setBackground(CharacterPanel.header);
        this.jPanel12.setBackground(CharacterPanel.header);
        this.jPanel13.setBackground(CharacterPanel.header);
        this.jPanel14.setBackground(CharacterPanel.header);
        for (Component component : this.lightList) {
            component.setBackground(CharacterPanel.bodyLight);
        }
        for (Component component : this.darkList) {
            component.setBackground(CharacterPanel.bodyMedLight);
        }
    }

    public void setPc(PlayerCharacter playerCharacter, PCClass pCClass, int n) {
        this.pc = playerCharacter;
        this.serial = 0;
        this.pcclass = pCClass;
        this.level = n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(pCClass.getDisplayClassName());
        stringBuffer.append(" Spells, Level ").append(n);
        this.title.setText(stringBuffer.toString());
    }

    public void setPc(PlayerCharacter playerCharacter) {
        if (this.pc != playerCharacter) {
            this.pc = playerCharacter;
            this.racial = true;
            this.serial = 0;
        }
    }

    public void refresh() {
        if (this.serial < this.pc.getSerial()) {
            String string;
            Collection collection;
            if (!this.racial) {
                int n = this.pcclass.getKnownForLevel(this.level, this.pc);
                if (n == 0) {
                    this.jLabel1.setVisible(false);
                    this.known.setVisible(false);
                } else {
                    this.known.setText(Integer.toString(n));
                }
                this.perDay.setText(this.pcclass.getCastForLevel(this.level, Globals.getDefaultSpellBook(), this.pc) + this.pcclass.getBonusCastForLevelString(this.level, Globals.getDefaultSpellBook(), this.pc));
                collection = this.pc.getCharacterSpells((PObject)this.pcclass, null, Globals.getDefaultSpellBook(), this.level);
                string = Globals.getDefaultSpellBook();
            } else {
                collection = this.pc.getSafeAssocList((Object)this.pc.getRace(), AssociationListKey.CHARACTER_SPELLS);
                string = "Innate";
            }
            for (Component component : this.removeList) {
                this.remove(component);
                this.jPanel4.remove(component);
            }
            this.removeList.clear();
            int n = 1;
            boolean bl = true;
            for (CharacterSpell characterSpell : collection) {
                List<Component> list;
                Color color;
                if (bl) {
                    color = CharacterPanel.bodyLight;
                    list = this.lightList;
                    bl = false;
                } else {
                    color = CharacterPanel.bodyMedLight;
                    list = this.darkList;
                    bl = true;
                }
                n = this.addLine(characterSpell, string, color, n, list);
            }
            this.serial = this.pc.getSerial();
        }
    }

    private int addLine(CharacterSpell characterSpell, String string, Color color, int n, List<Component> list) {
        Spell spell = characterSpell.getSpell();
        SpellInfo spellInfo = characterSpell.getSpellInfoFor(string, this.level, -1);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(color);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)jPanel, gridBagConstraints);
        this.removeList.add(jPanel);
        list.add(jPanel);
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel();
        jPanel2.setLayout(new FlowLayout(0, 1, 0));
        jPanel2.setBackground(color);
        jLabel.setFont(new Font(DIALOG, 1, 11));
        if (spellInfo != null) {
            jLabel.setText(new StringBuffer(spell.getOutputName()).append(spellInfo).toString());
        } else {
            jLabel.setText(new StringBuffer(spell.getOutputName()).toString());
        }
        jPanel2.add(jLabel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)jPanel2, gridBagConstraints);
        this.removeList.add(jPanel2);
        list.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        JLabel jLabel2 = new JLabel();
        jPanel3.setLayout(new FlowLayout(0, 1, 0));
        jPanel3.setBackground(color);
        jLabel2.setFont(new Font(DIALOG, 1, 10));
        String string2 = spell.getSaveInfo();
        if (!("".equals(string2) || "None".equals(string2) || "No".equals(string2))) {
            jLabel2.setText(Integer.toString(this.pc.getDC(spell, spellInfo)));
        }
        jPanel3.add(jLabel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)jPanel3, gridBagConstraints);
        this.removeList.add(jPanel3);
        list.add(jPanel3);
        JTextArea jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBackground(color);
        jTextArea.setFont(new Font(DIALOG, 0, 10));
        jTextArea.setText(spell.getSaveInfo());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = n;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)jTextArea, gridBagConstraints);
        this.removeList.add(jTextArea);
        list.add(jTextArea);
        JTextArea jTextArea2 = new JTextArea();
        jTextArea2.setLineWrap(true);
        jTextArea2.setWrapStyleWord(true);
        jTextArea2.setBackground(color);
        jTextArea2.setFont(new Font(DIALOG, 0, 10));
        jTextArea2.setText(spell.getCastingTime());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)jTextArea2, gridBagConstraints);
        this.removeList.add(jTextArea2);
        list.add(jTextArea2);
        JTextArea jTextArea3 = new JTextArea();
        jTextArea3.setLineWrap(true);
        jTextArea3.setWrapStyleWord(true);
        jTextArea3.setBackground(color);
        jTextArea3.setFont(new Font(DIALOG, 0, 10));
        jTextArea3.setText(this.pc.parseSpellString(characterSpell, spell.getDuration(), characterSpell.getOwner()));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = n;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)jTextArea3, gridBagConstraints);
        this.removeList.add(jTextArea3);
        list.add(jTextArea3);
        JPanel jPanel4 = new JPanel();
        JLabel jLabel3 = new JLabel();
        jPanel4.setLayout(new FlowLayout(0, 1, 0));
        jPanel4.setBackground(color);
        jLabel3.setFont(new Font(DIALOG, 1, 10));
        jLabel3.setText(this.pc.getSpellRange(characterSpell, characterSpell.getOwner(), spellInfo));
        jPanel4.add(jLabel3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = n;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)jPanel4, gridBagConstraints);
        this.removeList.add(jPanel4);
        list.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        JLabel jLabel4 = new JLabel();
        jPanel5.setLayout(new FlowLayout(0, 1, 0));
        jPanel5.setBackground(color);
        jLabel4.setFont(new Font(DIALOG, 1, 10));
        jLabel4.setText(spell.getComponentList());
        jPanel5.add(jLabel4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = n;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)jPanel5, gridBagConstraints);
        this.removeList.add(jPanel5);
        list.add(jPanel5);
        JTextArea jTextArea4 = new JTextArea();
        jTextArea4.setLineWrap(true);
        jTextArea4.setWrapStyleWord(true);
        jTextArea4.setBackground(color);
        jTextArea4.setFont(new Font(DIALOG, 0, 10));
        jTextArea4.setText(spell.getSpellResistance());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = n;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)jTextArea4, gridBagConstraints);
        this.removeList.add(jTextArea4);
        list.add(jTextArea4);
        JTextArea jTextArea5 = new JTextArea();
        jTextArea5.setLineWrap(true);
        jTextArea5.setWrapStyleWord(true);
        jTextArea5.setBackground(color);
        jTextArea5.setFont(new Font(DIALOG, 0, 10));
        StringBuffer stringBuffer = new StringBuffer(spell.getSchool());
        if (spell.getSubschool().length() > 0 && !NONE.equalsIgnoreCase(spell.getSubschool().trim())) {
            stringBuffer.append(' ').append('(').append(spell.getSubschool()).append(')');
        }
        if (spell.descriptor().length() > 0) {
            stringBuffer.append(' ').append('[').append(spell.descriptor()).append(']');
        }
        jTextArea5.setText(stringBuffer.toString());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = n;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)jTextArea5, gridBagConstraints);
        this.removeList.add(jTextArea5);
        list.add(jTextArea5);
        JPanel jPanel6 = new JPanel();
        JLabel jLabel5 = new JLabel();
        jPanel6.setLayout(new FlowLayout(0, 1, 0));
        jPanel6.setBackground(color);
        jLabel5.setFont(new Font(DIALOG, 1, 10));
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(SourceFormat.formatShort((CDOMObject)spell, (int)8));
        stringBuffer2.append(':').append(' ');
        stringBuffer2.append(spell.get(StringKey.SOURCE_PAGE));
        jLabel5.setText(stringBuffer2.toString());
        jPanel6.add(jLabel5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)jPanel6, gridBagConstraints);
        this.removeList.add(jPanel6);
        list.add(jPanel6);
        JPanel jPanel7 = new JPanel();
        jPanel7.setBackground(color);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)jPanel7, gridBagConstraints);
        this.removeList.add(jPanel7);
        list.add(jPanel7);
        JTextArea jTextArea6 = new JTextArea();
        jTextArea6.setLineWrap(true);
        jTextArea6.setWrapStyleWord(true);
        jTextArea6.setBackground(color);
        jTextArea6.setFont(new Font(DIALOG, 0, 10));
        jTextArea6.setText(new StringBuffer(EFFECT).append(this.pc.parseSpellString(characterSpell, this.pc.getDescription((PObject)spell), characterSpell.getOwner())).toString());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)jTextArea6, gridBagConstraints);
        this.removeList.add(jTextArea6);
        list.add(jTextArea6);
        JTextArea jTextArea7 = new JTextArea();
        jTextArea7.setLineWrap(true);
        jTextArea7.setWrapStyleWord(true);
        jTextArea7.setBackground(color);
        jTextArea7.setFont(new Font(DIALOG, 0, 10));
        jTextArea7.setText(new StringBuffer(TARGET).append(this.pc.parseSpellString(characterSpell, spell.getSafe(StringKey.TARGET_AREA), characterSpell.getOwner())).toString());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)jTextArea7, gridBagConstraints);
        this.removeList.add(jTextArea7);
        list.add(jTextArea7);
        return n;
    }

    public void destruct() {
        this.removeAll();
        this.removeList.clear();
        this.known = null;
        this.perDay = null;
        this.title = null;
        this.pc = null;
        this.pcclass = null;
        this.removeList = null;
        this.lightList.clear();
        this.lightList = null;
        this.darkList.clear();
        this.darkList = null;
    }
}

