/*
 * Decompiled with CFR 0.152.
 */
package plugin.charactersheet.gui;

import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;
import pcgen.core.PlayerCharacter;
import pcgen.io.exporttoken.VarToken;
import plugin.charactersheet.gui.CharacterPanel;

public class MusicPane
extends JPanel {
    private PlayerCharacter pc;
    private List<JCheckBox> checkList = new ArrayList<JCheckBox>();
    private Properties pcProperties;
    private boolean updateProperties = false;
    private JPanel checkPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JTextArea musicText;

    public MusicPane() {
        this.initComponents();
        this.setLocalColor();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.checkPanel = new JPanel();
        this.musicText = new JTextArea();
        this.setLayout(new BoxLayout(this, 1));
        this.jPanel1.setLayout(new FlowLayout(1, 1, 0));
        this.jLabel1.setFont(new Font("Dialog", 1, 14));
        this.jLabel1.setText("BARDIC MUSIC");
        this.jPanel1.add(this.jLabel1);
        this.add(this.jPanel1);
        this.jPanel3.setLayout(new BoxLayout(this.jPanel3, 0));
        this.jPanel2.setLayout(new FlowLayout(1, 1, 0));
        this.jLabel2.setFont(new Font("Dialog", 0, 10));
        this.jLabel2.setText("Uses Per Day");
        this.jPanel2.add(this.jLabel2);
        this.jPanel3.add(this.jPanel2);
        this.checkPanel.setLayout(new FlowLayout(1, 0, 1));
        this.jPanel3.add(this.checkPanel);
        this.add(this.jPanel3);
        this.musicText.setFont(new Font("Dialog", 0, 10));
        this.musicText.setLineWrap(true);
        this.musicText.setWrapStyleWord(true);
        this.add(this.musicText);
    }

    public void setColor() {
        this.setLocalColor();
        this.refresh();
    }

    public void setLocalColor() {
        this.jPanel1.setBackground(CharacterPanel.header);
        this.jPanel3.setBackground(CharacterPanel.border);
        this.jPanel2.setBackground(CharacterPanel.header);
        this.jPanel2.setBorder(new LineBorder(CharacterPanel.border));
        this.jPanel1.setBorder(new LineBorder(CharacterPanel.border));
        this.checkPanel.setBackground(CharacterPanel.white);
        this.checkPanel.setBorder(new LineBorder(CharacterPanel.border));
        this.musicText.setBorder(new LineBorder(CharacterPanel.border));
    }

    public void setPc(PlayerCharacter playerCharacter, Properties properties) {
        this.pc = playerCharacter;
        this.pcProperties = properties;
    }

    public void refresh() {
        int n = VarToken.getIntVarToken((PlayerCharacter)this.pc, (String)"BardicMusicLevel", (boolean)false);
        if (n > 0) {
            this.setVisible(true);
            this.musicText.setText("Effects (Perform ranks required): Inspire Courage(3), Countersong(3), Fascinate(3), Inspire Competence(6), Suggestion(9), Inspire Greatness(12), Song of Freedom (15), Inspire Heroics (18)");
            this.addCheckBoxes(n);
        } else {
            this.setVisible(false);
        }
        this.updatePane();
    }

    private void addCheckBoxes(int n) {
        if (this.checkList.size() != n) {
            this.checkList.clear();
            for (int i = 0; i < n; ++i) {
                JComponent jComponent;
                if (i % 5 == 0 && i != 0) {
                    jComponent = new JLabel();
                    jComponent.setFont(new Font("Dialog", 0, 10));
                    ((JLabel)jComponent).setText(" ");
                    this.checkPanel.add(jComponent);
                }
                jComponent = new JCheckBox();
                jComponent.setBackground(CharacterPanel.white);
                jComponent.setBorder(null);
                this.checkList.add((JCheckBox)jComponent);
                this.checkPanel.add(jComponent);
                ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        MusicPane.this.pc.setDirty(true);
                        MusicPane.this.updateProperties();
                    }
                });
            }
        }
    }

    public void updateProperties() {
        if (this.updateProperties) {
            int n = 0;
            for (JCheckBox jCheckBox : this.checkList) {
                if (!jCheckBox.isSelected()) continue;
                ++n;
            }
            this.pcProperties.put("cs.MusicPane", Integer.toString(n));
        }
    }

    public void updatePane() {
        try {
            int n = Integer.parseInt((String)this.pcProperties.get("cs.MusicPane"));
            for (JCheckBox jCheckBox : this.checkList) {
                if (n > 0) {
                    jCheckBox.setSelected(true);
                    --n;
                    continue;
                }
                jCheckBox.setSelected(false);
            }
            this.updateProperties = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void destruct() {
    }
}

