/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.DamageReduction;
import pcgen.core.prereq.Prerequisite;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrLst
extends AbstractToken
implements CDOMPrimaryToken<CDOMObject> {
    public String getTokenName() {
        return "DR";
    }

    public boolean parse(LoadContext loadContext, CDOMObject cDOMObject, String string) {
        if (this.isEmpty(string) || this.hasIllegalSeparator('|', string)) {
            return false;
        }
        if (".CLEAR".equals(string)) {
            loadContext.getObjectContext().removeList(cDOMObject, ListKey.DAMAGE_REDUCTION);
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        String string2 = stringTokenizer.nextToken();
        if (this.hasIllegalSeparator('/', string2)) {
            return false;
        }
        String[] stringArray = string2.split("/");
        if (stringArray.length != 2) {
            Logging.log((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " failed to build DamageReduction with value " + string));
            Logging.errorPrint((String)"  ...expected a String with one / as a separator");
            return false;
        }
        DamageReduction damageReduction = new DamageReduction(stringArray[0], stringArray[1]);
        if (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            Prerequisite prerequisite = this.getPrerequisite(string3);
            if (prerequisite == null) {
                return false;
            }
            damageReduction.addPrerequisite(prerequisite);
        }
        loadContext.getObjectContext().addToList(cDOMObject, ListKey.DAMAGE_REDUCTION, (Object)damageReduction);
        return true;
    }

    public String[] unparse(LoadContext loadContext, CDOMObject cDOMObject) {
        Changes changes = loadContext.getObjectContext().getListChanges(cDOMObject, ListKey.DAMAGE_REDUCTION);
        Collection collection = changes.getAdded();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (changes.includesGlobalClear()) {
            arrayList.add(".CLEAR");
        } else if (collection == null || collection.isEmpty()) {
            return null;
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        if (collection != null) {
            for (DamageReduction damageReduction : collection) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(damageReduction.getLSTformat());
                if (damageReduction.hasPrerequisites()) {
                    stringBuilder.append("|");
                    stringBuilder.append(loadContext.getPrerequisiteString((Collection)damageReduction.getPrerequisiteList()));
                }
                treeSet.add(stringBuilder.toString());
            }
        }
        arrayList.addAll(treeSet);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }
}

