/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.spell;

import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.Globals;
import pcgen.core.spell.Spell;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveinfoToken
extends AbstractToken
implements CDOMPrimaryToken<Spell> {
    public String getTokenName() {
        return "SAVEINFO";
    }

    public boolean parse(LoadContext loadContext, Spell spell, String string) {
        if (this.isEmpty(string) || this.hasIllegalSeparator('|', string)) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (".CLEAR".equals(string2)) {
                if (!bl) {
                    Logging.errorPrint((String)("Non-sensical use of .CLEAR in " + this.getTokenName() + ": " + string));
                    return false;
                }
                loadContext.getObjectContext().removeList((CDOMObject)spell, ListKey.SAVE_INFO);
            } else {
                loadContext.getObjectContext().addToList((CDOMObject)spell, ListKey.SAVE_INFO, (Object)string2);
                Globals.addSpellSaveInfoSet((String)string2);
            }
            bl = false;
        }
        return true;
    }

    public String[] unparse(LoadContext loadContext, Spell spell) {
        Changes changes = loadContext.getObjectContext().getListChanges((CDOMObject)spell, ListKey.SAVE_INFO);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Collection collection = changes.getAdded();
        boolean bl = changes.includesGlobalClear();
        if (bl) {
            stringBuilder.append(".CLEAR");
        }
        if (collection != null && !collection.isEmpty()) {
            if (bl) {
                stringBuilder.append("|");
            }
            stringBuilder.append(StringUtil.join((Collection)collection, (String)"|"));
        }
        if (stringBuilder.length() == 0) {
            loadContext.addWriteMessage(this.getTokenName() + " was expecting non-empty changes to include " + "added items or global clear");
            return null;
        }
        return new String[]{stringBuilder.toString()};
    }

    public Class<Spell> getTokenClass() {
        return Spell.class;
    }
}

