/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.kit;

import java.util.StringTokenizer;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.Kit;
import pcgen.core.PCStat;
import pcgen.core.kit.BaseKit;
import pcgen.core.kit.KitStat;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.rules.persistence.token.DeferredToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatToken
extends AbstractToken
implements CDOMSecondaryToken<KitStat>,
DeferredToken<Kit> {
    public String getTokenName() {
        return "STAT";
    }

    public Class<KitStat> getTokenClass() {
        return KitStat.class;
    }

    public String getParentToken() {
        return "*KITTOKEN";
    }

    public boolean parse(LoadContext loadContext, KitStat kitStat, String string) {
        if (this.isEmpty(string) || this.hasIllegalSeparator('|', string)) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(61);
            if (n == -1) {
                Logging.errorPrint((String)("Illegal " + this.getTokenName() + " did not have Stat=X format: " + string));
                return false;
            }
            if (n != string2.lastIndexOf(61)) {
                Logging.errorPrint((String)("Illegal " + this.getTokenName() + " had two equal signs, is not Stat=X format: " + string));
                return false;
            }
            String string3 = string2.substring(0, n);
            PCStat pCStat = (PCStat)loadContext.ref.getAbbreviatedObject(PCStat.class, string3);
            if (pCStat == null) {
                Logging.errorPrint((String)("Unable to find STAT: " + string3));
                return false;
            }
            String string4 = string2.substring(n + 1);
            if (string4.length() == 0) {
                Logging.errorPrint((String)("Unable to find STAT value: " + string));
                return false;
            }
            Formula formula = FormulaFactory.getFormulaFor((String)string4);
            kitStat.addStat(pCStat, formula);
        }
        return true;
    }

    public String[] unparse(LoadContext loadContext, KitStat kitStat) {
        String[] stringArray;
        if (kitStat.isEmpty()) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = kitStat.toString();
        }
        return stringArray;
    }

    public boolean process(LoadContext loadContext, Kit kit) {
        for (BaseKit baseKit : kit.getSafeListFor(ListKey.KIT_TASKS)) {
            if (!(baseKit instanceof KitStat)) continue;
            kit.removeFromListFor(ListKey.KIT_TASKS, (Object)baseKit);
            kit.addStat((KitStat)baseKit);
        }
        return true;
    }

    public Class<Kit> getDeferredTokenClass() {
        return Kit.class;
    }
}

