/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.template;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Category;
import pcgen.cdom.base.ChoiceActor;
import pcgen.cdom.base.ChoiceSet;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.base.PersistentChoiceActor;
import pcgen.cdom.base.PersistentTransitionChoice;
import pcgen.cdom.base.PrimitiveChoiceSet;
import pcgen.cdom.choiceset.AbilityRefChoiceSet;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.helper.AbilityRef;
import pcgen.cdom.helper.AbilitySelection;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.AbilityUtilities;
import pcgen.core.PCTemplate;
import pcgen.core.PlayerCharacter;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.DeferredToken;
import pcgen.util.Logging;
import pcgen.util.enumeration.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatToken
extends AbstractToken
implements CDOMPrimaryToken<PCTemplate>,
PersistentChoiceActor<AbilitySelection>,
DeferredToken<PCTemplate> {
    private static final Class<Ability> ABILITY_CLASS = Ability.class;

    public String getTokenName() {
        return "FEAT";
    }

    public boolean parse(LoadContext loadContext, PCTemplate pCTemplate, String string) {
        if (this.isEmpty(string) || this.hasIllegalSeparator('|', string)) {
            return false;
        }
        loadContext.getObjectContext().removeList((CDOMObject)pCTemplate, ListKey.FEAT_TOKEN_LIST);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (".CLEAR".equals(string2)) {
                if (!bl) {
                    Logging.errorPrint((String)("  Non-sensical " + this.getTokenName() + ": .CLEAR was not the first list item: " + string));
                    return false;
                }
            } else {
                CDOMReference cDOMReference = TokenUtilities.getTypeOrPrimitive((LoadContext)loadContext, ABILITY_CLASS, (Category)AbilityCategory.FEAT, (String)string2);
                if (cDOMReference == null) {
                    return false;
                }
                loadContext.getObjectContext().addToList((CDOMObject)pCTemplate, ListKey.FEAT_TOKEN_LIST, (Object)cDOMReference);
            }
            bl = false;
        }
        return true;
    }

    public String[] unparse(LoadContext loadContext, PCTemplate pCTemplate) {
        Changes changes = loadContext.getObjectContext().getListChanges((CDOMObject)pCTemplate, ListKey.FEAT_TOKEN_LIST);
        Collection collection = changes.getAdded();
        Collection collection2 = changes.getRemoved();
        String string = null;
        if (changes.includesGlobalClear()) {
            if (collection2 != null && !collection2.isEmpty()) {
                loadContext.addWriteMessage("Non-sensical relationship in " + this.getTokenName() + ": global .CLEAR and local .CLEAR. performed");
                return null;
            }
            string = ".CLEAR";
        } else if (collection2 != null && !collection2.isEmpty()) {
            loadContext.addWriteMessage(this.getTokenName() + " does not support " + ".CLEAR.");
            return null;
        }
        if (collection != null && !collection.isEmpty()) {
            string = ReferenceUtilities.joinLstFormat((Collection)collection, (String)"|");
        }
        if (string == null) {
            return null;
        }
        return new String[]{string};
    }

    public Class<PCTemplate> getTokenClass() {
        return PCTemplate.class;
    }

    public void applyChoice(CDOMObject cDOMObject, AbilitySelection abilitySelection, PlayerCharacter playerCharacter) {
        double d = ((BigDecimal)abilitySelection.getAbility().getSafe(ObjectKey.SELECTION_COST)).doubleValue();
        if (d > 1.0E-4) {
            playerCharacter.adjustFeats(d);
        }
        String string = abilitySelection.getFullAbilityKey();
        AbilityUtilities.modFeat((PlayerCharacter)playerCharacter, null, (String)string, (boolean)true, (boolean)false);
        playerCharacter.addAssoc((Object)cDOMObject, AssociationListKey.TEMPLATE_FEAT, (Object)string);
    }

    public boolean allow(AbilitySelection abilitySelection, PlayerCharacter playerCharacter, boolean bl) {
        for (Ability ability : playerCharacter.getAllAbilities()) {
            if (!AbilityCategory.FEAT.equals((Object)ability.getCDOMCategory().getParentCategory()) || !ability.getKeyName().equals(abilitySelection.getAbilityKey()) || playerCharacter.canSelectAbility(ability, false) && ((Visibility)ability.getSafe(ObjectKey.VISIBILITY)).equals((Object)Visibility.DEFAULT) && (this.allowStack(ability, bl) || !this.hasAssoc(playerCharacter.getAssociationList((CDOMObject)ability), abilitySelection))) continue;
            return false;
        }
        return true;
    }

    private boolean hasAssoc(List<String> list, AbilitySelection abilitySelection) {
        if (list == null) {
            return false;
        }
        for (String string : list) {
            if (!abilitySelection.containsAssociation(string)) continue;
            return true;
        }
        return false;
    }

    private boolean allowStack(Ability ability, boolean bl) {
        return (Boolean)ability.getSafe(ObjectKey.STACKS) != false && bl;
    }

    public AbilitySelection decodeChoice(String string) {
        return AbilitySelection.getAbilitySelectionFromPersistentFormat((String)string);
    }

    public String encodeChoice(Object object) {
        return ((AbilitySelection)object).getPersistentFormat();
    }

    public void restoreChoice(PlayerCharacter playerCharacter, CDOMObject cDOMObject, AbilitySelection abilitySelection) {
    }

    public Class<PCTemplate> getDeferredTokenClass() {
        return PCTemplate.class;
    }

    public void removeChoice(PlayerCharacter playerCharacter, CDOMObject cDOMObject, AbilitySelection abilitySelection) {
        AbilityUtilities.modFeat((PlayerCharacter)playerCharacter, null, (String)abilitySelection.getFullAbilityKey(), (boolean)false, (boolean)true);
    }

    public boolean process(LoadContext loadContext, PCTemplate pCTemplate) {
        List list = pCTemplate.getListFor(ListKey.FEAT_TOKEN_LIST);
        if (list != null) {
            AbilityRef abilityRef;
            ArrayList<AbilityRef> arrayList = new ArrayList<AbilityRef>();
            for (CDOMReference cDOMReference : list) {
                abilityRef = new AbilityRef(cDOMReference);
                arrayList.add(abilityRef);
                String string = cDOMReference.getLSTformat();
                if (string.indexOf(40) == -1) continue;
                ArrayList arrayList2 = new ArrayList();
                AbilityUtilities.getUndecoratedName((String)string, arrayList2);
                if (arrayList2.size() != 1) {
                    Logging.log((Level)Logging.LST_ERROR, (String)("Invalid use of multiple items in parenthesis (comma prohibited) in " + this.getTokenName() + ": " + string));
                    return false;
                }
                abilityRef.setChoice((String)arrayList2.get(0));
            }
            if (!arrayList.isEmpty()) {
                CDOMReference cDOMReference;
                AbilityRefChoiceSet abilityRefChoiceSet = new AbilityRefChoiceSet((Category)AbilityCategory.FEAT, arrayList, Ability.Nature.AUTOMATIC);
                cDOMReference = new ChoiceSet(this.getTokenName(), (PrimitiveChoiceSet)abilityRefChoiceSet);
                abilityRef = new PersistentTransitionChoice((ChoiceSet)cDOMReference, FormulaFactory.ONE);
                loadContext.getObjectContext().put((CDOMObject)pCTemplate, ObjectKey.TEMPLATE_FEAT, (Object)abilityRef);
                abilityRef.setTitle("Feat Choice");
                abilityRef.setChoiceActor((ChoiceActor)this);
            }
        }
        return true;
    }
}

