/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.pcclass;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.PCClass;
import pcgen.core.SpellProhibitor;
import pcgen.core.prereq.Prerequisite;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;
import pcgen.util.enumeration.ProhibitedSpellType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProhibitspellToken
extends AbstractToken
implements CDOMPrimaryToken<PCClass> {
    public String getTokenName() {
        return "PROHIBITSPELL";
    }

    public boolean parse(LoadContext loadContext, PCClass pCClass, String string) {
        SpellProhibitor spellProhibitor = this.subParse(loadContext, string);
        if (spellProhibitor == null) {
            return false;
        }
        loadContext.getObjectContext().addToList((CDOMObject)pCClass, ListKey.SPELL_PROHIBITOR, (Object)spellProhibitor);
        return true;
    }

    public SpellProhibitor subParse(LoadContext loadContext, String string) {
        ProhibitedSpellType prohibitedSpellType;
        if (this.isEmpty(string) || this.hasIllegalSeparator('|', string)) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        String string2 = stringTokenizer.nextToken();
        int n = string2.indexOf(".");
        if (n == -1) {
            Logging.errorPrint((String)(this.getTokenName() + " has no . separator for arguments: " + string));
            return null;
        }
        String string3 = string2.substring(0, n);
        try {
            prohibitedSpellType = ProhibitedSpellType.valueOf((String)string3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logging.errorPrint((String)(this.getTokenName() + " encountered an invalid Prohibited Spell Type: " + string));
            Logging.errorPrint((String)("  Legal values are: " + StringUtil.join(Arrays.asList(ProhibitedSpellType.values()), (String)", ")));
            return null;
        }
        SpellProhibitor spellProhibitor = this.typeSafeParse(loadContext, prohibitedSpellType, string2.substring(n + 1));
        if (spellProhibitor == null) {
            Logging.errorPrint((String)("  entire token value was: " + string));
            return null;
        }
        if (!stringTokenizer.hasMoreTokens()) {
            return spellProhibitor;
        }
        string2 = stringTokenizer.nextToken();
        while (true) {
            Prerequisite prerequisite;
            if ((prerequisite = this.getPrerequisite(string2)) == null) {
                Logging.errorPrint((String)("   (Did you put more than one limit, or items after the PRExxx tags in " + this.getTokenName() + ":?)"));
                return null;
            }
            spellProhibitor.addPrerequisite(prerequisite);
            if (!stringTokenizer.hasMoreTokens()) break;
            string2 = stringTokenizer.nextToken();
        }
        return spellProhibitor;
    }

    private SpellProhibitor typeSafeParse(LoadContext loadContext, ProhibitedSpellType prohibitedSpellType, String string) {
        SpellProhibitor spellProhibitor = new SpellProhibitor();
        spellProhibitor.setType(prohibitedSpellType);
        if (string.length() == 0) {
            Logging.errorPrint((String)(this.getTokenName() + " " + prohibitedSpellType + " has no arguments"));
            return null;
        }
        String string2 = this.getJoinChar(prohibitedSpellType, new LinkedList<String>());
        if (string.indexOf(string2) == 0) {
            Logging.errorPrint((String)(this.getTokenName() + " arguments may not start with " + string2));
            return null;
        }
        if (string.lastIndexOf(string2) == string.length() - 1) {
            Logging.errorPrint((String)(this.getTokenName() + " arguments may not end with " + string2));
            return null;
        }
        if (string.indexOf(string2 + string2) != -1) {
            Logging.errorPrint((String)(this.getTokenName() + " arguments uses double separator " + string2 + string2));
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (!(!prohibitedSpellType.equals((Object)ProhibitedSpellType.ALIGNMENT) || string3.equalsIgnoreCase("GOOD") || string3.equalsIgnoreCase("EVIL") || string3.equalsIgnoreCase("LAWFUL") || string3.equalsIgnoreCase("CHAOTIC"))) {
                Logging.errorPrint((String)("Illegal PROHIBITSPELL:ALIGNMENT subtag '" + string3 + "'"));
                return null;
            }
            spellProhibitor.addValue(string3);
        }
        return spellProhibitor;
    }

    public String[] unparse(LoadContext loadContext, PCClass pCClass) {
        Changes changes = loadContext.getObjectContext().getListChanges((CDOMObject)pCClass, ListKey.SPELL_PROHIBITOR);
        Collection collection = changes.getAdded();
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SpellProhibitor spellProhibitor : collection) {
            StringBuilder stringBuilder = new StringBuilder();
            ProhibitedSpellType prohibitedSpellType = spellProhibitor.getType();
            stringBuilder.append(prohibitedSpellType.toString().toUpperCase());
            stringBuilder.append('.');
            List list = spellProhibitor.getValueList();
            String string = this.getJoinChar(prohibitedSpellType, list);
            stringBuilder.append(StringUtil.join(new TreeSet(list), (String)string));
            if (spellProhibitor.hasPrerequisites()) {
                stringBuilder.append("|");
                stringBuilder.append(this.getPrerequisiteString(loadContext, spellProhibitor.getPrerequisiteList()));
            }
            arrayList.add(stringBuilder.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private <T> String getJoinChar(ProhibitedSpellType prohibitedSpellType, Collection<String> collection) {
        return prohibitedSpellType.getRequiredCount(collection) == 1 ? "," : ".";
    }

    public Class<PCClass> getTokenClass() {
        return PCClass.class;
    }
}

