/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.pcclass;

import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.MapKey;
import pcgen.core.PCClass;
import pcgen.rules.context.LoadContext;
import pcgen.rules.context.MapChanges;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;
import pcgen.util.enumeration.AttackType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttackcycleToken
extends AbstractToken
implements CDOMPrimaryToken<PCClass> {
    public String getTokenName() {
        return "ATTACKCYCLE";
    }

    public boolean parse(LoadContext loadContext, PCClass pCClass, String string) {
        if (this.isEmpty(string) || this.hasIllegalSeparator('|', string)) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        if (stringTokenizer.countTokens() % 2 != 0) {
            Logging.errorPrint((String)(this.getTokenName() + " must have an even number of arguments."));
            return false;
        }
        while (stringTokenizer.hasMoreTokens()) {
            AttackType attackType = AttackType.getInstance((String)stringTokenizer.nextToken());
            if (AttackType.GRAPPLE.equals((Object)attackType)) {
                Logging.errorPrint((String)"Error: Cannot Set Attack Cycle for GRAPPLE Attack Type");
                return false;
            }
            String string2 = stringTokenizer.nextToken();
            try {
                Integer n = Integer.parseInt(string2);
                loadContext.getObjectContext().put((CDOMObject)pCClass, MapKey.ATTACK_CYCLE, (Object)attackType, (Object)n);
                if (!attackType.equals((Object)AttackType.MELEE)) continue;
                loadContext.getObjectContext().put((CDOMObject)pCClass, MapKey.ATTACK_CYCLE, (Object)AttackType.GRAPPLE, (Object)n);
            }
            catch (NumberFormatException numberFormatException) {
                Logging.errorPrint((String)("Invalid " + this.getTokenName() + ": " + string + " Cycle " + string2 + " must be an integer."));
                return false;
            }
        }
        return true;
    }

    public String[] unparse(LoadContext loadContext, PCClass pCClass) {
        MapChanges mapChanges = loadContext.getObjectContext().getMapChanges((CDOMObject)pCClass, MapKey.ATTACK_CYCLE);
        if (mapChanges == null || mapChanges.isEmpty()) {
            return null;
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        Integer n = null;
        Integer n2 = null;
        Map map = mapChanges.getAdded();
        for (Map.Entry entry : map.entrySet()) {
            AttackType attackType = (AttackType)entry.getKey();
            if (attackType.equals((Object)AttackType.GRAPPLE)) {
                n = (Integer)entry.getValue();
                continue;
            }
            if (attackType.equals((Object)AttackType.MELEE)) {
                n2 = (Integer)entry.getValue();
            }
            treeSet.add(attackType.getIdentifier() + "|" + entry.getValue());
        }
        if (n != null && !n.equals(n2)) {
            loadContext.addWriteMessage("Grapple Attack Cycle (" + n + ") MUST be equal to " + "Melee Attack Cycle (" + n2 + ") because it is not stored");
            return null;
        }
        return new String[]{StringUtil.join(treeSet, (String)"|")};
    }

    public Class<PCClass> getTokenClass() {
        return PCClass.class;
    }
}

