/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma;

import com.vladium.emma.report.ReportProperties;
import com.vladium.util.ClassLoaderResolver;
import com.vladium.util.IProperties;
import com.vladium.util.Property;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;

public abstract class EMMAProperties {
    public static final String GENERIC_PROPERTY_OVERRIDE_PREFIX = "D";
    public static final String DEFAULT_META_DATA_OUT_FILE = "coverage.em";
    public static final Boolean DEFAULT_META_DATA_OUT_MERGE = Boolean.TRUE;
    public static final String PREFIX_META_DATA = "metadata.";
    public static final String PROPERTY_META_DATA_OUT_FILE = "metadata.out.file";
    public static final String PROPERTY_META_DATA_OUT_MERGE = "metadata.out.merge";
    public static final String DEFAULT_COVERAGE_DATA_OUT_FILE = "coverage.ec";
    public static final Boolean DEFAULT_COVERAGE_DATA_OUT_MERGE = Boolean.TRUE;
    public static final String PREFIX_COVERAGE_DATA = "coverage.";
    public static final String PROPERTY_COVERAGE_DATA_OUT_FILE = "coverage.out.file";
    public static final String PROPERTY_COVERAGE_DATA_OUT_MERGE = "coverage.out.merge";
    public static final String DEFAULT_SESSION_DATA_OUT_FILE = "coverage.es";
    public static final Boolean DEFAULT_SESSION_DATA_OUT_MERGE = Boolean.TRUE;
    public static final String PREFIX_SESSION_DATA = "session.";
    public static final String PROPERTY_SESSION_DATA_OUT_FILE = "session.out.file";
    public static final String PROPERTY_SESSION_DATA_OUT_MERGE = "session.out.merge";
    public static final String PROPERTY_TEMP_FILE_EXT = ".et";
    public static final Map SYSTEM_PROPERTY_REDIRECTS;
    private static long s_timestamp;
    private static final Map s_properties;

    public static synchronized long getTimeStamp() {
        long result = s_timestamp;
        if (result == 0L) {
            s_timestamp = result = System.currentTimeMillis();
        }
        return result;
    }

    public static String makeAppVersion(int major, int minor, int build) {
        StringBuffer buf = new StringBuffer();
        buf.append(major);
        buf.append('.');
        buf.append(minor);
        buf.append('.');
        buf.append(build);
        return buf.toString();
    }

    public static IProperties wrap(Properties properties) {
        if (properties == null) {
            return null;
        }
        return IProperties.Factory.wrap(properties, ReportProperties.REPORT_PROPERTY_MAPPER);
    }

    public static synchronized IProperties getAppProperties() {
        ClassLoader loader = ClassLoaderResolver.getClassLoader();
        return EMMAProperties.getAppProperties(loader);
    }

    public static synchronized IProperties getAppProperties(ClassLoader loader) {
        IProperties properties = (IProperties)s_properties.get(loader);
        if (properties != null) {
            return properties;
        }
        IProperties systemRedirects = EMMAProperties.wrap(Property.getSystemPropertyRedirects(SYSTEM_PROPERTY_REDIRECTS));
        IProperties appDefaults = EMMAProperties.wrap(Property.getProperties("emma_default.properties", loader));
        IProperties system = EMMAProperties.wrap(Property.getSystemProperties("emma"));
        IProperties userOverrides = EMMAProperties.wrap(Property.getProperties("emma.properties", loader));
        properties = IProperties.Factory.combine(userOverrides, IProperties.Factory.combine(system, IProperties.Factory.combine(appDefaults, systemRedirects)));
        s_properties.put(loader, properties);
        return properties;
    }

    private EMMAProperties() {
    }

    static {
        s_properties = new WeakHashMap();
        HashMap<String, String> redirects = new HashMap<String, String>();
        redirects.put("report.".concat("out.encoding"), "file.encoding");
        redirects.put("report.".concat("out.dir"), "user.dir");
        SYSTEM_PROPERTY_REDIRECTS = Collections.unmodifiableMap(redirects);
    }
}

