/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report;

import com.vladium.emma.EMMAProperties;
import com.vladium.emma.EMMARuntimeException;
import com.vladium.emma.IAppErrorCodes;
import com.vladium.emma.data.DataFactory;
import com.vladium.emma.data.ICoverageData;
import com.vladium.emma.data.IMergeable;
import com.vladium.emma.data.IMetaData;
import com.vladium.emma.report.AbstractReportGenerator;
import com.vladium.emma.report.IReportGenerator;
import com.vladium.emma.report.SourcePathCache;
import com.vladium.logging.Logger;
import com.vladium.util.Files;
import com.vladium.util.IConstants;
import com.vladium.util.IProperties;
import com.vladium.util.Strings;
import com.vladium.util.exception.Exceptions;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public final class ReportProcessor
implements IAppErrorCodes {
    private File[] m_dataPath = IConstants.EMPTY_FILE_ARRAY;
    private File[] m_sourcePath;
    private IReportGenerator[] m_reportGenerators;
    private Properties m_propertyOverrides;
    private int m_dataFileCount;
    private boolean m_info;
    private boolean m_verbose;
    private boolean m_trace1;
    private boolean m_trace2;
    private static final Class[] EXPECTED_FAILURES = new Class[]{class$com$vladium$emma$EMMARuntimeException == null ? (class$com$vladium$emma$EMMARuntimeException = ReportProcessor.class$("com.vladium.emma.EMMARuntimeException")) : class$com$vladium$emma$EMMARuntimeException, class$java$lang$IllegalArgumentException == null ? (class$java$lang$IllegalArgumentException = ReportProcessor.class$("java.lang.IllegalArgumentException")) : class$java$lang$IllegalArgumentException, class$java$lang$IllegalStateException == null ? (class$java$lang$IllegalStateException = ReportProcessor.class$("java.lang.IllegalStateException")) : class$java$lang$IllegalStateException};
    static /* synthetic */ Class class$com$vladium$emma$EMMARuntimeException;
    static /* synthetic */ Class class$java$lang$IllegalArgumentException;
    static /* synthetic */ Class class$java$lang$IllegalStateException;

    public static ReportProcessor create() {
        return new ReportProcessor();
    }

    public final synchronized void setDataPath(String[] path) {
        this.m_dataPath = path == null || path.length == 0 ? IConstants.EMPTY_FILE_ARRAY : Files.pathToFiles(path, true);
    }

    public synchronized void setSourcePath(String[] path) {
        this.m_sourcePath = path == null ? null : Files.pathToFiles(path, true);
    }

    public synchronized void setReportTypes(String[] types) {
        if (types == null) {
            throw new IllegalArgumentException("null input: types");
        }
        String[] reportTypes = Strings.removeDuplicates(types, true);
        if (reportTypes.length == 0) {
            throw new IllegalArgumentException("empty input: types");
        }
        IReportGenerator[] reportGenerators = new IReportGenerator[reportTypes.length];
        for (int t = 0; t < reportTypes.length; ++t) {
            reportGenerators[t] = AbstractReportGenerator.create(reportTypes[t]);
        }
        this.m_reportGenerators = reportGenerators;
    }

    public synchronized void setPropertyOverrides(Properties overrides) {
        this.m_propertyOverrides = overrides;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        this.m_info = Logger.isLoggable(2);
        this.m_verbose = Logger.atVERBOSE();
        this.m_trace1 = Logger.atTRACE1();
        this.m_trace2 = Logger.atTRACE2();
        if (this.m_verbose) {
            Logger.verbose("[EMMA v2.0, build 4127 (2004/06/27 18:28:25)]");
        }
        this.validateState();
        IProperties appProperties = EMMAProperties.getAppProperties();
        IProperties toolProperties = IProperties.Factory.combine(EMMAProperties.wrap(this.m_propertyOverrides), appProperties);
        RuntimeException failure = null;
        try {
            IMergeable cdata;
            IMergeable mdata;
            block34: {
                long start = this.m_info ? System.currentTimeMillis() : 0L;
                mdata = null;
                cdata = null;
                for (int f = 0; f < this.m_dataPath.length; ++f) {
                    ICoverageData _cdata;
                    IMergeable[] fileData = DataFactory.load(this.m_dataPath[f]);
                    IMetaData _mdata = (IMetaData)fileData[0];
                    if (_mdata != null) {
                        mdata = mdata == null ? _mdata : (IMetaData)mdata.merge(_mdata);
                    }
                    if ((_cdata = (ICoverageData)fileData[1]) != null) {
                        cdata = cdata == null ? _cdata : (ICoverageData)cdata.merge(_cdata);
                    }
                    ++this.m_dataFileCount;
                }
                if (this.m_info) {
                    long end = System.currentTimeMillis();
                    Logger.info(this.m_dataFileCount + " file(s) read and merged in " + (end - start) + " ms");
                }
                if (mdata == null || mdata.isEmpty()) {
                    Logger.warning("nothing to do: no metadata found in any of the data files");
                    return;
                }
                if (cdata != null) break block34;
                Logger.warning("nothing to do: no runtime coverage data found in any of the data files");
                return;
            }
            try {
                if (cdata.isEmpty()) {
                    Logger.warning("no collected coverage data found in any of the data files [all reports will be empty]");
                }
                SourcePathCache srcpathCache = null;
                if (this.m_sourcePath != null) {
                    srcpathCache = new SourcePathCache(this.m_sourcePath, true);
                }
                for (int g = 0; g < this.m_reportGenerators.length; ++g) {
                    IReportGenerator generator = this.m_reportGenerators[g];
                    generator.process((IMetaData)mdata, (ICoverageData)cdata, srcpathCache, toolProperties);
                    try {
                        generator.cleanup();
                    }
                    catch (Throwable ignore) {}
                    continue;
                    catch (Throwable t) {
                        try {
                            t.printStackTrace(System.out);
                            break;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            try {
                                generator.cleanup();
                            }
                            catch (Throwable ignore) {}
                        }
                    }
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace(System.out);
            }
        }
        catch (SecurityException se) {
            failure = new EMMARuntimeException("SECURITY_RESTRICTION:", new String[]{"EMMA"}, se);
        }
        catch (RuntimeException re) {
            failure = re;
        }
        finally {
            this.reset();
        }
        if (failure != null) {
            if (Exceptions.unexpectedFailure(failure, EXPECTED_FAILURES)) {
                throw new EMMARuntimeException("UNEXPECTED_FAILURE", new Object[]{failure.toString(), "http://sourceforge.net/projects/emma"}, failure);
            }
            throw failure;
        }
    }

    private ReportProcessor() {
    }

    private void validateState() {
        if (this.m_dataPath == null) {
            throw new IllegalStateException("data path not set");
        }
        if (this.m_reportGenerators == null || this.m_reportGenerators.length == 0) {
            throw new IllegalStateException("report types not set");
        }
    }

    private void reset() {
        this.m_dataFileCount = 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

