/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma;

import com.vladium.emma.Command;
import com.vladium.emma.EMMARuntimeException;
import com.vladium.emma.rt.AppRunner;
import com.vladium.util.ClassLoaderResolver;
import com.vladium.util.Strings;
import com.vladium.util.args.IOptsParser;
import java.io.File;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public final class runCommand
extends Command {
    private String[] m_classpath;
    private String[] m_srcpath;
    private boolean m_jarMode;
    private boolean m_scanCoveragePath;
    private String[] m_ixpath;
    private String[] m_appArgs;
    private boolean m_dumpRawData;
    private String m_outFileName;
    private Boolean m_outDataMerge;
    private String[] m_reportTypes;
    private static final boolean DEFAULT_TO_SYSTEM_CLASSPATH = false;

    public synchronized void run() {
        ClassLoader loader;
        try {
            loader = ClassLoaderResolver.getClassLoader();
        }
        catch (Throwable t) {
            loader = this.getClass().getClassLoader();
        }
        try {
            IOptsParser parser = this.getOptParser(loader);
            IOptsParser.IOpts parsedopts = parser.parse(this.m_args);
            int usageRequestLevel = parsedopts.usageRequestLevel();
            if (usageRequestLevel > 0) {
                this.usageexit(parser, usageRequestLevel, null);
                return;
            }
            IOptsParser.IOpt[] opts = parsedopts.getOpts();
            if (opts == null) {
                parsedopts.error(this.m_out, 80);
                this.usageexit(parser, 1, null);
                return;
            }
            try {
                for (int o = 0; o < opts.length; ++o) {
                    IOptsParser.IOpt opt = opts[o];
                    String on = opt.getCanonicalName();
                    if (this.processOpt(opt)) continue;
                    if ("cp".equals(on)) {
                        this.m_classpath = runCommand.getListOptValue(opt, PATH_DELIMITERS, true);
                        continue;
                    }
                    if ("jar".equals(on)) {
                        this.m_jarMode = true;
                        continue;
                    }
                    if ("f".equals(on)) {
                        this.m_scanCoveragePath = runCommand.getOptionalBooleanOptValue(opt);
                        continue;
                    }
                    if ("sp".equals(on)) {
                        this.m_srcpath = runCommand.getListOptValue(opt, PATH_DELIMITERS, true);
                        continue;
                    }
                    if ("raw".equals(on)) {
                        this.m_dumpRawData = runCommand.getOptionalBooleanOptValue(opt);
                        continue;
                    }
                    if ("out".equals(on)) {
                        this.m_outFileName = opt.getFirstValue();
                        continue;
                    }
                    if ("merge".equals(on)) {
                        this.m_outDataMerge = runCommand.getOptionalBooleanOptValue(opt) ? Boolean.TRUE : Boolean.FALSE;
                        continue;
                    }
                    if ("r".equals(on)) {
                        this.m_reportTypes = Strings.merge(opt.getValues(), ", \t\r\n", true);
                        continue;
                    }
                    if (!"ix".equals(on)) continue;
                    this.m_ixpath = runCommand.getListOptValue(opt, ", \t\r\n", true);
                }
                if (!this.processFilePropertyOverrides()) {
                    return;
                }
                this.processCmdPropertyOverrides(parsedopts);
            }
            catch (IOException ioe) {
                throw new EMMARuntimeException("ARGS_IO_FAILURE", ioe);
            }
            String[] freeArgs = parsedopts.getFreeArgs();
            if (this.m_jarMode) {
                String jarMainClass;
                if (freeArgs == null || freeArgs.length == 0) {
                    this.usageexit(parser, 1, "missing jar file name");
                    return;
                }
                File jarfile = new File(freeArgs[0]);
                try {
                    jarMainClass = runCommand.openJarFile(jarfile);
                }
                catch (IOException ioe) {
                    throw new EMMARuntimeException("ARGS_IO_FAILURE", ioe);
                }
                if (jarMainClass == null) {
                    this.exit(true, "failed to load Main-Class manifest attribute from [" + jarfile.getAbsolutePath() + "]", null, 2);
                    return;
                }
                this.m_appArgs = new String[freeArgs.length];
                System.arraycopy(freeArgs, 1, this.m_appArgs, 1, freeArgs.length - 1);
                this.m_appArgs[0] = jarMainClass;
                this.m_classpath = new String[]{jarfile.getPath()};
            } else {
                if (freeArgs == null || freeArgs.length == 0) {
                    this.usageexit(parser, 1, "missing application class name");
                    return;
                }
                this.m_appArgs = freeArgs;
            }
            if (this.m_classpath == null) {
                this.usageexit(parser, 1, "either '-cp' or '-jar' option is required");
                return;
            }
            if (this.m_reportTypes == null) {
                this.m_reportTypes = new String[]{"txt"};
            }
            String[] appargs = new String[this.m_appArgs.length - 1];
            System.arraycopy(this.m_appArgs, 1, appargs, 0, appargs.length);
            AppRunner processor = AppRunner.create(loader);
            processor.setAppClass(this.m_appArgs[0], appargs);
            processor.setCoveragePath(this.m_classpath, true);
            processor.setScanCoveragePath(this.m_scanCoveragePath);
            processor.setSourcePath(this.m_srcpath);
            processor.setInclExclFilter(this.m_ixpath);
            processor.setDumpSessionData(this.m_dumpRawData);
            processor.setSessionOutFile(this.m_outFileName);
            processor.setSessionOutMerge(this.m_outDataMerge);
            processor.setReportTypes(this.m_reportTypes);
            processor.setPropertyOverrides(this.m_propertyOverrides);
            processor.run();
        }
        catch (EMMARuntimeException yre) {
            this.exit(true, yre.getMessage(), yre, 2);
            return;
        }
        catch (Throwable t) {
            this.exit(true, "unexpected failure: ", t, 2);
            return;
        }
        this.exit(false, null, null, 0);
    }

    protected runCommand(String usageToolName, String[] args) {
        super(usageToolName, args);
    }

    protected void initialize() {
        super.initialize();
    }

    protected String usageArgsMsg() {
        return "[options] class [args...] | -jar [options] jarfile [args...]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String openJarFile(File file) throws IOException {
        String string;
        block13: {
            String jarMainClass;
            Attributes attributes;
            JarFile jarfile;
            block11: {
                String string2;
                block12: {
                    Manifest manifest;
                    block9: {
                        String string3;
                        block10: {
                            jarfile = null;
                            try {
                                jarfile = new JarFile(file, false);
                                manifest = jarfile.getManifest();
                                if (manifest != null) break block9;
                                string3 = null;
                                Object var7_5 = null;
                                if (jarfile == null) break block10;
                            }
                            catch (Throwable throwable) {
                                block14: {
                                    Object var7_8 = null;
                                    if (jarfile == null) break block14;
                                    try {
                                        jarfile.close();
                                    }
                                    catch (IOException ignore) {}
                                }
                                throw throwable;
                            }
                            try {
                                jarfile.close();
                            }
                            catch (IOException ignore) {
                                // empty catch block
                            }
                        }
                        return string3;
                    }
                    attributes = manifest.getMainAttributes();
                    if (attributes != null) break block11;
                    string2 = null;
                    Object var7_6 = null;
                    if (jarfile == null) break block12;
                    try {
                        jarfile.close();
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                }
                return string2;
            }
            string = jarMainClass = attributes.getValue(Attributes.Name.MAIN_CLASS);
            Object var7_7 = null;
            if (jarfile == null) break block13;
            try {
                jarfile.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        return string;
    }
}

