/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.util;

import com.vladium.util.IConstants;
import com.vladium.util.ResourceLoader;
import com.vladium.util.XProperties;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public abstract class Property {
    private static String s_systemFingerprint;
    private static Properties s_systemProperties;
    private static Properties s_systemRedirects;

    public static boolean toBoolean(String value) {
        if (value == null) {
            return false;
        }
        return value.startsWith("t") || value.startsWith("y");
    }

    public static String[] toAppArgsForm(Properties properties, String prefix) {
        if (properties == null) {
            return IConstants.EMPTY_STRING_ARRAY;
        }
        if (prefix == null) {
            throw new IllegalArgumentException("null input: prefix");
        }
        ArrayList<String> _result = new ArrayList<String>(properties.size());
        Enumeration<?> names = properties.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = properties.getProperty(name, "");
            _result.add(prefix.concat(name).concat("=").concat(value));
        }
        if (_result.isEmpty()) {
            return IConstants.EMPTY_STRING_ARRAY;
        }
        String[] result = new String[_result.size()];
        _result.toArray(result);
        return result;
    }

    public static Properties combine(Properties overrides, Properties base) {
        if (base == null) {
            if (overrides == null) {
                return new XProperties();
            }
            return overrides;
        }
        if (overrides == null) {
            return base;
        }
        XProperties result = new XProperties(base);
        Enumeration<?> overrideNames = overrides.propertyNames();
        while (overrideNames.hasMoreElements()) {
            String n = (String)overrideNames.nextElement();
            String v = overrides.getProperty(n);
            result.setProperty(n, v);
        }
        return result;
    }

    public static Properties getSystemProperties(String systemPrefix) {
        Properties result = s_systemProperties;
        if (result == null) {
            s_systemProperties = result = new SystemPropertyLookup(systemPrefix);
            return result;
        }
        return result;
    }

    public static Properties getSystemPropertyRedirects(Map systemRedirects) {
        Properties result = s_systemRedirects;
        if (result == null) {
            s_systemRedirects = result = new SystemRedirectsLookup(systemRedirects);
            return result;
        }
        return result;
    }

    public static String getSystemFingerprint() {
        if (s_systemFingerprint != null) {
            return s_systemFingerprint;
        }
        StringBuffer s = new StringBuffer();
        int delimiter = 58;
        s.append(Property.getSystemProperty("java.vm.name", ""));
        s.append(':');
        s.append(Property.getSystemProperty("java.vm.version", ""));
        s.append(':');
        s.append(Property.getSystemProperty("java.vm.vendor", ""));
        s.append(':');
        s.append(Property.getSystemProperty("os.name", ""));
        s.append(':');
        s.append(Property.getSystemProperty("os.version", ""));
        s.append(':');
        s.append(Property.getSystemProperty("os.arch", ""));
        s_systemFingerprint = s.toString();
        return s_systemFingerprint;
    }

    public static String getSystemProperty(String key) {
        try {
            return System.getProperty(key);
        }
        catch (SecurityException se) {
            return null;
        }
    }

    public static String getSystemProperty(String key, String def) {
        try {
            return System.getProperty(key, def);
        }
        catch (SecurityException se) {
            return def;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Properties getProperties(String name) {
        XProperties result;
        block12: {
            InputStream in;
            block11: {
                block10: {
                    result = null;
                    in = null;
                    in = ResourceLoader.getResourceAsStream(name);
                    if (in == null) break block10;
                    result = new XProperties();
                    result.load(in);
                }
                Object var5_3 = null;
                if (in == null) break block11;
                try {
                    in.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
            }
            in = null;
            {
                break block12;
                catch (Throwable t) {
                    result = null;
                    Object var5_4 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable ignore) {
                            // empty catch block
                        }
                    }
                    in = null;
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                }
                in = null;
                throw throwable;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Properties getProperties(String name, ClassLoader loader) {
        XProperties result;
        block12: {
            InputStream in;
            block11: {
                block10: {
                    result = null;
                    in = null;
                    in = ResourceLoader.getResourceAsStream(name, loader);
                    if (in == null) break block10;
                    result = new XProperties();
                    result.load(in);
                }
                Object var6_4 = null;
                if (in == null) break block11;
                try {
                    in.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
            }
            in = null;
            {
                break block12;
                catch (Throwable t) {
                    result = null;
                    Object var6_5 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable ignore) {
                            // empty catch block
                        }
                    }
                    in = null;
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                }
                in = null;
                throw throwable;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getPropertiesFromFile(File file) throws IOException {
        BufferedInputStream in;
        XProperties result;
        block6: {
            result = null;
            in = null;
            try {
                in = new BufferedInputStream(new FileInputStream(file), 8192);
                result = new XProperties();
                result.load(in);
                Object var4_3 = null;
                if (in == null) break block6;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                }
                in = null;
                throw throwable;
            }
            try {
                ((InputStream)in).close();
                break block6;
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            {
            }
        }
        in = null;
        return result;
    }

    private static final class SystemRedirectsLookup
    extends XProperties {
        private final Map m_systemRedirects;

        public String getProperty(String key) {
            return (String)this.get(key);
        }

        public Object get(Object key) {
            String redirect;
            if (!(key instanceof String)) {
                return null;
            }
            String result = (String)super.get(key);
            if (result != null) {
                return result;
            }
            if (this.m_systemRedirects != null && (redirect = (String)this.m_systemRedirects.get(key)) != null && (result = Property.getSystemProperty(redirect, null)) != null) {
                return result;
            }
            return result;
        }

        public synchronized Enumeration keys() {
            Hashtable _propertyNames = new Hashtable();
            if (this.m_systemRedirects != null) {
                Iterator i = this.m_systemRedirects.keySet().iterator();
                while (i.hasNext()) {
                    Object key = i.next();
                    if (key == null) continue;
                    _propertyNames.put(key, key);
                }
            }
            return _propertyNames.keys();
        }

        SystemRedirectsLookup(Map systemRedirects) {
            this.m_systemRedirects = systemRedirects;
        }
    }

    private static final class SystemPropertyLookup
    extends XProperties {
        private final String m_systemPrefix;

        public String getProperty(String key) {
            return (String)this.get(key);
        }

        public Object get(Object key) {
            if (!(key instanceof String)) {
                return null;
            }
            String result = (String)super.get(key);
            if (result != null) {
                return result;
            }
            if (this.m_systemPrefix != null && (result = Property.getSystemProperty(this.m_systemPrefix.concat((String)key), null)) != null) {
                return result;
            }
            return result;
        }

        public synchronized Enumeration keys() {
            Hashtable<String, String> _propertyNames = new Hashtable<String, String>();
            if (this.m_systemPrefix != null) {
                try {
                    int systemPrefixLength = this.m_systemPrefix.length();
                    Enumeration<?> e = System.getProperties().propertyNames();
                    while (e.hasMoreElements()) {
                        String n = (String)e.nextElement();
                        if (!n.startsWith(this.m_systemPrefix)) continue;
                        String yn = n.substring(systemPrefixLength);
                        _propertyNames.put(yn, yn);
                    }
                }
                catch (SecurityException ignore) {
                    ignore.printStackTrace(System.out);
                }
            }
            return _propertyNames.keys();
        }

        SystemPropertyLookup(String systemPrefix) {
            if (systemPrefix != null && !systemPrefix.endsWith(".")) {
                systemPrefix = systemPrefix.concat(".");
            }
            this.m_systemPrefix = systemPrefix;
        }
    }
}

