/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.add;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.logging.Level;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.ChoiceActor;
import pcgen.cdom.base.ChoiceSet;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.base.PersistentTransitionChoice;
import pcgen.cdom.base.PrimitiveChoiceSet;
import pcgen.cdom.choiceset.ReferenceChoiceSet;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.helper.ClassSkillChoiceActor;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.cdom.reference.ObjectMatchingReference;
import pcgen.core.PCClass;
import pcgen.core.Skill;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassSkillsLevelToken
extends AbstractToken
implements CDOMSecondaryToken<PCClassLevel> {
    private static final Class<Skill> SKILL_CLASS = Skill.class;

    public String getTokenName() {
        return "CLASSSKILLS";
    }

    public String getParentToken() {
        return "ADD";
    }

    private String getFullName() {
        return this.getParentToken() + ":" + this.getTokenName();
    }

    public boolean parse(LoadContext loadContext, PCClassLevel pCClassLevel, String string) {
        Object object;
        String string2;
        String string3;
        Formula formula;
        if (string.length() == 0) {
            Logging.log((Level)Logging.LST_ERROR, (String)(this.getFullName() + " may not have empty argument"));
            return false;
        }
        int n = string.indexOf("|");
        if (n == -1) {
            formula = FormulaFactory.ONE;
            string3 = string;
        } else {
            String string4 = string.substring(0, n);
            formula = FormulaFactory.getFormulaFor((String)string4);
            if (formula.isStatic() && formula.resolve(null, "").doubleValue() <= 0.0) {
                Logging.log((Level)Logging.LST_ERROR, (String)("Count in " + this.getFullName() + " must be > 0"));
                return false;
            }
            string3 = string.substring(n + 1);
        }
        if (this.isEmpty(string3) || this.hasIllegalSeparator(',', string3)) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        CDOMGroupRef cDOMGroupRef = loadContext.ref.getCDOMAllReference(SKILL_CLASS);
        Integer n2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if ("ALL".equals(string2) || "ANY".equals(string2)) {
                bl = true;
                arrayList.add(cDOMGroupRef);
                continue;
            }
            bl2 = true;
            if ("UNTRAINED".equals(string2)) {
                object = new ObjectMatchingReference(string2, SKILL_CLASS, cDOMGroupRef, ObjectKey.USE_UNTRAINED, (Object)Boolean.TRUE);
                object.returnIncludesNulls(true);
                arrayList.add(object);
                continue;
            }
            if ("TRAINED".equals(string2)) {
                arrayList.add(new ObjectMatchingReference(string2, SKILL_CLASS, cDOMGroupRef, ObjectKey.USE_UNTRAINED, (Object)Boolean.FALSE));
                continue;
            }
            if ("EXCLUSIVE".equals(string2)) {
                arrayList.add(new ObjectMatchingReference(string2, SKILL_CLASS, cDOMGroupRef, ObjectKey.EXCLUSIVE, (Object)Boolean.TRUE));
                continue;
            }
            if ("NONEXCLUSIVE".equals(string2) || "CROSSCLASSSKILLS".equals(string2)) {
                object = new ObjectMatchingReference(string2, SKILL_CLASS, cDOMGroupRef, ObjectKey.EXCLUSIVE, (Object)Boolean.FALSE);
                object.returnIncludesNulls(true);
                arrayList.add(object);
                continue;
            }
            if (string2.startsWith("AUTORANK=")) {
                if (n2 != null) {
                    Logging.log((Level)Logging.LST_ERROR, (String)("Cannot have two AUTORANK= items in " + this.getFullName() + ": " + string));
                    return false;
                }
                object = string2.substring(9);
                try {
                    n2 = Integer.decode((String)object);
                    if (n2 > 0) continue;
                    Logging.errorPrint((String)("Expected AUTORANK= to be greater than zero, found: " + n2));
                    return false;
                }
                catch (NumberFormatException numberFormatException) {
                    Logging.errorPrint((String)("Expected AUTORANK= to have an integer value, found: " + (String)object));
                    return false;
                }
            }
            object = TokenUtilities.getTypeOrPrimitive((LoadContext)loadContext, SKILL_CLASS, (String)string2);
            if (object == null) {
                Logging.log((Level)Logging.LST_ERROR, (String)("  Error was encountered while parsing " + this.getFullName() + ": " + string + " had an invalid reference: " + string2));
                return false;
            }
            arrayList.add(object);
        }
        if (bl && bl2) {
            Logging.log((Level)Logging.LST_ERROR, (String)("Non-sensical " + this.getFullName() + ": Contains ANY and a specific reference: " + string));
            return false;
        }
        if (arrayList.isEmpty()) {
            Logging.log((Level)Logging.LST_ERROR, (String)("Non-sensical " + this.getFullName() + ": Contains no skill reference: " + string));
            return false;
        }
        string2 = new ReferenceChoiceSet(arrayList);
        object = new ChoiceSet(this.getTokenName(), (PrimitiveChoiceSet)string2, true);
        PersistentTransitionChoice persistentTransitionChoice = new PersistentTransitionChoice(object, formula);
        PCClass pCClass = (PCClass)pCClassLevel.get(ObjectKey.PARENT);
        ClassSkillChoiceActor classSkillChoiceActor = new ClassSkillChoiceActor(pCClass, n2);
        persistentTransitionChoice.setChoiceActor((ChoiceActor)classSkillChoiceActor);
        loadContext.getObjectContext().addToList((CDOMObject)pCClassLevel, ListKey.ADD, (Object)persistentTransitionChoice);
        return true;
    }

    public String[] unparse(LoadContext loadContext, PCClassLevel pCClassLevel) {
        Changes changes = loadContext.getObjectContext().getListChanges((CDOMObject)pCClassLevel, ListKey.ADD);
        Collection collection = changes.getAdded();
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PersistentTransitionChoice persistentTransitionChoice : collection) {
            ChoiceSet choiceSet = persistentTransitionChoice.getChoices();
            if (!this.getTokenName().equals(choiceSet.getName()) || !SKILL_CLASS.equals(choiceSet.getChoiceClass())) continue;
            Formula formula = persistentTransitionChoice.getCount();
            if (formula == null) {
                loadContext.addWriteMessage("Unable to find " + this.getFullName() + " Count");
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (!FormulaFactory.ONE.equals(formula)) {
                stringBuilder.append(formula).append("|");
            }
            stringBuilder.append(choiceSet.getLSTformat());
            ClassSkillChoiceActor classSkillChoiceActor = (ClassSkillChoiceActor)persistentTransitionChoice.getChoiceActor();
            Integer n = classSkillChoiceActor.getApplyRank();
            if (n != null) {
                stringBuilder.append(",").append("AUTORANK=" + n);
            }
            arrayList.add(stringBuilder.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Class<PCClassLevel> getTokenClass() {
        return PCClassLevel.class;
    }
}

