/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.skill;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Skill;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;
import pcgen.util.enumeration.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisibleToken
extends AbstractToken
implements CDOMPrimaryToken<Skill> {
    public String getTokenName() {
        return "VISIBLE";
    }

    public boolean parse(LoadContext loadContext, Skill skill, String string) {
        Visibility visibility;
        if (this.isEmpty(string)) {
            return false;
        }
        String string2 = string;
        int n = string.indexOf("|");
        boolean bl = false;
        if (n != -1) {
            if (string.substring(n + 1).equals("READONLY")) {
                string2 = string.substring(0, n);
                bl = true;
            } else {
                Logging.errorPrint((String)("Misunderstood text after pipe on Tag: " + string));
                return false;
            }
        }
        if (string2.equals("YES")) {
            visibility = Visibility.DEFAULT;
        } else if (string2.equals("ALWAYS")) {
            visibility = Visibility.DEFAULT;
        } else if (string2.equals("DISPLAY")) {
            visibility = Visibility.DISPLAY_ONLY;
        } else if (string2.equals("GUI")) {
            visibility = Visibility.DISPLAY_ONLY;
        } else if (string2.equals("EXPORT")) {
            visibility = Visibility.OUTPUT_ONLY;
        } else if (string2.equals("CSHEET")) {
            visibility = Visibility.OUTPUT_ONLY;
        } else {
            Logging.errorPrint((String)("Unexpected value used in " + this.getTokenName() + " in Skill"));
            Logging.errorPrint((String)(" " + string + " is not a valid value for " + this.getTokenName()));
            Logging.errorPrint((String)" Valid values in Skill are YES, ALWAYS, DISPLAY, GUI, EXPORT, CSHEET");
            return false;
        }
        loadContext.getObjectContext().put((CDOMObject)skill, ObjectKey.VISIBILITY, (Object)visibility);
        if (bl) {
            if (visibility.equals((Object)Visibility.OUTPUT_ONLY)) {
                Logging.errorPrint((String)("|READONLY suffix not valid with " + this.getTokenName() + " EXPORT or CSHEET"));
                return false;
            }
            loadContext.getObjectContext().put((CDOMObject)skill, ObjectKey.READ_ONLY, (Object)Boolean.TRUE);
        }
        return true;
    }

    public String[] unparse(LoadContext loadContext, Skill skill) {
        Visibility visibility = (Visibility)loadContext.getObjectContext().getObject((CDOMObject)skill, ObjectKey.VISIBILITY);
        if (visibility == null) {
            return null;
        }
        if (!(visibility.equals((Object)Visibility.DEFAULT) || visibility.equals((Object)Visibility.DISPLAY_ONLY) || visibility.equals((Object)Visibility.OUTPUT_ONLY))) {
            loadContext.addWriteMessage("Visibility " + visibility + " is not a valid Visibility for a Skill");
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(visibility.getLSTFormat());
        Boolean bl = (Boolean)loadContext.getObjectContext().getObject((CDOMObject)skill, ObjectKey.READ_ONLY);
        if (bl != null && !visibility.equals((Object)Visibility.OUTPUT_ONLY)) {
            stringBuilder.append('|').append("READONLY");
        }
        return new String[]{stringBuilder.toString()};
    }

    public Class<Skill> getTokenClass() {
        return Skill.class;
    }
}

