/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.race;

import java.util.Collection;
import java.util.logging.Level;
import pcgen.base.util.WeightedCollection;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.Race;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartfeatsToken
extends AbstractToken
implements CDOMPrimaryToken<Race> {
    public String getTokenName() {
        return "STARTFEATS";
    }

    public boolean parse(LoadContext loadContext, Race race, String string) throws PersistenceLayerException {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            Logging.addParseMessage((Level)Logging.LST_ERROR, (String)("Error encountered in " + this.getTokenName() + " was expecting value to be an integer, found: " + string));
            return false;
        }
        BonusObj bonusObj = Bonus.newBonus((String)("FEAT|POOL|" + n));
        if (bonusObj == null) {
            Logging.errorPrint((String)("Internal Error: " + this.getTokenName() + " had invalid bonus"));
            return false;
        }
        Prerequisite prerequisite = this.getPrerequisite("PREMULT:1,[PREHD:MIN=1],[PRELEVEL:MIN=1]");
        if (prerequisite == null) {
            Logging.errorPrint((String)("Internal Error: " + this.getTokenName() + " had invalid prerequisite"));
            return false;
        }
        bonusObj.addPrerequisite(prerequisite);
        bonusObj.setCreatorObject((Object)race);
        bonusObj.setTokenSource(this.getTokenName());
        loadContext.obj.addToList((CDOMObject)race, ListKey.BONUS, (Object)bonusObj);
        return true;
    }

    public String[] unparse(LoadContext loadContext, Race race) {
        Changes changes = loadContext.obj.getListChanges((CDOMObject)race, ListKey.BONUS);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        Collection collection = changes.getAdded();
        String string = this.getTokenName();
        WeightedCollection weightedCollection = new WeightedCollection(String.CASE_INSENSITIVE_ORDER);
        for (BonusObj bonusObj : collection) {
            if (!string.equals(bonusObj.getTokenSource())) continue;
            weightedCollection.add(bonusObj.getValue());
        }
        if (weightedCollection.isEmpty()) {
            return null;
        }
        return weightedCollection.toArray(new String[weightedCollection.size()]);
    }

    public Class<Race> getTokenClass() {
        return Race.class;
    }
}

