/*
 * Decompiled with CFR 0.152.
 */
package plugin.experience;

import gmgen.io.ReadXML;
import gmgen.plugin.Combatant;
import gmgen.plugin.InitHolder;
import gmgen.plugin.InitHolderList;
import gmgen.util.LogUtilities;
import java.io.File;
import java.util.Observable;
import pcgen.core.SettingsHandler;
import pcgen.util.Logging;
import plugin.experience.ExperienceList;
import plugin.experience.ExperienceListItem;

public class ExperienceAdjusterModel
extends Observable {
    private ReadXML experienceTable = null;
    protected ExperienceList enemies = new ExperienceList();
    protected ExperienceList party = new ExperienceList();
    protected InitHolderList combat;
    protected String dir;
    protected double multiplier = 1.0;
    protected int partyExperience;

    public ExperienceAdjusterModel(String string) {
        this.dir = string;
    }

    public void setCombat(InitHolderList initHolderList) {
        this.combat = initHolderList;
    }

    public void setEnemies(ExperienceList experienceList) {
        this.enemies = experienceList;
    }

    public ExperienceList getEnemies() {
        return this.enemies;
    }

    public void setMultiplier(double d) {
        this.multiplier = d;
    }

    public void setParty(ExperienceList experienceList) {
        this.party = experienceList;
    }

    public ExperienceList getParty() {
        return this.party;
    }

    public void addEnemy(ExperienceListItem experienceListItem) {
        this.combat.add((InitHolder)experienceListItem.getCombatant());
        this.enemies.addElement(experienceListItem);
    }

    public void addExperienceToCharacter(ExperienceListItem experienceListItem, int n) {
        Combatant combatant = experienceListItem.getCombatant();
        combatant.setXP(combatant.getXP() + n);
        LogUtilities.inst().logMessage("Experience_Adjuster", combatant.getName() + " Awarded " + n + " Experience");
    }

    public void addExperienceToParty() {
        int n = SettingsHandler.getGMGenOption((String)"Experience_Adjuster.ExperienceType", (int)2);
        LogUtilities.inst().logMessage("Experience_Adjuster", "Party Awarded " + this.getPartyExperience() + " Total Experience Split as:");
        for (int i = 0; i < this.party.size(); ++i) {
            Combatant combatant = ((ExperienceListItem)this.party.get(i)).getCombatant();
            if (n == 1) {
                combatant.setXP(combatant.getXP() + this.getPartyTotalExperience() / this.party.size());
                LogUtilities.inst().logMessage("Experience_Adjuster", combatant.getName() + ": " + this.getPartyTotalExperience() / this.party.size());
                continue;
            }
            combatant.setXP(combatant.getXP() + this.getCombatantExperience(combatant));
            LogUtilities.inst().logMessage("Experience_Adjuster", combatant.getName() + ": " + this.getCombatantExperience(combatant));
        }
    }

    public void clearEnemies() {
        for (int i = 0; i < this.enemies.size(); ++i) {
            ExperienceListItem experienceListItem = (ExperienceListItem)this.enemies.get(i);
            this.combat.remove((Object)experienceListItem.getCombatant());
        }
        this.enemies.removeAllElements();
    }

    public void populateLists() {
        if (this.combat != null) {
            this.party.removeAllElements();
            this.enemies.removeAllElements();
            for (int i = 0; i < this.combat.size(); ++i) {
                InitHolder initHolder = (InitHolder)this.combat.get(i);
                if (!(initHolder instanceof Combatant)) continue;
                Combatant combatant = (Combatant)initHolder;
                if (combatant.getCombatantType().equals("PC")) {
                    this.party.addElement(new ExperienceListItem(combatant));
                    continue;
                }
                if (!combatant.getCombatantType().equals("Enemy") || !combatant.getStatus().equals("Dead") && !combatant.getStatus().equals("Defeated")) continue;
                this.enemies.addElement(new ExperienceListItem(combatant));
            }
        }
    }

    public void removeEnemy(ExperienceListItem experienceListItem) {
        this.combat.remove((Object)experienceListItem.getCombatant());
        this.enemies.removeElement(experienceListItem);
    }

    public int getCombatantExperience(Combatant combatant) {
        int n = 0;
        File file = new File(this.dir + File.separator + "experience_tables/7_1.xml");
        if (this.experienceTable == null) {
            this.experienceTable = new ReadXML(file);
        }
        for (int i = 0; i < this.enemies.size(); ++i) {
            ExperienceListItem experienceListItem = (ExperienceListItem)this.enemies.get(i);
            float f = experienceListItem.getCombatant().getCR();
            int n2 = f < 1.0f ? 1 : (int)f;
            String string = (String)this.experienceTable.getTable().crossReference((Object)Integer.toString((int)combatant.getCR()), (Object)Integer.toString(n2));
            try {
                if (f < 1.0f) {
                    n += (int)(Float.parseFloat(string) * f);
                    continue;
                }
                n += Integer.parseInt(string);
                continue;
            }
            catch (Exception exception) {
                Logging.errorPrint((String)("Experience Value: '" + string + "' Not a number"));
                Logging.errorPrint((String)exception.getMessage(), (Throwable)exception);
            }
        }
        return new Double((double)n * this.multiplier / (double)this.party.size()).intValue();
    }

    public int getPartyTotalExperience() {
        int n = 0;
        File file = new File(this.dir + File.separator + "experience_tables/7_1.xml");
        if (this.experienceTable == null) {
            this.experienceTable = new ReadXML(file);
        }
        for (int i = 0; i < this.enemies.size(); ++i) {
            ExperienceListItem experienceListItem = (ExperienceListItem)this.enemies.get(i);
            float f = experienceListItem.getCombatant().getCR();
            int n2 = f < 1.0f ? 1 : (int)f;
            String string = (String)this.experienceTable.getTable().crossReference((Object)Integer.toString(this.party.averageCR()), (Object)Integer.toString(n2));
            try {
                if (f < 1.0f) {
                    n += (int)(Float.parseFloat(string) * f);
                    continue;
                }
                n += Integer.parseInt(string);
                continue;
            }
            catch (Exception exception) {
                Logging.errorPrint((String)("Experience Value: '" + string + "' Not a number"));
                Logging.errorPrint((String)exception.getMessage(), (Throwable)exception);
            }
        }
        return new Double((double)n * this.multiplier).intValue();
    }

    public int getPartyExperience() {
        return this.partyExperience;
    }

    public void updatePartyExperience() {
        int n = SettingsHandler.getGMGenOption((String)"Experience_Adjuster.ExperienceType", (int)2);
        if (n == 1) {
            this.partyExperience = this.getPartyTotalExperience();
        } else {
            this.partyExperience = 0;
            for (int i = 0; i < this.party.size(); ++i) {
                Combatant combatant = ((ExperienceListItem)this.party.get(i)).getCombatant();
                this.partyExperience += this.getCombatantExperience(combatant);
            }
        }
    }
}

