/*
 * Decompiled with CFR 0.152.
 */
package plugin.bonustokens;

import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.core.SettingsHandler;
import pcgen.core.bonus.BonusObj;
import pcgen.core.bonus.util.MissingObject;

public final class Stat
extends BonusObj {
    private static final String[] bonusHandled = new String[]{"STAT"};
    private static final String[] bonusTags = new String[]{"BASESPELLSTAT", "BASESPELLKNOWNSTAT"};

    protected boolean parseToken(String string) {
        int n;
        for (n = 0; n < bonusTags.length; ++n) {
            if (!bonusTags[n].equals(string)) continue;
            this.addBonusInfo(n);
            return true;
        }
        if (string.startsWith("CAST=") || string.startsWith("CAST.")) {
            n = SettingsHandler.getGame().getStatFromAbbrev(string.substring(5));
            if (n >= 0) {
                this.addBonusInfo(new CastStat((PCStat)SettingsHandler.getGame().getUnmodifiableStatList().get(n)));
                return true;
            }
        } else {
            n = SettingsHandler.getGame().getStatFromAbbrev(string);
            if (n >= 0) {
                this.addBonusInfo(SettingsHandler.getGame().getUnmodifiableStatList().get(n));
            } else {
                PCClass pCClass = (PCClass)Globals.getContext().ref.silentlyGetConstructedCDOMObject(PCClass.class, string);
                if (pCClass != null) {
                    this.addBonusInfo(pCClass);
                } else {
                    this.addBonusInfo(new MissingObject(string));
                }
            }
            return true;
        }
        return false;
    }

    protected String unparseToken(Object object) {
        if (object instanceof Integer) {
            return bonusTags[(Integer)object];
        }
        if (object instanceof CastStat) {
            return "CAST." + ((CastStat)object).stat.getAbb();
        }
        if (object instanceof PCClass) {
            return ((PCClass)object).getKeyName();
        }
        if (object instanceof MissingObject) {
            return ((MissingObject)object).getObjectName();
        }
        return ((PCStat)object).getAbb();
    }

    protected String[] getBonusesHandled() {
        return bonusHandled;
    }

    public static class CastStat {
        public final PCStat stat;

        public CastStat(PCStat pCStat) {
            this.stat = pCStat;
        }
    }
}

