#!/bin/sh
cd `dirname $0`

pcgendir="$HOME/.pcgen"

if [ ! -d "$pcgendir" ]
then
	mkdir "$pcgendir" || exit 2
fi

if [ "x$BROWSER" = x ]
then
	case "$WINDOWMANAGER" in
		*kde ) BROWSER=kde-open ;;
		*gdm ) BROWSER=gnome-open ;;
		* ) BROWSER=netscape ;;
	esac
fi

# To load all sources takes more than the default 64MB.
javaargs="-Xms128m -Xmx256m"
pcgenargs=""
whosearg=java

while [ "x$1" != x ]
do
	case "$1" in
	-h ) cat <<EOM
usage: $0 [java-options] [-- pcgen-options]
	For java options, try 'java -h' and 'java -X -h'.
	Useful java property defines:
		-DBROWSER=/path/to/browser
		-Dpcgen.filter=/path/to/filter.ini
		-Dpcgen.options=/path/to/options.ini
	This script recognizes the BROWSER environment variable.
EOM
		exit 0
		;;
	-- ) whosearg=pcgen
		;;
	* ) if [ "$whosearg" = java ]
		then
			javaargs="$javaargs $1"
		else
			pcgenargs="$pcgenargs $1"
		fi
		;;
	esac
	shift
done

# PCGen related properties:
#
# pcgen.filter  - the full path to the file name containing the filter settings
# pcgen.options - the full path to the file name containing the options
#
# Both of these properties are optional.  Default behaviour is to get the
# files from the "user.dir" directory.
#
# Additional properties:
#     -DBROWSER="$BROWSER"
#     -Dpcgen.filter=/path/to/filter.ini
#     -Dpcgen.options=/path/to/options.ini

exec java -DBROWSER="$BROWSER" $javaargs -jar ./pcgen.jar $pcgenargs
